/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud.p2p;

import android.content.Context;
import com.qihoo.videocloud.p2p.CancelTaskCallback;
import com.qihoo.videocloud.p2p.CreateTaskCallback;
import com.qihoo.videocloud.p2p.TaskInfo;
import com.qihoo.videocloud.p2p.core.IP2PServer;
import com.qihoo.videocloud.p2p.core.P2PLogger;
import com.qihoo.videocloud.p2p.core.P2PMagager;
import java.util.Map;

public class P2PServer
implements IP2PServer {
    public static int LOG_LEVEL_TRACE = P2PLogger.LOG_LEVEL_TRACE;
    public static int LOG_LEVEL_DEBUG = P2PLogger.LOG_LEVEL_DEBUG;
    public static int LOG_LEVEL_INFO = P2PLogger.LOG_LEVEL_INFO;
    public static int LOG_LEVEL_WARN = P2PLogger.LOG_LEVEL_WARN;
    public static int LOG_LEVEL_ERROR = P2PLogger.LOG_LEVEL_ERROR;
    public static int LOG_LEVEL_NONE;
    private static int sLogLevel;

    public static synchronized int initialize(Context context, String cacheDir, String cid, String uid, Map<String, Object> params) {
        return P2PMagager.getInstance().initialize(context, cacheDir, cid, uid, params);
    }

    public static synchronized void destroy() {
        P2PMagager.getInstance().destroy();
    }

    public static void setLogLevel(int logLevel) {
        if (logLevel < LOG_LEVEL_TRACE || logLevel > LOG_LEVEL_NONE) {
            return;
        }
        P2PLogger.setLogLevel(logLevel);
    }

    public static int setCacheSize(int cacheSize) {
        return P2PMagager.getInstance().setCacheSize(cacheSize);
    }

    public static int clearCache() {
        return P2PMagager.getInstance().clearCache();
    }

    public static int enableUpload(boolean enablUpload) {
        return P2PMagager.getInstance().enableUpload(enablUpload);
    }

    public static void createTask(String url, CreateTaskCallback callback) {
        P2PServer.createTask(url, false, callback);
    }

    public static void createTask(String url, boolean forceP2P, CreateTaskCallback callback) {
        P2PMagager.getInstance().createTask(url, forceP2P, callback);
    }

    public static void cancelTask(String url, CancelTaskCallback callback) {
        P2PMagager.getInstance().cancelTask(url, callback);
    }

    public static int setVideoDuration(String url, int duration) {
        return P2PMagager.getInstance().setVideoDuration(url, duration);
    }

    public static int getTaskInfo(String url, TaskInfo taskInfo) {
        return P2PMagager.getInstance().getTaskInfo(url, taskInfo);
    }

    public static long getContinuousCacheSizeFromPos(String url, long pos) {
        return P2PMagager.getInstance().getContinuousCacheSizeFromPos(url, pos);
    }

    public static String getErrorMsg(int errorCode) {
        String errorMsg = "";
        switch (errorCode) {
            case -1: {
                errorMsg = "\u672a\u77e5\u9519\u8bef";
                break;
            }
            case 1000: 
            case 2000: {
                errorMsg = "\u65e0\u6548\u7684\u53c2\u6570";
                break;
            }
            case 2001: {
                errorMsg = "\u78c1\u76d8\u7a7a\u95f4\u4e0d\u8db3";
                break;
            }
            case 2003: {
                errorMsg = "\u521b\u5efa\u4efb\u52a1\u5931\u8d25";
                break;
            }
            case 2004: {
                errorMsg = "\u627e\u4e0d\u5230\u4efb\u52a1";
                break;
            }
            case 1003: 
            case 2005: {
                errorMsg = "\u6743\u9650\u4e0d\u8db3\uff0c\u8bbf\u95ee\u88ab\u62d2\u7edd";
                break;
            }
            case 1002: 
            case 2006: {
                errorMsg = "\u6a21\u5757\u6ca1\u6709\u521d\u59cb\u5316";
                break;
            }
            case 2007: {
                errorMsg = "\u7ed1\u5b9a\u672c\u5730\u7aef\u53e3\u5931\u8d25";
                break;
            }
            case 2008: {
                errorMsg = "\u6b63\u5728\u6388\u6743\u4e2d";
                break;
            }
            case 2009: {
                errorMsg = "\u6388\u6743\u5931\u8d25";
            }
        }
        return errorMsg;
    }

    public static String getVersion() {
        return P2PMagager.getInstance().getVersion();
    }

    public static String getNativeVersion() {
        return P2PMagager.getInstance().getNativeVersion();
    }

    public static String getNetworkType() {
        return P2PMagager.getInstance().getNetworkType();
    }

    static {
        sLogLevel = LOG_LEVEL_NONE = P2PLogger.LOG_LEVEL_TRACE;
    }
}

