/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud.p2p.config;

import android.text.TextUtils;
import com.qihoo.videocloud.p2p.core.P2PLogger;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudControlP2P {
    static final String TAG = "P2PServer";
    public int enable = 1;
    public int use_p2p = 0;
    public int p2p_rate = 0;
    public String p2p_operators = "1:1:1";

    public static CloudControlP2P fromJsonStr(String jsonStr) {
        CloudControlP2P cloudControlP2P = new CloudControlP2P();
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return cloudControlP2P;
        }
        try {
            JSONObject json = new JSONObject(jsonStr);
            JSONObject jsonPlayer = json.getJSONObject("play");
            if (jsonPlayer != null) {
                if (jsonPlayer.has("enable") && jsonPlayer.getInt("enable") == 0) {
                    return cloudControlP2P;
                }
                Iterator keys = jsonPlayer.keys();
                int count = 0;
                int notMatchCount = 0;
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    ++count;
                    if (key.equals("use_p2p")) {
                        cloudControlP2P.use_p2p = jsonPlayer.getInt(key);
                        continue;
                    }
                    if (key.equals("p2p_rate")) {
                        cloudControlP2P.p2p_rate = jsonPlayer.getInt(key);
                        continue;
                    }
                    if (key.equals("p2p_operators")) {
                        cloudControlP2P.p2p_operators = jsonPlayer.getString(key);
                        continue;
                    }
                    if (key.equals("enable")) {
                        cloudControlP2P.enable = jsonPlayer.getInt(key);
                        continue;
                    }
                    P2PLogger.v(TAG, "not match key =  " + key);
                    ++notMatchCount;
                }
                P2PLogger.v(TAG, "play json all obj count " + count + " not match count " + notMatchCount);
                P2PLogger.v(TAG, cloudControlP2P.toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return cloudControlP2P;
    }

    public String toString() {
        return "CloudControlP2P{enable=" + this.enable + ", use_p2p=" + this.use_p2p + ", p2p_rate=" + this.p2p_rate + ", p2p_operators='" + this.p2p_operators + '\'' + '}';
    }
}

