/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud.p2p.core;

import android.util.Log;
import com.qihoo.livecloud.tools.LogEntry;
import com.qihoo.livecloud.tools.Logger;
import java.util.Locale;

public class P2PLogger {
    public static int LOG_LEVEL_TRACE = 0;
    public static int LOG_LEVEL_DEBUG = 1;
    public static int LOG_LEVEL_INFO = 2;
    public static int LOG_LEVEL_WARN = 3;
    public static int LOG_LEVEL_ERROR = 4;
    public static int LOG_LEVEL_NONE = 5;
    private static int sLogLevel = LOG_LEVEL_ERROR;
    private static int sLogUploadId = -1;

    private static int logGetAndroidUploadId() {
        if (sLogUploadId < 0) {
            sLogUploadId = LogEntry.createLogger((String)"android_p2p");
        }
        return sLogUploadId;
    }

    public static void setLogLevel(int logLevel) {
        if (logLevel < LOG_LEVEL_TRACE || logLevel > LOG_LEVEL_NONE) {
            return;
        }
        sLogLevel = logLevel;
    }

    public static void v(String tag, String message) {
        if (sLogLevel > LOG_LEVEL_TRACE) {
            return;
        }
        try {
            Log.v((String)tag, (String)message);
            Logger.f((int)P2PLogger.logGetAndroidUploadId(), (int)0, (String)tag, (String)message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void v(String tag, String format, Object ... args) {
        if (sLogLevel > LOG_LEVEL_TRACE) {
            return;
        }
        try {
            Log.v((String)tag, (String)String.format(Locale.US, format, args));
            Logger.f((int)P2PLogger.logGetAndroidUploadId(), (int)0, (String)tag, (String)format, (Object[])args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void d(String tag, String message) {
        if (sLogLevel > LOG_LEVEL_DEBUG) {
            return;
        }
        try {
            Log.d((String)tag, (String)message);
            Logger.f((int)P2PLogger.logGetAndroidUploadId(), (int)1, (String)tag, (String)message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void d(String tag, String format, Object ... args) {
        if (sLogLevel > LOG_LEVEL_DEBUG) {
            return;
        }
        try {
            Log.d((String)tag, (String)String.format(Locale.US, format, args));
            Logger.f((int)P2PLogger.logGetAndroidUploadId(), (int)1, (String)tag, (String)format, (Object[])args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void i(String tag, String message) {
        if (sLogLevel > LOG_LEVEL_INFO) {
            return;
        }
        try {
            Logger.i((String)tag, (String)message);
            Logger.f((int)P2PLogger.logGetAndroidUploadId(), (int)2, (String)tag, (String)message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void i(String tag, String format, Object ... args) {
        if (sLogLevel > LOG_LEVEL_INFO) {
            return;
        }
        try {
            Log.i((String)tag, (String)String.format(Locale.US, format, args));
            Logger.f((int)P2PLogger.logGetAndroidUploadId(), (int)2, (String)tag, (String)format, (Object[])args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void w(String tag, String message) {
        if (sLogLevel > LOG_LEVEL_WARN) {
            return;
        }
        try {
            Log.w((String)tag, (String)message);
            Logger.f((int)P2PLogger.logGetAndroidUploadId(), (int)3, (String)tag, (String)message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void w(String tag, String format, Object ... args) {
        if (sLogLevel > LOG_LEVEL_WARN) {
            return;
        }
        try {
            Log.w((String)tag, (String)String.format(Locale.US, format, args));
            Logger.f((int)P2PLogger.logGetAndroidUploadId(), (int)3, (String)tag, (String)format, (Object[])args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void e(String tag, String message) {
        if (sLogLevel > LOG_LEVEL_ERROR) {
            return;
        }
        try {
            Log.e((String)tag, (String)message);
            Logger.f((int)P2PLogger.logGetAndroidUploadId(), (int)4, (String)tag, (String)message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void e(String tag, String format, Object ... args) {
        if (sLogLevel > LOG_LEVEL_ERROR) {
            return;
        }
        try {
            Log.e((String)tag, (String)String.format(Locale.US, format, args));
            Logger.f((int)P2PLogger.logGetAndroidUploadId(), (int)4, (String)tag, (String)format, (Object[])args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

