/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud.p2p.core;

import android.content.Context;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.qihoo.livecloud.network.NetworkStateMonitor;
import com.qihoo.livecloud.tools.CloudControlManager;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.Version;
import com.qihoo.videocloud.p2p.CancelTaskCallback;
import com.qihoo.videocloud.p2p.CreateTaskCallback;
import com.qihoo.videocloud.p2p.TaskInfo;
import com.qihoo.videocloud.p2p.config.CloudControlP2P;
import com.qihoo.videocloud.p2p.core.IP2PCore;
import com.qihoo.videocloud.p2p.core.IP2PServer;
import com.qihoo.videocloud.p2p.core.P2PLogger;
import com.qihoo.videocloud.p2p.core.Util;
import com.qihoo.videocloud.p2p.core.yunfan.YfP2PCore;
import com.qihoo.videocloud.p2p.core.yunfan.YfP2PPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class P2PMagager
implements IP2PServer {
    private static final String TAG = "P2PServer";
    private static final String VERSION = "0.0.0.0";
    private static final int P2P_MOUDLE_COUNT = 1;
    private static P2PMagager sInst = null;
    private IP2PCore mCurrentP2P;
    private int mRandomUseP2P = -1;
    NetworkStateMonitor.NetworkChangeListener mNetworkChangeListener;
    private CloudControlP2P mCloudControlP2p = null;
    private String mNetworkType;
    private boolean mEnableUpload = false;
    private int mCacheSize = 50;
    private boolean mParamChanged = true;
    private Context mContext;
    private String mCacheDir;
    private String mCId;
    private String mUId;
    private Map<String, Object> mParams = new HashMap<String, Object>();

    public static synchronized P2PMagager getInstance() {
        if (sInst == null) {
            sInst = new P2PMagager();
        }
        return sInst;
    }

    public synchronized int initialize(Context context, String cacheDir, String cid, String uid, Map<String, Object> params) {
        P2PLogger.v(TAG, "initialize cacheDir = " + cacheDir);
        int ret = -1;
        Version.check((String)"2.0.3.0");
        if (TextUtils.isEmpty((CharSequence)cid)) {
            throw new IllegalArgumentException("need channel id");
        }
        if (this.isInit()) {
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)cacheDir)) {
            P2PLogger.i(TAG, "cacheDir is empty!");
            return 1000;
        }
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        this.mCacheDir = cacheDir;
        this.mCId = !TextUtils.isEmpty((CharSequence)cid) ? cid : "";
        this.mUId = !TextUtils.isEmpty((CharSequence)uid) ? uid : "";
        if (params != null) {
            this.mParams.putAll(params);
        }
        this.mCloudControlP2p = CloudControlP2P.fromJsonStr(CloudControlManager.getInstance().getConfigJson());
        this.intRandomUseP2P();
        this.mNetworkChangeListener = new NetworkStateMonitor.NetworkChangeListener(){

            public void onNetworkChange(NetworkInfo networkInfo, String networkType) {
                P2PLogger.d(P2PMagager.TAG, "P2PMagager onNetworkChange type= " + networkType);
                P2PMagager.this.mNetworkType = networkType;
            }
        };
        if (this.mContext != null) {
            NetworkStateMonitor.getInstance().registerNetworkChangeListener(this.mContext, this.mNetworkChangeListener);
        }
        this.mCurrentP2P = this.createP2PCore();
        ret = this.mCurrentP2P == null ? -2 : 0;
        return ret;
    }

    public synchronized void destroy() {
        if (this.mCurrentP2P != null) {
            this.mCurrentP2P.destroy();
        }
        if (this.mContext != null && this.mNetworkChangeListener != null) {
            NetworkStateMonitor.getInstance().unRegisterNetworkChangeListener(this.mContext, this.mNetworkChangeListener);
        }
    }

    public synchronized boolean isInit() {
        return this.mCurrentP2P != null;
    }

    public int setCacheSize(int cacheSize) {
        if (cacheSize <= 0) {
            return 1000;
        }
        if (this.mCacheSize != cacheSize) {
            this.mCacheSize = cacheSize;
            this.mParamChanged = true;
        }
        return 0;
    }

    public int clearCache() {
        if (this.mCurrentP2P == null) {
            this.mCurrentP2P = this.createP2PCore();
        }
        if (this.mCurrentP2P != null) {
            if (!this.mCurrentP2P.isInit()) {
                this.mCurrentP2P.initialize(this.mContext, this.mCacheDir);
            }
            return this.mCurrentP2P.clearCache();
        }
        return 1002;
    }

    public int enableUpload(boolean enablUpload) {
        if (this.mEnableUpload != enablUpload) {
            this.mEnableUpload = enablUpload;
            this.mParamChanged = true;
        }
        if (this.mCurrentP2P != null) {
            return this.mCurrentP2P.enableUpload(enablUpload);
        }
        return 0;
    }

    public void createTask(String url, boolean forceP2P, CreateTaskCallback callback) {
        block14: {
            P2PLogger.v(TAG, "P2PMagager createTask origin url = " + url + " forceP2P  = " + forceP2P);
            if (TextUtils.isEmpty((CharSequence)url)) {
                P2PLogger.i(TAG, "P2PMagager url is empty, return");
                if (callback != null) {
                    callback.onCallback(1000, url, "common");
                }
                return;
            }
            try {
                boolean useP2p;
                boolean bl = useP2p = this.mRandomUseP2P == 1;
                if (!useP2p) {
                    useP2p = this.isCanUseP2P(forceP2P);
                }
                if (useP2p) {
                    if (this.mCurrentP2P == null) {
                        this.mCurrentP2P = this.createP2PCore();
                    }
                    if (this.mCurrentP2P != null) {
                        String session = MD5.encryptMD5((String)(String.valueOf(System.currentTimeMillis()) + String.valueOf(new Random().nextInt())));
                        Util.sessionStart(session, this.mCId, this.mUId, this.mCurrentP2P.getName());
                        if (!this.mCurrentP2P.isInit()) {
                            this.mCurrentP2P.initialize(this.mContext, this.mCacheDir);
                        }
                        if (this.mParamChanged) {
                            this.mCurrentP2P.setCacheSize(this.mCacheSize);
                            this.mCurrentP2P.enableUpload(this.mEnableUpload);
                            P2PLogger.v(TAG, "P2PMagager p2pCore set param mCacheSize = " + this.mCacheSize, " mEnableUpload = " + this.mEnableUpload);
                            this.mParamChanged = false;
                        }
                        this.mCurrentP2P.createTask(url, callback);
                        Util.sessionStop(session);
                    } else if (callback != null) {
                        callback.onCallback(-1, url, "common");
                    }
                } else if (callback != null) {
                    callback.onCallback(0, url, "common");
                }
            }
            catch (Throwable e) {
                if (callback == null) break block14;
                callback.onCallback(-2, url, "common");
            }
        }
    }

    public void cancelTask(String url, CancelTaskCallback callback) {
        if (this.mCurrentP2P != null) {
            this.mCurrentP2P.cancelTask(url, callback);
        } else if (callback != null) {
            callback.onCallback(1002, "common");
        }
    }

    public int setVideoDuration(String url, int duration) {
        if (this.mCurrentP2P != null) {
            int ret = this.mCurrentP2P.setVideoDuration(url, duration);
            return ret;
        }
        return 1002;
    }

    public int getTaskInfo(String url, TaskInfo taskInfo) {
        if (this.mCurrentP2P != null) {
            int ret = this.mCurrentP2P.getTaskInfo(url, taskInfo);
            return ret;
        }
        return 1002;
    }

    public long getContinuousCacheSizeFromPos(String url, long pos) {
        if (this.mCurrentP2P != null) {
            long size = this.mCurrentP2P.getContinuousCacheSizeFromPos(url, pos);
            return size;
        }
        return 0L;
    }

    private void intRandomUseP2P() {
        if (this.mRandomUseP2P != -1) {
            return;
        }
        if (this.mCloudControlP2p == null) {
            return;
        }
        int rand = (int)(Math.random() * 100.0);
        if (this.mCloudControlP2p.use_p2p == 0) {
            P2PLogger.i(TAG, "P2PMagager CloudControlP2p use_p2p == 0, return");
            this.mRandomUseP2P = 0;
        } else if (rand > this.mCloudControlP2p.p2p_rate) {
            P2PLogger.i(TAG, "P2PMagager rand > CloudControlP2p p2p_rate, return rand = " + rand);
            this.mRandomUseP2P = 0;
        } else {
            this.mRandomUseP2P = 1;
        }
    }

    private boolean isCanUseP2P(boolean forceP2P) {
        if (this.mCloudControlP2p.use_p2p == 0) {
            return false;
        }
        return forceP2P;
    }

    private IP2PCore createP2PCore() {
        if (this.mCloudControlP2p == null) {
            return null;
        }
        int rand = (int)(Math.random() * 100.0);
        int scheeduleIndex = -1;
        String p2p_operators = this.mCloudControlP2p.p2p_operators;
        if (!TextUtils.isEmpty((CharSequence)p2p_operators)) {
            String[] array = p2p_operators.split(":");
            int length = Math.min(array.length, 1);
            int allValue = 0;
            for (int i = 0; i < length; ++i) {
                allValue += Integer.valueOf(array[i].trim()).intValue();
            }
            int baseValue = 0;
            if (allValue > 0) {
                for (int i = 0; i < length; ++i) {
                    int precent = (baseValue += Integer.valueOf(array[i].trim()).intValue()) * 100 / allValue;
                    if (rand >= precent) continue;
                    scheeduleIndex = i;
                    break;
                }
            }
        }
        YfP2PCore pCore = null;
        if (scheeduleIndex == 0) {
            YfP2PPlugin p2pPlugin = YfP2PPlugin.getInstance();
            p2pPlugin.setDefaultPluginInstalled(false);
            if (p2pPlugin.isPluginInstalled()) {
                int result = p2pPlugin.loadPlugin();
                if (result != 0) {
                    P2PLogger.i(TAG, "P2PMagager YfP2PPlugin loadPlugin faild");
                    return pCore;
                }
            } else {
                p2pPlugin.checkInstallOrUpdatePlugin(this.mContext, null, null);
                P2PLogger.i(TAG, "P2PMagager YfP2PPlugin begin download");
                return pCore;
            }
            try {
                pCore = new YfP2PCore();
            }
            catch (Throwable e) {
                e.printStackTrace();
                P2PLogger.i(TAG, "P2PMagager new YfP2PCore faild");
            }
        }
        return pCore;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getNativeVersion() {
        if (this.mCurrentP2P != null) {
            return this.mCurrentP2P.getVersion();
        }
        return VERSION;
    }

    public String getNetworkType() {
        return this.mNetworkType;
    }
}

