/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud.p2p.core.yunfan;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.qihoo.videocloud.p2p.CancelTaskCallback;
import com.qihoo.videocloud.p2p.CreateTaskCallback;
import com.qihoo.videocloud.p2p.TaskInfo;
import com.qihoo.videocloud.p2p.core.IP2PCore;
import com.qihoo.videocloud.p2p.core.IP2PServer;
import com.qihoo.videocloud.p2p.core.P2PLogger;
import com.qihoo.videocloud.p2p.core.Util;
import com.yunfan.net.IYfCallBack;
import com.yunfan.net.YFTaskInfo;
import com.yunfan.net.Yfnet;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;

public class YfP2PCore
implements IP2PCore,
IP2PServer {
    private static final String TAG = "P2PServer";
    public static final String TOKEN = "b048975020d226f7bb64eff579a5751f6738367c";
    public static final String SO_NAME = "yfnet_360";
    public static final String SO_VER = "201712261643";
    private boolean mInit = false;
    private Context mContext = null;
    private final Yfnet mYfp2p = new Yfnet();
    private HashMap<String, String> mHashMap = new HashMap();
    private HashSet<String> mCacheFinshSet = new HashSet();
    private IYfCallBack mCallback = new IYfCallBack(){

        @Override
        public void CallBack(int i, String s) {
            P2PLogger.v(YfP2PCore.TAG, "yunfan IYfCallBack type = " + i + "value = " + s);
            if (i == 0) {
                YfP2PCore.this.saveFinishCache(s);
            }
        }
    };

    @Override
    public synchronized int initialize(Context context, String cacheDir) {
        P2PLogger.v(TAG, "yunfan initialize cacheDir = " + cacheDir);
        if (this.mInit) {
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)cacheDir)) {
            P2PLogger.e(TAG, "yunfan cacheDir is empty!");
            return 1000;
        }
        File file = new File(cacheDir);
        if (!file.exists()) {
            file.mkdirs();
            if (!file.exists()) {
                return 1003;
            }
        }
        if (!file.canRead() || !file.canWrite()) {
            return 1003;
        }
        File configFile = new File(file.getParentFile(), "P2PConfig");
        if (!configFile.exists()) {
            configFile.mkdirs();
            if (!configFile.exists()) {
                return 1003;
            }
        }
        this.mContext = context.getApplicationContext();
        Util.loadLibrary(this.mContext, SO_NAME);
        Yfnet.JSetAppContext(this.mContext);
        int ret = this.mYfp2p.JInit(configFile.getAbsolutePath(), cacheDir, TOKEN, this.mCallback);
        P2PLogger.v(TAG, "yunfan JInit ret = " + ret);
        if (YfP2PCore.isYfOk(ret)) {
            P2PLogger.v(TAG, "yunfan initialize ok ");
            this.mInit = true;
        }
        return this.getRet(ret);
    }

    @Override
    public boolean isInit() {
        return this.mInit;
    }

    @Override
    public synchronized void destroy() {
        if (this.mInit) {
            this.clearHashByUrl();
            this.clearFinishCache();
            int ret = this.mYfp2p.JClear();
            P2PLogger.v(TAG, "yunfan JClear ret = " + ret);
            this.mContext = null;
            this.mInit = false;
        }
    }

    @Override
    public int setCacheSize(int cacheSize) {
        if (!this.mInit) {
            return 1002;
        }
        if (cacheSize > 0) {
            try {
                Method SetSpaceCanUse = this.mYfp2p.getClass().getDeclaredMethod("SetSpaceCanUse", Integer.TYPE);
                if (SetSpaceCanUse != null) {
                    SetSpaceCanUse.setAccessible(true);
                    int ret = (Integer)SetSpaceCanUse.invoke(null, cacheSize);
                    P2PLogger.v(TAG, "yunfan SetSpaceCanUse cacheSize = " + cacheSize + " ret = " + ret);
                    return this.getRet(ret);
                }
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        } else {
            return 1000;
        }
        return -1;
    }

    @Override
    public int clearCache() {
        if (!this.mInit) {
            return 1002;
        }
        int ret = this.mYfp2p.JCleanCache();
        P2PLogger.v(TAG, "yunfan JCleanCache ret = " + ret);
        return this.getRet(ret);
    }

    @Override
    public int enableUpload(boolean enablUpload) {
        if (!this.mInit) {
            return 1002;
        }
        int ret = this.mYfp2p.JEnableUpload(enablUpload);
        P2PLogger.v(TAG, "yunfan JEnableUpload enablUpload = " + enablUpload + " ret = " + ret);
        return this.getRet(ret);
    }

    @Override
    public void createTask(String url, CreateTaskCallback callback) {
        P2PLogger.v(TAG, "yunfan getPlayUrl origin url = " + url);
        AsyncCreateTask task = new AsyncCreateTask(callback);
        if (task != null) {
            task.execute(new String[]{url});
        }
    }

    @Override
    public void cancelTask(String url, CancelTaskCallback callback) {
        if (!this.mInit) {
            if (callback != null) {
                callback.onCallback(1002, "yunfan");
            }
            return;
        }
        String hash = this.getHashByUrl(url);
        P2PLogger.v(TAG, "yunfan cancelTask hash = " + hash + " url = " + url);
        if (TextUtils.isEmpty((CharSequence)hash) && callback != null) {
            callback.onCallback(1001, "yunfan");
        }
        int ret = this.mYfp2p.JPauseTask(hash);
        if (callback != null) {
            this.removeFinishCache(hash);
            callback.onCallback(this.getRet(ret), "yunfan");
        }
        P2PLogger.v(TAG, "yunfan JPauseTask ret = " + ret);
    }

    @Override
    public int setVideoDuration(String url, int duration) {
        if (!this.mInit) {
            return 1002;
        }
        String hash = this.getHashByUrl(url);
        P2PLogger.v(TAG, "yunfan getFileCachedSize hash = " + hash + " url = " + url);
        if (TextUtils.isEmpty((CharSequence)hash)) {
            return 1001;
        }
        int ret = this.mYfp2p.JSetVideoDuration(hash, duration);
        P2PLogger.v(TAG, "yunfan JSetVideoDuration ret = " + ret);
        return this.getRet(ret);
    }

    @Override
    public int getTaskInfo(String url, TaskInfo taskInfo) {
        if (!this.mInit) {
            return 1002;
        }
        String hash = this.getHashByUrl(url);
        if (TextUtils.isEmpty((CharSequence)hash)) {
            return 1001;
        }
        YFTaskInfo[] yfTaskInfos = new YFTaskInfo[]{new YFTaskInfo()};
        int ret = this.mYfp2p.JGetTaskInfo(hash, yfTaskInfos);
        if (YfP2PCore.isYfOk(ret) && taskInfo != null) {
            taskInfo.downSpeed = yfTaskInfos[0].downSpeed;
            taskInfo.p2pDownSpeed = yfTaskInfos[0].p2pDownSpeed;
            taskInfo.cdnDownSpeed = yfTaskInfos[0].cdnDownSpeed;
            taskInfo.p2pDownSize = yfTaskInfos[0].p2pDownSize;
            taskInfo.cdnDownSize = yfTaskInfos[0].cdnDownSize;
            taskInfo.cachedSize = yfTaskInfos[0].continuousCacheSize;
            taskInfo.totalSize = yfTaskInfos[0].totalSize;
            boolean cacheFinish = this.isCacheFinish(hash);
            if (taskInfo.cacheFinish != cacheFinish) {
                taskInfo.cacheFinish = cacheFinish;
            }
        }
        return this.getRet(ret);
    }

    @Override
    public long getContinuousCacheSizeFromPos(String url, long pos) {
        if (!this.mInit) {
            return 0L;
        }
        String hash = this.getHashByUrl(url);
        if (TextUtils.isEmpty((CharSequence)hash)) {
            return 0L;
        }
        long size = this.mYfp2p.JGetContinuousCacheSizeFromPos(hash, pos);
        P2PLogger.v(TAG, "yunfan JGetContinuousCacheSizeFromPos ret = " + size);
        return size;
    }

    @Override
    public String getName() {
        return "yunfan";
    }

    @Override
    public String getVersion() {
        return SO_VER;
    }

    private static boolean isYfOk(int ret) {
        return 0 == ret || 1 == ret;
    }

    private synchronized String getHashByUrl(String url) {
        String hash = this.mHashMap.get(url);
        if (!TextUtils.isEmpty((CharSequence)hash)) {
            return hash;
        }
        return "";
    }

    private synchronized void saveHashByUrl(String url, String hash) {
        this.mHashMap.put(url, hash);
    }

    private synchronized void clearHashByUrl() {
        this.mHashMap.clear();
    }

    private synchronized boolean isCacheFinish(String hash) {
        return this.mCacheFinshSet.contains(hash);
    }

    private synchronized void saveFinishCache(String hash) {
        this.mCacheFinshSet.add(hash);
    }

    private synchronized void removeFinishCache(String hash) {
        this.mCacheFinshSet.remove(hash);
    }

    private synchronized void clearFinishCache() {
        this.mCacheFinshSet.clear();
    }

    private int getRet(int ret) {
        int notifyRet = -1;
        switch (ret) {
            case 0: 
            case 1: {
                notifyRet = 0;
                break;
            }
            case -1: {
                notifyRet = -1;
                break;
            }
            case -5: {
                notifyRet = 2000;
                break;
            }
            case -9: {
                notifyRet = 2001;
                break;
            }
            case -10: {
                notifyRet = 2003;
                break;
            }
            case -12: {
                notifyRet = 2004;
                break;
            }
            case -13: {
                notifyRet = 2005;
                break;
            }
            case -14: {
                notifyRet = 2006;
                break;
            }
            case -17: {
                notifyRet = 2007;
                break;
            }
            case -18: {
                notifyRet = 2008;
                break;
            }
            case -21: 
            case -20: 
            case -19: {
                notifyRet = 2009;
            }
        }
        return notifyRet;
    }

    private class AsyncCreateTask
    extends AsyncTask<String, Integer, Integer> {
        private CreateTaskCallback callback;
        private String rawUrl;
        private String p2pUrl;

        public AsyncCreateTask(CreateTaskCallback callback) {
            this.callback = callback;
        }

        protected Integer doInBackground(String ... params) {
            this.p2pUrl = this.rawUrl = params[0];
            int commonRet = -1;
            if (!YfP2PCore.this.mInit) {
                P2PLogger.i(YfP2PCore.TAG, "yunfan not init, return");
                return 1002;
            }
            if (TextUtils.isEmpty((CharSequence)this.rawUrl)) {
                P2PLogger.i(YfP2PCore.TAG, "yunfan url is empty, return");
                return 1000;
            }
            String[] hashArray = new String[1];
            String[] proxyUrlArray = new String[1];
            int ret = YfP2PCore.this.mYfp2p.JCreateTask(this.rawUrl, hashArray, proxyUrlArray);
            P2PLogger.v(YfP2PCore.TAG, "yunfan JCreateTask ret = " + ret);
            if (YfP2PCore.isYfOk(ret)) {
                YfP2PCore.this.saveHashByUrl(this.rawUrl, hashArray[0]);
                ret = YfP2PCore.this.mYfp2p.JRunTask(hashArray[0]);
                P2PLogger.v(YfP2PCore.TAG, "yunfan RunTask ret = " + ret);
                if (YfP2PCore.isYfOk(ret)) {
                    commonRet = YfP2PCore.this.getRet(ret);
                    if (!TextUtils.isEmpty((CharSequence)proxyUrlArray[0])) {
                        this.p2pUrl = proxyUrlArray[0];
                    }
                } else {
                    commonRet = YfP2PCore.this.getRet(ret);
                }
            } else {
                commonRet = YfP2PCore.this.getRet(ret);
            }
            return commonRet;
        }

        protected void onCancelled() {
            super.onCancelled();
            if (this.callback != null) {
                this.callback.onCallback(0, this.p2pUrl, "yunfan");
            }
        }

        protected void onPostExecute(Integer result) {
            super.onPostExecute((Object)result);
            if (this.callback != null) {
                this.callback.onCallback(result, this.p2pUrl, "yunfan");
            }
        }
    }
}

