/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.text.TextUtils;
import android.view.Surface;
import com.qihoo.livecloud.ILiveCloudPlayer;
import com.qihoo.livecloud.OnLiveCloudCallback;
import com.qihoo.livecloud.config.PlayerSettings;
import com.qihoo.livecloud.play.AudioInfo;
import com.qihoo.livecloud.play.PlayerControl;
import com.qihoo.livecloud.play.RecordConfig;
import com.qihoo.livecloud.play.callback.ILiveCloudDisplay;
import com.qihoo.livecloud.play.callback.PlayerCallback;
import com.qihoo.livecloud.play.jni.JPlayer;
import com.qihoo.livecloud.recorder.hc.QHVCRecorderSDK;
import com.qihoo.livecloud.resolution.PlayMonitor;
import com.qihoo.livecloud.resolution.ResolutionMgr;
import com.qihoo.livecloud.settings.GPWebrtcSettings;
import com.qihoo.livecloud.tools.CloudControlManager;
import com.qihoo.livecloud.tools.LiveCloudConfig;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.Schedule;
import com.qihoo.livecloud.tools.ScheduleCallBack;
import com.qihoo.livecloud.tools.ServerAddrs;
import com.qihoo.livecloud.tools.Stats;
import com.qihoo.livecloud.tools.Version;
import com.qihoo.livecloud.utils.PlayerLogger;
import com.qihoo.livecloud.view.TexturePlayView;
import com.qihoo.livecloud.view.elgcore.SurfaceTextureEGLSurface;
import com.qihoo.videocloud.QHVCQyCodec;
import com.qihoo.videocloud.model.MediaInformation;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class LiveCloudPlayer
implements ILiveCloudPlayer,
PlayerCallback {
    private static final String TAG = "LiveCloudPlayer";
    private static final int STATE_ERROR = -1;
    private static final int STATE_UNINIT = 0;
    private static final int STATE_IDLE = 1;
    private static final int STATE_PREPARING = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_STOP = 5;
    private static final int STATE_COMPLETED = 6;
    private Context mContext;
    private int mCurrentState = 0;
    private boolean mScreenOnWhilePlaying = false;
    private PowerManager.WakeLock mWakeLock = null;
    private String mPlayUrl;
    private int mPlayType;
    private boolean mBufferingUpdate = false;
    private volatile LiveCloudConfig mLiveCloudConfig;
    private volatile PlayerControl mPlayerControl;
    private OnLiveCloudCallback mCallback;
    private ILiveCloudDisplay mCurrentDisplay;
    private LinkedList<ILiveCloudDisplay> mDisplayList = null;
    private boolean firstSetDisplay = false;
    private int mPlayerId = 0;
    private boolean mFirstFrame = false;
    private boolean mMute = false;
    private boolean mUpdateMute = false;
    private int mDecodeMode = 10;
    private int mDelaySecond = 0;
    private boolean mFormatNotSupport = false;
    private String mUrl = "http://g2.live.360.cn/";
    private int mReturnProto = 8;
    private int mType = 0;
    private int mProto = 1;
    private PlayerSettings mPlayerSettings = null;
    private boolean mSetScheduleUrl = false;
    private boolean mInBackground = false;
    private boolean mSetInBackground = false;
    private int mIsHevc = 0;
    private boolean mFailedHevcplayback = false;
    private boolean mAddToGroup = false;
    private int mGroup = 0;
    private int mSeekTo = 0;
    private volatile boolean mIsSeeking = false;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private Handler mHandler;
    private String mFilePath = null;
    private long mMaxCacheDuration = 0L;
    private long mMaxCacheFileSize = 0L;
    private boolean mSetCacheFilePath = false;
    private int mMode = 0;
    private boolean mSetPlayMode = false;
    private String mStreamType = "all";
    private int previewDuration = 0;
    private volatile boolean onlyAudioPlay = false;
    private volatile boolean videoReadyMsgReceive = false;
    private volatile boolean audioReadyMsgReceive = false;
    private volatile boolean isPlayComplete = false;
    private SurfaceTextureEGLSurface mSurfaceTextureEGLSurface;
    private Surface mSurfaceRead = null;
    private SurfaceTexture mSurfaceTextCache = null;
    private SurfaceTexture mSurfaceTextureCheck = null;
    private int mSurfaceX;
    private int mSurfaceY;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private boolean mUseSwapSurface = false;
    private String mSessionId = "";
    public static final String SESSION_ID_SUFFIX_SWITCH = "__switch";
    public static final String SESSION_ID_SUFFIX_HEVC_FAILED = "__hevc_failed";
    private volatile boolean isResolutionAdapt = false;
    private volatile ILiveCloudPlayer.SwitchResolutionListener switchResolutionListener;
    private String[] mSourceRids;
    private String[] mSource;
    private volatile int mSourceIndex;
    private volatile int mSourceIndexCache;
    private volatile boolean mSwitchResolutionDoing = false;
    private volatile int mSwitchResolutionDoingCachePosition = 0;
    PlayMonitor mPlayMonitor;
    ResolutionMgr mResolutionMgr;
    private LocalServerHelper mLocalServerHelper;
    private boolean mUseHdRedord = false;
    QHVCRecorderSDK mRecorderSDK;
    private boolean isRecording;
    private long mStatBeginTick;
    private int mSarNum = 0;
    private int mSarDen = 0;
    private static final String VERSION = "2.0.3.18041001";
    private int mHalfDisplayer = 0;
    private Timer mTimer = null;
    private TimerTask mTimerTask = null;
    private ByteBuffer mAACByteBuffer = null;
    private int AAC_BUFFER_SIZE = 40960;
    AudioInfo mAudioInfo;
    private Runnable switchResolutionRunable = new Runnable(){

        @Override
        public void run() {
            LiveCloudPlayer.this.switchResolutionRunWrap();
        }
    };

    public LiveCloudPlayer(Context context) {
        PlayerLogger.d(TAG, "LiveCloudPlayer init");
        Version.check((String)"2.0.3.0");
        this.mContext = context.getApplicationContext();
        this.setAppContext(this.mContext);
        Stats.coreOpenLuaLib((String)"");
        Stats.coreOpenUdxLib((String)"");
        this.mPlayerSettings = PlayerSettings.fromJsonStr(CloudControlManager.getInstance().getConfigJson());
        if (this.mPlayerSettings != null) {
            PlayerLogger.i(TAG, "LiveCloudPlayer " + this.mPlayerSettings.toString());
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.mHandler = new Handler(Looper.getMainLooper());
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Looper.prepare();
                    LiveCloudPlayer.this.mHandler = new Handler(Looper.myLooper());
                    Looper.loop();
                }
            }).start();
        }
        this.mPlayMonitor = new PlayMonitor();
        this.mResolutionMgr = new ResolutionMgr();
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getNativeVersion() {
        return PlayerControl.getNativeVersion();
    }

    @Override
    public void setDataSource(String source, int playType) {
        if (this.mLiveCloudConfig == null) {
            if (this.mCallback != null) {
                this.mCallback.onError(201, 1001L);
            }
            return;
        }
        this.mLiveCloudConfig.setSn(source);
        this.mPlayType = playType;
        this.setCurState(1);
        PlayerLogger.i(TAG, "setDataSource sn=" + source + " playType=" + this.playTypeStr(playType));
        if (this.mLocalServerHelper != null) {
            this.mLocalServerHelper.setDataSource(null, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void setDataSource(String rid, String source, int playType) {
        if (this.mLiveCloudConfig == null) {
            if (this.mCallback == null) return;
            this.mCallback.onError(201, 1001L);
            return;
        }
        this.setDataSource(source, playType);
        if (this.mLocalServerHelper == null) {
            Class<LocalServerHelper> clazz = LocalServerHelper.class;
            // MONITORENTER : com.qihoo.livecloud.LiveCloudPlayer$LocalServerHelper.class
            if (this.mLocalServerHelper == null) {
                this.mLocalServerHelper = new LocalServerHelper();
            }
            // MONITOREXIT : clazz
        }
        this.mLocalServerHelper.setDataSource(rid, source);
    }

    @Override
    public void setDataSource(String[] source, int defaultIndex, int playType) {
        if (source != null && source.length > 0 && defaultIndex >= 0 && defaultIndex < source.length && playType == 2) {
            this.mSourceRids = null;
            this.mSource = source;
            this.mSourceIndex = defaultIndex;
            this.setDataSource(source[defaultIndex], playType);
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.stat(2, defaultIndex, 0, source);
            }
        } else if (this.mCallback != null) {
            this.mCallback.onError(201, 1003L);
        }
    }

    @Override
    public void setDataSource(String[] rids, String[] sources, int defaultIndex, int playType) {
        if (sources != null && sources.length > 0 && rids != null && rids.length == sources.length && defaultIndex >= 0 && defaultIndex < sources.length && playType == 2) {
            this.mSourceRids = rids;
            this.mSource = sources;
            this.mSourceIndex = defaultIndex;
            this.setDataSource(rids[defaultIndex], sources[defaultIndex], playType);
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.stat(2, defaultIndex, 0, sources);
            }
        } else if (this.mCallback != null) {
            this.mCallback.onError(201, 1003L);
        }
    }

    @Override
    public void setConfig(LiveCloudConfig config) {
        this.mLiveCloudConfig = config;
        if (config != null) {
            this.mSessionId = config.getSid();
        }
        if (this.mLiveCloudConfig != null && TextUtils.isEmpty((CharSequence)this.mLiveCloudConfig.getCid())) {
            throw new IllegalArgumentException("need channel id");
        }
        PlayerLogger.i(TAG, "set config: " + this.mLiveCloudConfig);
    }

    public LiveCloudConfig getConfig() {
        PlayerLogger.d(TAG, "get config: " + this.mLiveCloudConfig);
        return this.mLiveCloudConfig;
    }

    @Override
    public void prepareAsync() {
        PlayerLogger.i(TAG, "prepareAsync");
        this.mStatBeginTick = System.currentTimeMillis();
        if (this.mLiveCloudConfig != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("module", "player");
            params.put("sdk_ver", LiveCloudPlayer.getVersion());
            params.put("so_ver", LiveCloudPlayer.getNativeVersion());
            Stats.sessionStart((String)this.mLiveCloudConfig.getSid(), (String)this.mLiveCloudConfig.getUid(), (String)this.mLiveCloudConfig.getCid(), (String)this.mLiveCloudConfig.getNet(), (String)this.mLiveCloudConfig.getSn(), params);
        } else {
            Logger.w((String)TAG, (String)"player config is null. not call session start function!");
        }
        if (this.isNeedSchedule()) {
            this.doPrepare(0);
        } else {
            PlayerLogger.d(TAG, "isNeedSchedule not mCallback=" + this.mCallback);
            if (this.mLiveCloudConfig != null) {
                this.mPlayUrl = this.mLiveCloudConfig.getSn();
                this.mLiveCloudConfig.setUrl(this.mPlayUrl);
            }
            if (this.mCallback != null) {
                this.mReturnProto = 8;
                this.setCurState(2);
                this.mCallback.onPrepared();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int seekto, boolean accurate) {
        PlayerLogger.i(TAG, "start seekto=" + seekto + ", state=" + this.mCurrentState + ", vod=" + this.isVod());
        this.isPlayComplete = false;
        if (this.mCurrentState == 4) {
            if (this.isVod() && this.mPlayerControl != null) {
                PlayerLogger.d(TAG, "LiveCloudPlayer, play");
                this.mPlayerControl.pause(0);
                this.setCurState(3);
            }
        } else {
            this.mSeekTo = seekto;
            this.setCurState(this.mCurrentState);
            if (this.mCurrentState <= 1) {
                return;
            }
            this.initPlayerControl(this.mPlayType);
            if (this.mPlayerControl != null) {
                PlayerControl playerControl = this.mPlayerControl;
                synchronized (playerControl) {
                    if (this.mCurrentState == 5 || this.mCurrentState == 6) {
                        this.mCurrentState = 2;
                    }
                    this.setCurState(this.mCurrentState);
                    if (this.mCurrentState == 2) {
                        if (this.mReturnProto == 2) {
                            if (this.mPlayerControl != null) {
                                PlayerLogger.i(TAG, "mIsHevc=" + this.mIsHevc);
                                int ret = this.mPlayerControl.openLivePlayer(0, 0, this.mIsHevc);
                                if (ret != 0) {
                                    if (this.mCallback != null) {
                                        this.mCallback.onInfo(112, 0L);
                                    }
                                    this.setPlayerId(ret);
                                    this.mPlayerControl.setCallback(this);
                                    if (this.previewDuration > 0) {
                                        this.mPlayerControl.setPreviewDuration(ret, this.previewDuration);
                                    }
                                    this.mPlayerControl.startLive();
                                } else {
                                    this.setCurState(-1);
                                    if (this.mCallback != null) {
                                        this.mCallback.onError(203, 1012L);
                                    }
                                }
                            }
                        } else if (this.isVod()) {
                            this.replay(seekto, accurate);
                        } else if (this.isLive()) {
                            this.rtmpLive();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void start(int seekto) {
        this.start(seekto, false);
    }

    private void setUseHw(PlayerControl playerControl, LiveCloudConfig config) {
        String packageNames = "";
        try {
            PackageInfo info = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 0);
            packageNames = info.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        PlayerLogger.d(TAG, "packageName=" + packageNames);
        int priority = 0;
        if (this.mDecodeMode == 11) {
            priority = 1;
        }
        PlayerLogger.i(TAG, "LiveCloudPlayer, use decode: " + priority);
        if (playerControl != null) {
            if (config != null) {
                Stats.notifyCommonStat((String)config.getSid(), (String)"decodemd", (int)402, (int)0, (String)("b_hwdecode=" + priority));
            }
            playerControl.setUseHwDecoderPriority(priority, packageNames);
        }
    }

    @Override
    public void pause() {
        PlayerLogger.i(TAG, "pause");
        if (this.isVod() && this.mPlayerControl != null) {
            this.mPlayerControl.pause(-1);
            this.setCurState(4);
            this.switchResolutionStop("pause action");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int reason) {
        Object object;
        PlayerLogger.i(TAG, "LiveCloudPlayer stop");
        this.mFailedHevcplayback = false;
        this.unInitTimer();
        this.setCurState(5);
        if (this.mPlayerControl != null) {
            object = this.mPlayerControl;
            synchronized (object) {
                if (this.mPlayerControl != null) {
                    this.mPlayerControl.close(reason);
                }
            }
        }
        if (this.mScreenOnWhilePlaying) {
            this.mWakeLock.release();
            this.mScreenOnWhilePlaying = false;
        }
        this.previewDuration = 0;
        this.onlyAudioPlay = false;
        this.audioReadyMsgReceive = false;
        this.videoReadyMsgReceive = false;
        this.firstSetDisplay = true;
        this.mFirstFrame = false;
        this.mPlayerId = 0;
        object = this;
        synchronized (object) {
            if (this.mSurfaceRead != null) {
                this.mSurfaceRead.release();
                this.mSurfaceRead = null;
            }
            this.mSurfaceTextCache = null;
            this.mSurfaceTextureCheck = null;
            if (this.mSurfaceTextureEGLSurface != null) {
                this.mSurfaceTextureEGLSurface.release();
                this.mSurfaceTextureEGLSurface = null;
            }
        }
        PlayerLogger.d(TAG, "LiveCloudPlayer stop end");
        this.switchResolutionStop("stop action");
    }

    @Override
    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        PlayerLogger.i(TAG, "release");
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            Looper looper = this.mHandler.getLooper();
            if (looper != Looper.getMainLooper()) {
                looper.quit();
            }
        }
        if (this.mPlayerControl != null) {
            PlayerControl playerControl = this.mPlayerControl;
            synchronized (playerControl) {
                if (this.mPlayerControl != null) {
                    this.mPlayerControl = null;
                }
            }
        }
        if (this.mLiveCloudConfig != null) {
            Stats.sessionStop((String)this.mLiveCloudConfig.getSid());
            Schedule.scheduleDestroy((String)this.mLiveCloudConfig.getSid());
        }
        this.setCurState(0);
        if (this.mLiveCloudConfig != null) {
            this.mLiveCloudConfig = null;
        }
        this.releaseDisplayList();
        this.mCurrentDisplay = null;
        this.mUseSwapSurface = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean find(ILiveCloudDisplay fdisplay) {
        boolean find = false;
        if (this.mDisplayList != null && this.mDisplayList.size() > 0) {
            LinkedList<ILiveCloudDisplay> linkedList = this.mDisplayList;
            synchronized (linkedList) {
                for (ILiveCloudDisplay dp : this.mDisplayList) {
                    if (dp != fdisplay) continue;
                    find = true;
                    break;
                }
            }
        }
        return find;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDisplayList() {
        if (this.mDisplayList != null) {
            LinkedList<ILiveCloudDisplay> linkedList = this.mDisplayList;
            synchronized (linkedList) {
                if (this.mDisplayList != null) {
                    this.mDisplayList.clear();
                    this.mDisplayList = null;
                }
            }
        }
    }

    @Override
    public void setDisplay(ILiveCloudDisplay display) {
        PlayerLogger.d(TAG, "setDisplay");
        if (display == null) {
            PlayerLogger.d(TAG, "display is null");
            return;
        }
        if (this.mDisplayList == null) {
            this.mDisplayList = new LinkedList();
        }
        if (this.mCurrentDisplay == null) {
            if (!this.find(display)) {
                this.mDisplayList.add(display);
            }
            this.mCurrentDisplay = display;
            if (this.mPlayerId != 0) {
                this.mCurrentDisplay.setHandle(this.mPlayerId);
            } else {
                this.firstSetDisplay = true;
            }
        } else if (this.mCurrentDisplay != null) {
            if (this.find(display)) {
                if (this.mCurrentDisplay == display) {
                    return;
                }
                this.mCurrentDisplay.stopRender();
                this.mCurrentDisplay = display;
                if (this.mFirstFrame) {
                    this.mCurrentDisplay.startRender();
                }
            } else {
                this.mCurrentDisplay.stopRender();
                this.mDisplayList.add(display);
                this.mCurrentDisplay = display;
                if (this.mPlayerId != 0) {
                    this.mCurrentDisplay.setHandle(this.mPlayerId);
                }
                if (this.mFirstFrame) {
                    this.mCurrentDisplay.startRender();
                }
            }
        }
    }

    @Override
    public void setScreenOnWhilePlaying(boolean screenOn) {
        PlayerLogger.d(TAG, "ScreenOnWhilePlaying=" + screenOn);
        this.mScreenOnWhilePlaying = screenOn;
    }

    @Override
    public void setMute(boolean mute) {
        PlayerLogger.d(TAG, "setMute mMute=" + this.mMute + " mute=" + mute);
        if (this.mMute == mute) {
            return;
        }
        this.mMute = mute;
        if (this.mPlayerControl != null && this.mPlayerControl.getPlayerId() != 0) {
            PlayerLogger.d(TAG, "setMute handle=" + this.mPlayerControl.getPlayerId());
            this.mPlayerControl.setMute(mute);
        } else {
            this.mUpdateMute = true;
            PlayerLogger.d(TAG, "setMute mUpdateMute=" + this.mUpdateMute);
        }
    }

    public void setHalfDisplay(int half) {
        if (half == 0) {
            return;
        }
        if (this.mPlayerControl != null && this.mPlayerControl.getPlayerId() != 0) {
            PlayerLogger.i(TAG, "setHalfDisplay half : " + half);
            this.mPlayerControl.setHalfDisplay(half);
        } else {
            this.mHalfDisplayer = half;
        }
    }

    @Override
    public void setOnLiveCloudCallback(OnLiveCloudCallback callback) {
        this.mCallback = callback;
    }

    @Override
    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    @Override
    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    @Override
    public boolean isPlaying() {
        PlayerLogger.d(TAG, "isPlaying");
        this.setCurState(this.mCurrentState);
        return this.mCurrentState == 3;
    }

    @Override
    public boolean isPaused() {
        PlayerLogger.d(TAG, "isPaused");
        this.setCurState(this.mCurrentState);
        return this.mCurrentState == 4;
    }

    @Override
    public boolean snapshot(String path) {
        if (this.mPlayerControl != null) {
            return this.mPlayerControl.snapshot(path);
        }
        return false;
    }

    public static int generateThumbnail(String videoPath, String jpgPath, int width, int height, long pos) {
        return PlayerControl.generateThumbnail(videoPath, jpgPath, width, height, pos);
    }

    @Override
    public void seekTo(int msec) {
        this.seekTo(msec, false);
    }

    @Override
    public void seekTo(int msec, boolean accurate) {
        PlayerLogger.i(TAG, "seekTo=" + msec + " accurate: " + accurate);
        if (this.isVod() && this.mPlayerControl != null) {
            this.mSeekTo = msec;
            if (this.mCurrentState == 6) {
                this.setCurState(3);
            }
            this.isPlayComplete = false;
            this.mIsSeeking = true;
            int seek = this.mPlayerControl.seekTo(msec, accurate);
            PlayerLogger.i(TAG, "seekReturn=" + seek);
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.stat(6, 0, 0, null);
            }
            this.switchResolutionStop("seek action");
        }
    }

    @Override
    public int getDuration() {
        long all;
        PlayerLogger.d(TAG, "getDuration");
        if (this.isVod() && this.mPlayerControl != null && (all = this.mPlayerControl.getPosition()) != 0L) {
            int total = (int)all;
            return total;
        }
        return 0;
    }

    @Override
    public int getCurrentPosition() {
        long all;
        PlayerLogger.d(TAG, "getCurrentPosition");
        if (this.isVod() && this.mPlayerControl != null && (all = this.mPlayerControl.getPosition()) != 0L) {
            int pro = (int)(all >> 32);
            if (!this.mSwitchResolutionDoing) {
                return pro;
            }
            PlayerLogger.d(TAG, "get current position. switch resolution doing cache position: " + this.mSwitchResolutionDoingCachePosition);
            return this.mSwitchResolutionDoingCachePosition;
        }
        return 0;
    }

    private String playTypeStr(int playType) {
        String ptStr = "LIVE";
        if (playType == 2) {
            ptStr = "VOD";
        }
        return ptStr;
    }

    @SuppressLint(value={"Wakelock"})
    private void initPlayerControl(int playType) {
        PlayerLogger.d(TAG, "initPlayerControl playType=" + this.playTypeStr(playType));
        try {
            if (this.mPlayerControl == null) {
                this.mPlayerControl = new PlayerControl();
            }
            if (this.mPlayerControl != null && this.mLiveCloudConfig != null) {
                this.mPlayerControl.setUid(this.mLiveCloudConfig.getUid());
            }
            if (this.mPlayerControl != null && this.mLiveCloudConfig != null) {
                this.mPlayerControl.setCid(this.mLiveCloudConfig.getCid());
            }
            if (this.mPlayerControl != null && this.mLiveCloudConfig != null) {
                this.mPlayerControl.setSN(this.mLiveCloudConfig.getSn());
            }
            if (this.mPlayerControl != null && this.mLiveCloudConfig != null) {
                this.mPlayerControl.setSid(this.mLiveCloudConfig.getSid());
            }
            if (this.mScreenOnWhilePlaying) {
                PowerManager powerManager = null;
                powerManager = (PowerManager)this.mContext.getSystemService("power");
                this.mWakeLock = powerManager.newWakeLock(10, "Play Lock");
                this.mWakeLock.acquire();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isVod() {
        return this.mPlayType == 2;
    }

    private boolean isLive() {
        return this.mPlayType == 1;
    }

    private boolean isNeedSchedule() {
        boolean need = false;
        if (this.isVod()) {
            return need;
        }
        if (this.mLiveCloudConfig != null && !TextUtils.isEmpty((CharSequence)this.mLiveCloudConfig.getSn())) {
            need = Schedule.scheduleIsNecessary((String)this.mLiveCloudConfig.getSn());
            PlayerLogger.d(TAG, "need schedule=" + need);
        }
        return need;
    }

    private void replay(int seekto, boolean accurate) {
        PlayerLogger.d(TAG, "replay=" + seekto);
        this.initTimer();
        try {
            int ret = 0;
            if (this.mPlayerControl != null) {
                ret = this.mPlayerControl.openHls(this.mPlayUrl, 1, seekto, true, accurate ? 1 : 0);
                this.setPlayerId(ret);
                if (this.mPlayerSettings != null) {
                    this.mPlayerControl.playerSetting(this.mPlayerSettings);
                }
                this.mPlayerControl.setCallback(this);
                if (ret != 0) {
                    if (this.previewDuration > 0) {
                        this.mPlayerControl.setPreviewDuration(ret, this.previewDuration);
                    }
                    this.mPlayerControl.startLive();
                }
                PlayerLogger.d(TAG, "open hls handle=" + ret + " seekto=" + seekto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void rtmpLive() {
        PlayerLogger.d(TAG, "rtmpLive");
        if (this.mPlayerControl != null) {
            int ret = this.mPlayerControl.openVideoUrl(this.mPlayUrl);
            PlayerLogger.d(TAG, "openVideoUrl handle : " + ret);
            if (this.mCallback != null) {
                this.mCallback.onInfo(112, 0L);
            }
            this.setPlayerId(ret);
            if (this.mPlayerSettings != null) {
                this.mPlayerControl.playerSetting(this.mPlayerSettings);
            }
            this.mPlayerControl.setCallback(this);
            if (ret != 0) {
                if (this.previewDuration > 0) {
                    this.mPlayerControl.setPreviewDuration(ret, this.previewDuration);
                }
                this.mPlayerControl.startLive();
            }
        }
    }

    private void doPrepare(int backup) {
        if (this.mLiveCloudConfig == null) {
            if (this.mCallback != null) {
                this.mCallback.onError(202, 1002L);
            }
            return;
        }
        if (!this.mSetScheduleUrl && !this.mLiveCloudConfig.getCid().contains("huajiao")) {
            this.mUrl = "http://g.live.360.cn/";
        }
        Schedule.scheduleDoscheduling((String)this.mLiveCloudConfig.getSid(), (String)this.mUrl, (int)this.mDelaySecond, (String)"0", null, (int)this.mType, (int)this.mProto, null, null, (String)this.mLiveCloudConfig.getSign(), (String)"h265", (String)"sd", (String)this.mStreamType, (ScheduleCallBack)new ScheduleCallBack(){

            public void scheduleState(int event, int errCode, String sid, ServerAddrs serverAddrs) {
                PlayerLogger.i(LiveCloudPlayer.TAG, "enent=" + event + " sid=" + sid + " ServerAddrs: " + (serverAddrs == null ? "" : serverAddrs.toString()));
                if (event == 4 && serverAddrs != null) {
                    PlayerLogger.d(LiveCloudPlayer.TAG, serverAddrs.toString());
                    LiveCloudPlayer.this.mReturnProto = serverAddrs.getProto();
                    LiveCloudPlayer.this.mPlayUrl = serverAddrs.getMainAddr();
                    LiveCloudPlayer.this.mIsHevc = serverAddrs.getIsH265();
                    LiveCloudPlayer.this.setCurState(2);
                    if (LiveCloudPlayer.this.mLiveCloudConfig != null) {
                        LiveCloudPlayer.this.mLiveCloudConfig.setUrl(LiveCloudPlayer.this.mPlayUrl);
                    }
                    if (LiveCloudPlayer.this.mFailedHevcplayback) {
                        LiveCloudPlayer.this.start(0);
                    } else if (LiveCloudPlayer.this.mCallback != null) {
                        LiveCloudPlayer.this.mCallback.onPrepared();
                    }
                } else if (event == 5) {
                    LiveCloudPlayer.this.setCurState(-1);
                    if (LiveCloudPlayer.this.mCallback != null) {
                        LiveCloudPlayer.this.mCallback.onError(202, 1002L);
                    }
                }
            }
        });
    }

    @Override
    public void onPlayerMsg(int handle, int command, long para1, long para2, int user) {
        if (handle != this.mPlayerId) {
            PlayerLogger.d(TAG, "player id is diff! handle=" + handle + " command=" + command + " para1=" + para1 + " para2=" + para2 + " user=" + user);
            return;
        }
        switch (command) {
            case -1001: {
                PlayerLogger.e(TAG, "JPLAYER_MSG_NO_INIT_FAIL");
                if (this.mFormatNotSupport) {
                    this.mFormatNotSupport = false;
                    return;
                }
                this.setCurState(-1);
                if (this.mCallback == null) break;
                this.mCallback.onError(203, 1011L);
                break;
            }
            case -975: {
                this.setCurState(-1);
                PlayerLogger.e(TAG, "JPLAYER_MSG_CONNECT_FAILED");
                if (para1 == 0L) {
                    if (this.mCallback == null) break;
                    this.mCallback.onError(203, 1013L);
                    break;
                }
                if (para1 == 1L) {
                    if (this.mCallback == null) break;
                    this.mCallback.onError(203, 1030L);
                    break;
                }
                if (this.mCallback == null) break;
                this.mCallback.onError(203, 1000L);
                break;
            }
            case -978: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_SESSION_CONNECTED");
                break;
            }
            case -989: {
                PlayerLogger.e(TAG, "JPLAYER_MSG_RECORD_ERROR");
                this.setCurState(-1);
                if (this.mCallback == null) break;
                this.mCallback.onError(204, 1040L);
                break;
            }
            case -987: {
                PlayerLogger.e(TAG, "JPLAYER_MSG_RECORD_INVALID_FILE");
                this.setCurState(-1);
                if (this.mCallback == null) break;
                this.mCallback.onError(204, 1041L);
                break;
            }
            case -977: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_RECORD_TIMER");
                if (this.mCallback == null) break;
                this.mCallback.onInfo(102, para1);
                break;
            }
            case -988: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_RECORD_ENDSTREAM");
                if (this.mCallback == null) break;
                this.mCallback.onInfo(103, 101L);
                break;
            }
            case -1000: {
                PlayerLogger.e(TAG, "JPLAYER_MSG_SUBSCRIBE_FAILED");
                this.setCurState(-1);
                if (this.mCallback == null) break;
                this.mCallback.onError(203, 1014L);
                break;
            }
            case 10: {
                PlayerLogger.i(TAG, "JPLAYER_MSG_START_SUCCESS");
                break;
            }
            case -992: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_AUDIO_IS_READY para1: " + para1);
                this.audioReadyMsgReceive = true;
                if (0L == para1) {
                    this.onlyAudioPlay = true;
                    if (this.mCurrentState == 2) {
                        this.setCurState(3);
                        if (this.mPlayerControl != null) {
                            this.mPlayerControl.playSound();
                        }
                        this.reportPlayStart();
                        PlayerLogger.d(TAG, "mIsHevc=" + this.mIsHevc);
                        if (this.mIsHevc == 1 && this.mCallback != null) {
                            this.mCallback.onInfo(110, 1L);
                        }
                    }
                    if (!this.mUpdateMute || this.mPlayerControl == null) break;
                    this.mPlayerControl.setMute(this.mMute);
                    this.mUpdateMute = false;
                    break;
                }
                this.onlyAudioPlay = false;
                break;
            }
            case -999: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_VIDEO_IS_READY. para1: " + para1);
                if (this.mSwitchResolutionDoing) {
                    this.mSwitchResolutionDoing = false;
                    if (this.switchResolutionListener != null) {
                        this.switchResolutionListener.onSuccess(this.mSourceIndex, this.mSource[this.mSourceIndex]);
                    }
                }
                if (!this.onlyAudioPlay) {
                    if (this.mCurrentState == 2) {
                        this.setCurState(3);
                        if (this.mCurrentDisplay != null) {
                            PlayerLogger.d(TAG, "startRender handle : " + this.mPlayerId);
                            if (!this.mFirstFrame) {
                                this.mCurrentDisplay.startRender();
                                this.mFirstFrame = true;
                            }
                        }
                        if (this.mPlayerControl != null) {
                            this.mPlayerControl.playSound();
                        }
                        this.reportPlayStart();
                        PlayerLogger.d(TAG, "mIsHevc=" + this.mIsHevc);
                        if (this.mIsHevc == 1 && this.mCallback != null) {
                            this.mCallback.onInfo(110, 1L);
                        }
                    }
                    if (!this.mUpdateMute || this.mPlayerControl == null) break;
                    this.mPlayerControl.setMute(this.mMute);
                    this.mUpdateMute = false;
                    break;
                }
                this.onlyAudioPlay = false;
                if (!this.isPlaying() || this.mCurrentDisplay == null) break;
                PlayerLogger.d(TAG, "startRender handle : " + this.mPlayerId);
                if (this.mFirstFrame) break;
                this.mCurrentDisplay.startRender();
                this.mFirstFrame = true;
                break;
            }
            case -995: {
                this.mVideoWidth = (int)para1;
                this.mVideoHeight = (int)para2;
                PlayerLogger.i(TAG, "JPLAYER_MSG_VIDEO_SIZE_CHANGE videoWidth=" + this.mVideoWidth + " videoHeight=" + this.mVideoHeight);
                if (this.mSarNum > 0 && this.mSarDen > 0) {
                    this.mVideoWidth = this.mVideoWidth * this.mSarNum / this.mSarDen;
                }
                if (this.mCallback == null) break;
                this.mCallback.onSizeChanged(this.mVideoWidth, this.mVideoHeight);
                break;
            }
            case -950: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_STARTBUFFERING");
                this.setCurState(this.mCurrentState);
                if (this.mCurrentState != 3) {
                    return;
                }
                if (this.mCallback == null) break;
                this.mCallback.onBufferingUpdate(0, 0);
                break;
            }
            case -949: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_STOPBUFFERING");
                this.setCurState(this.mCurrentState);
                if (this.mCurrentState != 3) {
                    return;
                }
                if (this.mCallback == null) break;
                this.mCallback.onBufferingUpdate(1, 100);
                break;
            }
            case -996: {
                this.replayStatusUpdate(para1, para2, user);
                break;
            }
            case -979: {
                PlayerLogger.i(TAG, "JPLAYER_MSG_SESSION_CLOSED");
                if (this.mCallback == null) break;
                this.mCallback.onInfo(107, -979L);
                break;
            }
            case -998: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_VIDEO_RESOLUTION");
                break;
            }
            case -899: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_BUSY");
                break;
            }
            case -997: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_AUDIO_IS_SILENT");
                break;
            }
            case -974: {
                PlayerLogger.i(TAG, "JPLAYER_MSG_CONNECT_COMPLETE");
                if (this.mCurrentState == 3 && this.isVod()) {
                    int duration = this.getDuration();
                    this.mCallback.onProgressChange(duration, duration);
                }
                this.setCurState(6);
                if (this.isPlayComplete) break;
                this.isPlayComplete = true;
                if (this.mCallback == null || this.mHandler == null) break;
                this.mHandler.postAtFrontOfQueue(new Runnable(){

                    @Override
                    public void run() {
                        if (LiveCloudPlayer.this.mCallback != null) {
                            LiveCloudPlayer.this.mCallback.onCompletion();
                        }
                    }
                });
                break;
            }
            case -973: {
                PlayerLogger.i(TAG, "JPLAYER_MSG_CONNECT_INBACKGOURND");
                if (this.mCallback == null) break;
                this.mCallback.onInfo(108, -973L);
                break;
            }
            case -930: {
                this.setCurState(-1);
                PlayerLogger.e(TAG, "JPLAYER_MSG_ERROR_FORMATNOTSUPPORT");
                this.mFormatNotSupport = true;
                if (this.mCallback == null) break;
                this.mCallback.onError(205, para1);
                break;
            }
            case -931: {
                PlayerLogger.e(TAG, "JPLAYER_MSG_ERROR_FILENOTOPEN handle=" + handle + " command=" + command + " para1=" + para1 + " para2=" + para2 + " user=" + user);
                if (this.mCallback == null) break;
                this.mCallback.onError(206, para1);
                break;
            }
            case -800: {
                PlayerLogger.e(TAG, "JPLAYER_MSG_HW_DECODER_IS_NOT_SUPPORT");
                if (this.mCallback != null && this.mLiveCloudConfig != null) {
                    String encoderUrl = "";
                    try {
                        encoderUrl = URLEncoder.encode(this.mPlayUrl, "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        encoderUrl = "";
                        PlayerLogger.d(TAG, e.getMessage());
                    }
                    if (!TextUtils.isEmpty((CharSequence)encoderUrl)) {
                        String s = "b_url=" + encoderUrl + "&b_ishevc=" + this.mIsHevc;
                        Stats.notifyCommonStat((String)this.mLiveCloudConfig.getSid(), (String)"hwdecodefail", (int)403, (int)((int)para2), (String)s);
                    }
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PlayerLogger.i(LiveCloudPlayer.TAG, "JPLAYER_MSG_HW_DECODER_IS_NOT_SUPPORT switch soft decode");
                        int seekValue = LiveCloudPlayer.this.getCurrentPosition();
                        LiveCloudPlayer.this.stop(0);
                        LiveCloudPlayer.this.setDecoderMode(10);
                        PlayerLogger.d(LiveCloudPlayer.TAG, "LiveCloudPlayer setDecoderMode(ILiveCloudPlayer.DecoderMode.LIVECLOUD_SOFT_DECODE_MODE) seekValue = " + seekValue);
                        if (LiveCloudPlayer.this.mInBackground) {
                            LiveCloudPlayer.this.setInBackground(true);
                            PlayerLogger.d(LiveCloudPlayer.TAG, "LiveCloudPlayer setInBackground(true)");
                        }
                        LiveCloudPlayer.this.start(seekValue);
                    }
                });
                break;
            }
            case -994: {
                if (this.mCallback == null) break;
                PlayerLogger.d(TAG, "JPLAYER_MSG_DVRENDER handle=" + handle + " para1=" + para1 + " para2=" + para2);
                this.mCallback.onDvRenderCb(handle, para1, para2);
                break;
            }
            case -920: {
                PlayerLogger.e(TAG, "JPLAYER_MSG_FAILED_HEVCPLAYBACK");
                if (this.mIsHevc == 1 && this.mCallback != null) {
                    this.mCallback.onInfo(110, 0L);
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PlayerLogger.d(LiveCloudPlayer.TAG, "stop play h265");
                        Stats.sessionStop((String)LiveCloudPlayer.this.mLiveCloudConfig.getSid());
                        LiveCloudPlayer.this.mCurrentDisplay.stopRender();
                        LiveCloudPlayer.this.stop(0);
                    }
                });
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        LiveCloudPlayer.this.resumePlay();
                    }
                }, 2500L);
                break;
            }
            case -700: {
                if (this.mCallback == null) break;
                PlayerLogger.d(TAG, "JPLAYER_MSG_DVRENDER_RESETSURFACE handle=" + handle + " para1=" + para1 + " para2=" + para2);
                this.mCallback.onDvRenderCb(handle, -700L, para2);
                break;
            }
            case -929: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_VIDEOCACHE handle=" + handle + " para1=" + para1);
                if (this.mCallback == null) break;
                if (para1 == 1L) {
                    this.mCallback.onInfo(109, 1L);
                    break;
                }
                PlayerLogger.e(TAG, "JPLAYER_MSG_VIDEOCACHE failed");
                this.mCallback.onInfo(109, 0L);
                break;
            }
            case -500: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_RECORD_SUCCUSS handle=" + handle);
                if (this.mCallback == null) break;
                this.mCallback.onInfo(122, para1);
                break;
            }
            case -991: {
                this.mSarNum = (int)para1;
                this.mSarDen = (int)para2;
                PlayerLogger.i(TAG, "JPLAYER_MSG_VIDEO_SAR mSarNum=" + this.mSarNum + " mSarDen=" + this.mSarDen);
                break;
            }
            default: {
                PlayerLogger.d(TAG, "JPLAYER_MSG_OTHER handle=" + handle + " command=" + command + " para1=" + para1 + " para2=" + para2 + " user=" + user);
            }
        }
    }

    private void replayStatusUpdate(long para1, long para2, int user) {
        if (user == 1 && this.mBufferingUpdate) {
            int progress = 0;
            if (para2 > 0L && para1 > 0L) {
                progress = (int)(para1 * 100L / para2);
            }
            if (progress > 100) {
                progress = 100;
            }
            PlayerLogger.d(TAG, "onBufferingUpdate Buffer.PROGRESS. progress: " + progress);
            if (this.mCallback != null) {
                this.mCallback.onBufferingUpdate(2, progress);
            }
            return;
        }
        if (user == 1) {
            this.mBufferingUpdate = true;
            if (this.mCallback != null) {
                PlayerLogger.d(TAG, "onBufferingUpdate Buffer.START. ");
                if (this.mPlayMonitor != null) {
                    this.mPlayMonitor.stat(4, 0, 0, null);
                }
                this.mCallback.onBufferingUpdate(0, 0);
            }
        }
        if (user == 0 && this.mBufferingUpdate) {
            this.mBufferingUpdate = false;
            if (this.mCallback != null) {
                PlayerLogger.d(TAG, "onBufferingUpdate Buffer.STOP. position: " + this.getCurrentPosition());
                if (this.mPlayMonitor != null) {
                    this.mPlayMonitor.stat(4, 1, 0, null);
                }
                this.mCallback.onBufferingUpdate(1, 100);
                if (this.mSeekTo > 0) {
                    this.mIsSeeking = false;
                    this.mCallback.onSeekComplete();
                }
            }
        }
    }

    @Override
    public void onUpdateStatus(int handle, int vbps, int abps, int vfps, int afps, int sdvbps, int sdabps, int sdvfps, int sdafps, int user) {
        if (this.mCallback != null && this.mCurrentState == 3 && this.isLive()) {
            PlayerLogger.d(TAG, "onLiveUpdateStatus");
            this.setCurState(this.mCurrentState);
            int downloadSpeed = (vbps + abps) / 1024;
            if (downloadSpeed <= 0) {
                downloadSpeed = 0;
            }
            this.mCallback.onInfo(105, downloadSpeed);
            this.mCallback.onInfo(106, vfps);
        }
    }

    @Override
    public void onUpdateGPPlayState(int handle, long nowTime, long videoBufferTime, long audioBufferTime) {
        if (!this.isLive() || this.mPlayerSettings == null || this.mPlayerSettings.getGp_play_state_upload() == 0) {
            return;
        }
        PlayerLogger.d(TAG, "onUpdateGPPlayerState nt = " + nowTime + ", bvt = " + videoBufferTime + ", bat = " + audioBufferTime);
    }

    public void setPlayerControlConfig(PlayerControl playerControl, LiveCloudConfig liveCloudConfig, int playerId) {
        PlayerLogger.d(TAG, "set player control config.");
        if (playerControl != null && playerId != 0) {
            this.setUseHw(playerControl, liveCloudConfig);
            this.setUseQy265dec(playerControl, playerId, true);
            playerControl.setStreamType(this.cStreamType());
            playerControl.setPlayMode(this.mMode);
        }
    }

    private void initTimer() {
        if (this.mTimer == null) {
            PlayerLogger.d(TAG, "initTimer");
            this.mTimer = new Timer();
        }
        if (this.mTimerTask == null) {
            this.mTimerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (LiveCloudPlayer.this.mCurrentState == -1) {
                        PlayerLogger.d(LiveCloudPlayer.TAG, "drop run");
                        LiveCloudPlayer.this.unInitTimer();
                        return;
                    }
                    if ((LiveCloudPlayer.this.mCurrentState == 3 || LiveCloudPlayer.this.mCurrentState == 4) && LiveCloudPlayer.this.isVod() && !LiveCloudPlayer.this.mSwitchResolutionDoing) {
                        if (LiveCloudPlayer.this.mPlayerControl != null && LiveCloudPlayer.this.mCurrentState == 3) {
                            long all = 0L;
                            PlayerControl playerControl = LiveCloudPlayer.this.mPlayerControl;
                            synchronized (playerControl) {
                                if (LiveCloudPlayer.this.mPlayerControl != null) {
                                    all = LiveCloudPlayer.this.mPlayerControl.getPosition();
                                }
                            }
                            if (all != 0L) {
                                int pro = (int)(all >> 32);
                                int total = (int)all;
                                if (LiveCloudPlayer.this.mCallback != null && total != 0) {
                                    PlayerLogger.v(LiveCloudPlayer.TAG, "onProgressChange total : " + total + " pro : " + pro);
                                    LiveCloudPlayer.this.mCallback.onProgressChange(total, pro);
                                    if (total == pro && !LiveCloudPlayer.this.isPlayComplete) {
                                        LiveCloudPlayer.this.isPlayComplete = true;
                                        LiveCloudPlayer.this.setCurState(6);
                                        PlayerLogger.d(LiveCloudPlayer.TAG, "onCompletion");
                                        LiveCloudPlayer.this.mCallback.onCompletion();
                                    }
                                }
                                if (LiveCloudPlayer.this.mPlayMonitor != null) {
                                    LiveCloudPlayer.this.mPlayMonitor.stat(1, total, pro, null);
                                }
                            }
                        }
                        if (LiveCloudPlayer.this.mPlayerControl != null && LiveCloudPlayer.this.mCallback != null) {
                            long cacheDuration = 0L;
                            PlayerControl playerControl = LiveCloudPlayer.this.mPlayerControl;
                            synchronized (playerControl) {
                                if (LiveCloudPlayer.this.mPlayerControl != null) {
                                    cacheDuration = LiveCloudPlayer.this.mLocalServerHelper != null ? LiveCloudPlayer.this.mLocalServerHelper.getCacheDuration() : LiveCloudPlayer.this.mPlayerControl.getCacheDuration();
                                }
                            }
                            if (Logger.LOG_ENABLE) {
                                Logger.i((String)LiveCloudPlayer.TAG, (String)("cache duration: " + cacheDuration));
                            }
                            if (cacheDuration >= 0L) {
                                if (LiveCloudPlayer.this.mCallback != null) {
                                    LiveCloudPlayer.this.mCallback.onCacheDuration(cacheDuration);
                                }
                                if (LiveCloudPlayer.this.mPlayMonitor != null) {
                                    LiveCloudPlayer.this.mPlayMonitor.stat(0, (int)cacheDuration, 0, null);
                                }
                            }
                        }
                    }
                    if (LiveCloudPlayer.this.isPlaying() && !LiveCloudPlayer.this.mInBackground && !LiveCloudPlayer.this.isPlayComplete && !LiveCloudPlayer.this.mIsSeeking && LiveCloudPlayer.this.isResolutionAdapt && LiveCloudPlayer.this.mSourceIndex + 1 < LiveCloudPlayer.this.mSource.length && LiveCloudPlayer.this.mResolutionMgr != null && LiveCloudPlayer.this.mResolutionMgr.getSwitchStatus() == 0 && LiveCloudPlayer.this.mPlayMonitor != null && LiveCloudPlayer.this.mPlayMonitor.needSwitchResolution(LiveCloudPlayer.this.mContext, true)) {
                        PlayerLogger.d(LiveCloudPlayer.TAG, "need switch resolution");
                        if (LiveCloudPlayer.this.mHandler != null) {
                            LiveCloudPlayer.this.mHandler.postAtFrontOfQueue(new Runnable(){

                                @Override
                                public void run() {
                                    LiveCloudPlayer.this.switchResolutionImpl(LiveCloudPlayer.this.mSourceIndex + 1, LiveCloudPlayer.this.switchResolutionListener, true);
                                }
                            });
                        }
                    }
                }
            };
            this.mTimer.scheduleAtFixedRate(this.mTimerTask, 0L, 1000L);
        }
    }

    private void unInitTimer() {
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
        if (this.mTimer != null) {
            PlayerLogger.d(TAG, "unInitTimer");
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    @Override
    public void setDecoderMode(int decodeMode) {
        int blackListSupport;
        int useHwDecode;
        this.mDecodeMode = 10;
        if (this.mPlayerSettings != null && (useHwDecode = this.mPlayerSettings.getUse_hw_decode()) == 1 && (blackListSupport = GPWebrtcSettings.getInstance().getEnableLiveHwDecodeH264()) == 1) {
            this.mDecodeMode = decodeMode;
        }
    }

    @Override
    public int getDecoderMode() {
        if (this.mPlayerControl != null) {
            if (this.mPlayerControl.getUseHwDecoder() == 1) {
                return 11;
            }
            return 10;
        }
        return this.mDecodeMode;
    }

    @Override
    public boolean isInitialized() {
        return this.mCurrentState == 2 || this.mCurrentState == 3 || this.mCurrentState == 4;
    }

    @Override
    public OnLiveCloudCallback getOnLiveCloudCallback() {
        return this.mCallback;
    }

    @Override
    public boolean isMute() {
        return this.mMute;
    }

    @Override
    public void setPlayDelayTime(int second) {
        PlayerLogger.d(TAG, "setPlayDelayTime second : " + second);
        this.mDelaySecond = second;
    }

    @Override
    public void addToGroup(int group) {
        PlayerLogger.d(TAG, "addToGroup=" + group);
        if (this.mPlayerControl != null) {
            int openAddGroup = 1;
            if (this.mPlayerSettings != null) {
                openAddGroup = this.mPlayerSettings.getOpen_addgroup();
            }
            if (openAddGroup == 1) {
                this.mPlayerControl.addToGroup(group);
            }
        } else {
            this.mAddToGroup = true;
            this.mGroup = group;
        }
    }

    private void setPlayerId(int playerId) {
        PlayerLogger.d(TAG, "setPlayerId handle=" + playerId);
        if (this.mPlayerControl != null) {
            this.mPlayerControl.setPlayerId(playerId);
            PlayerLogger.d(TAG, "setPlayerId mUpdateMute=" + this.mUpdateMute + " mMute=" + this.mMute);
            if (this.mUpdateMute) {
                this.mPlayerControl.setMute(this.mMute);
                this.mUpdateMute = false;
            }
        }
        this.setUseHw(this.mPlayerControl, this.mLiveCloudConfig);
        this.mPlayerId = playerId;
        this.setUseQy265dec(this.mPlayerControl, playerId, true);
        this.mPlayerControl.setStreamType(this.cStreamType());
        if (this.firstSetDisplay) {
            if (this.mCurrentDisplay != null) {
                this.mCurrentDisplay.setHandle(playerId);
            }
            this.firstSetDisplay = false;
        }
        if (this.mSetInBackground) {
            this.mSetInBackground = false;
            this.setInBackground(this.mInBackground);
        }
        if (this.mHalfDisplayer != 0) {
            PlayerLogger.d(TAG, "setHalfDisplay mHalfDisplayer=" + this.mHalfDisplayer);
            this.mPlayerControl.setHalfDisplay(this.mHalfDisplayer);
        }
        if (this.mAddToGroup) {
            this.mAddToGroup = false;
            this.addToGroup(this.mGroup);
        }
        if (this.mSetCacheFilePath) {
            this.mSetCacheFilePath = false;
            this.mPlayerControl.setCacheFilePath(this.mFilePath, this.mMaxCacheDuration, this.mMaxCacheFileSize);
        }
        if (this.mSetPlayMode) {
            this.mSetPlayMode = false;
            this.mPlayerControl.setPlayMode(this.mMode);
        }
    }

    private int cStreamType() {
        if (this.mStreamType.equals("audio")) {
            return 0;
        }
        if (this.mStreamType.equals("video")) {
            return 1;
        }
        return 2;
    }

    public int getPlayerId() {
        if (this.mPlayerControl != null) {
            return this.mPlayerControl.getPlayerId();
        }
        return 0;
    }

    @Override
    public void setInBackground(boolean inBackground) {
        PlayerLogger.i(TAG, "setInBackground=" + inBackground);
        this.mInBackground = inBackground;
        if (this.mPlayerControl != null) {
            if (this.mPlayerId != 0) {
                this.mPlayerControl.setInBackground(inBackground);
            } else {
                this.mSetInBackground = true;
            }
        }
    }

    @Override
    public void setCacheFilePath(String filePath, long maxCacheDuration, long maxCacheFileSize) {
        PlayerLogger.d(TAG, "setCacheFilePath filePath=" + filePath);
        if (this.mPlayerId != 0 && this.mPlayerControl != null) {
            this.mPlayerControl.setCacheFilePath(filePath, maxCacheDuration, maxCacheFileSize);
        } else {
            this.mSetCacheFilePath = true;
            this.mFilePath = filePath;
            this.mMaxCacheDuration = maxCacheDuration;
            this.mMaxCacheFileSize = maxCacheFileSize;
        }
    }

    @Override
    public void setPlayMode(int mode) {
        PlayerLogger.i(TAG, "setPlayMode mode=" + mode);
        if (this.mPlayerId != 0 && this.mPlayerControl != null) {
            this.mPlayerControl.setPlayMode(mode);
        } else {
            this.mMode = mode;
            this.mSetPlayMode = true;
        }
    }

    private void setCurState(int state) {
        this.mCurrentState = state;
        String curState = "UNINIT";
        switch (this.mCurrentState) {
            case -1: {
                curState = "ERROR";
                break;
            }
            case 0: {
                curState = "UNINIT";
                break;
            }
            case 1: {
                curState = "IDLE";
                break;
            }
            case 2: {
                curState = "PREPARING";
                break;
            }
            case 3: {
                curState = "PLAYING";
                break;
            }
            case 4: {
                curState = "PAUSED";
                break;
            }
            case 5: {
                curState = "STOP";
                break;
            }
            case 6: {
                curState = "COMPLETED";
            }
        }
        PlayerLogger.d(TAG, "CurState=" + curState);
    }

    public long getCurrentStreamTime() {
        PlayerLogger.d(TAG, "getCurrentStreamTime");
        if (this.mPlayerControl != null) {
            return this.mPlayerControl.getcurrentstreamtime();
        }
        return 0L;
    }

    private void resumePlay() {
        if (this.mLiveCloudConfig == null) {
            return;
        }
        PlayerLogger.i(TAG, "resume play h264 mIsHevc=" + this.mIsHevc);
        this.mLiveCloudConfig.setSid(this.mLiveCloudConfig.getSid() + SESSION_ID_SUFFIX_HEVC_FAILED);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("module", "player");
        params.put("sdk_ver", LiveCloudPlayer.getVersion());
        params.put("so_ver", LiveCloudPlayer.getNativeVersion());
        Stats.sessionStart((String)this.mLiveCloudConfig.getSid(), (String)this.mLiveCloudConfig.getUid(), (String)this.mLiveCloudConfig.getCid(), (String)this.mLiveCloudConfig.getNet(), (String)this.mLiveCloudConfig.getSn(), params);
        this.firstSetDisplay = true;
        this.mFirstFrame = false;
        this.mFailedHevcplayback = true;
        if (this.mIsHevc == 1) {
            this.doPrepare(1);
        }
    }

    @Override
    public void onUserDefineData(int handle, byte[] data, int length) {
        PlayerLogger.d(TAG, "onUserDefineData handle=" + handle + " length=" + length);
        if (this.mCallback != null) {
            this.mCallback.onUserDefineData(data);
        }
    }

    @Override
    public void onMessage(int handle, int id, int type, int flags, int size, long data, long time) {
        if (this.mAACByteBuffer != null && this.mCallback != null) {
            this.mCallback.onCapMsg(id, type, flags, size, this.mAACByteBuffer, time);
            if (this.mRecorderSDK != null) {
                if (this.mAudioInfo == null) {
                    this.mAudioInfo = new AudioInfo();
                }
                this.mPlayerControl.getAudioInfo(handle, this.mAudioInfo);
                this.mRecorderSDK.writeAudioData(this.mAACByteBuffer, size, time, this.mAudioInfo.getChannel(), this.mAudioInfo.getBitsPerSample(), this.mAudioInfo.getSampleRate());
            }
        }
    }

    public void startRecordAAC() {
        PlayerLogger.d(TAG, "startRecordAAC");
        try {
            if (this.mAACByteBuffer == null) {
                this.mAACByteBuffer = ByteBuffer.allocateDirect(this.AAC_BUFFER_SIZE);
            }
            if (this.mPlayerControl != null && this.mPlayerId != 0) {
                this.mPlayerControl.startRecordAAC(this.mAACByteBuffer, this.AAC_BUFFER_SIZE, System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopRecordAAC() {
        PlayerLogger.d(TAG, "stopRecordAAC");
        try {
            if (this.mPlayerControl != null && this.mPlayerId != 0) {
                this.mPlayerControl.stopRecordAAC();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPreviewDuration(int duration) {
        this.previewDuration = duration;
    }

    @Override
    public int getAudioInfo(AudioInfo audioInfo) {
        if (this.mPlayerControl != null && this.mPlayerId != 0) {
            return this.mPlayerControl.getAudioInfo(this.mPlayerId, audioInfo);
        }
        return -1;
    }

    @Override
    public void getMediaInformation(MediaInformation mediaInformation) {
        if (this.mPlayerControl != null && this.mPlayerId != 0) {
            this.mPlayerControl.getMediaInformation(this.mPlayerId, mediaInformation);
        }
    }

    private void setAppContext(Context appContext) {
        PlayerControl.setAppContext(appContext);
    }

    private void setUseQy265dec(PlayerControl playerControl, int playerId, boolean isUseQy265dec) {
        if (playerId != 0 && playerControl != null) {
            int useQy265decFlag = 0;
            if (isUseQy265dec) {
                if (this.mPlayerSettings != null) {
                    useQy265decFlag = this.mPlayerSettings.getUse_qy265dec();
                }
                if (useQy265decFlag != 0) {
                    useQy265decFlag = QHVCQyCodec.supportQy265dec(this.mContext) ? 1 : 0;
                }
            }
            PlayerLogger.i(TAG, "setUseQy265dec playerId: " + playerId + " flags: " + useQy265decFlag);
            playerControl.setUseQy265dec(playerId, useQy265decFlag);
        }
    }

    private int getUseQy265dec() {
        if (this.mPlayerId != 0 && this.mPlayerControl != null) {
            return this.mPlayerControl.getUseQy265dec(this.mPlayerId);
        }
        return -1;
    }

    @Override
    public void setStreamType(String type) {
        this.mStreamType = type;
    }

    @Override
    public void setVolume(float volume) {
        if (this.mPlayerId != 0 && this.mPlayerControl != null) {
            this.mPlayerControl.setVolume(volume);
        }
    }

    @Override
    public float getVolume() {
        if (this.mPlayerId != 0 && this.mPlayerControl != null) {
            return this.mPlayerControl.getVolume();
        }
        return -1.0f;
    }

    @Override
    public synchronized void setSurface(final String from, SurfaceTexture texture) {
        PlayerLogger.i(TAG, "LiveCloudPlayer synchronized void setSurface from = " + from + " texture = " + texture);
        if (this.mCurrentState == 5) {
            PlayerLogger.i(TAG, "LiveCloudPlayer setSurface return mCurrentState == STATE_STOP");
            return;
        }
        if (this.mSurfaceTextureCheck == texture && texture == null) {
            return;
        }
        this.mSurfaceTextureCheck = texture;
        if (this.getDecoderMode() != 11 && !this.mUseSwapSurface) {
            PlayerLogger.i(TAG, "LiveCloudPlayer not use swap surface");
            if (texture != null) {
                if (texture != this.mSurfaceTextCache) {
                    this.mSurfaceTextCache = texture;
                    if (this.mSurfaceRead != null) {
                        this.mSurfaceRead.release();
                        this.mSurfaceRead = null;
                    }
                }
                if (this.mSurfaceRead == null) {
                    this.mSurfaceRead = new Surface(texture);
                }
                JPlayer.setSurface(from, this.mPlayerId, this.mSurfaceRead);
            } else {
                JPlayer.setSurface(from, this.mPlayerId, null);
            }
            return;
        }
        this.mUseSwapSurface = true;
        if (texture != null) {
            this.mSurfaceTextCache = texture;
            if (this.mSurfaceRead != null) {
                JPlayer.setSurface(from, this.mPlayerId, this.mSurfaceRead);
            } else if (this.mSurfaceTextureEGLSurface == null) {
                this.mSurfaceTextureEGLSurface = new SurfaceTextureEGLSurface();
                this.mSurfaceTextureEGLSurface.init(new SurfaceTextureEGLSurface.SurfaceTextureListener(){

                    @Override
                    public void onSurfaceTextureCreated(SurfaceTexture surfaceTexture) {
                        LiveCloudPlayer.this.mSurfaceRead = new Surface(surfaceTexture);
                        JPlayer.setSurface(from, LiveCloudPlayer.this.mPlayerId, LiveCloudPlayer.this.mSurfaceRead);
                        PlayerLogger.d(LiveCloudPlayer.TAG, "LiveCloudPlayer onSurfaceTextureCreated" + surfaceTexture);
                    }

                    @Override
                    public void onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                        if (LiveCloudPlayer.this.mSurfaceRead != null) {
                            LiveCloudPlayer.this.mSurfaceRead.release();
                            LiveCloudPlayer.this.mSurfaceRead = null;
                            if (LiveCloudPlayer.this.mPlayerControl == null || LiveCloudPlayer.this.mPlayerControl.getUseHwDecoder() != 1) {
                                JPlayer.setSurface(from, LiveCloudPlayer.this.mPlayerId, null);
                                PlayerLogger.d(LiveCloudPlayer.TAG, "LiveCloudPlayer onSurfaceTextureDestroyed" + surfaceTexture);
                            }
                        }
                    }

                    @Override
                    public void onFirstFrameAvailable() {
                        PlayerLogger.d(LiveCloudPlayer.TAG, "LiveCloudPlayer onFirstFrameAvailable");
                        LiveCloudPlayer.this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                LiveCloudPlayer.this.reportPlayStart();
                            }
                        });
                    }
                }, null);
            }
            if (this.mSurfaceTextureEGLSurface != null) {
                this.mSurfaceTextureEGLSurface.setSurface(texture);
                this.mSurfaceTextureEGLSurface.setSurfaceViewport(this.mSurfaceX, this.mSurfaceY, this.mSurfaceWidth, this.mSurfaceHeight);
            }
        } else {
            if (this.mPlayerControl == null || this.mPlayerControl.getUseHwDecoder() != 1) {
                JPlayer.setSurface(from, this.mPlayerId, null);
                PlayerLogger.d(TAG, "LiveCloudPlayer mPlayerControl.setSurface null");
            }
            if (this.mSurfaceTextureEGLSurface != null) {
                this.mSurfaceTextureEGLSurface.setSurface(null);
            }
        }
    }

    @Override
    public void setSurfaceViewport(int x, int y, int width, int height) {
        this.mSurfaceX = x;
        this.mSurfaceY = y;
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        if (this.mSurfaceTextureEGLSurface != null) {
            this.mSurfaceTextureEGLSurface.setSurfaceViewport(this.mSurfaceX, this.mSurfaceY, this.mSurfaceWidth, this.mSurfaceHeight);
        }
    }

    private void reportPlayStart() {
        if (this.mSurfaceTextureEGLSurface == null || this.mSurfaceTextureEGLSurface.isFirstFrameAvailable()) {
            PlayerLogger.i(TAG, "first frame render time=" + (System.currentTimeMillis() - this.mStatBeginTick) + ", url=" + this.mPlayUrl);
            if (this.mCallback != null) {
                this.mCallback.onInfo(104, 101L);
            }
            PlayerLogger.d(TAG, "LiveCloudPlayer reportPlayStart mCallback.onInfo");
        } else {
            PlayerLogger.d(TAG, "LiveCloudPlayer reportPlayStart wait");
        }
    }

    @Override
    public void setResolutionAdapt(boolean isAdapt, ILiveCloudPlayer.SwitchResolutionListener l) {
        PlayerLogger.i(TAG, "resolution adapt. isAdapt: " + isAdapt);
        if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
            this.switchResolutionStop("resolution adapt. stop last switch!");
        }
        this.isResolutionAdapt = isAdapt;
        this.switchResolutionListener = l;
        if (isAdapt && this.mResolutionMgr != null) {
            this.mResolutionMgr.setForceSwitch(true);
        } else {
            this.mResolutionMgr.setForceSwitch(false);
        }
        if (this.mPlayMonitor != null) {
            this.mPlayMonitor.stat(5, 0, 0, null);
        }
    }

    public ILiveCloudDisplay getmCurrentDisplay() {
        return this.mCurrentDisplay;
    }

    @Override
    public void switchResolution(int index, ILiveCloudPlayer.SwitchResolutionListener listener) {
        PlayerLogger.i(TAG, "switch resolution.");
        this.isResolutionAdapt = false;
        if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
            this.switchResolutionStop("handle switch. stop last switch!");
        }
        if (this.mSourceIndex == index) {
            if (listener != null) {
                String url = "";
                if (this.mSource != null && index < this.mSource.length) {
                    url = this.mSource[index];
                }
                listener.onSuccess(index, url);
            }
        } else {
            this.switchResolutionImpl(index, listener, false);
        }
    }

    private void switchResolutionImpl(int index, ILiveCloudPlayer.SwitchResolutionListener l, boolean isAdapt) {
        PlayerLogger.d(TAG, "switch resolution impl. index: " + index + " isAdapt: " + isAdapt);
        if (!this.isPlaying()) {
            PlayerLogger.d(TAG, "failed. player not in playing...");
            if (l != null) {
                l.onError(-1, "player not in playing...");
            }
            return;
        }
        if (this.mPlayMonitor != null && !this.mPlayMonitor.needSwitchResolution(this.mContext, isAdapt)) {
            if (l != null) {
                l.onError(-1, "");
            }
            return;
        }
        if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
            PlayerLogger.d(TAG, "failed. switch resolution doing...");
            if (l != null) {
                l.onError(-1, "switch resolution doing...");
            }
            return;
        }
        if (l != null) {
            l.onPrepare();
        }
        int curPos = this.getCurrentPosition();
        long cacheDuration = 0L;
        if (this.mPlayerControl != null) {
            cacheDuration = this.mPlayerControl.getCacheDuration();
        }
        long[] timestamp = new long[1];
        int ret = this.mPlayerControl.stopCache(timestamp, 1);
        PlayerLogger.d(TAG, "stop cache. ret: " + ret + " timestamp: " + timestamp[0]);
        if (isAdapt) {
            if (0 == ret) {
                if (timestamp[0] >= 0L) {
                    long switchDelay = timestamp[0] - (long)curPos;
                    if (switchDelay < 0L) {
                        switchDelay = 0L;
                    }
                    this.switchResolutionBegin(index, l, (int)timestamp[0], switchDelay);
                } else {
                    if (this.mResolutionMgr != null) {
                        this.mResolutionMgr.setForceSwitch(true);
                    }
                    this.switchResolutionBegin(index, l, this.getCurrentPosition(), 0L);
                }
            } else {
                if (l != null) {
                    l.onError(-2, "stop cache failed! " + ret);
                }
                if (this.mPlayMonitor != null) {
                    this.mPlayMonitor.resetStat();
                }
            }
        } else if (cacheDuration > 5001L) {
            this.switchResolutionBegin(index, l, curPos + 5000, 5000L);
        } else {
            if (this.mResolutionMgr != null) {
                this.mResolutionMgr.setForceSwitch(true);
            }
            this.switchResolutionBegin(index, l, curPos, 0L);
        }
    }

    private void switchResolutionBegin(int index, ILiveCloudPlayer.SwitchResolutionListener l, int switchPos, long switchDelay) {
        this.mSourceIndexCache = index;
        this.switchResolutionListener = l;
        this.mResolutionMgr.switchResolution(this.mContext, this, this.mLiveCloudConfig, this.mSessionId, this.mPlayerSettings, index, this.mSource[index], switchPos, new ResolutionMgr.OnSwitchListener(){

            @Override
            public void openLiveTimeout(int playerId, PlayerControl control, LiveCloudConfig config, String url) {
                if (LiveCloudPlayer.this.mResolutionMgr != null) {
                    LiveCloudPlayer.this.mResolutionMgr.updateStatus(5);
                }
                if (LiveCloudPlayer.this.mHandler != null && LiveCloudPlayer.this.mPlayerControl != null) {
                    if (LiveCloudPlayer.this.isPaused()) {
                        LiveCloudPlayer.this.switchResolutionStop("is paused");
                    } else if (LiveCloudPlayer.this.isPlaying()) {
                        LiveCloudPlayer.this.mHandler.postDelayed(LiveCloudPlayer.this.switchResolutionRunable, 0L);
                    } else {
                        LiveCloudPlayer.this.switchResolutionRunError(-1, "");
                    }
                } else {
                    LiveCloudPlayer.this.switchResolutionRunError(-1, "");
                }
            }

            @Override
            public void onPlayerOpened(int playerId, PlayerControl control, LiveCloudConfig config, int secondPlayerPos, String url) {
                if (LiveCloudPlayer.this.mResolutionMgr != null) {
                    LiveCloudPlayer.this.mResolutionMgr.updateStatus(5);
                }
                if (LiveCloudPlayer.this.mHandler != null && LiveCloudPlayer.this.mPlayerControl != null) {
                    if (LiveCloudPlayer.this.isPaused()) {
                        LiveCloudPlayer.this.switchResolutionStop("is paused");
                    } else if (LiveCloudPlayer.this.isPlaying()) {
                        long curPos = LiveCloudPlayer.this.getCurrentPosition();
                        long delay = (long)secondPlayerPos - curPos;
                        PlayerLogger.d(LiveCloudPlayer.TAG, "second player pos: " + secondPlayerPos + " current pos: " + curPos + " delay: " + delay);
                        if (delay > 0L) {
                            LiveCloudPlayer.this.mHandler.postDelayed(LiveCloudPlayer.this.switchResolutionRunable, delay);
                        } else {
                            LiveCloudPlayer.this.mHandler.postDelayed(LiveCloudPlayer.this.switchResolutionRunable, 0L);
                        }
                    } else {
                        LiveCloudPlayer.this.switchResolutionRunError(-1, "");
                    }
                } else {
                    LiveCloudPlayer.this.switchResolutionRunError(-1, "");
                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {
                LiveCloudPlayer.this.switchResolutionRunError(errorCode, errorMsg);
            }
        }, this.isResolutionAdapt, switchDelay);
    }

    private void switchResolutionRunSuccess(int switchRunRet, String url) {
        PlayerLogger.d(TAG, "switch resolution suc. idx:" + this.mSourceIndex + " url: " + this.mSource[this.mSourceIndex]);
        if (url == null || !url.equals(this.mSource[this.mSourceIndex])) {
            PlayerLogger.d(TAG, "switch resolution success. url not match!!!");
        }
        if (this.mResolutionMgr != null) {
            this.mResolutionMgr.updateStatus(7);
        }
        if (this.mResolutionMgr != null) {
            this.mResolutionMgr.resetValue();
        }
        if (0 == switchRunRet) {
            this.mSwitchResolutionDoing = false;
            if (this.switchResolutionListener != null) {
                this.switchResolutionListener.onStart();
                this.switchResolutionListener.onSuccess(this.mSourceIndex, this.mSource[this.mSourceIndex]);
            }
        } else if ((2 == switchRunRet || 1 == switchRunRet) && this.switchResolutionListener != null) {
            this.switchResolutionListener.onStart();
        }
        if (this.mPlayMonitor != null) {
            this.mPlayMonitor.stat(3, 0, 0, null);
        }
    }

    private void switchResolutionRunError(int errorCode, String errorMsg) {
        PlayerLogger.d(TAG, "switch resolution failed. " + errorCode + " " + errorMsg);
        if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.stat(3, -1, 0, null);
            }
            this.switchResolutionStop("errorCode: " + errorCode + " " + errorMsg);
        }
    }

    private int switchResolutionRun(int secondPlayerId, PlayerControl secondPlayerCtrl, LiveCloudConfig secondPlayerConfig, int secondPlayerPosition, String newUrl, int prepareStatus) {
        int ret = -1;
        Logger.i((String)TAG, (String)"switch resolution run");
        if (this.mPlayerControl != null && secondPlayerId != 0 && secondPlayerCtrl != null && secondPlayerConfig != null && newUrl != null) {
            if (!this.isPlaying()) {
                return -1;
            }
            int curPos = this.getCurrentPosition();
            Logger.e((String)TAG, (String)("real switch. position: " + curPos + " second player position: " + secondPlayerPosition + " diff: " + (secondPlayerPosition - curPos)));
            if (this.mResolutionMgr != null && !this.mResolutionMgr.isForceSwitch() && this.isResolutionAdapt && Math.abs(secondPlayerPosition - curPos) > 2000) {
                return -1;
            }
            Logger.i((String)TAG, (String)"switch resolution run. begin");
            boolean isMute = this.mMute;
            this.mPlayerControl.setMute(true);
            this.mPlayerControl.pause(-1);
            ILiveCloudDisplay display = this.mCurrentDisplay;
            if (display instanceof TexturePlayView) {
                PlayerLogger.d(TAG, "TexturePlayView pause surface");
                ((TexturePlayView)display).pauseSurface();
            }
            if (this.mLiveCloudConfig != null) {
                Stats.sessionStop((String)this.mLiveCloudConfig.getSid());
            }
            final PlayerControl cacheFirstPlayerCtrl = this.mPlayerControl;
            this.mSwitchResolutionDoingCachePosition = curPos;
            this.mSwitchResolutionDoing = true;
            this.mPlayerControl = secondPlayerCtrl;
            this.mPlayerControl.setCallback(null);
            this.mPlayerId = secondPlayerId;
            this.mPlayerControl.setCallback(this);
            this.mLiveCloudConfig = secondPlayerConfig;
            display.setHandle(secondPlayerId);
            this.setPlayMode(this.mMode);
            this.mPlayUrl = secondPlayerConfig.getSn();
            this.mPlayerControl.setMute(isMute);
            this.mMute = isMute;
            this.mUpdateMute = false;
            PlayerLogger.e(TAG, "switch resolution. prepare status: " + prepareStatus);
            if (prepareStatus == 0) {
                this.mPlayerControl.startLive();
                ret = 2;
            } else if (prepareStatus == 1) {
                this.mCurrentState = 4;
                this.start(0);
                ret = 1;
            } else if (prepareStatus == 2) {
                this.mCurrentState = 4;
                this.start(0);
                ret = 0;
            } else {
                PlayerLogger.e(TAG, "switch resolution. not support prepare status!");
            }
            if (display instanceof TexturePlayView) {
                PlayerLogger.d(TAG, "TexturePlayView resume surface");
                ((TexturePlayView)display).resumeSurface();
            }
            if (this.mInBackground) {
                this.mPlayerControl.setInBackground(this.mInBackground);
            }
            this.mSourceIndex = this.mSourceIndexCache;
            if (this.mLocalServerHelper != null && this.mSourceRids != null && this.mSourceIndex >= 0 && this.mSourceIndex < this.mSourceRids.length) {
                this.mLocalServerHelper.setDataSource(this.mSourceRids[this.mSourceIndex], this.mPlayUrl);
            }
            PlayerLogger.d(TAG, "second player playing...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (cacheFirstPlayerCtrl != null) {
                        PlayerLogger.d(LiveCloudPlayer.TAG, "release switch. first player close: " + cacheFirstPlayerCtrl);
                        cacheFirstPlayerCtrl.close(0);
                    }
                }
            }).start();
            Logger.i((String)TAG, (String)"switch resolution run. end");
            return ret;
        }
        return -1;
    }

    private void switchResolutionRunWrap() {
        PlayerLogger.d(TAG, "multi resolution adapt check.");
        if (this.mPlayerControl != null && this.mResolutionMgr != null && this.mResolutionMgr.getSwitchStatus() == 5) {
            if (this.mHandler != null) {
                PlayerLogger.d(TAG, "remove switch runable. ");
                this.mHandler.removeCallbacks(this.switchResolutionRunable);
            }
            this.mResolutionMgr.updateStatus(6);
            ResolutionMgr.SecondPlayerInfo o = this.mResolutionMgr.getSecondPlayer();
            if (o.playerId != 0 && o.control != null && o.config != null && o.url != null && !this.mIsSeeking) {
                long tick = System.currentTimeMillis();
                int ret = this.switchResolutionRun(o.playerId, o.control, o.config, o.position, o.url, o.prepareStatus);
                if (0 == ret || 2 == ret || 1 == ret) {
                    this.switchResolutionRunSuccess(ret, o.url);
                } else {
                    this.switchResolutionRunError(-1, "real switch error");
                }
                Logger.w((String)TAG, (String)("switch resolution use: " + (System.currentTimeMillis() - tick)));
            } else {
                Logger.e((String)TAG, (String)("is seeking: " + this.mIsSeeking + " is play complete: " + this.isPlayComplete));
                this.switchResolutionRunError(-1, "switch error. second info invalid.");
            }
        } else {
            Logger.e((String)TAG, (String)"switch resolution run wrap. do nothing. not waiting switch status.");
        }
    }

    @Override
    public void switchResolutionStop(String reason) {
        PlayerLogger.d(TAG, "stop switch rsolution. reson: " + reason);
        if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
            if (this.mHandler != null) {
                PlayerLogger.d(TAG, "remove switch runable. ");
                this.mHandler.removeCallbacks(this.switchResolutionRunable);
                if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
                    this.mResolutionMgr.updateStatus(8);
                    this.mHandler.postAtFrontOfQueue(new Runnable(){

                        @Override
                        public void run() {
                            LiveCloudPlayer.this.mResolutionMgr.resetValueWithClosePlayer();
                        }
                    });
                }
            }
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.resetStat();
            }
            if (this.switchResolutionListener != null) {
                this.switchResolutionListener.onError(-2, "stop reason: " + reason);
            }
            if (this.mPlayerControl != null) {
                int ret = this.mPlayerControl.resumeCache();
                PlayerLogger.d(TAG, "id: " + this.mPlayerControl.getPlayerId() + " resumme cache ret: " + ret);
            }
        } else {
            PlayerLogger.d(TAG, "stop switch rsolution. not run");
        }
    }

    @Override
    public void setPlayBackRate(float rate) {
        PlayerLogger.i(TAG, "setPlayBackRate rate=" + rate);
        if (this.mPlayerControl != null && this.mPlayerId != 0) {
            this.mPlayerControl.setPlayBackRate(rate);
        }
    }

    public boolean isUseHdRedord(int width, int height) {
        if (this.mPlayerSettings == null) {
            return false;
        }
        int blackListSupport = GPWebrtcSettings.getInstance().getEnableLiveHwEncodeH264();
        int use_hw_record = this.mPlayerSettings.getUse_hw_record();
        boolean sizeFit = false;
        if (width >= 360 && height >= 640 || height >= 360 && width >= 640) {
            sizeFit = true;
        }
        PlayerLogger.i(TAG, "use_hw_record=" + use_hw_record + " --blackListSupport: " + blackListSupport + "-- Build.VERSION.SDK_INT: " + Build.VERSION.SDK_INT + "--sizeFit:" + sizeFit + "--width:" + width + "--heigth:" + height);
        return use_hw_record != 0 && blackListSupport == 1 && Build.VERSION.SDK_INT >= 19 && sizeFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startRecorder(String filePath, String fmt, RecordConfig config) {
        PlayerLogger.i(TAG, "startRecorder filePath=" + filePath + " fmt: " + fmt + " config: " + (config != null ? config.toString() : ""));
        if ("mp4".equals(fmt)) {
            this.mUseHdRedord = this.isUseHdRedord(this.getVideoWidth(), this.getVideoHeight());
            PlayerLogger.i(TAG, "startRecorder\uff08\uff09---isUseHdRedord \uff1a" + this.mUseHdRedord + "--getVideoWidth():" + this.getVideoWidth() + "--getVideoHeight:" + this.getVideoHeight());
            PlayerLogger.i(TAG, "ILiveCloudPlayer.RECORDER_FORMAT_MP4.equals(fmt):mUseHdRedord" + this.mUseHdRedord);
        }
        if (!this.mUseSwapSurface && this.mUseHdRedord) {
            this.setSurface("recored", null);
            LiveCloudPlayer liveCloudPlayer = this;
            synchronized (liveCloudPlayer) {
                this.mUseSwapSurface = true;
                this.mSurfaceTextureCheck = null;
                this.mSurfaceTextCache = null;
                if (this.mSurfaceRead != null) {
                    this.mSurfaceRead.release();
                    this.mSurfaceRead = null;
                }
            }
        }
        if (this.mPlayerControl != null && this.mPlayerId != 0 && !TextUtils.isEmpty((CharSequence)filePath) && (TextUtils.equals((CharSequence)fmt, (CharSequence)"mov") || TextUtils.equals((CharSequence)fmt, (CharSequence)"gif") || TextUtils.equals((CharSequence)fmt, (CharSequence)"mp4"))) {
            int ret = -1;
            if (!this.mUseHdRedord) {
                ret = this.mPlayerControl.initRecorder(filePath, fmt, config);
                if (ret == 0) {
                    ret = this.mPlayerControl.startRecorder();
                }
            } else {
                this.mRecorderSDK = QHVCRecorderSDK.getInstance();
                this.mRecorderSDK.setSurfaceTextureListener(new QHVCRecorderSDK.SurfaceTextureListener(){

                    @Override
                    public void onSurfaceTextureCreated(SurfaceTexture surfaceTexture) {
                        PlayerLogger.d(LiveCloudPlayer.TAG, "QHVCRecorderSDK onSurfaceTextureCreated");
                        while (LiveCloudPlayer.this.mSurfaceTextureEGLSurface == null) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        LiveCloudPlayer.this.mSurfaceTextureEGLSurface.setRecordSurface(surfaceTexture);
                    }

                    @Override
                    public void onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                        PlayerLogger.d(LiveCloudPlayer.TAG, "QHVCRecorderSDK onSurfaceTextureDestroyed ");
                    }

                    @Override
                    public void onFrameAvailable() {
                        PlayerLogger.d(LiveCloudPlayer.TAG, "QHVCRecorderSDK onFrameAvailable ");
                    }
                });
                File saveFile = new File(filePath);
                MediaInformation info = new MediaInformation();
                this.getMediaInformation(info);
                this.mRecorderSDK.startRecord(this.mContext, saveFile.getParent() + "/", saveFile.getName(), this.getVideoWidth(), this.getVideoHeight(), info.getBitrate() * 1000 * 8, 30, 2);
                this.startRecordAAC();
                ret = 0;
            }
            if (ret == 0) {
                this.isRecording = true;
            }
            return ret;
        }
        return -1;
    }

    @Override
    public int stopRecorder() {
        PlayerLogger.i(TAG, "stopRecorder");
        if (!this.mUseHdRedord) {
            if (this.mPlayerControl != null && this.mPlayerId != 0) {
                this.isRecording = false;
                return this.mPlayerControl.stopRecorder();
            }
            return -1;
        }
        if (this.mRecorderSDK != null) {
            this.mRecorderSDK.stopRecording();
            this.mRecorderSDK = null;
            this.stopRecordAAC();
        }
        if (this.mSurfaceTextureEGLSurface != null) {
            this.mSurfaceTextureEGLSurface.setRecordSurface(null);
        }
        this.isRecording = false;
        return 0;
    }

    public void test_setSchedulingUrl(String url) {
        PlayerLogger.d(TAG, "test_setSchedulingUrl=" + url);
        this.mUrl = url;
        this.mSetScheduleUrl = true;
    }

    public void test_setProto(int proto) {
        PlayerLogger.d(TAG, "test_setProto=" + proto);
        this.mProto = proto < 1 || proto > 7 ? 1 : proto;
    }

    public void test_hard_decoder_error() {
        PlayerLogger.d(TAG, "LiveCloudPlayer test_hard_decoder_error");
        this.onPlayerMsg(0, -800, 0L, 0L, 0);
    }

    public boolean getRecordingState() {
        return this.isRecording;
    }

    private class LocalServerHelper {
        private Method mGetFileAvailedSizeMethod;
        private String mRid;
        private String mUrl;

        public LocalServerHelper() {
            try {
                Class<?> localServerClazz = Class.forName("net.qihoo.videocloud.LocalServer");
                this.mGetFileAvailedSizeMethod = localServerClazz.getMethod("getFileAvailedSize", String.class, String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void setDataSource(String rid, String url) {
            this.mRid = rid;
            this.mUrl = url;
        }

        public long getCacheDuration() {
            long duration = -1L;
            if (this.mGetFileAvailedSizeMethod != null && !TextUtils.isEmpty((CharSequence)this.mRid) && !TextUtils.isEmpty((CharSequence)this.mUrl)) {
                try {
                    duration = ((Integer)this.mGetFileAvailedSizeMethod.invoke(null, this.mRid, this.mUrl, LiveCloudPlayer.this.getCurrentPosition(), LiveCloudPlayer.this.getDuration())).intValue();
                    PlayerLogger.v(LiveCloudPlayer.TAG, "cache duration localserver: " + duration);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (duration <= 0L && LiveCloudPlayer.this.mPlayerControl != null) {
                duration = LiveCloudPlayer.this.mPlayerControl.getCacheDuration();
                PlayerLogger.v(LiveCloudPlayer.TAG, "cache duration: " + duration);
            }
            return duration;
        }
    }

    static interface SwitchResolutionRunRet {
        public static final int FAILED = -1;
        public static final int VIDEO_IS_READY = 0;
        public static final int OPEN_LIVE_TIMEOUT = 1;
        public static final int NOT_OPEN = 2;
    }
}

