/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.config;

import android.os.Build;
import android.text.TextUtils;
import com.qihoo.livecloud.utils.PlayerLogger;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class PlayerSettings {
    static final String TAG = "NewCloudControl";
    private static final int NO_USE_CLOUDCONTROL = -1000;
    int enable = 1;
    int skipDetectFull = 1;
    int bufferingType = 0;
    int bufferingFirst = 300;
    int bufferingMaxTime = 10000;
    int use_sound_speed = 0;
    int duration_sound_speed_1 = 10000;
    float sound_speed_1 = 2.0f;
    int use_rtmp_delay_reconnection = 0;
    int duration_delay_reconnection = 15000;
    int use_framedrop_first = 0;
    int max_buffering_delay = 2000;
    int max_rtmp_reconnection_waittime = 2000;
    int huikan_skip_detect_fullstreaminfo = 1;
    int huikan_buffering_first = 300;
    int huikan_buffering_max_time = 2000;
    int use_hw_decode = 0;
    int gp_play_state_upload = -1000;
    long gp_play_state_upload_size = -1000L;
    int use_qy265dec = 0;
    int open_addgroup = 1;
    int use_p2p = 0;
    int p2p_rate = 0;
    String p2p_operators = "1:1:1";
    int use_hw_record = 0;
    double ip_scheduling_timeout = 1.5;
    int pre_scheduling_dirtytime = 60;
    int failed_count_265 = 2;
    int plugin_type = 0;
    int filter_enable = 1;
    int filter_mode = 0;
    float filter_brightness = 0.05f;
    float filter_contrast = 1.16f;
    float filter_saturation = 1.2f;

    public int getEnable() {
        return this.enable;
    }

    public void setEnable(int enable) {
        this.enable = enable;
    }

    public int getSkipDetectFull() {
        return this.skipDetectFull;
    }

    public void setSkipDetectFull(int skipDetectFull) {
        this.skipDetectFull = skipDetectFull;
    }

    public int getBufferingType() {
        return this.bufferingType;
    }

    public void setBufferingType(int bufferingType) {
        this.bufferingType = bufferingType;
    }

    public int getBufferingFirst() {
        return this.bufferingFirst;
    }

    public void setBufferingFirst(int bufferingFirst) {
        this.bufferingFirst = bufferingFirst;
    }

    public int getBufferingMaxTime() {
        return this.bufferingMaxTime;
    }

    public void setBufferingMaxTime(int bufferingMaxTime) {
        this.bufferingMaxTime = bufferingMaxTime;
    }

    public int getUse_sound_speed() {
        return this.use_sound_speed;
    }

    public void setUse_sound_speed(int use_sound_speed) {
        this.use_sound_speed = use_sound_speed;
    }

    public int getDuration_sound_speed_1() {
        return this.duration_sound_speed_1;
    }

    public void setDuration_sound_speed_1(int duration_sound_speed_1) {
        this.duration_sound_speed_1 = duration_sound_speed_1;
    }

    public float getSound_speed_1() {
        return this.sound_speed_1;
    }

    public void setSound_speed_1(float sound_speed_1) {
        this.sound_speed_1 = sound_speed_1;
    }

    public int getUse_rtmp_delay_reconnection() {
        return this.use_rtmp_delay_reconnection;
    }

    public void setUse_rtmp_delay_reconnection(int use_rtmp_delay_reconnection) {
        this.use_rtmp_delay_reconnection = use_rtmp_delay_reconnection;
    }

    public int getDuration_delay_reconnection() {
        return this.duration_delay_reconnection;
    }

    public void setDuration_delay_reconnection(int duration_delay_reconnection) {
        this.duration_delay_reconnection = duration_delay_reconnection;
    }

    public int getUse_framedrop_first() {
        return this.use_framedrop_first;
    }

    public void setUse_framedrop_first(int use_framedrop_first) {
        this.use_framedrop_first = use_framedrop_first;
    }

    public int getMax_buffering_delay() {
        return this.max_buffering_delay;
    }

    public void setMax_buffering_delay(int max_buffering_delay) {
        this.max_buffering_delay = max_buffering_delay;
    }

    public int getHuikan_skip_detect_fullstreaminfo() {
        return this.huikan_skip_detect_fullstreaminfo;
    }

    public void setHuikan_skip_detect_fullstreaminfo(int huikan_skip_detect_fullstreaminfo) {
        this.huikan_skip_detect_fullstreaminfo = huikan_skip_detect_fullstreaminfo;
    }

    public int getHuikan_buffering_first() {
        return this.huikan_buffering_first;
    }

    public void setHuikan_buffering_first(int huikan_buffering_first) {
        this.huikan_buffering_first = huikan_buffering_first;
    }

    public int getHuikan_buffering_max_time() {
        return this.huikan_buffering_max_time;
    }

    public void setHuikan_buffering_max_time(int huikan_buffering_max_time) {
        this.huikan_buffering_max_time = huikan_buffering_max_time;
    }

    public int getUse_hw_decode() {
        return this.use_hw_decode;
    }

    public void setUse_hw_decode(int use_hw_decode) {
        this.use_hw_decode = use_hw_decode;
    }

    public void setGp_play_state_upload(int gp_play_state_upload) {
        this.gp_play_state_upload = gp_play_state_upload;
    }

    public int getGp_play_state_upload() {
        return this.gp_play_state_upload;
    }

    public void setGp_play_state_upload_size(long gp_play_state_upload_size) {
        this.gp_play_state_upload_size = gp_play_state_upload_size;
    }

    public long getGp_play_state_upload_size() {
        return this.gp_play_state_upload_size;
    }

    public int getMax_rtmp_reconnection_waittime() {
        return this.max_rtmp_reconnection_waittime;
    }

    public void setMax_rtmp_reconnection_waittime(int max_rtmp_reconnection_waittime) {
        this.max_rtmp_reconnection_waittime = max_rtmp_reconnection_waittime;
    }

    public void setUse_qy265dec(int use_qy265dec) {
        this.use_qy265dec = use_qy265dec;
    }

    public int getUse_qy265dec() {
        if (PlayerSettings.isX86()) {
            return 0;
        }
        return this.use_qy265dec;
    }

    public void setOpen_addgroup(int addgroup) {
        this.open_addgroup = addgroup;
    }

    public int getOpen_addgroup() {
        return this.open_addgroup;
    }

    public void setUse_p2p(int use_p2p) {
        this.use_p2p = use_p2p;
    }

    public int getUse_p2p() {
        return this.use_p2p;
    }

    public int getP2p_rate() {
        return this.p2p_rate;
    }

    public void setP2p_rate(int p2p_rate) {
        this.p2p_rate = p2p_rate;
    }

    public void setUse_hw_record(int use_hw_record) {
        this.use_hw_record = use_hw_record;
    }

    public int getUse_hw_record() {
        return this.use_hw_record;
    }

    public double getIp_scheduling_timeout() {
        return this.ip_scheduling_timeout;
    }

    public void setIp_scheduling_timeout(double ip_scheduling_timeout) {
        this.ip_scheduling_timeout = ip_scheduling_timeout;
    }

    public int getPre_scheduling_dirtytime() {
        return this.pre_scheduling_dirtytime;
    }

    public void setPre_scheduling_dirtytime(int pre_scheduling_dirtytime) {
        this.pre_scheduling_dirtytime = pre_scheduling_dirtytime;
    }

    public int getFailed_count_265() {
        return this.failed_count_265;
    }

    public void setFailed_count_265(int failed_count_265) {
        this.failed_count_265 = failed_count_265;
    }

    public String getP2p_operators() {
        return this.p2p_operators;
    }

    public void setP2p_operators(String p2p_operators) {
        this.p2p_operators = p2p_operators;
    }

    public int getPlugin_type() {
        return this.plugin_type;
    }

    public void setPlugin_type(int plugin_type) {
        this.plugin_type = plugin_type;
    }

    public int getFilter_enable() {
        return this.filter_enable;
    }

    public int getFilter_mode() {
        return this.filter_mode;
    }

    public float getFilter_brightness() {
        return this.filter_brightness;
    }

    public float getFilter_contrast() {
        return this.filter_contrast;
    }

    public float getFilter_saturation() {
        return this.filter_saturation;
    }

    public void setFilter_enable(int filter_enable) {
        this.filter_enable = filter_enable;
    }

    public void setFilter_mode(int filter_mode) {
        this.filter_mode = filter_mode;
    }

    public void setFilter_brightness(float filter_brightness) {
        this.filter_brightness = filter_brightness;
    }

    public void setFilter_contrast(float filter_contrast) {
        this.filter_contrast = filter_contrast;
    }

    public void setFilter_saturation(float filter_saturation) {
        this.filter_saturation = filter_saturation;
    }

    public String toString() {
        return "PlayerSettings{enable=" + this.enable + ", skipDetectFull=" + this.skipDetectFull + ", bufferingType=" + this.bufferingType + ", bufferingFirst=" + this.bufferingFirst + ", bufferingMaxTime=" + this.bufferingMaxTime + ", use_sound_speed=" + this.use_sound_speed + ", duration_sound_speed_1=" + this.duration_sound_speed_1 + ", sound_speed_1=" + this.sound_speed_1 + ", use_rtmp_delay_reconnection=" + this.use_rtmp_delay_reconnection + ", duration_delay_reconnection=" + this.duration_delay_reconnection + ", use_framedrop_first=" + this.use_framedrop_first + ", max_buffering_delay=" + this.max_buffering_delay + ", max_rtmp_reconnection_waittime=" + this.max_rtmp_reconnection_waittime + ", huikan_skip_detect_fullstreaminfo=" + this.huikan_skip_detect_fullstreaminfo + ", huikan_buffering_first=" + this.huikan_buffering_first + ", huikan_buffering_max_time=" + this.huikan_buffering_max_time + ", use_hw_decode=" + this.use_hw_decode + ", gp_play_state_upload=" + this.gp_play_state_upload + ", gp_play_state_upload_size=" + this.gp_play_state_upload_size + ", use_qy265dec=" + this.use_qy265dec + ", open_addgroup=" + this.open_addgroup + ", use_p2p=" + this.use_p2p + ", p2p_rate=" + this.p2p_rate + ", p2p_operators='" + this.p2p_operators + '\'' + ", use_hw_record=" + this.use_hw_record + ", ip_scheduling_timeout=" + this.ip_scheduling_timeout + ", pre_scheduling_dirtytime=" + this.pre_scheduling_dirtytime + ", failed_count_265=" + this.failed_count_265 + ", plugin_type=" + this.plugin_type + ", filter_enable=" + this.filter_enable + ", filter_mode=" + this.filter_mode + ", filter_brightness=" + this.filter_brightness + ", filter_contrast=" + this.filter_contrast + ", filter_saturation=" + this.filter_saturation + '}';
    }

    public static PlayerSettings fromJsonStr(String jsonStr) {
        PlayerSettings playerSettings = new PlayerSettings();
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return playerSettings;
        }
        try {
            JSONObject json = new JSONObject(jsonStr);
            JSONObject jsonPlayer = json.getJSONObject("play");
            if (jsonPlayer != null) {
                if (jsonPlayer.has("enable") && jsonPlayer.getInt("enable") == 0) {
                    PlayerLogger.v(TAG, "PlayerSettings enable = 0 return " + playerSettings.toString());
                    return playerSettings;
                }
                Iterator keys = jsonPlayer.keys();
                int count = 0;
                int matchCount = 0;
                int notMatchCount = 0;
                while (keys.hasNext()) {
                    String value;
                    String key = (String)keys.next();
                    ++count;
                    if (key.equals("live_fast_open")) {
                        playerSettings.setSkipDetectFull(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("live_buffering_type")) {
                        playerSettings.setBufferingType(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("live_buffering_first")) {
                        playerSettings.setBufferingFirst(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("live_buffering_max_time")) {
                        playerSettings.setBufferingMaxTime(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("optimize_delay")) {
                        playerSettings.setUse_sound_speed(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("duration_chase_track")) {
                        playerSettings.setDuration_sound_speed_1(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("chase_track_speed")) {
                        playerSettings.setSound_speed_1((float)jsonPlayer.getDouble(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("use_delay_reconnection")) {
                        playerSettings.setUse_rtmp_delay_reconnection(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("duration_delay_reconnection")) {
                        playerSettings.setDuration_delay_reconnection(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("max_reconnection_waittime")) {
                        playerSettings.setMax_rtmp_reconnection_waittime(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("use_framedrop_first")) {
                        playerSettings.setUse_framedrop_first(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("max_buffering_delay")) {
                        playerSettings.setMax_buffering_delay(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("vod_fast_open")) {
                        playerSettings.setHuikan_skip_detect_fullstreaminfo(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("vod_buffering_first")) {
                        playerSettings.setHuikan_buffering_first(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("vod_buffering_max_time")) {
                        playerSettings.setHuikan_buffering_max_time(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("use_hw_decode")) {
                        playerSettings.setUse_hw_decode(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("use_h265decode")) {
                        playerSettings.setUse_qy265dec(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("open_addgroup")) {
                        playerSettings.setOpen_addgroup(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("use_p2p")) {
                        playerSettings.setUse_p2p(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("p2p_rate")) {
                        playerSettings.setP2p_rate(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("p2p_operators")) {
                        playerSettings.setP2p_operators(jsonPlayer.getString(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("use_hw_record")) {
                        playerSettings.setUse_hw_record(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("ip_scheduling_timeout")) {
                        playerSettings.setIp_scheduling_timeout(jsonPlayer.getDouble(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("pre_scheduling_dirtytime")) {
                        playerSettings.setPre_scheduling_dirtytime(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("failed_count_265")) {
                        playerSettings.setFailed_count_265(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("enable")) {
                        playerSettings.setEnable(jsonPlayer.getInt(key));
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("plugin_type")) {
                        playerSettings.setPlugin_type(jsonPlayer.getInt(key));
                        continue;
                    }
                    if (key.equals("filter_enable")) {
                        playerSettings.setFilter_enable(jsonPlayer.getInt(key));
                        continue;
                    }
                    if (key.equals("filter_mode")) {
                        playerSettings.setFilter_mode(jsonPlayer.getInt(key));
                        continue;
                    }
                    if (key.equals("filter_brightness")) {
                        value = jsonPlayer.getString(key);
                        if (TextUtils.isEmpty((CharSequence)value)) continue;
                        try {
                            float brightness = Float.parseFloat(value);
                            playerSettings.setFilter_brightness(brightness);
                        }
                        catch (Exception brightness) {}
                        continue;
                    }
                    if (key.equals("filter_contrast")) {
                        value = jsonPlayer.getString(key);
                        if (TextUtils.isEmpty((CharSequence)value)) continue;
                        try {
                            float contrast = Float.parseFloat(value);
                            playerSettings.setFilter_contrast(contrast);
                        }
                        catch (Exception contrast) {}
                        continue;
                    }
                    if (key.equals("filter_saturation")) {
                        value = jsonPlayer.getString(key);
                        if (TextUtils.isEmpty((CharSequence)value)) continue;
                        try {
                            float saturation = Float.parseFloat(value);
                            playerSettings.setFilter_saturation(saturation);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    PlayerLogger.v(TAG, "not match key =  " + key);
                    ++notMatchCount;
                }
                PlayerLogger.v(TAG, "play json all obj count " + count + " var count " + playerSettings.getVarCount() + " match count " + matchCount + " not match count " + notMatchCount);
                PlayerLogger.v(TAG, playerSettings.toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return playerSettings;
    }

    public int getVarCount() {
        int count = 0;
        try {
            String strValue = this.toString();
            Pattern pattern = Pattern.compile("=");
            Matcher matcher = pattern.matcher(strValue);
            while (matcher.find()) {
                ++count;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return count;
    }

    public static boolean isX86() {
        try {
            String cpu = Build.CPU_ABI;
            if (cpu != null) {
                return cpu.toLowerCase().contains("x86");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

