/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.play;

import android.content.Context;
import android.text.TextUtils;
import android.view.Surface;
import com.qihoo.livecloud.config.PlayerSettings;
import com.qihoo.livecloud.play.AudioInfo;
import com.qihoo.livecloud.play.RecordConfig;
import com.qihoo.livecloud.play.callback.PlayerCallback;
import com.qihoo.livecloud.play.jni.JPlayer;
import com.qihoo.livecloud.utils.PlayerLogger;
import com.qihoo.videocloud.model.MediaInformation;
import java.util.Vector;

public class PlayerControl {
    private static final String TAG = "PlayerControl";
    private static final int PREVIEW_DURATION_MAX = 300000;
    private static int SRC_TYPE = 1001;
    private static volatile Vector<String> handleList = null;
    private String mSN = "";
    private String mCid = "";
    private String mUid = "";
    private String mSid = "";
    private String mUri = "http://g2.live.360.cn/streamschedule";
    private int deputyId = 0;
    private JPlayer mPlayer = new JPlayer();
    private int mPlayerId = 0;
    private PlayerCallback mCallback;

    public static String getNativeVersion() {
        String version = "0.0.0.0";
        try {
            version = JPlayer.getNativeVersion();
        }
        catch (Throwable e) {
            PlayerLogger.e(TAG, "PlayerControl, " + e.getMessage());
        }
        PlayerLogger.d(TAG, "player native version: " + version);
        return version;
    }

    public int getPlayerId() {
        return this.mPlayerId;
    }

    public void setPlayerId(int handle) {
        this.mPlayerId = handle;
    }

    public void setMute(boolean mute) {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.setMute(this.mPlayerId, mute);
    }

    public void playSound() {
        if (this.mPlayer != null) {
            this.mPlayer.playSound(this.mPlayerId);
        }
    }

    public void close(int reason) {
        if (this.mPlayer == null) {
            return;
        }
        PlayerLogger.d(TAG, "close handle : " + this.mPlayerId);
        this.mPlayer.stop(this.mPlayerId);
        this.mPlayer.close(this.mPlayerId, reason);
        if (handleList != null) {
            handleList.remove(String.valueOf(this.mPlayerId));
        }
        this.mPlayerId = 0;
        if (handleList == null || handleList.size() == 0) {
            PlayerLogger.d(TAG, "JPlayer.uninit()");
            JPlayer.uninit();
        }
    }

    public int startLive() {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return 0;
        }
        this.mPlayer.startLive(this.mPlayerId);
        return this.mPlayerId;
    }

    public int openLivePlayer(int deputyId, int mainHandle, int isHevc) {
        if (this.mPlayer == null || TextUtils.isEmpty((CharSequence)this.mSN) || TextUtils.isEmpty((CharSequence)this.mCid) || TextUtils.isEmpty((CharSequence)this.mSid)) {
            this.mPlayerId = 0;
            return 0;
        }
        PlayerControl.handleListInit();
        this.deputyId = deputyId;
        this.mPlayerId = this.mPlayerId == 0 ? this.mPlayer.open(this.mSN, this.mCid, this.mUid, this.mUri, 1, SRC_TYPE, deputyId, mainHandle, this.mSid, isHevc) : this.mPlayer.setSession(this.mPlayerId, this.mSN, this.mCid, this.mUid, this.mUri, 1, SRC_TYPE, deputyId, mainHandle);
        if (handleList != null && this.mPlayerId != 0) {
            handleList.add(String.valueOf(this.mPlayerId));
        }
        return this.mPlayerId;
    }

    public int openVideoUrl(String url) {
        PlayerControl.handleListInit();
        this.mPlayerId = this.mPlayer != null ? this.mPlayer.openVideoUrl(url, this.mSid, 1) : 0;
        if (handleList != null && this.mPlayerId != 0) {
            handleList.add(String.valueOf(this.mPlayerId));
        }
        return this.mPlayerId;
    }

    public int openHls(String url, int trustPts, int seekto, boolean isCallBackDecode, int ibMode) {
        PlayerLogger.d(TAG, "url=" + url + " trustPts=" + trustPts + " seekto=" + seekto + " isCallBackDecode=" + isCallBackDecode + " accurateSeekTo=" + ibMode);
        PlayerControl.handleListInit();
        this.mPlayerId = this.mPlayer != null ? this.mPlayer.openHls(url, trustPts, seekto, isCallBackDecode ? 1 : 0, ibMode, this.mSid) : 0;
        if (handleList != null && this.mPlayerId != 0) {
            handleList.add(String.valueOf(this.mPlayerId));
        }
        return this.mPlayerId;
    }

    public int seekTo(int progress) {
        if (this.mPlayer != null) {
            return this.mPlayer.seekTo(this.mPlayerId, progress);
        }
        return -1;
    }

    public int seekTo(int millis, boolean accurate) {
        if (this.mPlayer != null) {
            if (accurate) {
                return this.mPlayer.seekToAccurate(this.mPlayerId, millis, 1);
            }
            return this.mPlayer.seekTo(this.mPlayerId, millis);
        }
        return -1;
    }

    public int pause(int type) {
        if (this.mPlayer != null) {
            return this.mPlayer.pause(this.mPlayerId, type);
        }
        return -1;
    }

    public long getPosition() {
        if (this.mPlayer != null) {
            return this.mPlayer.position(this.mPlayerId);
        }
        return -1L;
    }

    public long getCacheDuration() {
        if (this.mPlayer != null) {
            try {
                return this.mPlayer.getCacheDuration(this.mPlayerId);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        return -1L;
    }

    public void setTrustPts(int trustPts) {
        if (this.mPlayer != null) {
            this.mPlayer.trustPts(this.mPlayerId, trustPts);
        }
    }

    public PlayerCallback getCallback() {
        return this.mCallback;
    }

    public void setCallback(PlayerCallback mCallback) {
        if (this.mPlayer == null) {
            return;
        }
        this.mCallback = mCallback;
        this.mPlayer.setPlayerCallback(this.mPlayerId, mCallback);
    }

    public boolean snapshot(String path) {
        if (this.mPlayer == null) {
            return false;
        }
        return this.mPlayer.snapshot(this.mPlayerId, path);
    }

    public static int generateThumbnail(String videoPath, String jpgPath, int width, int height, long pos) {
        return JPlayer.genthumb(videoPath, jpgPath, width, height, pos);
    }

    @Deprecated
    public void setLogPrint(int isLogPrint, int isFileLog, String logPath) {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.setLogPrint(isLogPrint, isFileLog, logPath);
    }

    @Deprecated
    public void setTransportLog(String logPath) {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.setTransportLog(logPath);
    }

    public void setSN(String rid) {
        this.mSN = rid;
    }

    public void setCid(String cid) {
        this.mCid = cid;
    }

    public void setUid(String uid) {
        this.mUid = uid;
    }

    public void setSid(String sid) {
        this.mSid = sid;
    }

    public void setUseHwDecoderPriority(int flags, String pn) {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.setUseHwDecoderPriority(this.mPlayerId, flags, pn);
    }

    public int getUseHwDecoder() {
        if (this.mPlayer == null) {
            return 0;
        }
        return this.mPlayer.getUseHwDecoder(this.mPlayerId);
    }

    public int multipleRegister(int value) {
        if (this.mPlayer == null || value == 1 && (this.mPlayerId == 0 || this.deputyId == 0)) {
            return 0;
        }
        return JPlayer.multipleRegister(this.mPlayerId, this.deputyId, value);
    }

    public void playerSetting(PlayerSettings setting) {
        if (this.mPlayer == null || setting == null) {
            return;
        }
        JPlayer.playerSetting(this.mPlayerId, setting);
    }

    public void setInBackground(boolean inbackground) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return;
        }
        JPlayer.inBackground(this.mPlayerId, inbackground);
    }

    public void setHalfDisplay(int half) {
        if (this.mPlayer == null) {
            return;
        }
        JPlayer.halfDisplay(this.mPlayerId, half);
    }

    public void startRecordAAC(Object buffer, int size, long time) {
        if (this.mPlayer == null || this.mPlayerId == 0 || buffer == null) {
            return;
        }
        JPlayer.startRecordAAC(this.mPlayerId, buffer, size, time);
    }

    public void stopRecordAAC() {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return;
        }
        JPlayer.stopRecordAAC(this.mPlayerId);
    }

    public long getcurrentstreamtime() {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return 0L;
        }
        return JPlayer.getcurrentstreamtime(this.mPlayerId);
    }

    public void addToGroup(int group) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return;
        }
        JPlayer.addtogroup(this.mPlayerId, group);
    }

    public void setCacheFilePath(String filePath, long maxCacheDuration, long maxCacheFileSize) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return;
        }
        JPlayer.setCacheFilePath(this.mPlayerId, filePath, maxCacheDuration, maxCacheFileSize);
    }

    public void setPlayMode(int mode) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return;
        }
        JPlayer.setPlayMode(this.mPlayerId, mode);
    }

    public void setSurface(String from, int playerId, Surface sur) {
        JPlayer.setSurface(from, playerId, sur);
    }

    public void setPreviewDuration(int playerId, int mode) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return;
        }
        if (mode <= 0) {
            return;
        }
        if (mode > 300000) {
            mode = 300000;
        }
        PlayerLogger.d(TAG, "setPreviewDuration: " + playerId + " , " + mode);
        JPlayer.setPreviewDuration(playerId, mode);
    }

    public int getAudioInfo(int playerId, AudioInfo audioInfo) {
        return JPlayer.getAudioInfo(playerId, audioInfo);
    }

    public void getMediaInformation(int playerId, MediaInformation mediaInformation) {
        JPlayer.getMediaInformation(playerId, mediaInformation);
    }

    public static void setAppContext(Context appContext) {
        JPlayer.setAppContext(appContext);
    }

    public void setStreamType(int streamType) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return;
        }
        PlayerLogger.d(TAG, "set stream type : " + streamType);
        JPlayer.setStreamType(this.mPlayerId, streamType);
    }

    public void setUseQy265dec(int playerId, int flags) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return;
        }
        this.mPlayer.setUseQy265dec(playerId, flags);
    }

    public int getUseQy265dec(int playerId) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return -1;
        }
        return this.mPlayer.getUseQy265dec(playerId);
    }

    private static synchronized void handleListInit() {
        if (handleList == null) {
            handleList = new Vector();
            JPlayer.init();
        } else if (handleList.size() <= 0) {
            JPlayer.init();
        }
    }

    public void setVolume(float volume) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return;
        }
        JPlayer.setAudioVolume(this.mPlayerId, volume);
    }

    public float getVolume() {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return -1.0f;
        }
        return JPlayer.getAudioVolume(this.mPlayerId);
    }

    public void setPlayBackRate(float rate) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return;
        }
        PlayerLogger.d(TAG, "set playback rate: " + rate);
        this.mPlayer.setPlayBackRate(this.mPlayerId, rate);
    }

    public int stopCache(long[] timestamp, int forceStop) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return -1;
        }
        return JPlayer.stopCache(this.mPlayerId, timestamp, forceStop);
    }

    public int resumeCache() {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return -1;
        }
        return JPlayer.resumeCache(this.mPlayerId);
    }

    public int initRecorder(String filePath, String fmt, RecordConfig config) {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return -1;
        }
        return this.mPlayer.initRecorder(this.mPlayerId, filePath, fmt, config);
    }

    public int startRecorder() {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return -1;
        }
        return this.mPlayer.startRecorder(this.mPlayerId);
    }

    public int stopRecorder() {
        if (this.mPlayer == null || this.mPlayerId == 0) {
            return -1;
        }
        return this.mPlayer.stopRecorder(this.mPlayerId);
    }
}

