/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.annotation.SuppressLint;
import android.media.AudioManager;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import com.qihoo.livecloud.utils.PlayerLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressLint(value={"NewApi"})
public class AudioInputByMediaCodec {
    private static final String TAG = "AudioInput";
    private static final int QUEUE_NUM = 5;
    private static final int QUEUE_FRAME = 3;
    public static final int FRAME_RATE = 25;
    private int packageSize = 0;
    private boolean isMute = false;
    private LinkedBlockingQueue<byte[]> mInputQueue = null;
    private LinkedBlockingQueue<byte[]> mOutputQueue = null;
    private ExecutorService mEncodeExecutor = null;
    private AtomicBoolean isRecording = new AtomicBoolean(false);
    private boolean isEncoding = false;
    private AtomicBoolean hasRecorded = new AtomicBoolean(false);
    private final String AUDIO_MIME_TYPE = "audio/mp4a-latm";
    private MediaCodec mAudioEncoder;
    private MediaCodec.BufferInfo mAudioBufferInfo = new MediaCodec.BufferInfo();
    private MediaMuxer mMuxer;
    private int mAudioTrackIndex;
    public final Object saveAudioAndVideo_lock = new Object();
    public static final int SAMPLE_RATE = 44100;
    public static final int CHANNEL_CONFIG = 16;
    public static final int AUDIO_FORMAT = 2;
    public static final int FRAMES_PER_BUFFER = 24;
    public static long US_PER_FRAME = 0L;
    public int samples_per_frame = 2048;
    public boolean illegalState = false;
    private boolean initDone = false;
    private long writeTimeStamp = 0L;
    private Object mPollLock = new Object();
    private AudioManager audioManager;
    long audioStartTime;
    int totalInputAudioFrameCount;
    long audioBytesReceived;
    boolean finishEncode = false;
    boolean noEncode = false;

    public void init() {
    }

    public void unInit() {
        this.isRecording.set(false);
        this.isEncoding = false;
        this.finishEncode = true;
        if (this.mInputQueue != null) {
            this.mInputQueue.clear();
        }
        if (this.mOutputQueue != null) {
            this.mOutputQueue.clear();
        }
        long startUninitTime = System.currentTimeMillis();
        this.mInputQueue = null;
        this.mOutputQueue = null;
    }

    public void start() {
        this.isEncoding = true;
    }

    public void pauseTansport() {
        this.isEncoding = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        PlayerLogger.i(TAG, "audio stop start");
        this.isEncoding = false;
        Object object = this.mPollLock;
        synchronized (object) {
            this.mPollLock.notifyAll();
        }
        if (this.mEncodeExecutor != null) {
            this.mEncodeExecutor.shutdown();
            try {
                this.mEncodeExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mEncodeExecutor = null;
        }
        PlayerLogger.i(TAG, "audio stop end");
    }

    public boolean isMute() {
        return this.isMute;
    }

    public void setMute(boolean isMute) {
        this.isMute = isMute;
    }

    public boolean isEncoding() {
        return this.isEncoding;
    }

    private void initQueue() {
        if (this.mInputQueue == null) {
            this.mInputQueue = new LinkedBlockingQueue(5);
            for (int i = 0; i < 5; ++i) {
                byte[] b = new byte[this.packageSize];
                this.mInputQueue.offer(b);
            }
            this.mOutputQueue = new LinkedBlockingQueue(5);
        }
    }

    private void initAudioRecord(int size, int channelCount, int bitrate, int audioSampleRate) {
        int newPackageSize = size;
        if (this.packageSize != newPackageSize) {
            this.packageSize = newPackageSize;
        }
        this.initQueue();
        if (this.mEncodeExecutor == null) {
            this.mEncodeExecutor = Executors.newFixedThreadPool(1);
        }
        this.prepareEncoder(channelCount, bitrate, audioSampleRate);
        this.startRecord();
    }

    private void startRecord() {
        if (this.isRecording.get()) {
            return;
        }
        this.isRecording.set(true);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (AudioInputByMediaCodec.this.isRecording.get()) {
                        if (!AudioInputByMediaCodec.this.isEncoding) continue;
                        Object object = AudioInputByMediaCodec.this.mPollLock;
                        synchronized (object) {
                            AudioInputByMediaCodec.this.mPollLock.wait();
                        }
                        if (AudioInputByMediaCodec.this.mOutputQueue == null || AudioInputByMediaCodec.this.mOutputQueue.size() >= 3 || AudioInputByMediaCodec.this.mEncodeExecutor == null || AudioInputByMediaCodec.this.mEncodeExecutor.isShutdown() || AudioInputByMediaCodec.this.mOutputQueue.size() <= 0) continue;
                        AudioInputByMediaCodec.this.mEncodeExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (AudioInputByMediaCodec.this.mOutputQueue != null && AudioInputByMediaCodec.this.isRecording.get()) {
                                    byte[] data = (byte[])AudioInputByMediaCodec.this.mOutputQueue.poll();
                                    if (AudioInputByMediaCodec.this.isEncoding && data != null) {
                                        AudioInputByMediaCodec.this._offerAudioEncoder(data, System.nanoTime());
                                    }
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    PlayerLogger.e(AudioInputByMediaCodec.TAG, "drop audio,Exception = " + e.getMessage());
                    e.printStackTrace();
                }
                PlayerLogger.e(AudioInputByMediaCodec.TAG, "drop audio,exit");
                AudioInputByMediaCodec.this.isEncoding = false;
                AudioInputByMediaCodec.this.isRecording.set(false);
            }
        };
        thread.setName("RecorderAudioInput");
        thread.start();
    }

    private void prepareEncoder(int channelCount, int bitrate, int audioSampleRate) {
        try {
            MediaFormat audioFormat = new MediaFormat();
            audioFormat.setString("mime", "audio/mp4a-latm");
            audioFormat.setInteger("aac-profile", 2);
            audioFormat.setInteger("sample-rate", audioSampleRate);
            audioFormat.setInteger("channel-count", channelCount);
            audioFormat.setInteger("bitrate", 128000);
            audioFormat.setInteger("max-input-size", 16384);
            try {
                this.mAudioEncoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mAudioEncoder.configure(audioFormat, null, null, 1);
            this.mAudioEncoder.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMuxer(MediaMuxer mMuxer) {
        if (this.illegalState) {
            PlayerLogger.e(TAG, "Audio-----setMuxer()----illegalState--:" + this.illegalState);
            return;
        }
        this.mMuxer = mMuxer;
        this.addTrack();
    }

    public void addTrack() {
        while (this.mAudioEncoder == null) {
            try {
                PlayerLogger.e(TAG, "Audio-----addTrack()----Thread.sleep(20)--");
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        MediaFormat newaudioFormat = this.mAudioEncoder.getOutputFormat();
        this.mAudioTrackIndex = this.mMuxer.addTrack(newaudioFormat);
        PlayerLogger.e(TAG, "-----addTrack------mAudioTrackIndex:" + this.mAudioTrackIndex);
    }

    private void _offerAudioEncoder(byte[] input, long presentationTimeNs) {
        if (this.noEncode) {
            return;
        }
        if (this.audioStartTime == 0L) {
            this.audioStartTime = presentationTimeNs;
        }
        PlayerLogger.i(TAG, "*****presentationTimeNs:" + presentationTimeNs);
        ++this.totalInputAudioFrameCount;
        this.audioBytesReceived += (long)input.length;
        this.drainEncoder(this.mAudioEncoder, this.mAudioBufferInfo, this.mAudioTrackIndex, false);
        try {
            ByteBuffer[] inputBuffers = this.mAudioEncoder.getInputBuffers();
            int inputBufferIndex = this.mAudioEncoder.dequeueInputBuffer(-1L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                inputBuffer.put(input);
                if (!this.isRecording.get()) {
                    PlayerLogger.i(TAG, "LiveCloudPlayer EOS received in offerEncoder");
                    this.mAudioEncoder.queueInputBuffer(inputBufferIndex, 0, input.length, presentationTimeNs / 1000L, 4);
                    this.noEncode = true;
                } else {
                    this.mAudioEncoder.queueInputBuffer(inputBufferIndex, 0, input.length, presentationTimeNs / 1000L, 0);
                }
            }
        }
        catch (Throwable t) {
            PlayerLogger.i(TAG, "_offerAudioEncoder exception");
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void drainEncoder(MediaCodec encoder, MediaCodec.BufferInfo bufferInfo, int mAudioTrackIndex, boolean endOfStream) {
        block13: {
            int TIMEOUT_USEC = 10000;
            ByteBuffer[] encoderOutputBuffers = encoder.getOutputBuffers();
            PlayerLogger.i(TAG, "****presentationTimeNs1:" + bufferInfo.presentationTimeUs);
            while (true) {
                int encoderStatus;
                if ((encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 10000L)) == -1) {
                    if (endOfStream) continue;
                    break block13;
                }
                if (encoderStatus == -3) {
                    encoderOutputBuffers = encoder.getOutputBuffers();
                    continue;
                }
                if (encoderStatus == -2) continue;
                if (encoderStatus < 0) {
                    PlayerLogger.e(TAG, "unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus);
                    continue;
                }
                ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
                if (encodedData == null) {
                    throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                }
                if ((bufferInfo.flags & 2) != 0) {
                    bufferInfo.size = 0;
                }
                if (bufferInfo.size != 0) {
                    encodedData.position(bufferInfo.offset);
                    encodedData.limit(bufferInfo.offset + bufferInfo.size);
                    Object object = this.saveAudioAndVideo_lock;
                    synchronized (object) {
                        if (this.mMuxer != null) {
                            if (bufferInfo.presentationTimeUs <= this.writeTimeStamp) {
                                bufferInfo.presentationTimeUs = this.writeTimeStamp + 1L;
                            }
                            this.mMuxer.writeSampleData(mAudioTrackIndex, encodedData, bufferInfo);
                            this.writeTimeStamp = bufferInfo.presentationTimeUs;
                        }
                    }
                    PlayerLogger.e(TAG, "-----mMuxer.writeSampleData---audio +bufferInfo.presentationTimeUs\uff1a" + bufferInfo.presentationTimeUs + "--------bufferInfo.size:" + bufferInfo.size);
                }
                encoder.releaseOutputBuffer(encoderStatus, false);
                if ((bufferInfo.flags & 4) != 0) break;
            }
            if (!endOfStream) {
                PlayerLogger.e(TAG, "reached end of stream unexpectedly");
            }
            PlayerLogger.e(TAG, "****break");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void muxerWriteData(ByteBuffer encodedData, int size, long presentationTimeUs, int channelCount, int bitrate, int audioSampleRate) {
        if (!this.initDone) {
            this.initAudioRecord(size, channelCount, bitrate, audioSampleRate);
            this.initDone = true;
        }
        if (this.mMuxer != null) {
            byte[] mPackage = null;
            if (this.mInputQueue != null) {
                mPackage = this.mInputQueue.poll();
            }
            if (mPackage == null || mPackage != null && mPackage.length != size) {
                mPackage = new byte[size];
            }
            encodedData.get(mPackage, 0, size);
            encodedData.rewind();
            if (this.isEncoding) {
                if (this.mOutputQueue != null && this.mOutputQueue.size() < 3 && this.mEncodeExecutor != null && !this.mEncodeExecutor.isShutdown()) {
                    this.mOutputQueue.offer(mPackage);
                } else {
                    PlayerLogger.e(TAG, "drop audio,because encode long time");
                    if (this.mInputQueue != null) {
                        this.mInputQueue.offer(mPackage);
                    }
                }
            } else if (this.mInputQueue != null) {
                this.mInputQueue.offer(mPackage);
            }
        }
        Object object = this.mPollLock;
        synchronized (object) {
            this.mPollLock.notifyAll();
        }
    }
}

