/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.opengl.GLUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;

public class GLProducerThread
extends Thread {
    private AtomicBoolean mShouldRender;
    private SurfaceTexture mSurfaceTexture;
    private GLRenderer mRenderer;
    private EGL10 mEgl;
    private EGLDisplay mEglDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLContext mEglContext = EGL10.EGL_NO_CONTEXT;
    private EGLSurface mEglSurface = EGL10.EGL_NO_SURFACE;
    private GL mGL;
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;

    public GLProducerThread(SurfaceTexture surfaceTexture, GLRenderer renderer, AtomicBoolean shouldRender) {
        this.mSurfaceTexture = surfaceTexture;
        this.mRenderer = renderer;
        this.mShouldRender = shouldRender;
    }

    @SuppressLint(value={"NewApi"})
    private void initGL() {
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetdisplay failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
        int[] version = new int[2];
        if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
            throw new RuntimeException("eglInitialize failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
        int[] configAttribs = new int[]{12320, 32, 12321, 8, 12322, 8, 12323, 8, 12324, 8, 12352, 4, 12339, 4, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!this.mEgl.eglChooseConfig(this.mEglDisplay, configAttribs, configs, 1, numConfigs)) {
            throw new RuntimeException("eglChooseConfig failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
        int[] contextAttribs = new int[]{12440, 2, 12344};
        this.mEglContext = this.mEgl.eglCreateContext(this.mEglDisplay, configs[0], EGL10.EGL_NO_CONTEXT, contextAttribs);
        this.mSurfaceTexture.updateTexImage();
        this.mGL = this.mEglContext.getGL();
    }

    private void destoryGL() {
        this.mEgl.eglDestroyContext(this.mEglDisplay, this.mEglContext);
        this.mEgl.eglDestroySurface(this.mEglDisplay, this.mEglSurface);
        this.mEglContext = EGL10.EGL_NO_CONTEXT;
        this.mEglSurface = EGL10.EGL_NO_SURFACE;
    }

    @Override
    public void run() {
        this.initGL();
        while (this.mShouldRender != null && this.mShouldRender.get()) {
            if (this.mRenderer == null) continue;
            try {
                GLProducerThread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.destoryGL();
    }

    public static interface GLRenderer {
        public void drawFrame();
    }
}

