/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.qihoo.livecloud.recorder.hc.GLProducerThread;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class GLRendererImpl
implements GLProducerThread.GLRenderer {
    private int mProgramObject;
    private int mWidth;
    private int mHeight;
    private FloatBuffer mVertices;
    private ShortBuffer mTexCoords;
    private Context mContext;
    private int mTexID;
    private static String TAG = "GLRendererImpl";
    private final float[] mVerticesData = new float[]{-0.5f, -0.5f, 0.0f, 0.5f, -0.5f, 0.0f, -0.5f, 0.5f, 0.0f, 0.5f, 0.5f, 0.0f};
    private final short[] mTexCoordsData = new short[]{0, 1, 1, 1, 0, 0, 1, 0};

    public GLRendererImpl(Context ctx) {
        this.mVertices = ByteBuffer.allocateDirect(this.mVerticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mVertices.put(this.mVerticesData).position(0);
        this.mTexCoords = ByteBuffer.allocateDirect(this.mTexCoordsData.length * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.mTexCoords.put(this.mTexCoordsData).position(0);
        this.mContext = ctx;
    }

    public void setViewport(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    @SuppressLint(value={"NewApi"})
    public void initGL() {
        this.comipleAndLinkProgram();
        this.loadTexture();
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    public void resize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void drawFrame() {
        GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
        GLES20.glClear((int)16384);
        GLES20.glUseProgram((int)this.mProgramObject);
        GLES20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)this.mVertices);
        GLES20.glEnableVertexAttribArray((int)0);
        GLES20.glVertexAttribPointer((int)1, (int)2, (int)5122, (boolean)false, (int)0, (Buffer)this.mTexCoords);
        GLES20.glEnableVertexAttribArray((int)1);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mTexID);
        int loc = GLES20.glGetUniformLocation((int)this.mProgramObject, (String)"u_Texture");
        GLES20.glUniform1f((int)loc, (float)0.0f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        Log.i((String)"GLRendererImpl", (String)("drawing..." + this.mWidth));
    }

    @SuppressLint(value={"NewApi"})
    private void loadTexture() {
        Bitmap b = null;
        if (b != null) {
            int[] texID = new int[1];
            GLES20.glGenTextures((int)1, (int[])texID, (int)0);
            GLES20.glBindTexture((int)3553, (int)texID[0]);
            this.mTexID = texID[0];
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)10497);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)10497);
            GLUtils.texImage2D((int)3553, (int)0, b, (int)0);
            b.recycle();
        }
    }

    @SuppressLint(value={"NewApi"})
    private int loadShader(int shaderType, String shaderSource) {
        int[] compiled = new int[1];
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader == 0) {
            return 0;
        }
        GLES20.glShaderSource((int)shader, (String)shaderSource);
        GLES20.glCompileShader((int)shader);
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.e((String)TAG, (String)GLES20.glGetShaderInfoLog((int)shader));
            GLES20.glDeleteShader((int)shader);
            return 0;
        }
        return shader;
    }

    @SuppressLint(value={"NewApi"})
    private void comipleAndLinkProgram() {
        String vShaderStr = "attribute vec4 a_position;    \nattribute vec2 a_texCoords; \nvarying vec2 v_texCoords; \nvoid main()                  \n{                            \n   gl_Position = a_position;  \n    v_texCoords = a_texCoords; \n}                            \n";
        String fShaderStr = "precision mediump float;                     \nuniform sampler2D u_Texture; \nvarying vec2 v_texCoords; \nvoid main()                                  \n{                                            \n  gl_FragColor = texture2D(u_Texture, v_texCoords) ;\n}                                            \n";
        int[] linked = new int[1];
        int vertexShader = this.loadShader(35633, vShaderStr);
        int fragmentShader = this.loadShader(35632, fShaderStr);
        int programObject = GLES20.glCreateProgram();
        if (programObject == 0) {
            return;
        }
        GLES20.glAttachShader((int)programObject, (int)vertexShader);
        GLES20.glAttachShader((int)programObject, (int)fragmentShader);
        GLES20.glBindAttribLocation((int)programObject, (int)0, (String)"a_position");
        GLES20.glBindAttribLocation((int)programObject, (int)1, (String)"a_texCoords");
        GLES20.glLinkProgram((int)programObject);
        GLES20.glGetProgramiv((int)programObject, (int)35714, (int[])linked, (int)0);
        if (linked[0] == 0) {
            Log.e((String)TAG, (String)"Error linking program:");
            Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)programObject));
            GLES20.glDeleteProgram((int)programObject);
            return;
        }
        this.mProgramObject = programObject;
    }
}

