/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.view.Surface;
import com.qihoo.livecloud.utils.PlayerLogger;

@SuppressLint(value={"NewApi"})
public final class HCEglCore {
    private static final String TAG = "HCEglCore";
    public static final int FLAG_RECORDABLE = 1;
    public static final int FLAG_TRY_GLES3 = 2;
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private int mGlVersion = -1;

    public HCEglCore() {
        this(null, 0);
    }

    public HCEglCore(EGLContext sharedContext, int flags) {
        EGLContext context;
        EGLConfig config;
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("EGL already set up");
        }
        if (sharedContext == null) {
            sharedContext = EGL14.EGL_NO_CONTEXT;
        }
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.mEGLDisplay = null;
            throw new RuntimeException("unable to initialize EGL14");
        }
        if ((flags & 2) != 0 && (config = this.getConfig(flags, 3)) != null) {
            int[] attrib3_list = new int[]{12440, 3, 12344};
            context = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)config, (EGLContext)sharedContext, (int[])attrib3_list, (int)0);
            if (EGL14.eglGetError() == 12288) {
                this.mEGLConfig = config;
                this.mEGLContext = context;
                this.mGlVersion = 3;
            }
        }
        if (this.mEGLContext == EGL14.EGL_NO_CONTEXT) {
            config = this.getConfig(flags, 2);
            if (config == null) {
                throw new RuntimeException("Unable to find a suitable EGLConfig");
            }
            int[] attrib2_list = new int[]{12440, 2, 12344};
            context = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)config, (EGLContext)sharedContext, (int[])attrib2_list, (int)0);
            this.checkEglError("eglCreateContext");
            this.mEGLConfig = config;
            this.mEGLContext = context;
            this.mGlVersion = 2;
        }
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext, (int)12440, (int[])values, (int)0);
        PlayerLogger.i(TAG, "EGLContext created, client version " + values[0]);
    }

    private EGLConfig getConfig(int flags, int version) {
        int[] numConfigs;
        EGLConfig[] configs;
        int renderableType = 4;
        if (version >= 3) {
            renderableType |= 0x40;
        }
        int[] attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, renderableType, 12344, 0, 12344};
        if ((flags & 1) != 0) {
            attribList[attribList.length - 3] = 12610;
            attribList[attribList.length - 2] = 1;
        }
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])attribList, (int)0, (EGLConfig[])(configs = new EGLConfig[1]), (int)0, (int)configs.length, (int[])(numConfigs = new int[1]), (int)0)) {
            PlayerLogger.i(TAG, "unable to find RGB8888 / " + version + " EGLConfig");
            return null;
        }
        return configs[0];
    }

    public void release() {
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
        }
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.mEGLConfig = null;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
                PlayerLogger.i(TAG, "WARNING: EglCore was not explicitly released -- state may be leaked");
                this.release();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void releaseSurface(EGLSurface eglSurface) {
        EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface);
    }

    public EGLSurface createWindowSurface(Object surface) {
        if (!(surface instanceof Surface) && !(surface instanceof SurfaceTexture)) {
            throw new RuntimeException("invalid surface: " + surface);
        }
        int[] surfaceAttribs = new int[]{12344};
        EGLSurface eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (Object)surface, (int[])surfaceAttribs, (int)0);
        this.checkEglError("eglCreateWindowSurface");
        if (eglSurface == null) {
            throw new RuntimeException("surface was null");
        }
        return eglSurface;
    }

    public EGLSurface createOffscreenSurface(int width, int height) {
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        EGLSurface eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (int[])surfaceAttribs, (int)0);
        this.checkEglError("eglCreatePbufferSurface");
        if (eglSurface == null) {
            throw new RuntimeException("surface was null");
        }
        return eglSurface;
    }

    public void makeCurrent(EGLSurface eglSurface) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            PlayerLogger.i(TAG, "NOTE: makeCurrent w/o display");
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface, (EGLSurface)eglSurface, (EGLContext)this.mEGLContext)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    public void makeCurrent(EGLSurface drawSurface, EGLSurface readSurface) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            PlayerLogger.i(TAG, "NOTE: makeCurrent w/o display");
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)drawSurface, (EGLSurface)readSurface, (EGLContext)this.mEGLContext)) {
            throw new RuntimeException("eglMakeCurrent(draw,read) failed");
        }
    }

    public void makeNothingCurrent() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    public boolean swapBuffers(EGLSurface eglSurface) {
        return EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface);
    }

    public void setPresentationTime(EGLSurface eglSurface, long nsecs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface, (long)nsecs);
    }

    public boolean isCurrent(EGLSurface eglSurface) {
        return this.mEGLContext.equals((Object)EGL14.eglGetCurrentContext()) && eglSurface.equals((Object)EGL14.eglGetCurrentSurface((int)12377));
    }

    public int querySurface(EGLSurface eglSurface, int what) {
        int[] value = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface, (int)what, (int[])value, (int)0);
        return value[0];
    }

    public String queryString(int what) {
        return EGL14.eglQueryString((EGLDisplay)this.mEGLDisplay, (int)what);
    }

    public int getGlVersion() {
        return this.mGlVersion;
    }

    public static void logCurrent(String msg) {
        EGLDisplay display = EGL14.eglGetCurrentDisplay();
        EGLContext context = EGL14.eglGetCurrentContext();
        EGLSurface surface = EGL14.eglGetCurrentSurface((int)12377);
        PlayerLogger.i(TAG, "Current EGL (" + msg + "): display=" + display + ", context=" + context + ", surface=" + surface);
    }

    private void checkEglError(String msg) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }
}

