/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import com.qihoo.livecloud.recorder.hc.HCDrawable2d;
import com.qihoo.livecloud.recorder.hc.HCGlUtil;
import com.qihoo.livecloud.recorder.hc.HCTexture2dProgram;

public class HCFullFrameRect {
    private final HCDrawable2d mRectDrawable = new HCDrawable2d(HCDrawable2d.Prefab.FULL_RECTANGLE);
    private HCTexture2dProgram mProgram;

    public HCFullFrameRect(HCTexture2dProgram program) {
        this.mProgram = program;
    }

    public void release(boolean doEglCleanup) {
        if (this.mProgram != null) {
            if (doEglCleanup) {
                this.mProgram.release();
            }
            this.mProgram = null;
        }
    }

    public HCDrawable2d GetRectDrawable() {
        return this.mRectDrawable;
    }

    public HCTexture2dProgram getProgram() {
        return this.mProgram;
    }

    public void changeProgram(HCTexture2dProgram program) {
        this.mProgram.release();
        this.mProgram = program;
    }

    public int createTextureObject() {
        return this.mProgram.createTextureObject();
    }

    public void drawFrame(int textureId, float[] texMatrix, boolean b_use_mirror) {
        this.mProgram.draw(HCGlUtil.IDENTITY_MATRIX, this.mRectDrawable.getVertexArray(), 0, this.mRectDrawable.getVertexCount(), this.mRectDrawable.getCoordsPerVertex(), this.mRectDrawable.getVertexStride(), texMatrix, b_use_mirror ? this.mRectDrawable.getTexMirroCoordArray() : this.mRectDrawable.getTexCoordArray(), textureId, this.mRectDrawable.getTexCoordStride());
    }
}

