/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.opengl.Matrix;
import com.qihoo.livecloud.recorder.hc.HCDrawable2d;
import com.qihoo.livecloud.recorder.hc.HCGlUtil;
import com.qihoo.livecloud.recorder.hc.HCTexture2dProgram;

public class HCSprite2d {
    private static final String TAG = "Grafika";
    private HCDrawable2d mDrawable;
    private float[] mColor;
    private int mTextureId;
    private float mAngle;
    private float mScaleX;
    private float mScaleY;
    private float mPosX;
    private float mPosY;
    private float[] mModelViewMatrix;
    private boolean mMatrixReady;
    private float[] mScratchMatrix = new float[16];

    public HCSprite2d(HCDrawable2d drawable) {
        this.mDrawable = drawable;
        this.mColor = new float[4];
        this.mColor[3] = 1.0f;
        this.mTextureId = -1;
        this.mModelViewMatrix = new float[16];
        this.mMatrixReady = false;
    }

    private void recomputeMatrix() {
        float[] modelView = this.mModelViewMatrix;
        Matrix.setIdentityM((float[])modelView, (int)0);
        Matrix.translateM((float[])modelView, (int)0, (float)this.mPosX, (float)this.mPosY, (float)0.0f);
        if (this.mAngle != 0.0f) {
            Matrix.rotateM((float[])modelView, (int)0, (float)this.mAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        Matrix.scaleM((float[])modelView, (int)0, (float)this.mScaleX, (float)this.mScaleY, (float)1.0f);
        this.mMatrixReady = true;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public void setScale(float scaleX, float scaleY) {
        this.mScaleX = scaleX;
        this.mScaleY = scaleY;
        this.mMatrixReady = false;
    }

    public float getRotation() {
        return this.mAngle;
    }

    public void setRotation(float angle) {
        while (angle >= 360.0f) {
            angle -= 360.0f;
        }
        while (angle <= -360.0f) {
            angle += 360.0f;
        }
        this.mAngle = angle;
        this.mMatrixReady = false;
    }

    public float getPositionX() {
        return this.mPosX;
    }

    public float getPositionY() {
        return this.mPosY;
    }

    public void setPosition(float posX, float posY) {
        this.mPosX = posX;
        this.mPosY = posY;
        this.mMatrixReady = false;
    }

    public float[] getModelViewMatrix() {
        if (!this.mMatrixReady) {
            this.recomputeMatrix();
        }
        return this.mModelViewMatrix;
    }

    public void setColor(float red, float green, float blue) {
        this.mColor[0] = red;
        this.mColor[1] = green;
        this.mColor[2] = blue;
    }

    public void setTexture(int textureId) {
        this.mTextureId = textureId;
    }

    public float[] getColor() {
        return this.mColor;
    }

    public void draw(HCTexture2dProgram program, float[] projectionMatrix) {
        Matrix.multiplyMM((float[])this.mScratchMatrix, (int)0, (float[])projectionMatrix, (int)0, (float[])this.getModelViewMatrix(), (int)0);
        program.draw(this.mScratchMatrix, this.mDrawable.getVertexArray(), 0, this.mDrawable.getVertexCount(), this.mDrawable.getCoordsPerVertex(), this.mDrawable.getVertexStride(), HCGlUtil.IDENTITY_MATRIX, this.mDrawable.getTexCoordArray(), this.mTextureId, this.mDrawable.getTexCoordStride());
    }

    public String toString() {
        return "[Sprite2d pos=" + this.mPosX + "," + this.mPosY + " scale=" + this.mScaleX + "," + this.mScaleY + " angle=" + this.mAngle + " color={" + this.mColor[0] + "," + this.mColor[1] + "," + this.mColor[2] + "} drawable=" + this.mDrawable + "]";
    }
}

