/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.annotation.SuppressLint;
import android.opengl.GLES20;
import com.qihoo.livecloud.recorder.hc.HCGlUtil;
import com.qihoo.livecloud.utils.PlayerLogger;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class HCTexture2dProgram {
    private static final String TAG = "Grafika";
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n";
    private static final String FRAGMENT_SHADER_2D = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform sampler2D sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final String FRAGMENT_SHADER_EXT = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final String VERTEX_BEAUTY_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvarying vec2 blurCoord0;\nvarying vec2 blurCoord1;\nvarying vec2 blurCoord2;\nvarying vec2 blurCoord3;\nvarying vec2 blurCoord4;\nvarying vec2 blurCoord5;\nvarying vec2 blurCoord6;\nvarying vec2 blurCoord7;\nvarying vec2 blurCoord8;\nvarying vec2 blurCoord9;\nvarying vec2 blurCoord10;\nvarying vec2 blurCoord11;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n    blurCoord0 = vTextureCoord.xy + vec2(0.0, -0.008);\n    blurCoord1 = vTextureCoord.xy + vec2(0.0, 0.008);\n    blurCoord2 = vTextureCoord.xy + vec2(-0.014, 0.0);\n    blurCoord3 = vTextureCoord.xy + vec2(0.014, 0.0);\n    blurCoord4 = vTextureCoord.xy + vec2(0.007, -0.006);\n    blurCoord5 = vTextureCoord.xy + vec2(0.007, 0.006);\n    blurCoord6 = vTextureCoord.xy + vec2(-0.007, 0.006);\n    blurCoord7 = vTextureCoord.xy + vec2(-0.007, -0.006);\n    blurCoord8 = vTextureCoord.xy + vec2(0.011, -0.004);\n    blurCoord9 = vTextureCoord.xy + vec2(0.011, 0.004);\n    blurCoord10 = vTextureCoord.xy + vec2(-0.011, 0.004);\n    blurCoord11 = vTextureCoord.xy + vec2(-0.011, -0.004);\n}\n";
    private static final String FRAGMENT_SHADER_EXT_BEAUTY2 = "#extension GL_OES_EGL_image_external : require                                                                            \nprecision highp float;                                                                                                    \n                                                                                                                          \nuniform samplerExternalOES sTexture;                                                                                      \nuniform vec2 singleStepOffset;                                                                                            \nuniform highp vec4 params;                                                                                                \n                                                                                                                          \nvarying highp vec2 vTextureCoord;                                                                                     \nvarying vec2 blurCoord0;\nvarying vec2 blurCoord1;\nvarying vec2 blurCoord2;\nvarying vec2 blurCoord3;\nvarying vec2 blurCoord4;\nvarying vec2 blurCoord5;\nvarying vec2 blurCoord6;\nvarying vec2 blurCoord7;\nvarying vec2 blurCoord8;\nvarying vec2 blurCoord9;\nvarying vec2 blurCoord10;\nvarying vec2 blurCoord11;\n                                                                                                                          \nvoid main(){                                                                                                              \n\tvec3 sampleColor = texture2D(sTexture, vTextureCoord).rgb;                                          \n\tsampleColor += texture2D(sTexture, blurCoord0).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoord1).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoord2).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoord3).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoord4).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoord5).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoord6).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoord7).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoord8).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoord9).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoord10).rgb;                                                    \n\tsampleColor += texture2D(sTexture, blurCoord11).rgb;                                                    \n\t\t                                                                                                                   \n\tsampleColor /= 13.0;                                                                                     \n\t                                                                                                                       \n\tfloat var = 0.0;             \n\tvar +=  abs((texture2D(sTexture, blurCoord0).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord1).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord2).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord3).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord4).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord5).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord6).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord7).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord8).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord9).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord10).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoord11).g- sampleColor.g));          \n\tvar /= 12.0;             \n\tgl_FragColor.rgb = mix(sampleColor, texture2D(sTexture, vTextureCoord).rgb, var / (var + 0.075));               \n}";
    private static final String FRAGMENT_SHADER_EXT_BEAUTY = "#extension GL_OES_EGL_image_external : require                                                                            \nprecision highp float;                                                                                                    \n                                                                                                                          \nuniform samplerExternalOES sTexture;                                                                                      \nuniform vec2 singleStepOffset;                                                                                            \nuniform highp vec4 params;                                                                                                \n                                                                                                                          \nvarying highp vec2 vTextureCoord;                                                                                     \n                                                                                                                          \nvoid main(){                                                                                                              \n\tvec2 blurCoordinates[12];                                                                                              \n\t                                                                                                                       \n\tblurCoordinates[0] = vTextureCoord.xy + vec2(0.0, -0.008);                                       \n\tblurCoordinates[1] = vTextureCoord.xy + vec2(0.0, 0.008);                                        \n\tblurCoordinates[2] = vTextureCoord.xy + vec2(-0.014, 0.0);                                       \n\tblurCoordinates[3] = vTextureCoord.xy + vec2(0.014, 0.0);                                        \n\t                                                                                                                       \n\tblurCoordinates[4] = vTextureCoord.xy + vec2(0.007, -0.006);                                      \n\tblurCoordinates[5] = vTextureCoord.xy + vec2(0.007, 0.006);                                       \n\tblurCoordinates[6] = vTextureCoord.xy + vec2(-0.007, 0.006);                                      \n\tblurCoordinates[7] = vTextureCoord.xy + vec2(-0.007, -0.006);                                     \n\t                                                                                                                       \n\tblurCoordinates[8] = vTextureCoord.xy + vec2(0.011, -0.004);                                      \n\tblurCoordinates[9] = vTextureCoord.xy + vec2(0.011, 0.004);                                       \n\tblurCoordinates[10] = vTextureCoord.xy + vec2(-0.011, 0.004);\t                                   \n\tblurCoordinates[11] = vTextureCoord.xy + vec2(-0.011, -0.004);                                    \n\t                                                                                                                       \n\t                                                                                                                       \n\tvec3 sampleColor = texture2D(sTexture, vTextureCoord).rgb;                                          \n\tsampleColor += texture2D(sTexture, blurCoordinates[0]).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoordinates[1]).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoordinates[2]).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoordinates[3]).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoordinates[4]).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoordinates[5]).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoordinates[6]).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoordinates[7]).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoordinates[8]).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoordinates[9]).rgb;                                                     \n\tsampleColor += texture2D(sTexture, blurCoordinates[10]).rgb;                                                    \n\tsampleColor += texture2D(sTexture, blurCoordinates[11]).rgb;                                                    \n\t\t                                                                                                                   \n\tsampleColor /= 13.0;                                                                                     \n\t                                                                                                                       \n\tfloat var = 0.0;             \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[0]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[1]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[2]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[3]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[4]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[5]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[6]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[7]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[8]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[9]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[10]).g- sampleColor.g));          \n\tvar +=  abs((texture2D(sTexture, blurCoordinates[11]).g- sampleColor.g));          \n\tvar /= 12.0;             \n\tgl_FragColor.rgb = mix(sampleColor, texture2D(sTexture, vTextureCoord).rgb, var / (var + 0.075));               \n}";
    private static final String FRAGMENT_SHADER_EXT_SHAPEN = "#extension GL_OES_EGL_image_external : require                                                                            \nprecision highp float;                                                                                                    \n                                                                                                                          \nuniform samplerExternalOES sTexture;                                                                                      \n                                                                                                                          \nvarying highp vec2 vTextureCoord;                                                                                         \nvoid main() {                                                                                                             \nvec2 offset0=vec2(-0.001389,-0.000781); vec2 offset1=vec2(0.0,-0.000781); vec2 offset2=vec2(0.001389,-0.000781);                                   \nvec2 offset3=vec2(-0.001389,0.0); vec2 offset4=vec2(0.0,0.0); vec2 offset5=vec2(0.001389,0.0);                                      \nvec2 offset6=vec2(-0.001389,0.000781); vec2 offset7=vec2(0.0,0.000781); vec2 offset8=vec2(0.001389,0.000781);                                      \nfloat kernelValue0 = 0.0; float kernelValue1 = -1.0; float kernelValue2 = 0.0;                                            \nfloat kernelValue3 = -1.0; float kernelValue4 = 5.0; float kernelValue5 = -1.0;                                           \nfloat kernelValue6 = 0.0; float kernelValue7 = -1.0; float kernelValue8 = 0.0;                                            \nvec4 sum;                                                                                                                 \nvec4 cTemp0,cTemp1,cTemp2,cTemp3,cTemp4,cTemp5,cTemp6,cTemp7,cTemp8;                                                      \ncTemp0=texture2D(sTexture, vec2(vTextureCoord.s+offset0.x, vTextureCoord.t + offset0.y));                     \ncTemp1=texture2D(sTexture, vec2(vTextureCoord.s+offset1.x, vTextureCoord.t + offset1.y));                                                          \ncTemp2=texture2D(sTexture, vec2(vTextureCoord.s+offset2.x, vTextureCoord.t + offset2.y));                                                          \ncTemp3=texture2D(sTexture, vec2(vTextureCoord.s+offset3.x, vTextureCoord.t + offset3.y));                                                          \ncTemp4=texture2D(sTexture, vec2(vTextureCoord.s+offset4.x, vTextureCoord.t + offset4.y));                                                          \ncTemp5=texture2D(sTexture, vec2(vTextureCoord.s+offset5.x, vTextureCoord.t + offset5.y));                                                          \ncTemp6=texture2D(sTexture, vec2(vTextureCoord.s+offset6.x, vTextureCoord.t + offset6.y));                                                          \ncTemp7=texture2D(sTexture, vec2(vTextureCoord.s+offset7.x, vTextureCoord.t + offset7.y));                                                          \ncTemp8=texture2D(sTexture, vec2(vTextureCoord.s+offset8.x, vTextureCoord.t + offset8.y));                                                          \nsum =kernelValue0*cTemp0+kernelValue1*cTemp1+kernelValue2*cTemp2+                                                         \nkernelValue3*cTemp3+kernelValue4*cTemp4+kernelValue5*cTemp5+                                                              \nkernelValue6*cTemp6+kernelValue7*cTemp7+kernelValue8*cTemp8;                                                              \ngl_FragColor = sum;                                                                                                       \n}";
    private static final String FRAGMENT_SHADER_EXT_BRIGHTNESS = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n     vec4 textureColor = texture2D(sTexture, vTextureCoord);\ngl_FragColor = vec4((textureColor.rgb + vec3(0.1)), textureColor.w);\n}\n";
    private ProgramType mProgramType;
    private int mProgramHandle;
    private int muMVPMatrixLoc;
    private int muTexMatrixLoc;
    private int maPositionLoc;
    private int maTextureCoordLoc;
    private int mSingleStepOffsetLocation;
    private int mParamsLocation;
    private int mTextureTarget;
    private float[] mTexOffset;
    private float mColorAdjust;
    FloatBuffer tmp1 = FloatBuffer.wrap(new float[]{0.0013888889f, 7.8125E-4f});
    FloatBuffer tmp2 = FloatBuffer.wrap(new float[]{0.33f, 0.63f, 0.4f, 0.35f});

    @SuppressLint(value={"NewApi"})
    public HCTexture2dProgram(ProgramType programType) {
        this.mProgramType = programType;
        switch (programType) {
            case TEXTURE_2D: {
                this.mTextureTarget = 3553;
                this.mProgramHandle = HCGlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_2D);
                break;
            }
            case TEXTURE_EXT: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = HCGlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT);
                break;
            }
            case TEXTURE_EXT_BEAUTY: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = HCGlUtil.createProgram(VERTEX_BEAUTY_SHADER, FRAGMENT_SHADER_EXT_BEAUTY2);
                break;
            }
            case TEXTURE_EXT_SHAPEN: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = HCGlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT_SHAPEN);
                break;
            }
            case TEXTURE_EXT_BRIGHTNESS: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = HCGlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT_BRIGHTNESS);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled type " + (Object)((Object)programType));
            }
        }
        if (this.mProgramHandle == 0) {
            throw new RuntimeException("Unable to create program");
        }
        PlayerLogger.d(TAG, "Created program " + this.mProgramHandle + " (" + (Object)((Object)programType) + ")");
        this.maPositionLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aPosition");
        HCGlUtil.checkLocation(this.maPositionLoc, "aPosition");
        this.maTextureCoordLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aTextureCoord");
        HCGlUtil.checkLocation(this.maTextureCoordLoc, "aTextureCoord");
        this.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uMVPMatrix");
        HCGlUtil.checkLocation(this.muMVPMatrixLoc, "uMVPMatrix");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexMatrix");
        HCGlUtil.checkLocation(this.muTexMatrixLoc, "uTexMatrix");
        if (programType == ProgramType.TEXTURE_EXT_BEAUTY) {
            this.mSingleStepOffsetLocation = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"singleStepOffset");
            this.mParamsLocation = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"params");
        }
    }

    @SuppressLint(value={"NewApi"})
    public void release() {
        PlayerLogger.i(TAG, "deleting program " + this.mProgramHandle);
        GLES20.glDeleteProgram((int)this.mProgramHandle);
        this.mProgramHandle = -1;
    }

    public ProgramType getProgramType() {
        return this.mProgramType;
    }

    @SuppressLint(value={"NewApi"})
    public int createTextureObject() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        HCGlUtil.checkGlError("glGenTextures");
        int texId = textures[0];
        GLES20.glBindTexture((int)this.mTextureTarget, (int)texId);
        HCGlUtil.checkGlError("glBindTexture " + texId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        HCGlUtil.checkGlError("glTexParameter");
        return texId;
    }

    public void setTexSize(int width, int height) {
        float rw = 1.0f / (float)width;
        float rh = 1.0f / (float)height;
        this.mTexOffset = new float[]{-rw, -rh, 0.0f, -rh, rw, -rh, -rw, 0.0f, 0.0f, 0.0f, rw, 0.0f, -rw, rh, 0.0f, rh, rw, rh};
    }

    @SuppressLint(value={"NewApi"})
    public void draw(float[] mvpMatrix, FloatBuffer vertexBuffer, int firstVertex, int vertexCount, int coordsPerVertex, int vertexStride, float[] texMatrix, FloatBuffer texBuffer, int textureId, int texStride) {
        HCGlUtil.checkGlError("draw start");
        GLES20.glUseProgram((int)this.mProgramHandle);
        HCGlUtil.checkGlError("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)textureId);
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        HCGlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        HCGlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)this.maPositionLoc);
        HCGlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maPositionLoc, (int)coordsPerVertex, (int)5126, (boolean)false, (int)vertexStride, (Buffer)vertexBuffer);
        HCGlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.maTextureCoordLoc);
        HCGlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)texStride, (Buffer)texBuffer);
        HCGlUtil.checkGlError("glVertexAttribPointer");
        if (this.mProgramType == ProgramType.TEXTURE_EXT_BEAUTY && this.mSingleStepOffsetLocation > 0 && this.mParamsLocation > 0) {
            GLES20.glUniform2fv((int)this.mSingleStepOffsetLocation, (int)1, (FloatBuffer)this.tmp1);
            HCGlUtil.checkGlError("mSingleStepOffsetLocation");
            GLES20.glUniform4fv((int)this.mParamsLocation, (int)1, (FloatBuffer)this.tmp2);
            HCGlUtil.checkGlError("mParamsLocation");
        }
        GLES20.glDrawArrays((int)5, (int)firstVertex, (int)vertexCount);
        HCGlUtil.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.maPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.maTextureCoordLoc);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }

    public static enum ProgramType {
        TEXTURE_2D,
        TEXTURE_EXT,
        TEXTURE_EXT_BEAUTY,
        TEXTURE_EXT_SHAPEN,
        TEXTURE_EXT_BRIGHTNESS;

    }
}

