/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.EGLContext;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.qihoo.livecloud.recorder.hc.AudioInputByMediaCodec;
import com.qihoo.livecloud.recorder.hc.HCEglCore;
import com.qihoo.livecloud.recorder.hc.HCFullFrameRect;
import com.qihoo.livecloud.recorder.hc.HCTexture2dProgram;
import com.qihoo.livecloud.recorder.hc.HCVideoEncoderCore;
import com.qihoo.livecloud.recorder.hc.HCWindowSurface;
import com.qihoo.livecloud.recorder.hc.QHVCRecorderSDK;
import com.qihoo.livecloud.utils.PlayerLogger;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressLint(value={"NewApi"})
public class HCTextureMovieEncoder
implements Runnable,
SurfaceTexture.OnFrameAvailableListener {
    private static final String TAG = "TextureMovieEncoder";
    private static final int MSG_START_RECORDING = 1;
    private static final int MSG_STOP_RECORDING = 2;
    private static final int MSG_FRAME_AVAILABLE = 3;
    private static final int MSG_SET_TEXTURE_ID = 4;
    private static final int MSG_SET_MIRRO = 6;
    private static final int MSG_QUIT = 20;
    private HCWindowSurface mInputWindowSurface;
    private HCEglCore mEglCore;
    private HCFullFrameRect mFullScreen;
    private int mTextureId;
    private HCVideoEncoderCore mVideoEncoder;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoBitrate;
    private int mVideoFps;
    private int mVideoiframeInterval;
    private String mSavePath;
    private volatile EncoderHandler mHandler;
    private Object mReadyFence = new Object();
    private boolean mReady;
    private boolean mRunning;
    private long tempTime;
    private static final int QUEUE_NUM = 7;
    private static final int QUEUE_FRAME = 5;
    private ExecutorService mEncodeExecutor = null;
    private boolean hasUpdateResolution = false;
    private boolean pauseEncoderFlag = false;
    private SurfaceTexture mReadSurfaceTexture = null;
    private int mReadTextureId;
    private QHVCRecorderSDK.SurfaceTextureListener surfaceTextureListener;
    private QHVCRecorderSDK.EncoderReleaseFinishCallBack mEncoderReleaseFinishCallBack;
    private AtomicBoolean mFrameAvailable = new AtomicBoolean(false);
    private AtomicBoolean mFirstFrameAvailable = new AtomicBoolean(false);
    float[] transform_matrix = new float[16];
    private AudioInputByMediaCodec mAudioInput;
    private Context context;
    EncoderConfig m_config;
    boolean m_b_mirro = false;
    boolean canPrintFps = true;
    int frameNumber = 0;
    long startTime = 0L;

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.mFirstFrameAvailable.set(true);
        if (this.surfaceTextureListener != null) {
            this.surfaceTextureListener.onFrameAvailable();
        }
        this.mFrameAvailable.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Context context) {
        this.context = context;
        Object object = this.mReadyFence;
        synchronized (object) {
            if (this.mRunning) {
                PlayerLogger.i(TAG, "Encoder thread already running");
                return;
            }
            this.mRunning = true;
            Thread thread_tmp = new Thread((Runnable)this, TAG);
            thread_tmp.start();
            while (!this.mReady) {
                try {
                    this.mReadyFence.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void setSurfaceTextureListener(QHVCRecorderSDK.SurfaceTextureListener listener) {
        this.surfaceTextureListener = listener;
    }

    public void setreleaseSuccessListener(QHVCRecorderSDK.EncoderReleaseFinishCallBack listener) {
        this.mEncoderReleaseFinishCallBack = listener;
    }

    public void startRecording(EncoderConfig config) {
        PlayerLogger.i(TAG, "Encoder: startRecording()");
        this.m_config = config;
        if (this.mHandler != null) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, config));
        } else {
            PlayerLogger.e(TAG, "TextureMovieEncoder, startRecording failed, mHandler is null...");
        }
    }

    public void stopRecording() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
        this.mHandler.sendMessage(this.mHandler.obtainMessage(20));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecording() {
        Object object = this.mReadyFence;
        synchronized (object) {
            return this.mRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void frameAvailable() {
        Object object = this.mReadyFence;
        synchronized (object) {
            if (!this.mReady) {
                return;
            }
        }
        if (this.mReadSurfaceTexture == null) {
            return;
        }
        long timestamp = this.mReadSurfaceTexture.getTimestamp();
        if (timestamp == 0L) {
            timestamp = System.nanoTime();
        }
        if (timestamp == 0L) {
            PlayerLogger.d(TAG, "HEY: got SurfaceTexture with timestamp of zero");
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (int)(timestamp >> 32), (int)timestamp, this.transform_matrix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextureId(int id) {
        Object object = this.mReadyFence;
        synchronized (object) {
            if (!this.mReady) {
                return;
            }
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, id, 0, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        Object object = this.mReadyFence;
        synchronized (object) {
            this.mHandler = new EncoderHandler(this);
            this.mReady = true;
            this.mReadyFence.notify();
        }
        Looper.loop();
        PlayerLogger.d(TAG, "Encoder thread exiting");
        object = this.mReadyFence;
        synchronized (object) {
            this.mRunning = false;
            this.mReady = false;
            this.mHandler = null;
        }
    }

    private void handleStartRecording(EncoderConfig config) {
        this.prepareEncoder(config.mEglContext, config.mWidth, config.mHeight, config.mBitRate, config.mFps, config.mIframeInterval, config.savePath);
    }

    @SuppressLint(value={"NewApi"})
    private void handleCreateSurfaceTexture() {
        this.mReadTextureId = this.mFullScreen.createTextureObject();
        this.mReadSurfaceTexture = new SurfaceTexture(this.mReadTextureId);
        this.mReadSurfaceTexture.setDefaultBufferSize(this.mVideoWidth, this.mVideoHeight);
        this.mReadSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        if (this.surfaceTextureListener != null) {
            this.surfaceTextureListener.onSurfaceTextureCreated(this.mReadSurfaceTexture);
        }
        this.setTextureId(this.mReadTextureId);
    }

    private void handleSetMirro(int n_mirro) {
        this.m_b_mirro = n_mirro == 1;
    }

    private void printAverageFps() {
        if (!this.canPrintFps) {
            return;
        }
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        ++this.frameNumber;
        long time = (System.currentTimeMillis() - this.startTime) / 1000L;
        if (time > 0L) {
            int fps = (int)((long)this.frameNumber / time);
            PlayerLogger.d(TAG, "TextureMovieEncoder, averageFps : " + fps);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void handleFrameAvailable(float[] transform, long timestampNanos) {
        if (this.hasUpdateResolution || this.pauseEncoderFlag || this.mReadSurfaceTexture == null) {
            return;
        }
        if (this.mFrameAvailable.get()) {
            this.mReadSurfaceTexture.updateTexImage();
            this.mReadSurfaceTexture.getTransformMatrix(this.transform_matrix);
            this.mFrameAvailable.set(false);
        }
        long startTime = System.currentTimeMillis();
        PlayerLogger.i("convert--Time", "-------handleFrameAvailable:" + System.currentTimeMillis() + "-----------------------  diff=" + (startTime - this.tempTime));
        this.tempTime = startTime;
        this.mVideoEncoder.drainEncoder(false);
        this.mFullScreen.drawFrame(this.mTextureId, this.transform_matrix, this.m_b_mirro);
        this.mInputWindowSurface.setPresentationTime(timestampNanos);
        this.mInputWindowSurface.swapBuffers();
        PlayerLogger.i("convert--Time", "---------------------AllEnd cost:" + (System.currentTimeMillis() - startTime) + "-----------------------");
    }

    private void handleStopRecording() {
        this.releaseEncoder();
        PlayerLogger.i(TAG, "handleStopRecording");
    }

    private void handleReleaseSuccess() {
        if (this.mEncoderReleaseFinishCallBack != null) {
            PlayerLogger.i(TAG, "handleReleaseSuccess");
            this.mEncoderReleaseFinishCallBack.finishSuccess();
        }
    }

    private void handleSetTexture(int id) {
        PlayerLogger.i(TAG, "handleSetTexture " + id);
        this.mTextureId = id;
    }

    private void prepareEncoder(EGLContext sharedContext, int width, int height, int bitRate, int fps, int iframeInterval, String savePath) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.mVideoBitrate = bitRate;
        this.mVideoFps = fps;
        this.mVideoiframeInterval = iframeInterval;
        this.mSavePath = savePath;
        try {
            this.mAudioInput = this.initAudio();
            this.mVideoEncoder = new HCVideoEncoderCore(this.mVideoWidth, this.mVideoHeight, this.mVideoBitrate, this.mVideoFps, this.mVideoiframeInterval, this.mSavePath, this.mAudioInput);
        }
        catch (Throwable ioe) {
            PlayerLogger.e(TAG, ioe.getMessage());
        }
        this.mEglCore = new HCEglCore(sharedContext, 1);
        this.mInputWindowSurface = new HCWindowSurface(this.mEglCore, this.mVideoEncoder.getInputSurface(), true);
        this.mInputWindowSurface.makeCurrent();
        this.mFullScreen = new HCFullFrameRect(new HCTexture2dProgram(HCTexture2dProgram.ProgramType.TEXTURE_EXT));
        this.handleCreateSurfaceTexture();
    }

    public AudioInputByMediaCodec initAudio() {
        this.mAudioInput = new AudioInputByMediaCodec();
        return this.mAudioInput;
    }

    public void writeAudioData(ByteBuffer encodedData, int size, long presentationTimeUs, int channelCount, int bitrate, int audioSampleRate) {
        if (this.mAudioInput != null) {
            this.mAudioInput.muxerWriteData(encodedData, size, presentationTimeUs, channelCount, bitrate, audioSampleRate);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void releaseEncoder() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.release();
            this.mVideoEncoder = null;
        }
        if (this.mInputWindowSurface != null) {
            this.mInputWindowSurface.release();
            this.mInputWindowSurface = null;
        }
        if (this.mFullScreen != null) {
            this.mFullScreen.release(false);
            this.mFullScreen = null;
        }
        if (this.mEglCore != null) {
            this.mEglCore.release();
            this.mEglCore = null;
        }
        if (this.surfaceTextureListener != null) {
            this.surfaceTextureListener.onSurfaceTextureDestroyed(this.mReadSurfaceTexture);
            this.surfaceTextureListener = null;
        }
        if (this.mReadSurfaceTexture != null) {
            this.mReadSurfaceTexture.release();
            this.mReadSurfaceTexture = null;
        }
        if (this.mEncodeExecutor != null) {
            this.mEncodeExecutor.shutdown();
            try {
                this.mEncodeExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mEncodeExecutor = null;
        }
    }

    public void pauseEncoder() {
        this.pauseEncoderFlag = true;
    }

    public void resumeEncoder() {
        this.pauseEncoderFlag = false;
    }

    private static class EncoderHandler
    extends Handler {
        private WeakReference<HCTextureMovieEncoder> mWeakEncoder;

        public EncoderHandler(HCTextureMovieEncoder encoder) {
            this.mWeakEncoder = new WeakReference<HCTextureMovieEncoder>(encoder);
        }

        public void handleMessage(Message inputMessage) {
            int what = inputMessage.what;
            Object obj = inputMessage.obj;
            HCTextureMovieEncoder encoder = (HCTextureMovieEncoder)this.mWeakEncoder.get();
            if (encoder == null) {
                PlayerLogger.d(HCTextureMovieEncoder.TAG, "EncoderHandler.handleMessage: encoder is null");
                return;
            }
            switch (what) {
                case 1: {
                    encoder.handleStartRecording((EncoderConfig)obj);
                    break;
                }
                case 2: {
                    encoder.handleStopRecording();
                    break;
                }
                case 3: {
                    long timestamp = (long)inputMessage.arg1 << 32 | (long)inputMessage.arg2 & 0xFFFFFFFFL;
                    encoder.handleFrameAvailable((float[])obj, timestamp);
                    break;
                }
                case 4: {
                    encoder.handleSetTexture(inputMessage.arg1);
                    break;
                }
                case 6: {
                    encoder.handleSetMirro(inputMessage.arg1);
                    break;
                }
                case 20: {
                    encoder.handleReleaseSuccess();
                    Looper.myLooper().quit();
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled msg what=" + what);
                }
            }
        }
    }

    public static class EncoderConfig {
        final String savePath;
        int mWidth;
        int mHeight;
        final int mBitRate;
        final int mFps;
        final int mIframeInterval;
        final EGLContext mEglContext;

        public EncoderConfig(String savePath, int width, int height, int bitRate, int fps, int iframeInterval, EGLContext sharedEglContext) {
            this.savePath = savePath;
            this.mWidth = EncoderConfig.alignPixels(width);
            this.mHeight = EncoderConfig.alignPixels(height);
            this.mBitRate = bitRate;
            this.mFps = fps;
            this.mIframeInterval = iframeInterval;
            this.mEglContext = sharedEglContext;
        }

        public static synchronized int alignPixels(int px) {
            if (px % 2 != 0) {
                ++px;
            }
            return px;
        }

        public String toString() {
            return "EncoderConfig [mWidth=" + this.mWidth + ", mHeight=" + this.mHeight + ", mBitRate=" + this.mBitRate + ", mFps=" + this.mFps + ", mIframeInterval=" + this.mIframeInterval;
        }
    }
}

