/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.view.Surface;
import com.qihoo.livecloud.recorder.hc.AudioInputByMediaCodec;
import com.qihoo.livecloud.utils.PlayerLogger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@SuppressLint(value={"NewApi"})
public class HCVideoEncoderCore {
    private static final String TAG = "VideoEncoderCore";
    private static final String MIME_TYPE = "video/avc";
    private Surface mInputSurface;
    private MediaMuxer mMuxer;
    private MediaCodec mEncoder;
    private MediaCodec.BufferInfo mBufferInfo;
    private int mTrackIndex;
    private boolean mMuxerStarted;
    ExecutorService mThreadPool = Executors.newSingleThreadExecutor();
    AudioInputByMediaCodec mAudioInput;
    private String savePath;
    private long writeTimeStamp = 0L;
    byte[] sps_pps = null;

    public HCVideoEncoderCore(int width, int height, int bitRate, int fps, int iframeInterval, String savePath, AudioInputByMediaCodec mAudioInput) {
        try {
            this.mAudioInput = mAudioInput;
            this.mBufferInfo = new MediaCodec.BufferInfo();
            PlayerLogger.e(TAG, "VideoEncoderCore width : " + width + " --height : " + height + "---fps:" + fps + "---iframeInterval:" + iframeInterval + "----savePath:" + savePath + "----bitRate:" + bitRate);
            MediaFormat format = null;
            format = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)width, (int)height);
            format.setInteger("color-format", 2130708361);
            format.setInteger("frame-rate", fps);
            format.setInteger("i-frame-interval", iframeInterval);
            format.setInteger("bitrate", bitRate);
            PlayerLogger.i(TAG, "format: " + format);
            this.mEncoder = MediaCodec.createEncoderByType((String)MIME_TYPE);
            this.mEncoder.configure(format, null, null, 1);
            this.mInputSurface = this.mEncoder.createInputSurface();
            this.mEncoder.start();
        }
        catch (Throwable format) {
            // empty catch block
        }
        try {
            PlayerLogger.e("TAG", "----------path:" + savePath);
            this.mMuxer = new MediaMuxer(savePath, 0);
        }
        catch (IOException ioe) {
            throw new RuntimeException("MediaMuxer creation failed", ioe);
        }
        this.savePath = savePath;
        this.mTrackIndex = -1;
        this.mMuxerStarted = false;
    }

    public Surface getInputSurface() {
        return this.mInputSurface;
    }

    public void release() {
        new Thread(){

            @Override
            public void run() {
                if (HCVideoEncoderCore.this.mAudioInput != null) {
                    HCVideoEncoderCore.this.mAudioInput.stop();
                    HCVideoEncoderCore.this.mAudioInput.unInit();
                    HCVideoEncoderCore.this.mAudioInput = null;
                }
            }
        }.start();
        try {
            this.mThreadPool.shutdownNow();
            if (this.mEncoder != null) {
                this.mEncoder.stop();
                this.mEncoder.release();
                this.mEncoder = null;
            }
        }
        catch (Throwable e) {
            this.mEncoder = null;
            this.mThreadPool = null;
        }
        if (this.mMuxer != null) {
            try {
                this.mMuxer.stop();
                this.mMuxer.release();
                this.mMuxer = null;
            }
            catch (IllegalStateException e) {
                PlayerLogger.e(TAG, " mMuxer.stop()" + e.toString());
                this.checkFile();
            }
        }
    }

    public void checkFile() {
        File file = new File(this.savePath);
        PlayerLogger.e(TAG, " checkFile---");
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    public void drainEncoder(boolean endOfStream) {
        final boolean end_of_stream = endOfStream;
        this.mThreadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                int TIMEOUT_USEC = 10000;
                if (end_of_stream) {
                    HCVideoEncoderCore.this.mEncoder.signalEndOfInputStream();
                }
                ByteBuffer[] encoderOutputBuffers = null;
                try {
                    encoderOutputBuffers = HCVideoEncoderCore.this.mEncoder.getOutputBuffers();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                while (true) {
                    Object outData;
                    int encoderStatus = -1;
                    try {
                        encoderStatus = HCVideoEncoderCore.this.mEncoder.dequeueOutputBuffer(HCVideoEncoderCore.this.mBufferInfo, 10000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (encoderStatus == -1) {
                        if (!end_of_stream) {
                            return;
                        }
                        PlayerLogger.i(HCVideoEncoderCore.TAG, "no output available, spinning to await EOS");
                        continue;
                    }
                    if (encoderStatus == -3) {
                        try {
                            encoderOutputBuffers = HCVideoEncoderCore.this.mEncoder.getOutputBuffers();
                        }
                        catch (Throwable e) {
                            encoderOutputBuffers = null;
                        }
                        continue;
                    }
                    if (encoderStatus == -2) {
                        HCVideoEncoderCore.this.startRecordeAndMuxer();
                        continue;
                    }
                    if (encoderStatus < 0) continue;
                    if (encoderOutputBuffers == null) {
                        return;
                    }
                    ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
                    if (encodedData == null) {
                        return;
                    }
                    if ((((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.flags & 2) != 0) {
                        if (((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.size > 0) {
                            outData = new byte[((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.size];
                            encodedData.get((byte[])outData);
                            HCVideoEncoderCore.this.sps_pps = new byte[((byte[])outData).length];
                            System.arraycopy(outData, 0, HCVideoEncoderCore.this.sps_pps, 0, ((byte[])outData).length);
                        }
                        ((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.size = 0;
                    }
                    if (((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.size != 0) {
                        encodedData.position(((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.offset);
                        encodedData.limit(((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.offset + ((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.size);
                        if (HCVideoEncoderCore.this.mMuxerStarted && HCVideoEncoderCore.this.mAudioInput != null) {
                            if (!HCVideoEncoderCore.this.mAudioInput.isEncoding()) {
                                HCVideoEncoderCore.this.mAudioInput.start();
                            }
                            Object object = HCVideoEncoderCore.this.mAudioInput.saveAudioAndVideo_lock;
                            outData = object;
                            // MONITORENTER : object
                            if (((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.presentationTimeUs < HCVideoEncoderCore.this.writeTimeStamp) {
                                ((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.presentationTimeUs = HCVideoEncoderCore.this.writeTimeStamp + 1L;
                                PlayerLogger.e(HCVideoEncoderCore.TAG, "-----mBufferInfo.presentationTimeUs <writeTimeStamp");
                            }
                            HCVideoEncoderCore.this.mMuxer.writeSampleData(HCVideoEncoderCore.this.mTrackIndex, encodedData, HCVideoEncoderCore.this.mBufferInfo);
                            HCVideoEncoderCore.this.writeTimeStamp = ((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.presentationTimeUs;
                            PlayerLogger.e(HCVideoEncoderCore.TAG, "-----mMuxer.writeSampleData---video+mBufferInfo.size" + ((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.size + "-----mBufferInfo.presentationTimeUs:" + ((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.presentationTimeUs);
                            // MONITOREXIT : outData
                        }
                        outData = new byte[((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.size];
                        encodedData.get((byte[])outData);
                        if ((((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.flags & 1) != 0) {
                            byte[] sendData = new byte[HCVideoEncoderCore.this.sps_pps.length + ((byte[])outData).length];
                            System.arraycopy(HCVideoEncoderCore.this.sps_pps, 0, sendData, 0, HCVideoEncoderCore.this.sps_pps.length);
                            System.arraycopy(outData, 0, sendData, HCVideoEncoderCore.this.sps_pps.length, ((byte[])outData).length);
                        }
                        PlayerLogger.i(HCVideoEncoderCore.TAG, "sent " + ((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.size + " bytes to muxer, ts=" + ((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.presentationTimeUs);
                    }
                    try {
                        HCVideoEncoderCore.this.mEncoder.releaseOutputBuffer(encoderStatus, false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if ((((HCVideoEncoderCore)HCVideoEncoderCore.this).mBufferInfo.flags & 4) != 0) break;
                }
                if (!end_of_stream) {
                    PlayerLogger.d(HCVideoEncoderCore.TAG, "reached end of stream unexpectedly");
                    return;
                }
                PlayerLogger.d(HCVideoEncoderCore.TAG, "end of stream reached");
            }
        });
    }

    public void startRecordeAndMuxer() {
        MediaFormat newFormat = this.mEncoder.getOutputFormat();
        this.mTrackIndex = this.mMuxer.addTrack(newFormat);
        PlayerLogger.i(TAG, "-----addTrack------mTrackIndex:video" + this.mTrackIndex);
        this.mAudioInput.setMuxer(this.mMuxer);
        this.mMuxer.start();
        this.mMuxerStarted = true;
    }
}

