/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.os.Build;
import android.text.format.DateFormat;
import com.qihoo.livecloud.recorder.hc.LogUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.concurrent.ConcurrentLinkedQueue;

class LogToFile {
    private static final long MAX_IDLE_TIME = 60000L;
    static final String ACTION_LOG_D = "com.qihoo.videoplayer.log.d";
    private static final Object LOCKER_WRITE_THREAD = new Object();
    private static WriteThread sWriteThread = null;
    private static ConcurrentLinkedQueue<Object[]> sQueuePool = new ConcurrentLinkedQueue();
    static String sDirName = "undefined";
    private static long sCachedOsExpireTime = -1L;
    private static OutputStream sCachedOs = null;

    LogToFile() {
    }

    public static void log(String action, String tagName, String content) {
        LogToFile.log(action, tagName, content, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void log(String action, String tagName, String content, boolean forceFlush) {
        long curTime = System.currentTimeMillis();
        if ("crash_log".contains(tagName)) {
            LogToFile.handleLogD(curTime, tagName, content, forceFlush);
            return;
        }
        if (sWriteThread == null) {
            sWriteThread = new WriteThread();
            Thread t = new Thread(sWriteThread);
            t.setName("LogToFile.Thread");
            t.setDaemon(true);
            t.setPriority(1);
            t.start();
            String initContent = " ";
            sQueuePool.offer(new Object[]{action, curTime, tagName, initContent, forceFlush});
            sQueuePool.offer(new Object[]{action, curTime, tagName, initContent, forceFlush});
            initContent = "---- Phone=" + Build.BRAND + "/" + Build.MODEL + " ----";
            sQueuePool.offer(new Object[]{action, curTime, tagName, initContent, forceFlush});
        }
        sQueuePool.offer(new Object[]{action, System.currentTimeMillis(), tagName, content, forceFlush});
        Object object = LOCKER_WRITE_THREAD;
        synchronized (object) {
            LOCKER_WRITE_THREAD.notify();
        }
    }

    public static synchronized void stop() {
        if (sWriteThread != null) {
            sWriteThread.stopRun();
            sWriteThread = null;
        }
    }

    private static OutputStream getLogOutputStream() {
        Calendar c = Calendar.getInstance();
        if (sCachedOs != null) {
            if (c.getTimeInMillis() >= sCachedOsExpireTime) {
                try {
                    sCachedOs.flush();
                    sCachedOs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sCachedOs = null;
            } else {
                return sCachedOs;
            }
        }
        File fRoot = new File(LogUtil.getSDCardPath());
        FileOutputStream fos = null;
        if (fRoot == null) {
            return null;
        }
        if (!fRoot.exists() || !fRoot.isDirectory()) {
            return null;
        }
        if (!(fRoot = new File(fRoot, "360LiveCloud")).exists()) {
            fRoot.mkdir();
        }
        if (!(fRoot = new File(fRoot, sDirName)).exists()) {
            fRoot.mkdir();
        }
        String fileName = String.format("%s.bin", DateFormat.format((CharSequence)"yyyy-MM-dd", (Calendar)c));
        File f = new File(fRoot, fileName);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new FileOutputStream(f, true);
            sCachedOs = new BufferedOutputStream(fos, 1024);
            c.add(5, 1);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            sCachedOsExpireTime = c.getTimeInMillis();
            return sCachedOs;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleLogD(long time, String tagName, String content, Boolean forceFlush) {
        if (content == null) {
            return;
        }
        if ("crash_log".contains(tagName)) {
            OutputStream os = null;
            try {
                os = LogToFile.getLogOutputStream();
                try {
                    String prefix = String.format("%s D/%s:", DateFormat.format((CharSequence)"MM-dd kk:mm:ss", (long)time), tagName);
                    os.write(prefix.getBytes());
                }
                catch (Throwable prefix) {
                    // empty catch block
                }
                os.write(content.getBytes());
                os.flush();
            }
            catch (Throwable e) {
                LogToFile.close(sCachedOs);
                sCachedOs = null;
            }
            return;
        }
        String[] splitContent = content.split("\n");
        String[] txt = new String[splitContent.length];
        String prefix = String.format("%s D/%s:", DateFormat.format((CharSequence)"MM-dd kk:mm:ss", (long)time), tagName);
        for (int i = 0; i < txt.length; ++i) {
            txt[i] = i == 0 ? String.format("%s %s\n", prefix, splitContent[i]) : String.format("%s \t%s\n", prefix, splitContent[i]);
        }
        OutputStream os = LogToFile.getLogOutputStream();
        if (os != null) {
            try {
                for (int i = 0; i < txt.length; ++i) {
                    os.write(txt[i].getBytes());
                }
                if (forceFlush.booleanValue()) {
                    os.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogToFile.close(sCachedOs);
                sCachedOs = null;
            }
        }
    }

    public static void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class WriteThread
    implements Runnable {
        private volatile boolean mRunning = true;

        private WriteThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRun() {
            this.mRunning = false;
            Object object = LOCKER_WRITE_THREAD;
            synchronized (object) {
                LOCKER_WRITE_THREAD.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.mRunning) {
                try {
                    Object[] oneLog = (Object[])sQueuePool.poll();
                    if (oneLog == null) {
                        Object object = LOCKER_WRITE_THREAD;
                        synchronized (object) {
                            LOCKER_WRITE_THREAD.wait(60000L);
                        }
                        if (!sQueuePool.isEmpty() || sCachedOs == null) continue;
                        sCachedOs.flush();
                        continue;
                    }
                    if (!LogToFile.ACTION_LOG_D.equals(oneLog[0])) continue;
                    long time = (Long)oneLog[1];
                    String tagName = (String)oneLog[2];
                    String content = (String)oneLog[3];
                    Boolean forceFlush = (Boolean)oneLog[4];
                    LogToFile.handleLogD(time, tagName, content, forceFlush);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

