/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.format.DateFormat;
import com.qihoo.livecloud.recorder.hc.LogToFile;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Vector;

public final class LogUtil {
    private static boolean firstLog = true;
    private static boolean useFileLog = false;
    private static boolean useAndroidLog = true;
    static int maxKeepLogDateCount = -1;
    private static HandlerThread sOutOfDateHandlerThread = null;
    private static OutOfDateHandler sOutOfDateHandler = null;

    public static void setUseFileLog(boolean bUse) {
        useFileLog = bUse;
        if (!useFileLog) {
            LogToFile.stop();
        }
    }

    public static void setAndroidLog(boolean bUse) {
        useAndroidLog = bUse;
    }

    public static void setFileLogDirName(String dirName) {
        LogToFile.sDirName = dirName;
    }

    public static String getFileLogDirName() {
        return LogToFile.sDirName;
    }

    public static void log(String tag, String msg, Object ... params) {
        if (!useFileLog) {
            return;
        }
        if (params != null && params.length > 0) {
            msg = String.format(msg, params);
        }
        if (firstLog) {
            firstLog = false;
            String initContent = "---- Phone=" + Build.BRAND + "/" + Build.MODEL + " ----";
            if (useFileLog) {
                LogToFile.log("com.qihoo.videoplayer.log.d", tag, " ");
                LogToFile.log("com.qihoo.videoplayer.log.d", tag, initContent);
            }
        }
        LogToFile.log("com.qihoo.videoplayer.log.d", tag, msg);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static String translateDuration(long duration) {
        if (duration < 1000L) {
            return duration + " ms";
        }
        long seconds = duration / 1000L;
        if (seconds < 60L) {
            return String.format("%.1f sec", Float.valueOf((float)duration / 1000.0f));
        }
        long minutes = seconds / 60L;
        if (minutes < 60L) {
            return String.format("%.1f min", Float.valueOf((float)seconds / 60.0f));
        }
        return String.format("%.1f hour", Float.valueOf((float)minutes / 60.0f));
    }

    public static synchronized void setMaxKeepLogDateCount(int dateCount) {
        maxKeepLogDateCount = dateCount;
        if (sOutOfDateHandlerThread == null) {
            sOutOfDateHandlerThread = new HandlerThread("LogUtil.OutOfDate.HandlerThread");
            sOutOfDateHandlerThread.setPriority(1);
            sOutOfDateHandlerThread.start();
        }
        if (sOutOfDateHandler == null) {
            sOutOfDateHandler = new OutOfDateHandler(sOutOfDateHandlerThread.getLooper());
        }
        sOutOfDateHandler.sendEmptyMessageDelayed(0, 5000L);
    }

    public static String getSDCardPath() {
        File sdDir = null;
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExist) {
            sdDir = Environment.getExternalStorageDirectory();
        }
        return sdDir.toString();
    }

    private static class OutOfDateHandler
    extends Handler {
        public OutOfDateHandler(Looper lo) {
            super(lo);
        }

        public void handleMessage(Message msg) {
            try {
                this.removeOutOfDateLogFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void removeOutOfDateLogFile() {
            if (maxKeepLogDateCount == -1) {
                return;
            }
            Vector<String> allowDates = new Vector<String>();
            Calendar c = null;
            try {
                c = Calendar.getInstance();
            }
            catch (Throwable e) {
                return;
            }
            for (int i = 0; i < maxKeepLogDateCount; ++i) {
                if (i != 0) {
                    c.add(5, -1);
                }
                try {
                    allowDates.add(String.format("%s.bin", DateFormat.format((CharSequence)"yyyy-MM-dd", (Calendar)c)));
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            File fRoot = new File(LogUtil.getSDCardPath());
            if (fRoot == null || !fRoot.exists() || !fRoot.isDirectory()) {
                return;
            }
            if (!(fRoot = new File(fRoot, "360LiveCloud")).exists()) {
                return;
            }
            if (!(fRoot = new File(fRoot, LogToFile.sDirName)).exists()) {
                return;
            }
            for (File tmpFile : fRoot.listFiles()) {
                if (allowDates.contains(tmpFile.getName())) continue;
                tmpFile.delete();
            }
        }
    }
}

