/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.util.Log;
import com.qihoo.livecloud.recorder.hc.LogUtil;
import java.util.Locale;

public class Logger {
    public static final String TAG = "Logger";
    public static boolean LOG_ENABLE = true;
    public static final String CRASHTAG = "crash_log";
    static String className;
    static String methodName;
    static int lineNumber;

    public static void enable() {
        LOG_ENABLE = true;
    }

    public static void disable() {
        LOG_ENABLE = false;
    }

    private static String createLog(String log) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(methodName);
        buffer.append(":");
        buffer.append(lineNumber);
        buffer.append("] ");
        buffer.append(log);
        return buffer.toString();
    }

    private static void getMethodNames(StackTraceElement[] sElements) {
        className = sElements[1].getFileName();
        methodName = sElements[1].getMethodName();
        lineNumber = sElements[1].getLineNumber();
    }

    public static void e(String tag, String message) {
        Logger.getMethodNames(new Throwable().getStackTrace());
        Log.e((String)className, (String)Logger.createLog(message));
        LogUtil.log(tag, Logger.createLog(message), new Object[0]);
    }

    public static void longLengthE(String tag, String content) {
        int p = 2000;
        long length = content.length();
        if (length < (long)p || length == (long)p) {
            Log.e((String)tag, (String)content);
        } else {
            while (content.length() > p) {
                String logContent = content.substring(0, p);
                content = content.replace(logContent, "");
                Log.e((String)tag, (String)logContent);
            }
            Log.e((String)tag, (String)content);
        }
    }

    public static void efmt(String tag, String fmt, Object ... args) {
        Logger.getMethodNames(new Throwable().getStackTrace());
        String message = String.format(Locale.US, fmt, args);
        Log.e((String)className, (String)Logger.createLog(message));
        LogUtil.log(tag, Logger.createLog(message), new Object[0]);
    }

    public static void d(String tag, String message, Throwable tr) {
        Log.d((String)TAG, (String)("[ " + tag + " ] " + message), (Throwable)tr);
    }

    public static void d(String tag, String message) {
        Logger.getMethodNames(new Throwable().getStackTrace());
        Log.i((String)className, (String)Logger.createLog(message));
        LogUtil.log(tag, Logger.createLog(message), new Object[0]);
    }

    public static void d(Object tag, String message) {
        Logger.getMethodNames(new Throwable().getStackTrace());
        Log.i((String)className, (String)Logger.createLog(message));
        LogUtil.log(tag.getClass().getSimpleName(), Logger.createLog(message), new Object[0]);
    }

    public static void w(String tag, String message) {
        Logger.getMethodNames(new Throwable().getStackTrace());
        Log.w((String)className, (String)Logger.createLog(message));
        LogUtil.log(tag, Logger.createLog(message), new Object[0]);
    }

    public static void v(String tag, String message) {
        Logger.getMethodNames(new Throwable().getStackTrace());
        Log.v((String)className, (String)Logger.createLog(message));
        LogUtil.log(tag, Logger.createLog(message), new Object[0]);
    }

    public static void i(String tag, String message) {
        Logger.getMethodNames(new Throwable().getStackTrace());
        Log.i((String)className, (String)Logger.createLog(message));
        LogUtil.log(tag, Logger.createLog(message), new Object[0]);
    }
}

