/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.recorder.hc;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import com.qihoo.livecloud.recorder.hc.HCTextureMovieEncoder;
import com.qihoo.livecloud.utils.PlayerLogger;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class QHVCRecorderSDK {
    private static QHVCRecorderSDK mInstance = null;
    private static String TAG = "QHVCRecorderSDK";
    private HCTextureMovieEncoder mTextureMovieEncoder;
    private ScheduledExecutorService mExecutorService = null;
    private int fps;
    private ScheduledFuture mScheduledFuture;
    private SurfaceTextureListener mSurfaceTextureListener;
    private AtomicBoolean encodeReleaseSuccess = new AtomicBoolean(true);
    private Object surfaceTextureLock = new Object();
    EncoderReleaseFinishCallBack mEncoderReleaseFinishCallBack = new EncoderReleaseFinishCallBack(){

        @Override
        public void finishSuccess() {
            QHVCRecorderSDK.this.encodeReleaseSuccess.set(true);
            PlayerLogger.i(TAG, "LiveCloud-----QHVCRecorderSDK:mEncoderReleaseFinishCallBack----------encodeReleaseSuccess:" + QHVCRecorderSDK.this.encodeReleaseSuccess.get());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QHVCRecorderSDK getInstance() {
        if (mInstance != null) return mInstance;
        Class<QHVCRecorderSDK> clazz = QHVCRecorderSDK.class;
        synchronized (QHVCRecorderSDK.class) {
            if (mInstance != null) return mInstance;
            PlayerLogger.e(TAG, "LiveCloud-----QHVCRecorderSDK:getInstance()----------");
            mInstance = new QHVCRecorderSDK();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private QHVCRecorderSDK() {
    }

    public void setSurfaceTextureListener(SurfaceTextureListener listener) {
        this.mSurfaceTextureListener = listener;
    }

    @SuppressLint(value={"NewApi"})
    public void startRecord(Context context, String saveDirPath, String fileName, int width, int height, int bitRate, int fps, int iframeInterval) {
        PlayerLogger.e(TAG, "LiveCloud-----QHVCRecorderSDK:startRecord():encodeReleaseSuccess.get()----------" + this.encodeReleaseSuccess.get());
        if (!this.encodeReleaseSuccess.get()) {
            return;
        }
        this.createDir(saveDirPath);
        this.checkFileExist(saveDirPath + fileName);
        this.mTextureMovieEncoder = new HCTextureMovieEncoder();
        this.mTextureMovieEncoder.setreleaseSuccessListener(this.mEncoderReleaseFinishCallBack);
        this.mTextureMovieEncoder.setSurfaceTextureListener(this.mSurfaceTextureListener);
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newScheduledThreadPool(1);
        }
        if (!this.mTextureMovieEncoder.isRecording()) {
            PlayerLogger.e(TAG, "LiveCloud-----QHVCRecorderSDK:startRecord()----------saveDirPath:" + saveDirPath + "---fileName:" + fileName);
            this.fps = fps;
            this.mTextureMovieEncoder.start(context);
            this.mTextureMovieEncoder.startRecording(new HCTextureMovieEncoder.EncoderConfig(saveDirPath + fileName, width, height, bitRate, fps, iframeInterval, EGL14.eglGetCurrentContext()));
            this.handleFrameAvailable();
            this.encodeReleaseSuccess.set(false);
        }
    }

    private void checkFileExist(String s) {
        File file = new File(s);
        if (file.exists()) {
            file.delete();
        }
    }

    private void handleFrameAvailable() {
        this.mScheduledFuture = this.mExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                PlayerLogger.e(TAG, "LiveCloud-----QHVCRecorderSDK:handleFrameAvailable():ScheduledFuture.run()----------");
                QHVCRecorderSDK.this.frameAvailable();
            }
        }, 100L, 1000 / this.fps, TimeUnit.MILLISECONDS);
    }

    private void frameAvailable() {
        if (!this.isRecording()) {
            return;
        }
        PlayerLogger.e(TAG, "LiveCloud-----QHVCRecorderSDK:frameAvailable()----------");
        if (this.mTextureMovieEncoder != null) {
            this.mTextureMovieEncoder.frameAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording() {
        Object object = this.surfaceTextureLock;
        synchronized (object) {
            PlayerLogger.i(TAG, "LiveCloud-----QHVCRecorderSDK:stopRecording()----------");
            if (this.mScheduledFuture != null) {
                this.mScheduledFuture.cancel(true);
                this.mScheduledFuture = null;
            }
            if (this.mTextureMovieEncoder != null) {
                this.mTextureMovieEncoder.stopRecording();
            }
            PlayerLogger.i(TAG, "LiveCloud-----QHVCRecorderSDK:stopRecording----------encodeReleaseSuccess:-------");
            this.release();
        }
    }

    private void createDir(String dir) {
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public boolean isRecording() {
        if (this.mTextureMovieEncoder != null) {
            PlayerLogger.i(TAG, "LiveCloud-----QHVCRecorderSDK:isRecording()----------" + this.mTextureMovieEncoder.isRecording());
            PlayerLogger.i(TAG, "LiveCloud-----QHVCRecorderSDK:mEncoderReleaseFinishCallBack----------isRecording()");
            return this.mTextureMovieEncoder.isRecording();
        }
        return false;
    }

    public void writeAudioData(ByteBuffer encodedData, int size, long presentationTimeUs, int channelCount, int bitrate, int audioSampleRate) {
        if (this.mTextureMovieEncoder != null) {
            this.mTextureMovieEncoder.writeAudioData(encodedData, size, presentationTimeUs, channelCount, bitrate, audioSampleRate);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void release() {
        PlayerLogger.i(TAG, "LiveCloud-----QHVCRecorderSDK:release()----------");
        if (this.mExecutorService != null) {
            this.mExecutorService.shutdown();
            try {
                this.mExecutorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mExecutorService = null;
        }
        if (this.encodeReleaseSuccess != null) {
            this.encodeReleaseSuccess.set(true);
        }
    }

    public Object getSurfaceTextureLock() {
        return this.surfaceTextureLock;
    }

    public static interface EncoderReleaseFinishCallBack {
        public void finishSuccess();
    }

    public static interface SurfaceTextureListener {
        public void onSurfaceTextureCreated(SurfaceTexture var1);

        public void onSurfaceTextureDestroyed(SurfaceTexture var1);

        public void onFrameAvailable();
    }
}

