/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.resolution;

import android.content.Context;
import android.text.TextUtils;
import com.qihoo.livecloud.LiveCloudPlayer;
import com.qihoo.livecloud.config.PlayerSettings;
import com.qihoo.livecloud.play.PlayerControl;
import com.qihoo.livecloud.play.callback.PlayerCallback;
import com.qihoo.livecloud.tools.LiveCloudConfig;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.Stats;
import com.qihoo.livecloud.utils.PlayerLogger;
import java.util.HashMap;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ResolutionMgr {
    private static final String TAG = "LiveCloudPlayer-ResolutionMgr";
    public static final int HANCLE_SWITCH_DELAY = 5000;
    public static final int REAL_SWITCH_TIME_DIFF = 2000;
    private static final String[] STATUS_STR = new String[]{"switch-invalid", "switch-prepare", "switch-playerCreated", "switch-playerOpening", "switch-playerOpened", "switch-waitingSwitch", "switch-switching", "switch-switchSuccess", "switch-switchFailed", "switch-release"};
    private volatile int mStatus = 0;
    private Context mContext;
    private String mUrl;
    private int mSeekTo;
    private OnSwitchListener mListener;
    private int mSecondPausePosition;
    private PlayerControl mSecondPlayerCtrl;
    private LiveCloudConfig mSecondPlayerConfig;
    private int mSecondPlayerId;
    private volatile boolean mIsReceiveVideoIsReady = false;
    private int mSwitchCount = 0;
    private volatile int mPrepareStatus;
    private boolean mBufferingUpdate = false;
    private long mBufferingStartTick = 0L;
    private volatile boolean mIsResolutionAdapt = false;
    private boolean mIsForce = false;
    private PlayerCallback secondPlayerCallback = new PlayerCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlayerMsg(int handle, int command, long para1, long para2, int user) {
            PlayerLogger.v(ResolutionMgr.TAG, "[handle]: " + handle + " command=" + command + " para1=" + para1 + " para2=" + para2 + " user=" + user);
            switch (command) {
                case -1001: 
                case -1000: 
                case -989: 
                case -987: 
                case -975: 
                case -931: 
                case -930: 
                case -800: {
                    PlayerLogger.d(ResolutionMgr.TAG, "[handle]: " + handle + " command: " + command + " para1: " + para1 + " para2: " + para2 + " user: " + user);
                    if (ResolutionMgr.this.mListener != null) {
                        ResolutionMgr.this.mListener.onError(-2, "handle: " + handle + " command: " + command + " para1: " + para1 + " para2: " + para2 + " user: " + user);
                    }
                    ResolutionMgr.this.resetValueWithClosePlayer();
                    break;
                }
                case -999: {
                    PlayerLogger.v(ResolutionMgr.TAG, "[handle]: " + handle + " JPLAYER_MSG_VIDEO_IS_READY. para1: " + para1);
                    if (ResolutionMgr.this.mIsReceiveVideoIsReady) break;
                    ResolutionMgr.this.mIsReceiveVideoIsReady = true;
                    if (0 == ResolutionMgr.this.mRunFlag) {
                        ResolutionMgr.this.lock.lock();
                        try {
                            if (0 == ResolutionMgr.this.mRunFlag) {
                                ResolutionMgr.this.mRunFlag = 2;
                            }
                        }
                        finally {
                            ResolutionMgr.this.lock.unlock();
                        }
                    }
                    if (2 == ResolutionMgr.this.mRunFlag) {
                        ResolutionMgr.this.unInitTimer();
                        PlayerLogger.v(ResolutionMgr.TAG, "JPLAYER_MSG_VIDEO_IS_READY run");
                        ResolutionMgr.this.mSecondPausePosition = (int)para1;
                        ResolutionMgr.this.mSecondPlayerCtrl.setMute(true);
                        ResolutionMgr.this.mSecondPlayerCtrl.pause(-1);
                        ResolutionMgr.this.updateStatus(4);
                        if (ResolutionMgr.this.mListener == null) break;
                        ResolutionMgr.this.mPrepareStatus = 2;
                        PlayerLogger.e(ResolutionMgr.TAG, "second player opened. playerId: " + ResolutionMgr.this.mSecondPlayerId + " prepare status: " + ResolutionMgr.this.mPrepareStatus + " url: " + ResolutionMgr.this.mUrl);
                        ResolutionMgr.this.mListener.onPlayerOpened(ResolutionMgr.this.mSecondPlayerId, ResolutionMgr.this.mSecondPlayerCtrl, ResolutionMgr.this.mSecondPlayerConfig, ResolutionMgr.this.mSecondPausePosition, ResolutionMgr.this.mUrl);
                        break;
                    }
                    PlayerLogger.v(ResolutionMgr.TAG, "JPLAYER_MSG_VIDEO_IS_READY not run");
                    break;
                }
                case -992: {
                    PlayerLogger.v(ResolutionMgr.TAG, "[handle]: " + handle + " JPLAYER_MSG_AUDIO_IS_READY.");
                    if (ResolutionMgr.this.mSecondPlayerCtrl == null) break;
                    ResolutionMgr.this.mSecondPlayerCtrl.setMute(true);
                    break;
                }
                case -996: {
                    this.replayStatusUpdate(handle, command, para1, para2, user);
                    break;
                }
                case -998: 
                case -997: 
                case -994: 
                case -988: 
                case -979: 
                case -978: 
                case -977: 
                case -974: 
                case -973: 
                case -950: 
                case -949: 
                case -929: 
                case -920: 
                case -899: 
                case -700: 
                case 10: {
                    break;
                }
            }
        }

        @Override
        public void onUpdateStatus(int handle, int vbps, int abps, int vfps, int afps, int sdvbps, int sdabps, int sdvfps, int sdafps, int user) {
        }

        @Override
        public void onUpdateGPPlayState(int handle, long nowTime, long videoBufferTime, long audioBufferTime) {
        }

        @Override
        public void onMessage(int handle, int id, int type, int flags, int size, long data, long time) {
        }

        @Override
        public void onUserDefineData(int handle, byte[] data, int length) {
        }

        private void replayStatusUpdate(int handle, int command, long para1, long para2, int user) {
            if (user == 1 && ResolutionMgr.this.mBufferingUpdate) {
                int progress = 0;
                if (para2 > 0L && para1 > 0L) {
                    progress = (int)(para1 * 100L / para2);
                }
                if (progress > 100) {
                    progress = 100;
                }
                PlayerLogger.d(ResolutionMgr.TAG, "[second player] buffering progress: " + progress);
                return;
            }
            if (user == 1) {
                ResolutionMgr.this.mBufferingUpdate = true;
                PlayerLogger.d(ResolutionMgr.TAG, "[handle]: " + handle + " onBufferingUpdate Buffer.START");
                ResolutionMgr.this.mBufferingStartTick = System.currentTimeMillis();
            }
            if (user == 0 && ResolutionMgr.this.mBufferingUpdate) {
                ResolutionMgr.this.mBufferingUpdate = false;
                long useTick = System.currentTimeMillis() - ResolutionMgr.this.mBufferingStartTick;
                PlayerLogger.d(ResolutionMgr.TAG, "[handle]: " + handle + " onBufferingUpdate Buffer.STOP use tick: " + useTick);
            }
        }
    };
    private Timer mTimer = null;
    private TimerTask mTimerTask = null;
    private Lock lock = new ReentrantLock();
    private static final int RUN_FLAG_INVALID = 0;
    private static final int RUN_FLAG_TIMER_RUN = 1;
    private static final int RUN_FLAG_OTHER = 2;
    private volatile int mRunFlag = 0;

    public synchronized void setForceSwitch(boolean force) {
        this.mIsForce = force;
        PlayerLogger.d(TAG, "set switch force: " + force);
    }

    public synchronized boolean isForceSwitch() {
        PlayerLogger.d(TAG, "get switch force: " + this.mIsForce);
        return this.mIsForce;
    }

    public void switchResolution(Context context, LiveCloudPlayer player, LiveCloudConfig config, String sessionIdFromUser, PlayerSettings playerSettings, int urlIndex, String url, int seekTo, OnSwitchListener listener, boolean isAdapt, long switchDelay) {
        if (Logger.LOG_ENABLE) {
            Logger.i((String)TAG, (String)("switch resolution. switch position: " + seekTo + " newUrl: " + url + " " + Thread.currentThread().getName()));
        }
        this.updateStatus(1);
        if (context == null || config == null || TextUtils.isEmpty((CharSequence)url)) {
            PlayerLogger.e(TAG, "switch resolution input param invalid!");
            this.resetValueWithClosePlayer();
            if (listener != null) {
                listener.onError(-2, "input param invalid");
            }
            return;
        }
        this.mContext = context;
        this.mUrl = url;
        this.mSeekTo = seekTo;
        this.mListener = listener;
        this.mIsResolutionAdapt = isAdapt;
        this.mSecondPlayerCtrl = new PlayerControl();
        PlayerLogger.d(TAG, "switch resolution. create player: " + this.mSecondPlayerCtrl);
        this.mSecondPlayerConfig = this.getConfig(config, sessionIdFromUser, urlIndex, url);
        this.mSecondPlayerCtrl.setUid(this.mSecondPlayerConfig.getUid());
        this.mSecondPlayerCtrl.setCid(this.mSecondPlayerConfig.getCid());
        this.mSecondPlayerCtrl.setSN(this.mSecondPlayerConfig.getSn());
        this.mSecondPlayerCtrl.setSid(this.mSecondPlayerConfig.getSid());
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("module", "player");
            params.put("sdk_ver", LiveCloudPlayer.getVersion());
            params.put("so_ver", LiveCloudPlayer.getNativeVersion());
            Stats.sessionStart((String)this.mSecondPlayerConfig.getSid(), (String)this.mSecondPlayerConfig.getUid(), (String)this.mSecondPlayerConfig.getCid(), (String)this.mSecondPlayerConfig.getNet(), (String)this.mSecondPlayerConfig.getSn(), params);
            int playerId = this.mSecondPlayerCtrl.openHls(url, 1, this.mSeekTo, true, 0);
            if (playerId != 0) {
                PlayerLogger.d(TAG, "open hls handle=" + playerId + " seekto=" + this.mSeekTo);
                this.updateStatus(2);
                player.setPlayerControlConfig(this.mSecondPlayerCtrl, this.mSecondPlayerConfig, playerId);
                this.mSecondPlayerId = playerId;
                this.mSecondPlayerCtrl.playerSetting(playerSettings);
                this.mSecondPlayerCtrl.setCallback(this.secondPlayerCallback);
                PlayerLogger.d(TAG, "second player startLive.");
                if (this.mIsForce) {
                    this.mRunFlag = 1;
                    this.updateStatus(3);
                    if (this.mListener != null) {
                        this.mPrepareStatus = 0;
                        PlayerLogger.e(TAG, "force switch. playerId: " + playerId + " prepare status: " + this.mPrepareStatus + " url: " + url);
                        this.mListener.openLiveTimeout(this.mSecondPlayerId, this.mSecondPlayerCtrl, this.mSecondPlayerConfig, this.mUrl);
                    }
                } else {
                    this.mSecondPlayerCtrl.startLive();
                    this.updateStatus(3);
                    this.initTimer(switchDelay);
                }
            } else {
                PlayerLogger.e(TAG, "openHls failed.");
                if (listener != null) {
                    listener.onError(-2, "openHls failed.");
                }
                this.resetValueWithClosePlayer();
            }
        }
        catch (Exception e) {
            PlayerLogger.e(TAG, "exception: " + e.getMessage());
            if (listener != null) {
                listener.onError(-2, e == null ? "" : e.getMessage());
            }
            this.resetValueWithClosePlayer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetValueWithClosePlayer() {
        if (this.mStatus == 0 || this.mStatus == 9) {
            return;
        }
        PlayerLogger.d(TAG, "reset value with close player.");
        this.updateStatus(9);
        if (this.mSecondPlayerCtrl != null) {
            PlayerControl playerControl = this.mSecondPlayerCtrl;
            synchronized (playerControl) {
                if (this.mSecondPlayerCtrl != null) {
                    PlayerLogger.d(TAG, "release resource. player close: " + this.mSecondPlayerCtrl);
                    this.mSecondPlayerCtrl.close(0);
                    this.mSecondPlayerCtrl = null;
                }
            }
        }
        this.resetValue();
    }

    public void resetValue() {
        PlayerLogger.d(TAG, "reset flag.");
        this.unInitTimer();
        this.mListener = null;
        this.mSecondPlayerCtrl = null;
        this.mSecondPlayerConfig = null;
        this.mSecondPlayerId = 0;
        this.mIsReceiveVideoIsReady = false;
        this.mContext = null;
        this.mSecondPausePosition = 0;
        this.updateStatus(0);
        this.mRunFlag = 0;
        this.mIsForce = false;
    }

    public synchronized void updateStatus(int status) {
        this.mStatus = status;
        PlayerLogger.d(TAG, this.mStatus >= 0 && this.mStatus < STATUS_STR.length ? STATUS_STR[status] : status + "");
    }

    public synchronized int getSwitchStatus() {
        return this.mStatus;
    }

    public synchronized boolean isUnStart() {
        return this.mStatus == 0;
    }

    public SecondPlayerInfo getSecondPlayer() {
        return new SecondPlayerInfo(this.mSecondPlayerId, this.mSecondPlayerCtrl, this.mSecondPlayerConfig, this.mSecondPausePosition, this.mUrl, this.mPrepareStatus);
    }

    private LiveCloudConfig getConfig(LiveCloudConfig o, String sessionIdFromUser, int urlIndex, String url) {
        PlayerLogger.d(TAG, "getSecondPlayerConfig");
        LiveCloudConfig config = new LiveCloudConfig();
        config.setCid(o.getCid());
        config.setUid(o.getUid());
        config.setVer(o.getVer());
        config.setBid(o.getBid());
        String sid = "";
        String curSid = o.getSid();
        if (curSid != null) {
            ++this.mSwitchCount;
            sid = sessionIdFromUser + "__switch" + "_" + this.mSwitchCount;
        } else {
            sid = MD5.encryptMD5((String)(String.valueOf(System.currentTimeMillis()) + String.valueOf(new Random().nextInt())));
        }
        config.setSid(sid);
        config.setMid(o.getMid());
        config.setNet(o.getNet());
        config.setSn(url);
        String cid = o.getCid();
        String ts = String.valueOf(System.currentTimeMillis() / 1000L);
        String token = null;
        token = cid != null && cid.equals("live_yingshi") ? "channel__" + config.getCid() + "sn__" + config.getSn() + "key_" + "0Zjurl^y5t{6O;<6L" : "channel__" + config.getCid() + "sn__" + config.getSn() + "key_" + "2Zjurl^y5t{6O;<6L";
        String utoken = MD5.encryptMD5((String)token);
        config.setSign(utoken);
        config.setTs(ts);
        return config;
    }

    private void initTimer(long delay) {
        this.mRunFlag = 0;
        if (this.mTimer == null) {
            PlayerLogger.d(TAG, "initTimer. for open player");
            this.mTimer = new Timer();
        }
        if (this.mTimerTask == null) {
            this.mTimerTask = new TimerTask(){

                @Override
                public void run() {
                    ResolutionMgr.this.openPlayerTimeout();
                }
            };
            long defaultDelay = 6000L;
            long switchDelay = 6000L;
            if (delay > 0L && delay - 6000L < 1000L && (switchDelay = delay - 1000L) < 0L) {
                switchDelay = 0L;
            }
            Logger.i((String)TAG, (String)("switch param delay: " + delay + " real delay: " + switchDelay));
            this.mTimer.schedule(this.mTimerTask, switchDelay);
        }
    }

    private void unInitTimer() {
        try {
            if (this.mTimerTask != null) {
                this.mTimerTask.cancel();
                this.mTimerTask = null;
            }
            if (this.mTimer != null) {
                PlayerLogger.d(TAG, "unInitTimer. for open player");
                this.mTimer.cancel();
                this.mTimer = null;
            }
        }
        catch (Exception e) {
            PlayerLogger.e(TAG, e.getMessage());
        }
    }

    private void openPlayerTimeout() {
        PlayerLogger.d(TAG, "timer run. open player timeout! ");
        if (0 == this.mRunFlag) {
            this.lock.lock();
            try {
                if (0 == this.mRunFlag) {
                    this.mRunFlag = 1;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (1 == this.mRunFlag) {
            PlayerLogger.d(TAG, "run");
            if (this.mIsResolutionAdapt) {
                if (this.mListener != null) {
                    this.mListener.onError(-2, "playerId: " + this.mSecondPlayerId + " open timeout!");
                }
                this.resetValueWithClosePlayer();
            } else if (this.mListener != null) {
                this.mPrepareStatus = 1;
                PlayerLogger.e(TAG, "open live timeout. playerId: " + this.mSecondPlayerId + " prepare status: " + this.mPrepareStatus + " url: " + this.mUrl);
                this.mListener.openLiveTimeout(this.mSecondPlayerId, this.mSecondPlayerCtrl, this.mSecondPlayerConfig, this.mUrl);
            }
        } else {
            PlayerLogger.d(TAG, "not run");
        }
    }

    public static class SecondPlayerInfo {
        public int playerId;
        public PlayerControl control;
        public LiveCloudConfig config;
        public int position;
        public String url;
        public int prepareStatus;

        public SecondPlayerInfo(int playerId, PlayerControl control, LiveCloudConfig config, int position, String url, int prepareStatus) {
            this.playerId = playerId;
            this.control = control;
            this.config = config;
            this.position = position;
            this.url = url;
            this.prepareStatus = prepareStatus;
        }
    }

    public static interface OnSwitchListener {
        public void openLiveTimeout(int var1, PlayerControl var2, LiveCloudConfig var3, String var4);

        public void onPlayerOpened(int var1, PlayerControl var2, LiveCloudConfig var3, int var4, String var5);

        public void onError(int var1, String var2);
    }

    public static interface SwitchStatus {
        public static final int INVALID = 0;
        public static final int PREPARE = 1;
        public static final int PLAYER_CREATED = 2;
        public static final int PLAYER_OPENING = 3;
        public static final int PLAYER_OPENED = 4;
        public static final int WAITING_SWITCH = 5;
        public static final int SWITCHING = 6;
        public static final int SWITCH_SUCCESS = 7;
        public static final int SWITCH_FAILED = 8;
        public static final int RELEASE = 9;
    }

    public static interface PrepareStatus {
        public static final int NOT_OPEN = 0;
        public static final int OPEN_LIVE_TIMEOUT = 1;
        public static final int VIDEO_IS_READY = 2;
    }
}

