/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.utils;

import android.content.Context;
import android.os.Environment;
import com.qihoo.livecloud.utils.FileUtils;
import com.qihoo.livecloud.utils.PlayerLogger;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public class P2PServerHelper {
    private static final String TAG = "P2PServerHelper";
    private Method mInitialize;
    private Method mDestroy;
    private Method mCreateTask;
    private Method mCancelTask;
    private Method mSetVideoDuration;
    private Method mGetTaskInfo;
    private Method mSetLogLevel;
    private Method mGetContinuousCacheSizeFromPos;
    public static int ERROR_OK = 0;
    public static int ERROR_UNKNOW = -1;
    public static int ERROR_EXCEPTION = 0;
    public static int ERROR_COMMON_INVLID_PARAM = 0;
    public static int ERROR_COMMON_NO_URL_FIND = 0;
    public static int ERROR_COMMON_NO_INIT = 0;
    public static int ERROR_COMMON_ACCESS_DENIED = 0;
    public static int ERROR_INVLID_PARAM = 0;
    public static int ERROR_DISK_NOT_ENOUGH = 0;
    public static int ERROR_FILE_IO_FAILED = 0;
    public static int ERROR_CREATE_TASK_FAILED = 0;
    public static int ERROR_NO_TASK_BY_HASH = 0;
    public static int ERROR_ACCESS_DENIED = 0;
    public static int ERROR_NO_INIT = 0;
    static int ERROR_BIND_LOCAL_HTTP_PORT_FAIL = 0;
    static int ERROR_AUTH_DOING = 0;
    static int ERROR_AUTH_FAIL = 0;
    public static int LOG_LEVEL_TRACE = -1;
    public static int LOG_LEVEL_DEBUG = -1;
    public static int LOG_LEVEL_INFO = -1;
    public static int LOG_LEVEL_WARN = -1;
    public static int LOG_LEVEL_ERROR = -1;
    public static int LOG_LEVEL_NONE = -1;
    private int mVideoDuration = 0;
    private long mVideoFileSize = 0L;

    public P2PServerHelper() {
        this.initMethod();
    }

    public int initialize(Context context, String cacheDir, String cid, String uid, Map<String, Object> params) {
        int ret = -1;
        if (this.mInitialize != null) {
            try {
                ret = (Integer)this.mInitialize.invoke(null, context, cacheDir, cid, uid, params);
            }
            catch (Exception e) {
                e.printStackTrace();
                PlayerLogger.i(TAG, "initialize error " + e.getMessage());
            }
        }
        return ret;
    }

    public boolean isValid() {
        return this.mInitialize != null && this.mDestroy != null && this.mCreateTask != null && this.mCancelTask != null && this.mGetTaskInfo != null && this.mSetVideoDuration != null;
    }

    public void destroy() {
        if (this.mDestroy != null) {
            try {
                this.mDestroy.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                PlayerLogger.i(TAG, "destroy error " + e.getMessage());
            }
        }
    }

    public void createTask(String url, boolean forceP2P, final CreateTaskCallback callback) {
        if (this.mCreateTask != null) {
            try {
                ClassLoader loader = P2PServerHelper.class.getClassLoader();
                Class<?> interfazz = loader.loadClass("com.qihoo.videocloud.p2p.CreateTaskCallback");
                Object clazzInstance = Proxy.newProxyInstance(loader, new Class[]{interfazz}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("onCallback") && callback != null) {
                            callback.onCallback((Integer)args[0], (String)args[1]);
                        }
                        return null;
                    }
                });
                this.mCreateTask.invoke(null, url, forceP2P, clazzInstance);
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (callback != null) {
                    callback.onCallback(-1, url);
                }
                PlayerLogger.i(TAG, "createTask error " + e.getMessage());
            }
        }
    }

    public void cancelTask(String url, final CancelTaskCallback callback) {
        if (this.mCancelTask != null) {
            try {
                ClassLoader loader = P2PServerHelper.class.getClassLoader();
                Class<?> interfazz = loader.loadClass("com.qihoo.videocloud.p2p.CancelTaskCallback");
                Object clazzInstance = Proxy.newProxyInstance(loader, new Class[]{interfazz}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("onCallback") && callback != null) {
                            callback.onCallback((Integer)args[0]);
                        }
                        return null;
                    }
                });
                this.mCancelTask.invoke(null, url, clazzInstance);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callback != null) {
                    callback.onCallback(-1);
                }
                PlayerLogger.i(TAG, "cancelTask error " + e.getMessage());
            }
        }
    }

    public int setVideoDuration(String url, int duration) {
        this.mVideoDuration = duration;
        int ret = -1;
        if (this.mSetVideoDuration != null) {
            try {
                ret = (Integer)this.mSetVideoDuration.invoke(null, url, duration / 1000);
            }
            catch (Exception e) {
                e.printStackTrace();
                PlayerLogger.i(TAG, "setVideoDuration error " + e.getMessage());
            }
        }
        return ret;
    }

    public int getTaskInfo(String url, TaskInfo taskInfo) {
        int ret = -1;
        if (this.mGetTaskInfo != null) {
            try {
                ClassLoader loader = P2PServerHelper.class.getClassLoader();
                Class<?> interfazz = loader.loadClass("com.qihoo.videocloud.p2p.TaskInfo");
                Object clazzInstance = interfazz.newInstance();
                ret = (Integer)this.mGetTaskInfo.invoke(null, url, clazzInstance);
                if (ret == ERROR_OK) {
                    Field[] fields;
                    for (Field field : fields = interfazz.getFields()) {
                        if (field.getName() == "downSpeed") {
                            taskInfo.downSpeed = field.getLong(clazzInstance);
                            continue;
                        }
                        if (field.getName() == "p2pDownSpeed") {
                            taskInfo.p2pDownSpeed = field.getLong(clazzInstance);
                            continue;
                        }
                        if (field.getName() == "cdnDownSpeed") {
                            taskInfo.cdnDownSpeed = field.getLong(clazzInstance);
                            continue;
                        }
                        if (field.getName() == "p2pDownSize") {
                            taskInfo.p2pDownSize = field.getLong(clazzInstance);
                            continue;
                        }
                        if (field.getName() == "cdnDownSize") {
                            taskInfo.cdnDownSize = field.getLong(clazzInstance);
                            continue;
                        }
                        if (field.getName() == "cachedSize") {
                            taskInfo.cachedSize = field.getLong(clazzInstance);
                            continue;
                        }
                        if (field.getName() == "totalSize") {
                            taskInfo.totalSize = field.getLong(clazzInstance);
                            continue;
                        }
                        if (field.getName() != "cacheFinish") continue;
                        taskInfo.cacheFinish = field.getBoolean(clazzInstance);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                PlayerLogger.i(TAG, "getTaskInfo error " + e.getMessage());
            }
        }
        return ret;
    }

    public static int enableUpload(boolean enablUpload) {
        int ret = -1;
        try {
            Class<?> p2pServerClazz = Class.forName("com.qihoo.videocloud.p2p.P2PServer");
            Method enableUpload = p2pServerClazz.getMethod("enableUpload", Boolean.TYPE);
            if (enableUpload != null) {
                ret = (Integer)enableUpload.invoke(null, enablUpload);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PlayerLogger.i(TAG, "setCacheSize error " + e.getMessage());
        }
        return ret;
    }

    public void setLogLevel(int logLevel) {
        int ret = -1;
        if (this.mSetLogLevel != null) {
            try {
                this.mSetLogLevel.invoke(null, logLevel);
            }
            catch (Exception e) {
                e.printStackTrace();
                PlayerLogger.i(TAG, "setLogLevel error " + e.getMessage());
            }
        }
    }

    public int getCacheDuration(String url, int playPos) {
        TaskInfo taskInfo;
        int ret;
        int percent_cache = 0;
        if (this.mVideoFileSize == 0L && (ret = this.getTaskInfo(url, taskInfo = new TaskInfo())) == ERROR_OK && taskInfo.totalSize > 0L) {
            this.mVideoFileSize = taskInfo.totalSize;
        }
        if (this.mVideoFileSize > 0L && this.mVideoDuration > 0) {
            long pos = (long)((double)playPos / (double)this.mVideoDuration * (double)this.mVideoFileSize);
            long cachedSize = 0L;
            if (this.mGetContinuousCacheSizeFromPos != null) {
                try {
                    cachedSize = (Long)this.mGetContinuousCacheSizeFromPos.invoke(null, url, pos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PlayerLogger.i(TAG, "mGetContinuousCacheSizeFromPos error" + e.getMessage());
                }
            }
            if (cachedSize > 0L) {
                percent_cache = (int)((double)cachedSize * (double)this.mVideoDuration / (double)this.mVideoFileSize);
            }
        }
        return percent_cache;
    }

    public static String getP2PCacheDir() {
        String dir = Environment.getExternalStorageDirectory().getAbsolutePath();
        dir = dir + File.separator + "LiveCloud" + File.separator + "P2PCache" + File.separator;
        FileUtils.createDir((String)dir);
        return dir;
    }

    public static int clearCache() {
        int ret = -1;
        try {
            Class<?> p2pServerClazz = Class.forName("com.qihoo.videocloud.p2p.P2PServer");
            Method clearCache = p2pServerClazz.getMethod("clearCache", new Class[0]);
            if (clearCache != null) {
                ret = (Integer)clearCache.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PlayerLogger.i(TAG, "clearCache error " + e.getMessage());
        }
        return ret;
    }

    public static void setCacheSize(int cacheSize) {
        try {
            Class<?> p2pServerClazz = Class.forName("com.qihoo.videocloud.p2p.P2PServer");
            Method setCacheSize = p2pServerClazz.getMethod("setCacheSize", Integer.TYPE);
            if (setCacheSize != null) {
                setCacheSize.invoke(null, cacheSize);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PlayerLogger.i(TAG, "setCacheSize error " + e.getMessage());
        }
    }

    private void initMethod() {
        try {
            Field[] fields;
            Class<?> p2pServerClazz = Class.forName("com.qihoo.videocloud.p2p.P2PServer");
            this.mInitialize = p2pServerClazz.getMethod("initialize", Context.class, String.class, String.class, String.class, Map.class);
            this.mDestroy = p2pServerClazz.getMethod("destroy", new Class[0]);
            Class<?> CreateTaskCallbackClazz = Class.forName("com.qihoo.videocloud.p2p.CreateTaskCallback");
            this.mCreateTask = p2pServerClazz.getMethod("createTask", String.class, Boolean.TYPE, CreateTaskCallbackClazz);
            Class<?> CancelaskCallbackClazz = Class.forName("com.qihoo.videocloud.p2p.CancelTaskCallback");
            this.mCancelTask = p2pServerClazz.getMethod("cancelTask", String.class, CancelaskCallbackClazz);
            this.mSetVideoDuration = p2pServerClazz.getMethod("setVideoDuration", String.class, Integer.TYPE);
            Class<?> TaskInfolazz = Class.forName("com.qihoo.videocloud.p2p.TaskInfo");
            this.mGetTaskInfo = p2pServerClazz.getMethod("getTaskInfo", String.class, TaskInfolazz);
            this.mSetVideoDuration = p2pServerClazz.getMethod("setVideoDuration", String.class, Integer.TYPE);
            this.mSetLogLevel = p2pServerClazz.getMethod("setLogLevel", Integer.TYPE);
            this.mGetContinuousCacheSizeFromPos = p2pServerClazz.getMethod("getContinuousCacheSizeFromPos", String.class, Long.TYPE);
            for (Field field : fields = p2pServerClazz.getFields()) {
                if (field.getName() == "ERROR_OK") {
                    ERROR_OK = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_UNKNOW") {
                    ERROR_UNKNOW = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_EXCEPTION") {
                    ERROR_EXCEPTION = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_COMMON_INVLID_PARAM") {
                    ERROR_COMMON_INVLID_PARAM = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_COMMON_NO_URL_FIND") {
                    ERROR_COMMON_NO_URL_FIND = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_COMMON_NO_INIT") {
                    ERROR_COMMON_NO_INIT = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_COMMON_ACCESS_DENIED") {
                    ERROR_COMMON_ACCESS_DENIED = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_INVLID_PARAM") {
                    ERROR_INVLID_PARAM = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_DISK_NOT_ENOUGH") {
                    ERROR_DISK_NOT_ENOUGH = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_FILE_IO_FAILED") {
                    ERROR_FILE_IO_FAILED = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_CREATE_TASK_FAILED") {
                    ERROR_CREATE_TASK_FAILED = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_NO_TASK_BY_HASH") {
                    ERROR_NO_TASK_BY_HASH = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_ACCESS_DENIED") {
                    ERROR_ACCESS_DENIED = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_NO_INIT") {
                    ERROR_NO_INIT = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_BIND_LOCAL_HTTP_PORT_FAIL") {
                    ERROR_BIND_LOCAL_HTTP_PORT_FAIL = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_AUTH_DOING") {
                    ERROR_AUTH_DOING = field.getInt(null);
                    continue;
                }
                if (field.getName() == "ERROR_AUTH_FAIL") {
                    ERROR_AUTH_FAIL = field.getInt(null);
                    continue;
                }
                if (field.getName() == "LOG_LEVEL_TRACE") {
                    LOG_LEVEL_TRACE = field.getInt(null);
                    continue;
                }
                if (field.getName() == "LOG_LEVEL_DEBUG") {
                    LOG_LEVEL_DEBUG = field.getInt(null);
                    continue;
                }
                if (field.getName() == "LOG_LEVEL_INFO") {
                    LOG_LEVEL_INFO = field.getInt(null);
                    continue;
                }
                if (field.getName() == "LOG_LEVEL_WARN") {
                    LOG_LEVEL_WARN = field.getInt(null);
                    continue;
                }
                if (field.getName() == "LOG_LEVEL_ERROR") {
                    LOG_LEVEL_ERROR = field.getInt(null);
                    continue;
                }
                if (field.getName() != "LOG_LEVEL_NONE") continue;
                LOG_LEVEL_NONE = field.getInt(null);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            PlayerLogger.i(TAG, "initMethod error " + e.getMessage());
        }
    }

    public static class TaskInfo {
        public long downSpeed;
        public long p2pDownSpeed;
        public long cdnDownSpeed;
        public long p2pDownSize;
        public long cdnDownSize;
        public long cachedSize;
        public long totalSize;
        public boolean cacheFinish;

        public String toString() {
            return "TaskInfo{downSpeed=" + this.downSpeed + ", p2pDownSpeed=" + this.p2pDownSpeed + ", cdnDownSpeed=" + this.cdnDownSpeed + ", p2pDownSize=" + this.p2pDownSize + ", cdnDownSize=" + this.cdnDownSize + ", cachedSize=" + this.cachedSize + ", totalSize=" + this.totalSize + ", cacheFinish=" + this.cacheFinish + '}';
        }
    }

    public static interface CancelTaskCallback {
        public void onCallback(int var1);
    }

    public static interface CreateTaskCallback {
        public void onCallback(int var1, String var2);
    }
}

