/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.view;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import com.qihoo.livecloud.play.callback.ILiveCloudDisplay;
import com.qihoo.livecloud.play.jni.JPlayer;
import com.qihoo.livecloud.utils.PlayerLogger;
import com.qihoo.livecloud.view.GL2BaseView;
import java.util.LinkedList;
import java.util.Queue;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class GL2VideoView
extends GL2BaseView
implements ILiveCloudDisplay {
    private static final String TAG = "GL2VideoView";
    private int mSurfaceWidth = 0;
    private int mSurfaceHeight = 0;
    private int handle = 0;
    private float rotateX = 0.0f;
    private float rotateY = 0.0f;
    private float rotateZ = 0.0f;
    private boolean needInitRotate = false;
    private float translateX = 0.0f;
    private float translateY = 0.0f;
    private boolean needTranlate = false;
    private boolean needDisplayMode = false;
    private int mDisplayMode = 0;
    private Queue<Runnable> mRunOnDraw;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAll() {
        if (this.mRunOnDraw != null) {
            Queue<Runnable> queue = this.mRunOnDraw;
            synchronized (queue) {
                while (!this.mRunOnDraw.isEmpty()) {
                    this.mRunOnDraw.poll().run();
                }
            }
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        super.surfaceChanged(holder, format, w, h);
        PlayerLogger.d(TAG, "surfaceChanged");
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        super.surfaceDestroyed(holder);
        PlayerLogger.d(TAG, "surfaceDestroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnDraw(Runnable runnable) {
        Queue<Runnable> queue = this.mRunOnDraw;
        synchronized (queue) {
            this.mRunOnDraw.add(runnable);
        }
    }

    public GL2VideoView(Context context) {
        super(context);
        this.init(true, 0, 0);
    }

    public GL2VideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(true, 0, 0);
    }

    private void init(boolean translucent, int depth, int stencil) {
        PlayerLogger.d(TAG, "init translucent : " + translucent);
        this.mRunOnDraw = new LinkedList<Runnable>();
        if (translucent) {
            this.getHolder().setFormat(1);
        }
        this.setEGLContextClientVersion(2);
        this.setEGLContextFactory(new ContextFactory());
        this.setEGLConfigChooser(translucent ? new ConfigChooser(8, 8, 8, 8, depth, stencil) : new ConfigChooser(5, 6, 5, 0, depth, stencil));
        this.setRenderer(new MyRenderer(this));
        super.onPause();
    }

    @Override
    public void setHandle(int playerId) {
        this.handle = playerId;
        PlayerLogger.d(TAG, "sethandle : " + playerId + " width : " + this.mSurfaceWidth + " height : " + this.mSurfaceHeight);
        if (this.mSurfaceWidth != 0 && this.mSurfaceHeight != 0) {
            this.runOnDraw(new Runnable(){

                @Override
                public void run() {
                    PlayerLogger.i(GL2VideoView.TAG, "JPlayer.renderInit");
                    JPlayer.renderInit(GL2VideoView.this.handle, GL2VideoView.this.mSurfaceWidth, GL2VideoView.this.mSurfaceHeight);
                    GL2VideoView.this.setRotate();
                    GL2VideoView.this.setTranslate();
                    GL2VideoView.this.setDisplayMode();
                }
            });
        }
    }

    private void setVideoSize(int width, int height) {
        PlayerLogger.i(TAG, "setVideoSize handle : " + this.handle + " width : " + width + " height : " + height);
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        if (this.handle != 0) {
            this.runOnDraw(new Runnable(){

                @Override
                public void run() {
                    PlayerLogger.i(GL2VideoView.TAG, "JPlayer.renderInit");
                    JPlayer.renderInit(GL2VideoView.this.handle, GL2VideoView.this.mSurfaceWidth, GL2VideoView.this.mSurfaceHeight);
                    GL2VideoView.this.setRotate();
                    GL2VideoView.this.setTranslate();
                    GL2VideoView.this.setDisplayMode();
                }
            });
        }
    }

    @Override
    public void stopRender() {
        PlayerLogger.i(TAG, "stopRender onPause");
        this.onPause();
    }

    @Override
    public void startRender() {
        PlayerLogger.i(TAG, "startRender onResume");
        this.onResume();
    }

    public void setRotate(float angleX, float angleY, float angleZ) {
        PlayerLogger.i(TAG, "setRotate angleX : " + angleX + " angleY : " + angleY + " angleZ : " + angleZ);
        this.rotateX = angleX;
        this.rotateY = angleY;
        this.rotateZ = angleZ;
        this.needInitRotate = true;
        this.setRotate();
    }

    private void setRotate() {
        if (this.needInitRotate && this.handle != 0 && this.mSurfaceHeight != 0 && this.mSurfaceWidth != 0) {
            PlayerLogger.d(TAG, "setRotate handle : " + this.handle + " mSurfaceHeight : " + this.mSurfaceHeight + " mSurfaceWidth : " + this.mSurfaceWidth + " needInitRotate : " + this.needInitRotate);
            JPlayer.setRotate(this.handle, -1.0f, 0.0f, 0.0f, 0.0f);
            JPlayer.setRotate(this.handle, this.rotateX, 1.0f, 0.0f, 0.0f);
            JPlayer.setRotate(this.handle, this.rotateY, 0.0f, 1.0f, 0.0f);
            JPlayer.setRotate(this.handle, this.rotateZ, 0.0f, 0.0f, 1.0f);
            this.needInitRotate = false;
        }
    }

    public void setTranslate(float x, float y) {
        PlayerLogger.i(TAG, "setTranslate x : " + x + " y : " + y);
        this.translateX = x;
        this.translateY = y;
        this.needTranlate = true;
        this.setTranslate();
    }

    private void setTranslate() {
        if (this.needTranlate && this.handle != 0 && this.mSurfaceHeight != 0 && this.mSurfaceWidth != 0) {
            PlayerLogger.d(TAG, "setTranslate handle : " + this.handle + " mSurfaceHeight : " + this.mSurfaceHeight + " mSurfaceWidth : " + this.mSurfaceWidth + " needTranlate : " + this.needTranlate);
            JPlayer.setTranslate(this.handle, this.translateX, this.translateY);
            this.needTranlate = false;
        }
    }

    public void setDisplayMode(int mode) {
        PlayerLogger.i(TAG, "setDisplayMode mode : " + mode);
        this.mDisplayMode = mode;
        this.needDisplayMode = true;
        this.setDisplayMode();
    }

    private void setDisplayMode() {
        if (this.needDisplayMode && this.handle != 0 && this.mSurfaceHeight != 0 && this.mSurfaceWidth != 0) {
            PlayerLogger.d(TAG, "setDisplayMode handle : " + this.handle + " mSurfaceHeight : " + this.mSurfaceHeight + " mSurfaceWidth : " + this.mSurfaceWidth + " needDisplayMode : " + this.needDisplayMode);
            JPlayer.setDisplayMode(this.handle, this.mDisplayMode);
            this.needDisplayMode = false;
        }
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttrs = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};

        public ConfigChooser(int r, int g, int b, int a, int depth, int stencil) {
            this.mRedSize = r;
            this.mGreenSize = g;
            this.mBlueSize = b;
            this.mAlphaSize = a;
            this.mDepthSize = depth;
            this.mStencilSize = stencil;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, s_configAttrs, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, s_configAttrs, configs, numConfigs, num_config);
            return this.chooseConfig(egl, display, configs);
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttr(egl, display, config, 12325, 0);
                int s = this.findConfigAttr(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttr(egl, display, config, 12324, 0);
                int g = this.findConfigAttr(egl, display, config, 12323, 0);
                int b = this.findConfigAttr(egl, display, config, 12322, 0);
                int a = this.findConfigAttr(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttr(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }

        private void printConfigs(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            int numConfigs = configs.length;
            for (int i = 0; i < numConfigs; ++i) {
                this.printConfig(egl, display, configs[i]);
            }
        }

        private void printConfig(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attributes = new int[]{12320, 12321, 12322, 12323, 12324, 12325, 12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333, 12334, 12335, 12336, 12337, 12338, 12339, 12340, 12343, 12342, 12341, 12345, 12346, 12347, 12348, 12349, 12350, 12351, 12352, 12354};
            String[] names = new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT"};
            int[] value = new int[1];
            for (int i = 0; i < attributes.length; ++i) {
                int attribute = attributes[i];
                String name = names[i];
                if (egl.eglGetConfigAttrib(display, config, attribute, value)) continue;
                while (egl.eglGetError() != 12288) {
                }
            }
        }
    }

    private static class ContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private static int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private ContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig eglConfig) {
            ContextFactory.checkEglError("Before eglCreateContext", egl);
            int[] attr_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
            EGLContext context = egl.eglCreateContext(display, eglConfig, EGL10.EGL_NO_CONTEXT, attr_list);
            ContextFactory.checkEglError("After eglCreateContext", egl);
            return context;
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            egl.eglDestroyContext(display, context);
        }

        private static void checkEglError(String prompt, EGL10 egl) {
            int error;
            while ((error = egl.eglGetError()) != 12288) {
            }
        }
    }

    private static class MyRenderer
    implements GLSurfaceView.Renderer {
        private GL2VideoView mVideoView;

        public MyRenderer(GL2VideoView videoView) {
            this.mVideoView = videoView;
            PlayerLogger.d(GL2VideoView.TAG, "MyRenderer");
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            PlayerLogger.d(GL2VideoView.TAG, "MyRenderer onSurfaceCreated");
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            PlayerLogger.d(GL2VideoView.TAG, "MyRenderer onSurfaceChanged");
            if (this.mVideoView != null) {
                this.mVideoView.needInitRotate = true;
                this.mVideoView.needTranlate = true;
                this.mVideoView.needDisplayMode = true;
                this.mVideoView.setVideoSize(width, height);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDrawFrame(GL10 gl) {
            if (this.mVideoView != null) {
                Object object = this.mVideoView.lock;
                synchronized (object) {
                    if (this.mVideoView.handle != 0) {
                        PlayerLogger.v(GL2VideoView.TAG, "onDrawFrame=" + this.mVideoView.handle);
                        this.mVideoView.runAll();
                        JPlayer.renderDraw(this.mVideoView.handle);
                    }
                }
            }
        }
    }
}

