/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.view;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.util.AttributeSet;
import android.view.TextureView;
import com.qihoo.livecloud.play.callback.ILiveCloudDisplay;
import com.qihoo.livecloud.utils.PlayerLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;

public class GLBaseTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private static final String TAG = "GLBaseTextureView";
    private GLSurfaceView.Renderer mRenderer;
    private static final int TARGET_FRAME_RATE = 60;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private SurfaceTexture mSurface;
    private EGLDisplay mEglDisplay;
    private EGLSurface mEglSurface;
    private EGLContext mEglContext;
    private EGL10 mEgl;
    private EGLConfig eglConfig;
    private GL10 mGl;
    private int targetFrameDurationMillis;
    private int surfaceHeight;
    private int surfaceWidth;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private AtomicBoolean paused = new AtomicBoolean(false);
    private boolean rendererChanged = false;
    private RenderThread thread;
    private static AtomicBoolean isRenderThreadStopping = new AtomicBoolean(false);
    private static ExecutorService stoppingThread = Executors.newSingleThreadExecutor();
    private ILiveCloudDisplay mILiveCloudDisplay;
    private int targetFps;

    public GLBaseTextureView(Context context) {
        super(context);
        this.initialize();
    }

    public GLBaseTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    public GLBaseTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    public synchronized void setRenderer(GLSurfaceView.Renderer renderer) {
        PlayerLogger.d(TAG, "setRenderer");
        this.mRenderer = renderer;
        this.rendererChanged = true;
    }

    private void initialize() {
        this.targetFps = 60;
        this.setSurfaceTextureListener(this);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        PlayerLogger.d(TAG, "onSurfaceTextureAvailable");
        this.startThread(surface, width, height, this.targetFps);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        PlayerLogger.d(TAG, "onSurfaceTextureSizeChanged");
        this.setDimensions(width, height);
        if (this.mRenderer != null) {
            this.mRenderer.onSurfaceChanged(this.mGl, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        PlayerLogger.d(TAG, "onSurfaceTextureDestroyed");
        this.stopThread();
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void startThread(SurfaceTexture surface, int width, int height, float targetFramesPerSecond) {
        PlayerLogger.d(TAG, "startThread");
        this.thread = new RenderThread();
        this.mSurface = surface;
        this.setDimensions(width, height);
        this.targetFrameDurationMillis = (int)(1.0f / targetFramesPerSecond * 1000.0f);
        this.rendererChanged = true;
        this.thread.start();
    }

    public void stopThread() {
        PlayerLogger.d(TAG, "stopThread");
        if (this.thread != null) {
            this.isRunning.set(false);
            isRenderThreadStopping.set(true);
            stoppingThread.execute(new Runnable(){

                @Override
                public void run() {
                    if (GLBaseTextureView.this.thread != null) {
                        try {
                            GLBaseTextureView.this.thread.join();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        GLBaseTextureView.this.thread = null;
                        isRenderThreadStopping.set(false);
                    }
                }
            });
        }
    }

    public void setPaused(boolean isPaused) {
        this.paused.set(isPaused);
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    private boolean shouldSleep() {
        return this.isPaused() || this.mRenderer == null;
    }

    private synchronized void initializeRenderer(GLSurfaceView.Renderer renderer) {
        if (renderer != null && this.isRunning.get()) {
            renderer.onSurfaceCreated(this.mGl, this.eglConfig);
            renderer.onSurfaceChanged(this.mGl, this.surfaceWidth, this.surfaceHeight);
        }
    }

    private synchronized void drawSingleFrame() {
        this.checkCurrent();
        if (this.mRenderer != null) {
            this.mRenderer.onDrawFrame(this.mGl);
        }
        this.checkGlError();
        if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
            PlayerLogger.d(TAG, "cannot swap buffers!");
        }
    }

    public void setDimensions(int width, int height) {
        this.surfaceWidth = width;
        this.surfaceHeight = height;
    }

    private void checkCurrent() {
        if (!this.mEglContext.equals(this.mEgl.eglGetCurrentContext()) || !this.mEglSurface.equals(this.mEgl.eglGetCurrentSurface(12377))) {
            this.checkEglError();
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                throw new RuntimeException("eglMakeCurrent failed " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
            }
            this.checkEglError();
        }
    }

    private void checkEglError() {
        int error = this.mEgl.eglGetError();
        if (error != 12288) {
            PlayerLogger.e(TAG, "EGL error = 0x" + Integer.toHexString(error));
        }
    }

    private void checkGlError() {
        int error = this.mGl.glGetError();
        if (error != 0) {
            PlayerLogger.e(TAG, "EGL error = 0x" + Integer.toHexString(error));
        }
    }

    private void initGL() {
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
        int[] version = new int[2];
        if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
            throw new RuntimeException("eglInitialize failed " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
        int[] configsCount = new int[1];
        EGLConfig[] configs = new EGLConfig[1];
        int[] configSpec = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12344};
        this.eglConfig = null;
        if (!this.mEgl.eglChooseConfig(this.mEglDisplay, configSpec, configs, 1, configsCount)) {
            throw new IllegalArgumentException("eglChooseConfig failed " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
        if (configsCount[0] > 0) {
            this.eglConfig = configs[0];
        }
        if (this.eglConfig == null) {
            throw new RuntimeException("eglConfig not initialized");
        }
        int[] attrib_list = new int[]{12440, 2, 12344};
        this.mEglContext = this.mEgl.eglCreateContext(this.mEglDisplay, this.eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
        this.checkEglError();
        this.mEglSurface = this.mEgl.eglCreateWindowSurface(this.mEglDisplay, this.eglConfig, (Object)this.mSurface, null);
        this.checkEglError();
        if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
            int error = this.mEgl.eglGetError();
            if (error == 12299) {
                PlayerLogger.e(TAG, "eglCreateWindowSurface returned EGL10.EGL_BAD_NATIVE_WINDOW");
                return;
            }
            throw new RuntimeException("eglCreateWindowSurface failed " + GLUtils.getEGLErrorString((int)error));
        }
        if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
            throw new RuntimeException("eglMakeCurrent failed " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
        this.checkEglError();
        this.mGl = (GL10)this.mEglContext.getGL();
        this.checkEglError();
    }

    private class RenderThread
    extends Thread {
        private RenderThread() {
        }

        @Override
        public void run() {
            GLBaseTextureView.this.isRunning.set(true);
            while (isRenderThreadStopping.get() && GLBaseTextureView.this.isRunning.get()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            GLBaseTextureView.this.initGL();
            GLBaseTextureView.this.checkGlError();
            while (GLBaseTextureView.this.isRunning.get()) {
                if (GLBaseTextureView.this.mRenderer == null || GLBaseTextureView.this.shouldSleep()) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (GLBaseTextureView.this.rendererChanged) {
                    GLBaseTextureView.this.initializeRenderer(GLBaseTextureView.this.mRenderer);
                    GLBaseTextureView.this.rendererChanged = false;
                }
                long lastFrameTime = System.currentTimeMillis();
                GLBaseTextureView.this.drawSingleFrame();
                long thisFrameTime = System.currentTimeMillis();
                long timDiff = thisFrameTime - lastFrameTime;
                long cha = (long)GLBaseTextureView.this.targetFrameDurationMillis - timDiff;
                try {
                    long sp = Math.max(10L, cha);
                    Thread.sleep(sp);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

