/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.view;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import com.qihoo.livecloud.play.callback.ILiveCloudDisplay;
import com.qihoo.livecloud.play.jni.JPlayer;
import com.qihoo.livecloud.utils.PlayerLogger;
import com.qihoo.livecloud.view.GLBaseTextureView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GLTextureView
extends GLBaseTextureView
implements GLSurfaceView.Renderer,
ILiveCloudDisplay {
    private static final String TAG = "GLTextureView";
    private int mSurfaceWidth = 0;
    private int mSurfaceHeight = 0;
    private int handle = 0;
    private float rotateX = 0.0f;
    private float rotateY = 0.0f;
    private float rotateZ = 0.0f;
    private boolean needInitRotate = false;
    private float translateX = 0.0f;
    private float translateY = 0.0f;
    private boolean needTranlate = false;
    private boolean needDisplayMode = false;
    private int mDisplayMode = 0;
    private boolean isPlayerInit = false;
    private boolean renderInit = false;
    private boolean mIsDraw = false;
    private Object lock = new Object();

    public GLTextureView(Context context) {
        super(context);
        this.init();
    }

    public GLTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GLTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        PlayerLogger.d(TAG, "init");
        this.setRenderer(this);
        this.setPaused(true);
    }

    @Override
    public void setHandle(int playerId) {
        this.handle = playerId;
        PlayerLogger.i(TAG, "sethandle : " + playerId + " width : " + this.mSurfaceWidth + " height : " + this.mSurfaceHeight);
        if (this.mSurfaceWidth != 0 && this.mSurfaceHeight != 0) {
            this.renderInit = true;
            this.isPlayerInit = true;
        }
    }

    private void setVideoSize(int width, int height) {
        PlayerLogger.i(TAG, "setVideoSize handle : " + this.handle + " width : " + width + " height : " + height);
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        if (this.handle != 0) {
            this.renderInit = true;
            this.isPlayerInit = true;
        }
    }

    @Override
    public void stopRender() {
        PlayerLogger.i(TAG, "stopRender");
        this.setIsDraw(false);
    }

    @Override
    public void startRender() {
        PlayerLogger.i(TAG, "startRender");
        this.setIsDraw(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIsDraw(boolean isDraw) {
        if (isDraw != this.mIsDraw) {
            Object object = this.lock;
            synchronized (object) {
                this.mIsDraw = isDraw;
                if (isDraw) {
                    this.setPaused(false);
                } else {
                    this.setPaused(true);
                }
            }
        }
    }

    public void setRotate(float angleX, float angleY, float angleZ) {
        PlayerLogger.i(TAG, "setRotate angleX : " + angleX + " angleY : " + angleY + " angleZ : " + angleZ);
        this.rotateX = angleX;
        this.rotateY = angleY;
        this.rotateZ = angleZ;
        this.needInitRotate = true;
    }

    private void setRotate() {
        if (this.needInitRotate && this.handle != 0 && this.mSurfaceHeight != 0 && this.mSurfaceWidth != 0) {
            PlayerLogger.i(TAG, "setRotate handle : " + this.handle + " mSurfaceHeight : " + this.mSurfaceHeight + " mSurfaceWidth : " + this.mSurfaceWidth + " needInitRotate : " + this.needInitRotate);
            JPlayer.setRotate(this.handle, -1.0f, 0.0f, 0.0f, 0.0f);
            JPlayer.setRotate(this.handle, this.rotateX, 1.0f, 0.0f, 0.0f);
            JPlayer.setRotate(this.handle, this.rotateY, 0.0f, 1.0f, 0.0f);
            JPlayer.setRotate(this.handle, this.rotateZ, 0.0f, 0.0f, 1.0f);
            this.needInitRotate = false;
        }
    }

    public void setTranslate(float x, float y) {
        PlayerLogger.i(TAG, "setTranslate x : " + x + " y : " + y);
        this.translateX = x;
        this.translateY = y;
        this.needTranlate = true;
    }

    private void setTranslate() {
        if (this.needTranlate && this.handle != 0 && this.mSurfaceHeight != 0 && this.mSurfaceWidth != 0) {
            PlayerLogger.i(TAG, "setTranslate handle : " + this.handle + " mSurfaceHeight : " + this.mSurfaceHeight + " mSurfaceWidth : " + this.mSurfaceWidth + " needTranlate : " + this.needTranlate);
            JPlayer.setTranslate(this.handle, this.translateX, this.translateY);
            this.needTranlate = false;
        }
    }

    @Deprecated
    public void setDisplayMode(int mode) {
        PlayerLogger.i(TAG, "setDisplayMode mode : " + mode);
        this.mDisplayMode = mode;
        this.needDisplayMode = true;
    }

    public void setRenderMode(int mode) {
        PlayerLogger.i(TAG, "setDisplayMode mode : " + mode);
        this.mDisplayMode = mode;
        this.needDisplayMode = true;
    }

    private void setDisplayMode() {
        if (this.needDisplayMode && this.handle != 0 && this.mSurfaceHeight != 0 && this.mSurfaceWidth != 0) {
            PlayerLogger.i(TAG, "setDisplayMode handle : " + this.handle + " mSurfaceHeight : " + this.mSurfaceHeight + " mSurfaceWidth : " + this.mSurfaceWidth + " needDisplayMode : " + this.needDisplayMode);
            JPlayer.setDisplayMode(this.handle, this.mDisplayMode);
            this.needDisplayMode = false;
        }
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        PlayerLogger.d(TAG, "onSurfaceCreated");
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        PlayerLogger.d(TAG, "onSurfaceChanged");
        this.setVideoSize(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.handle != 0 && this.isPlayerInit) {
                this.renderInit();
                if (this.mIsDraw) {
                    this.setRotate();
                    this.setTranslate();
                    this.setDisplayMode();
                    JPlayer.renderDraw(this.handle);
                }
            }
        }
    }

    private void renderInit() {
        if (this.renderInit) {
            PlayerLogger.i(TAG, "renderInit handle : " + this.handle + " mSurfaceHeight : " + this.mSurfaceHeight + " mSurfaceWidth : " + this.mSurfaceWidth + " renderInit : " + this.renderInit);
            JPlayer.renderInit(this.handle, this.mSurfaceWidth, this.mSurfaceHeight);
            this.renderInit = false;
        }
    }
}

