/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.view;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.TextureView;
import com.qihoo.livecloud.ILiveCloudPlayer;
import com.qihoo.livecloud.play.callback.ILiveCloudDisplay;
import com.qihoo.livecloud.utils.PlayerLogger;

public class TexturePlayView
extends TextureView
implements TextureView.SurfaceTextureListener,
ILiveCloudDisplay {
    private static final String TAG = "TexturePlayView";
    public static int RENDER_MODE_IN = 0;
    public static int RENDER_MODE_OUT = 1;
    public static int RENDER_MODE_FULL = 2;
    private int handle = 0;
    private DisplayCtrl m_dis_ctrl = null;
    private boolean m_is_play = false;
    private ILiveCloudPlayer mLiveCloudPlayer;
    private float mVideoRatio = 0.0f;
    private int mVideoRendMode = 0;

    public TexturePlayView(Context context) {
        super(context);
        this.initialize();
    }

    public TexturePlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    public void setLiveCloudPlayer(ILiveCloudPlayer player) {
        this.mLiveCloudPlayer = player;
    }

    private void initialize() {
        this.m_dis_ctrl = new DisplayCtrl();
        this.setSurfaceTextureListener(this);
    }

    @Override
    public void setHandle(int playerId) {
        PlayerLogger.i(TAG, "setPlayerId handle=" + playerId);
        this.handle = playerId;
    }

    @Override
    public void stopRender() {
        PlayerLogger.d(TAG, "stopRender");
    }

    public void on_play() {
        this.m_is_play = true;
        PlayerLogger.i(TAG, "on_play");
    }

    public void on_stop() {
        this.m_is_play = false;
        PlayerLogger.i(TAG, "on_stop");
    }

    @Override
    public void startRender() {
        PlayerLogger.d(TAG, "startRender");
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        PlayerLogger.d(TAG, "onSurfaceTextureAvailable width=" + width + " height=" + height);
        this.m_dis_ctrl.setSurfaceTexture(surfaceTexture);
        this.setSurface("new", this.m_dis_ctrl.getSurfaceTexture());
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        PlayerLogger.d(TAG, "onSurfaceTextureDestroyed");
        this.m_dis_ctrl.setSurfaceTexture(null);
        this.setSurface("destroy", this.m_dis_ctrl.getSurfaceTexture());
        return true;
    }

    private void setSurface(String from, SurfaceTexture texture) {
        PlayerLogger.i(TAG, "setSurface texture=" + texture + " m_is_play=" + this.m_is_play + " handle=" + this.handle);
        if (this.m_is_play && this.mLiveCloudPlayer != null) {
            this.mLiveCloudPlayer.setSurface(from, texture);
        }
    }

    public void pauseSurface() {
        PlayerLogger.i(TAG, "pauseSurface");
        this.setSurface("pause", null);
    }

    public void resumeSurface() {
        PlayerLogger.i(TAG, "resumeSurface");
        this.setSurface("resume", this.m_dis_ctrl.getSurfaceTexture());
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void render_proc(long i_msgId, long i_msgVal) {
        if (i_msgId == 1L) {
            PlayerLogger.d(TAG, "surface DEVICE_RENDER_QUERY_SURFACE");
            SurfaceTexture texture = this.m_dis_ctrl.getSurfaceTexture();
            if (texture != null) {
                this.setSurface("query", texture);
            }
        } else if (i_msgId == 2L) {
            int nWidth = (int)(i_msgVal >> 16 & 0xFFFFL);
            int nHeight = (int)(i_msgVal & 0xFFFFL);
            PlayerLogger.d(TAG, "surface change " + i_msgVal + " width " + nWidth + " height " + nHeight);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        PlayerLogger.d(TAG, "TextureView onSizeChanged  width " + w + " height " + h);
        this.updateTransform();
    }

    public void setVideoRatio(int renderMode, float videoRatio) {
        this.mVideoRatio = videoRatio;
        this.mVideoRendMode = renderMode;
        this.updateTransform();
    }

    private void updateTransform() {
        if (this.mVideoRatio == 0.0f) {
            return;
        }
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        int displayWidth = viewWidth;
        int displayHeight = viewHeight;
        RectF previewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        if (this.mVideoRendMode == RENDER_MODE_IN) {
            if ((float)viewWidth <= (float)viewHeight * this.mVideoRatio) {
                displayWidth = viewWidth;
                displayHeight = (int)((double)((float)viewWidth / this.mVideoRatio) + 0.5);
            } else {
                displayWidth = (int)((double)((float)viewHeight * this.mVideoRatio) + 0.5);
                displayHeight = viewHeight;
            }
        } else if (this.mVideoRendMode == RENDER_MODE_OUT) {
            if ((float)viewWidth >= (float)viewHeight * this.mVideoRatio) {
                displayWidth = viewWidth;
                displayHeight = (int)((double)((float)viewWidth / this.mVideoRatio) + 0.5);
            } else {
                displayWidth = (int)((double)((float)viewHeight * this.mVideoRatio) + 0.5);
                displayHeight = viewHeight;
            }
        } else {
            displayWidth = viewWidth;
            displayHeight = viewHeight;
        }
        RectF surfaceDimensions = new RectF((float)((viewWidth - displayWidth) / 2), (float)((viewHeight - displayHeight) / 2), (float)((viewWidth - displayWidth) / 2 + displayWidth), (float)((viewHeight - displayHeight) / 2 + displayHeight));
        PlayerLogger.d(TAG, "TextureView updateTransform  left " + surfaceDimensions.left + " top " + surfaceDimensions.top + " right " + surfaceDimensions.right + " bottom " + surfaceDimensions.bottom);
        Matrix matrix = new Matrix();
        matrix.setRectToRect(previewRect, surfaceDimensions, Matrix.ScaleToFit.FILL);
        this.setTransform(matrix);
    }

    class DisplayCtrl {
        private SurfaceTexture m_surfaceTexture = null;

        public void setSurfaceTexture(SurfaceTexture surTex) {
            this.m_surfaceTexture = null;
            this.m_surfaceTexture = surTex;
        }

        public SurfaceTexture getSurfaceTexture() {
            return this.m_surfaceTexture;
        }
    }
}

