/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.view.elgcore;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class BaseGLRender {
    public static final String VERTEX_SHADER_NORMAL = "attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = aPosition;\n    vTextureCoord = aTextureCoord;\n}";
    public static final String VERTEX_SHADER_MATRIX_VERTEX = "uniform mat4 uVertexMatrix;\nattribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uVertexMatrix * aPosition;\n    vTextureCoord = aTextureCoord;\n}";
    public static final String VERTEX_SHADER_MATRIX_TEXTURE = "uniform mat4 uTextureMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = aPosition;\n    vTextureCoord = (uTextureMatrix * aTextureCoord).xy;\n}";
    public static final String VERTEX_SHADER_MATRIX = "uniform mat4 uVertexMatrix;\nuniform mat4 uTextureMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uVertexMatrix * aPosition;\n    vTextureCoord = (uTextureMatrix * aTextureCoord).xy;\n}";
    public static final String FRAGMENT_SHADER_OES = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}";
    public static final String FRAGMENT_SHADER_2D = "precision mediump float;\nuniform sampler2D sTexture;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}";
    public static final String FRAGMENT_SHADER_BLUR_2D = "precision mediump float;\nuniform float texelWidthOffset;\nuniform float texelHeightOffset;\nuniform sampler2D sTexture;\nvarying vec2 vTextureCoord;\nvoid main() {\n    int half_win = 2;\n    int win = 5;\n    mediump vec3 sum = vec3(0.0);\n    mediump vec4 fragColor = texture2D(sTexture, vTextureCoord);\n    mediump vec2 tempcood = vec2(0.0);\n    for (int i = 0; i < win; i++) {\n        for (int j = 0; j < win; j++) {\n            tempcood.x = vTextureCoord.x-float((half_win-j)) * texelWidthOffset;\n            tempcood.y = vTextureCoord.y-float((half_win-i)) * texelHeightOffset;\n            sum += texture2D(sTexture, tempcood).rgb;\n  \t      }\n    }\n    gl_FragColor = vec4(sum / 25.0, fragColor.a);\n}";
    public static final String FRAGMENT_SHADER_FADE_2D = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform sampler2D sTexture;\nuniform float fAlpha;\nvoid main() {\n    mediump vec4 piximg = vec4(0.0);\n    piximg = texture2D(sTexture, vTextureCoord);\n    gl_FragColor = vec4(piximg.rgb * fAlpha, piximg.a);\n}";
    public static final String FRAGMENT_SHADER_FADE_OUT_2D = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform sampler2D sTexture;\nuniform float fAlpha;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n    gl_FragColor.a = gl_FragColor.a * fAlpha;\n}";
    public static final String FRAGMENT_SHADER_EXT_FILTER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform float brightness;\nuniform float contrast;\nuniform float saturation;\nconst mediump vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\nvoid main() {\n    vec4 textureColor = texture2D(sTexture, vTextureCoord);\n    vec4 brightnessColor = vec4((textureColor.rgb + vec3(brightness)), textureColor.w);\n    vec4 contrastColor = vec4(((brightnessColor.rgb - vec3(0.5)) * contrast + vec3(0.5)), brightnessColor.w);\n    float luminance = dot(contrastColor.rgb, luminanceWeighting);\n    vec3 greyScaleColor = vec3(luminance);\n    gl_FragColor = vec4(mix(greyScaleColor, contrastColor.rgb, saturation), contrastColor.w);\n}\n";

    public static int[] genTextures(TextureType type) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        if (type == TextureType.TEXTURE_EXTERNAL_OES) {
            GLES20.glBindTexture((int)36197, (int)textures[0]);
            GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
            GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        } else if (type == TextureType.TEXTURE_2D) {
            GLES20.glBindTexture((int)3553, (int)textures[0]);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        } else {
            textures = null;
        }
        return textures;
    }

    public static void deleteTextures(int[] textures) {
        if (textures != null) {
            GLES20.glDeleteTextures((int)textures.length, (int[])textures, (int)0);
        }
    }

    public static void texImage2D(int texture, int width, int height, Buffer pixels) {
        GLES20.glBindTexture((int)3553, (int)texture);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (Buffer)pixels);
    }

    public static void texImage2D(int texture, Bitmap bitmap) {
        if (texture > 0 && bitmap != null && !bitmap.isRecycled()) {
            GLES20.glBindTexture((int)3553, (int)texture);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        }
    }

    public static int[] genFramebuffers(int texture) {
        if (texture > 0) {
            int[] framebuffers = new int[1];
            GLES20.glBindTexture((int)3553, (int)texture);
            GLES20.glGenFramebuffers((int)1, (int[])framebuffers, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)framebuffers[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GLES20.glBindTexture((int)3553, (int)0);
            return framebuffers;
        }
        return null;
    }

    public static void deleteFramebuffers(int[] framebuffers) {
        if (framebuffers != null) {
            GLES20.glDeleteFramebuffers((int)framebuffers.length, (int[])framebuffers, (int)0);
        }
    }

    public static void bindFramebuffer(int framebuffer) {
        GLES20.glBindFramebuffer((int)36160, (int)framebuffer);
    }

    public static int createProgram(String vss, String fss) {
        if (vss == null || fss == null) {
            return 0;
        }
        int vertexShader = GLES20.glCreateShader((int)35633);
        GLES20.glShaderSource((int)vertexShader, (String)vss);
        GLES20.glCompileShader((int)vertexShader);
        int[] params = new int[1];
        GLES20.glGetShaderiv((int)vertexShader, (int)35713, (int[])params, (int)0);
        if (params[0] == 0) {
            Log.e((String)"Shader", (String)("Could not compile vshader:" + GLES20.glGetShaderInfoLog((int)vertexShader)));
            GLES20.glDeleteShader((int)vertexShader);
            return 0;
        }
        int fragmentShader = GLES20.glCreateShader((int)35632);
        GLES20.glShaderSource((int)fragmentShader, (String)fss);
        GLES20.glCompileShader((int)fragmentShader);
        GLES20.glGetShaderiv((int)fragmentShader, (int)35713, (int[])params, (int)0);
        if (params[0] == 0) {
            Log.e((String)"Shader", (String)("Could not compile fshader:" + GLES20.glGetShaderInfoLog((int)fragmentShader)));
            GLES20.glDeleteShader((int)fragmentShader);
            return 0;
        }
        int program = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)program, (int)vertexShader);
        GLES20.glAttachShader((int)program, (int)fragmentShader);
        GLES20.glLinkProgram((int)program);
        GLES20.glDeleteShader((int)vertexShader);
        GLES20.glDeleteShader((int)fragmentShader);
        return program;
    }

    public static int createShader(int type, String shaderCode) {
        int shader = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)shader, (String)shaderCode);
        GLES20.glCompileShader((int)shader);
        int[] params = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])params, (int)0);
        if (params[0] == 0) {
            Log.e((String)"Shader", (String)("Could not compile shader:" + GLES20.glGetShaderInfoLog((int)shader)));
            GLES20.glDeleteShader((int)shader);
            return 0;
        }
        return shader;
    }

    public static void deleteProgram(int program) {
        if (program != 0) {
            GLES20.glDeleteProgram((int)program);
        }
    }

    public static void useProgram(int program) {
        GLES20.glUseProgram((int)program);
    }

    public static void viewport(int x, int y, int width, int height) {
        GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void clear(float red, float green, float blue, float alpha) {
        GLES20.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
        GLES20.glClear((int)16384);
    }

    public static void readPixels(int x, int y, int width, int height, IntBuffer pixels) {
        GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6408, (int)5121, (Buffer)pixels);
    }

    public static void drawBackgroundColor(int x, int y, int width, int height, float red, float green, float blue, float alpha) {
        GLES20.glEnable((int)3089);
        GLES20.glScissor((int)x, (int)y, (int)width, (int)height);
        BaseGLRender.clear(red, green, blue, alpha);
        GLES20.glDisable((int)3089);
    }

    public static void vertexAttribPointer(int program, String attributeName, int componentNumber, FloatBuffer attribute) {
        int vAttribute = GLES20.glGetAttribLocation((int)program, (String)attributeName);
        GLES20.glVertexAttribPointer((int)vAttribute, (int)componentNumber, (int)5126, (boolean)false, (int)(4 * componentNumber), (Buffer)attribute);
        GLES20.glEnableVertexAttribArray((int)vAttribute);
    }

    public static void uniformMatrix4fv(int program, String valueName, float[] value) {
        int mValue = GLES20.glGetUniformLocation((int)program, (String)valueName);
        GLES20.glUniformMatrix4fv((int)mValue, (int)1, (boolean)false, (float[])value, (int)0);
    }

    public static void uniform1f(int program, String valueName, float value) {
        int fValue = GLES20.glGetUniformLocation((int)program, (String)valueName);
        GLES20.glUniform1f((int)fValue, (float)value);
    }

    public static void bindTexture(int textureUnit, TextureType textureType, int texture) {
        GLES20.glActiveTexture((int)(33984 + textureUnit));
        if (textureType == TextureType.TEXTURE_EXTERNAL_OES) {
            GLES20.glBindTexture((int)36197, (int)texture);
        } else if (textureType == TextureType.TEXTURE_2D) {
            GLES20.glBindTexture((int)3553, (int)texture);
        }
    }

    public static void uniformTexture(int program, String textureName, int textureUnit) {
        int sTexture = GLES20.glGetUniformLocation((int)program, (String)textureName);
        GLES20.glUniform1i((int)sTexture, (int)textureUnit);
    }

    public static void drawArrays(boolean transparent, BlendSrcType blendSrcType, int indexNumber) {
        if (transparent) {
            int sfactor;
            GLES20.glEnable((int)3042);
            switch (blendSrcType) {
                case BLEND_SRC_ALPHA: {
                    sfactor = 770;
                    break;
                }
                default: {
                    sfactor = 1;
                }
            }
            GLES20.glBlendFunc((int)sfactor, (int)771);
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)indexNumber);
        GLES20.glFlush();
        if (transparent) {
            GLES20.glDisable((int)3042);
        }
    }

    public static void flush() {
        GLES20.glFlush();
    }

    public static float getSaturatedColor(float color) {
        color = Math.max(color, 0.0f);
        color = Math.min(color, 1.0f);
        return color;
    }

    public static enum BlendSrcType {
        BLEND_SRC_ONE,
        BLEND_SRC_ALPHA;

    }

    public static enum TextureType {
        TEXTURE_EXTERNAL_OES,
        TEXTURE_2D;

    }
}

