/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.view.elgcore;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@SuppressLint(value={"NewApi"})
public final class Egl10Core {
    private static final String TAG = "EglCore";
    public static final int FLAG_TRY_GLES3 = 2;
    private EGLDisplay mEGLDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL10.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private int mGlVersion = -1;
    private EGL10 mEgl = null;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;

    public Egl10Core() {
        this(null, 0);
    }

    public Egl10Core(EGLContext sharedContext, int flags) {
        EGLContext context;
        EGLConfig config;
        if (this.mEGLDisplay != EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("EGL already set up");
        }
        if (sharedContext == null) {
            sharedContext = EGL10.EGL_NO_CONTEXT;
        }
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEGLDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("unable to get EGL10 display");
        }
        int[] version = new int[2];
        if (!this.mEgl.eglInitialize(this.mEGLDisplay, version)) {
            this.mEGLDisplay = null;
            throw new RuntimeException("unable to initialize EGL10");
        }
        if ((flags & 2) != 0 && (config = this.getConfig(flags, 3)) != null) {
            int[] attrib3_list = new int[]{12440, 3, 12344};
            context = this.mEgl.eglCreateContext(this.mEGLDisplay, config, sharedContext, attrib3_list);
            if (this.mEgl.eglGetError() == 12288) {
                this.mEGLConfig = config;
                this.mEGLContext = context;
                this.mGlVersion = 3;
            }
        }
        if (this.mEGLContext == EGL10.EGL_NO_CONTEXT) {
            config = this.getConfig(flags, 2);
            if (config == null) {
                throw new RuntimeException("Unable to find a suitable EGLConfig");
            }
            int[] attrib2_list = new int[]{12440, 2, 12344};
            context = this.mEgl.eglCreateContext(this.mEGLDisplay, config, sharedContext, attrib2_list);
            this.checkEglError("eglCreateContext");
            this.mEGLConfig = config;
            this.mEGLContext = context;
            this.mGlVersion = 2;
        }
        int[] values = new int[1];
        this.mEgl.eglQueryContext(this.mEGLDisplay, this.mEGLContext, 12440, values);
    }

    private EGLConfig getConfig(int flags, int version) {
        int[] numConfigs;
        EGLConfig[] configs;
        int[] attribList;
        int renderableType = 4;
        if (version >= 3) {
            renderableType |= 0x40;
        }
        if (!this.mEgl.eglChooseConfig(this.mEGLDisplay, attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 16, 12326, 0, 12352, renderableType, 12344}, configs = new EGLConfig[1], configs.length, numConfigs = new int[1])) {
            return null;
        }
        return configs[0];
    }

    public void release() {
        if (this.mEGLDisplay != EGL10.EGL_NO_DISPLAY) {
            this.mEgl.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.mEgl.eglDestroyContext(this.mEGLDisplay, this.mEGLContext);
            this.mEgl.eglTerminate(this.mEGLDisplay);
        }
        this.mEGLDisplay = EGL10.EGL_NO_DISPLAY;
        this.mEGLContext = EGL10.EGL_NO_CONTEXT;
        this.mEGLConfig = null;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mEGLDisplay != EGL10.EGL_NO_DISPLAY) {
                this.release();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void releaseSurface(EGLSurface eglSurface) {
        this.mEgl.eglDestroySurface(this.mEGLDisplay, eglSurface);
    }

    public EGLSurface createWindowSurface(Object surface) {
        if (!(surface instanceof Surface || surface instanceof SurfaceTexture || surface instanceof SurfaceHolder)) {
            throw new RuntimeException("invalid surface: " + surface);
        }
        int[] surfaceAttribs = new int[]{12344};
        EGLSurface eglSurface = this.mEgl.eglCreateWindowSurface(this.mEGLDisplay, this.mEGLConfig, surface, surfaceAttribs);
        this.checkEglError("eglCreateWindowSurface");
        if (eglSurface == null) {
            throw new RuntimeException("surface was null");
        }
        return eglSurface;
    }

    public EGLSurface createOffscreenSurface(int width, int height) {
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        EGLSurface eglSurface = this.mEgl.eglCreatePbufferSurface(this.mEGLDisplay, this.mEGLConfig, surfaceAttribs);
        this.checkEglError("eglCreatePbufferSurface");
        if (eglSurface == null) {
            throw new RuntimeException("surface was null");
        }
        return eglSurface;
    }

    public int makeCurrent(EGLSurface eglSurface) {
        if (this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
            return -1;
        }
        if (!this.mEgl.eglMakeCurrent(this.mEGLDisplay, eglSurface, eglSurface, this.mEGLContext)) {
            return -1;
        }
        return 0;
    }

    public int makeCurrent(EGLSurface drawSurface, EGLSurface readSurface) {
        if (this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
            // empty if block
        }
        if (!this.mEgl.eglMakeCurrent(this.mEGLDisplay, drawSurface, readSurface, this.mEGLContext)) {
            return -1;
        }
        return 0;
    }

    public int makeNothingCurrent() {
        if (!this.mEgl.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) {
            return -1;
        }
        return 0;
    }

    public boolean swapBuffers(EGLSurface eglSurface) {
        return this.mEgl.eglSwapBuffers(this.mEGLDisplay, eglSurface);
    }

    public int swap(EGLSurface eglSurface) {
        if (!this.swapBuffers(eglSurface)) {
            return this.mEgl.eglGetError();
        }
        return 12288;
    }

    public void setPresentationTime(EGLSurface eglSurface, long nsecs) {
    }

    public boolean isCurrent(EGLSurface eglSurface) {
        return this.mEGLContext.equals(this.mEgl.eglGetCurrentContext()) && eglSurface.equals(this.mEgl.eglGetCurrentSurface(12377));
    }

    public int querySurface(EGLSurface eglSurface, int what) {
        int[] value = new int[1];
        this.mEgl.eglQuerySurface(this.mEGLDisplay, eglSurface, what, value);
        return value[0];
    }

    public String queryString(int what) {
        return this.mEgl.eglQueryString(this.mEGLDisplay, what);
    }

    public int getGlVersion() {
        return this.mGlVersion;
    }

    public static boolean haveEGLContext() {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLContext eglContext = egl.eglGetCurrentContext();
        return eglContext != null && !eglContext.equals(EGL10.EGL_NO_CONTEXT);
    }

    private void checkEglError(String msg) {
        int error = this.mEgl.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }
}

