/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.view.elgcore;

import android.annotation.SuppressLint;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Build;
import com.qihoo.livecloud.view.elgcore.Egl10Core;
import com.qihoo.livecloud.view.elgcore.EglCore;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLSurface;

public final class EglCoreProxy {
    private static final String TAG = "EglCoreProc";
    public static final int FLAG_RECORDABLE = 1;
    private Egl10Core mEgl10Core = null;
    private EglCore mEglCore = null;
    private int m_sdk_int = Build.VERSION.SDK_INT;
    static int EGL10_VERSION = 17;

    public EglCoreProxy(Object sharedContext, int i_nFlag) {
        if (this.m_sdk_int < EGL10_VERSION) {
            this.mEgl10Core = new Egl10Core((javax.microedition.khronos.egl.EGLContext)sharedContext, i_nFlag);
        } else {
            this.mEglCore = new EglCore((EGLContext)sharedContext, i_nFlag);
        }
    }

    public int makeNothingCurrent() {
        int i_err = 0;
        if (this.m_sdk_int < EGL10_VERSION) {
            this.mEgl10Core.makeNothingCurrent();
        } else {
            this.mEglCore.makeNothingCurrent();
        }
        return i_err;
    }

    public void releaseSurface(Object eglSurface) {
        if (this.m_sdk_int < EGL10_VERSION) {
            this.mEgl10Core.releaseSurface((EGLSurface)eglSurface);
        } else {
            this.mEglCore.releaseSurface((android.opengl.EGLSurface)eglSurface);
        }
    }

    @SuppressLint(value={"NewApi"})
    public Object createWindowSurface(Object surface) {
        EGLSurface eglSurface = null;
        if (this.m_sdk_int < EGL10_VERSION) {
            eglSurface = this.mEgl10Core.createWindowSurface(surface);
            if (eglSurface == EGL10.EGL_NO_SURFACE) {
                eglSurface = null;
            }
        } else {
            eglSurface = this.mEglCore.createWindowSurface(surface);
            if (eglSurface == EGL14.EGL_NO_SURFACE) {
                eglSurface = null;
            }
        }
        return eglSurface;
    }

    public int makeCurrent(Object eglSurface) {
        int i_err = 0;
        i_err = this.m_sdk_int < EGL10_VERSION ? this.mEgl10Core.makeCurrent((EGLSurface)eglSurface) : this.mEglCore.makeCurrent((android.opengl.EGLSurface)eglSurface);
        return i_err;
    }

    public int swap(Object eglSurface) {
        int i_err = 0;
        int ret = 0;
        i_err = this.m_sdk_int < EGL10_VERSION ? ((ret = this.mEgl10Core.swap((EGLSurface)eglSurface)) == 12288 ? 0 : (ret == 12302 ? -1 : ret)) : (this.mEglCore.swapBuffers((android.opengl.EGLSurface)eglSurface) ? 0 : -1);
        return i_err;
    }

    public void release() {
        if (this.m_sdk_int < EGL10_VERSION) {
            this.mEgl10Core.release();
            this.mEgl10Core = null;
        } else {
            this.mEglCore.release();
            this.mEglCore = null;
        }
    }

    public void setPresentationTime(Object eglSurface, long nsecs) {
        if (this.m_sdk_int < EGL10_VERSION) {
            this.mEgl10Core.setPresentationTime((EGLSurface)eglSurface, nsecs);
        } else {
            this.mEglCore.setPresentationTime((android.opengl.EGLSurface)eglSurface, nsecs);
        }
    }

    public int getSurfaceWidth(Object eglSurface) {
        if (this.m_sdk_int < EGL10_VERSION) {
            return this.mEgl10Core.querySurface((EGLSurface)eglSurface, 12375);
        }
        return this.mEglCore.querySurface((android.opengl.EGLSurface)eglSurface, 12375);
    }

    public int getSurfaceHeight(Object eglSurface) {
        if (this.m_sdk_int < EGL10_VERSION) {
            return this.mEgl10Core.querySurface((EGLSurface)eglSurface, 12374);
        }
        return this.mEglCore.querySurface((android.opengl.EGLSurface)eglSurface, 12374);
    }

    @SuppressLint(value={"NewApi"})
    public boolean isValid(Object surface) {
        boolean isValid = true;
        isValid = this.m_sdk_int < EGL10_VERSION ? (EGLSurface)surface != EGL10.EGL_NO_SURFACE : (android.opengl.EGLSurface)surface != EGL14.EGL_NO_SURFACE;
        return isValid;
    }

    public static boolean haveEGLContext() {
        if (Build.VERSION.SDK_INT < EGL10_VERSION) {
            return Egl10Core.haveEGLContext();
        }
        return EglCore.haveEGLContext();
    }
}

