/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.view.elgcore;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import com.qihoo.livecloud.utils.PlayerLogger;
import com.qihoo.livecloud.view.elgcore.BaseGLRender;
import com.qihoo.livecloud.view.elgcore.EglCoreProxy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SurfaceTextureEGLSurface
implements SurfaceTexture.OnFrameAvailableListener {
    private static final String TAG = "SurfaceSwap";
    private final GLThreadManager mGLThreadManager = new GLThreadManager();
    private GLThread mGLThread;
    private SurfaceTextureListener mListener;

    public int init(SurfaceTextureListener listener, SurfaceTextureRenderListener renderListener) {
        PlayerLogger.d(TAG, "SurfaceTextureEGLSurface init");
        if (this.mGLThread != null || listener == null) {
            return -1;
        }
        this.mListener = listener;
        this.mGLThread = new GLThread();
        this.mGLThread.setRenderListener(renderListener);
        this.mGLThread.start();
        return 0;
    }

    public int setSurface(SurfaceTexture surfaceTexture) {
        if (this.mGLThread != null) {
            return this.mGLThread.setSurface(surfaceTexture);
        }
        return -1;
    }

    public int setRecordSurface(SurfaceTexture surfaceTexture) {
        if (this.mGLThread != null) {
            return this.mGLThread.setRecordSurface(surfaceTexture);
        }
        return -1;
    }

    public void release() {
        if (this.mGLThread != null) {
            this.mGLThread.release();
            this.mGLThread = null;
        }
        this.mListener = null;
    }

    public void setSurfaceViewport(int surfaceX, int surfaceY, int surfaceWidth, int surfaceHeight) {
        if (this.mGLThread != null) {
            this.mGLThread.setSurfaceViewport(surfaceX, surfaceY, surfaceWidth, surfaceHeight);
        }
    }

    public void setFilterValues(float brightness, float contrast, float saturation) {
        if (this.mGLThread != null) {
            this.mGLThread.setFilterValues(brightness, contrast, saturation);
        }
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        if (this.mGLThread != null) {
            this.mGLThread.requestRender();
        }
    }

    public boolean isFirstFrameAvailable() {
        if (this.mGLThread != null) {
            return this.mGLThread.isFirstFrameAvailable();
        }
        return false;
    }

    public static interface SurfaceTextureRenderListener {
        public static final String VERTEX_DEFAULT_SHADER = "uniform mat4 uTextureMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = aPosition;\n    vTextureCoord = (uTextureMatrix * aTextureCoord).xy;\n}";
        public static final String VERTEX_ATTRIBUTE_POSITION = "aPosition";
        public static final String VERTEX_ATTRIBUTE_TEXTURE_COORD = "aTextureCoord";
        public static final String VERTEX_UNIFORM_TEXTURE_MATRIX = "uTextureMatrix";
        public static final String VERTEX_VARYING_TEXTURE_COORD = "vTextureCoord";
        public static final String FRAGMENT_DEFAULT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}";
        public static final String FRAGMENT_UNIFORM_TEXTURE = "sTexture";

        public void onCreateProgram(int var1);

        public void onDeleteProgram(int var1);

        public int onCreateShader(int var1);

        public void onDeleteShader(int var1);

        public void onDraw(int var1, FloatBuffer var2, FloatBuffer var3, float[] var4, int var5, int var6, int var7);
    }

    public static interface SurfaceTextureListener {
        public void onSurfaceTextureCreated(SurfaceTexture var1);

        public void onSurfaceTextureDestroyed(SurfaceTexture var1);

        public void onFirstFrameAvailable();
    }

    private class GLThread
    extends Thread {
        private boolean mShouldExit;
        private boolean mExited = true;
        private boolean mRequestRender;
        private SurfaceTexture mWriteSurfaceTexture;
        private int mWriteSurfaceX;
        private int mWriteSurfaceY;
        private int mWriteSurfaceWidth;
        private int mWriteSurfaceHeight;
        private SurfaceTexture mRecordSurfaceTexture;
        private SurfaceTextureRenderListener mRenderListener;
        private boolean[] mRenderFlags = new boolean[2];
        private static final int RENDER_VERTEX_SHADER = 0;
        private static final int RENDER_FRAGMENT_SHADER = 1;
        private EglCoreProxy mEglCoreProxy;
        private Object mEglSurface;
        private Object mEglRecordSurface;
        private int[] mTextures;
        private SurfaceTexture mReadSurfaceTexture;
        private int mProgram;
        private FloatBuffer mVertexs;
        private FloatBuffer mTexCoords;
        private float[] mTextureMatrix = new float[16];
        private boolean mNeedRecreateEglSurface = false;
        private boolean mFirstFrameAvailable = false;
        private long mDrawFrameCount = 0L;
        private float mBrightnessValue = 0.0f;
        private float mContrastValue = 1.0f;
        private float mSaturationValue = 1.0f;

        GLThread() {
            this.mVertexs = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
            float[] vtmp = new float[]{1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
            this.mVertexs.put(vtmp);
            this.mVertexs.position(0);
            this.mTexCoords = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
            float[] ttmp = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
            this.mTexCoords.put(ttmp);
            this.mTexCoords.position(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mShouldExit = true;
                SurfaceTextureEGLSurface.this.mGLThreadManager.notifyAll();
                while (!this.mExited) {
                    try {
                        SurfaceTextureEGLSurface.this.mGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void setSurfaceViewport(int surfaceX, int surfaceY, int surfaceWidth, int surfaceHeight) {
            this.mWriteSurfaceX = surfaceX;
            this.mWriteSurfaceY = surfaceY;
            this.mWriteSurfaceWidth = surfaceWidth;
            this.mWriteSurfaceHeight = surfaceHeight;
        }

        public void setFilterValues(float brightness, float contrast, float saturation) {
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface setFilterValues brightness:" + brightness + " contrast:" + contrast + " saturation:" + saturation);
            this.mBrightnessValue = brightness;
            this.mContrastValue = contrast;
            this.mSaturationValue = saturation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int setSurface(SurfaceTexture surfaceTexture) {
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface setSurface " + surfaceTexture);
            if (surfaceTexture != null) {
                GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
                synchronized (gLThreadManager) {
                    if (this.mWriteSurfaceTexture != surfaceTexture) {
                        if (this.mWriteSurfaceTexture != null) {
                            this.mNeedRecreateEglSurface = true;
                        }
                        PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface mNeedRecreateEglSurface= " + this.mNeedRecreateEglSurface);
                    }
                    this.mWriteSurfaceTexture = surfaceTexture;
                    SurfaceTextureEGLSurface.this.mGLThreadManager.notifyAll();
                }
            }
            GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWriteSurfaceTexture = null;
                SurfaceTextureEGLSurface.this.mGLThreadManager.notifyAll();
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int setRecordSurface(SurfaceTexture surfaceTexture) {
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface setSurface " + surfaceTexture);
            if (surfaceTexture != null) {
                GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
                synchronized (gLThreadManager) {
                    this.mRecordSurfaceTexture = surfaceTexture;
                    SurfaceTextureEGLSurface.this.mGLThreadManager.notifyAll();
                }
            }
            GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRecordSurfaceTexture = null;
                SurfaceTextureEGLSurface.this.mGLThreadManager.notifyAll();
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int setRenderListener(SurfaceTextureRenderListener renderListener) {
            GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRenderListener = renderListener;
            }
            return 0;
        }

        @Override
        public void run() {
            this.mExited = false;
            try {
                this.guardedRun();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface guardedRun threadExiting");
                SurfaceTextureEGLSurface.this.mGLThreadManager.threadExiting(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void guardedRun() throws InterruptedException {
            try {
                PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface guardedRun begin");
                this.mEglCoreProxy = new EglCoreProxy(null, 1);
                while (true) {
                    block20: {
                        GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
                        synchronized (gLThreadManager) {
                            while (true) {
                                if (this.mShouldExit) {
                                    PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface guardedRun mShouldExit = true");
                                    return;
                                }
                                if (this.mWriteSurfaceTexture != null && (this.mEglSurface == null || this.mNeedRecreateEglSurface) && this.createEglSurface()) {
                                    this.initGLResource();
                                }
                                if (this.mWriteSurfaceTexture == null) {
                                    this.destroyElgSurface();
                                    SurfaceTextureEGLSurface.this.mGLThreadManager.notifyAll();
                                }
                                if (this.mRecordSurfaceTexture != null && this.mEglRecordSurface == null) {
                                    this.createRecordEglSurface();
                                }
                                if (this.mRecordSurfaceTexture == null && this.mEglRecordSurface != null) {
                                    this.destroyElgRecordSurface();
                                    SurfaceTextureEGLSurface.this.mGLThreadManager.notifyAll();
                                }
                                if (this.mRequestRender && this.mEglSurface != null) {
                                    this.mRequestRender = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 19, 5, 9, 10] lbl26 : MonitorExitStatement: MONITOREXIT : var1_2
                                    this.mEglCoreProxy.makeCurrent(this.mEglSurface);
                                    this.drawEglSurface();
                                    int ret = this.mEglCoreProxy.swap(this.mEglSurface);
                                    if (ret != 0) {
                                        break;
                                    }
                                    break block20;
                                }
                                SurfaceTextureEGLSurface.this.mGLThreadManager.wait();
                            }
                        }
                        PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface swap failed");
                    }
                    GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
                    synchronized (gLThreadManager) {
                        if (this.mEglRecordSurface == null) {
                            continue;
                        }
                    }
                    this.mEglCoreProxy.makeCurrent(this.mEglRecordSurface);
                    this.drawEglRecordSurface();
                    this.mEglCoreProxy.swap(this.mEglRecordSurface);
                }
            }
            finally {
                PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface guardedRun finally");
                this.releaseGLResource();
                this.destroyElgSurface();
                if (this.mEglCoreProxy != null) {
                    this.mEglCoreProxy.release();
                    this.mEglCoreProxy = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requestRender() {
            GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                SurfaceTextureEGLSurface.this.mGLThreadManager.notifyAll();
            }
        }

        private boolean createEglSurface() {
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface createEglSurface");
            if (this.mEglCoreProxy == null || this.mWriteSurfaceTexture == null) {
                return false;
            }
            if (this.mEglSurface != null) {
                PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface createEglSurface recreate");
                this.mEglCoreProxy.makeNothingCurrent();
                this.mEglCoreProxy.releaseSurface(this.mEglSurface);
                this.mEglSurface = null;
            }
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface mEglCoreProxy.createWindowSurface= " + this.mWriteSurfaceTexture);
            try {
                this.mEglSurface = this.mEglCoreProxy.createWindowSurface(this.mWriteSurfaceTexture);
            }
            catch (Throwable e) {
                PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface mEglCoreProxy.createWindowSurface failed");
            }
            if (this.mEglSurface == null || !this.mEglCoreProxy.isValid(this.mEglSurface)) {
                this.mEglSurface = null;
                return false;
            }
            this.mEglCoreProxy.makeCurrent(this.mEglSurface);
            this.mNeedRecreateEglSurface = false;
            return true;
        }

        private boolean createRecordEglSurface() {
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface createRecordEglSurface");
            if (this.mEglCoreProxy == null || this.mRecordSurfaceTexture == null) {
                return false;
            }
            if (this.mEglRecordSurface != null) {
                PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface createRecordEglSurface recreate");
                this.mEglCoreProxy.makeNothingCurrent();
                this.mEglCoreProxy.releaseSurface(this.mEglRecordSurface);
                this.mEglRecordSurface = null;
            }
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface mEglCoreProxy.createRecordEglSurface= " + this.mRecordSurfaceTexture);
            try {
                this.mEglRecordSurface = this.mEglCoreProxy.createWindowSurface(this.mRecordSurfaceTexture);
            }
            catch (Throwable e) {
                PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface createRecordEglSurface mEglCoreProxy.createWindowSurface failed");
            }
            if (this.mEglRecordSurface == null || !this.mEglCoreProxy.isValid(this.mEglRecordSurface)) {
                this.mEglRecordSurface = null;
                return false;
            }
            return true;
        }

        private void destroyElgSurface() {
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface destroyElgSurface");
            if (this.mEglSurface != null) {
                this.mEglCoreProxy.makeNothingCurrent();
                this.mEglCoreProxy.releaseSurface(this.mEglSurface);
                this.mEglSurface = null;
            }
        }

        private void destroyElgRecordSurface() {
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface destroyElgRecordSurface");
            if (this.mEglRecordSurface != null) {
                this.mEglCoreProxy.makeNothingCurrent();
                this.mEglCoreProxy.releaseSurface(this.mEglRecordSurface);
                this.mEglRecordSurface = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean initGLResource() {
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface initGLResource");
            if (!EglCoreProxy.haveEGLContext()) {
                PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface haveEGLContext error");
                return false;
            }
            if (this.mTextures == null) {
                this.mTextures = BaseGLRender.genTextures(BaseGLRender.TextureType.TEXTURE_EXTERNAL_OES);
            }
            if (this.mReadSurfaceTexture == null) {
                this.mReadSurfaceTexture = new SurfaceTexture(this.mTextures[0]);
                this.mReadSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)SurfaceTextureEGLSurface.this);
                if (SurfaceTextureEGLSurface.this.mListener != null) {
                    SurfaceTextureEGLSurface.this.mListener.onSurfaceTextureCreated(this.mReadSurfaceTexture);
                }
            } else {
                this.mReadSurfaceTexture.updateTexImage();
                PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface mReadSurfaceTexture updateTexImage");
            }
            if (this.mProgram == 0) {
                this.mProgram = GLES20.glCreateProgram();
                GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
                synchronized (gLThreadManager) {
                    if (this.mRenderListener != null) {
                        this.mRenderListener.onCreateProgram(this.mProgram);
                    }
                }
                int vertexShader = 0;
                int fragmentShader = 0;
                GLThreadManager gLThreadManager2 = SurfaceTextureEGLSurface.this.mGLThreadManager;
                synchronized (gLThreadManager2) {
                    if (this.mRenderListener != null) {
                        vertexShader = this.mRenderListener.onCreateShader(35633);
                        fragmentShader = this.mRenderListener.onCreateShader(35632);
                    }
                }
                if (vertexShader <= 0) {
                    vertexShader = BaseGLRender.createShader(35633, "uniform mat4 uTextureMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = aPosition;\n    vTextureCoord = (uTextureMatrix * aTextureCoord).xy;\n}");
                    this.mRenderFlags[0] = false;
                } else {
                    this.mRenderFlags[0] = true;
                }
                if (fragmentShader <= 0) {
                    fragmentShader = BaseGLRender.createShader(35632, "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform float brightness;\nuniform float contrast;\nuniform float saturation;\nconst mediump vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\nvoid main() {\n    vec4 textureColor = texture2D(sTexture, vTextureCoord);\n    vec4 brightnessColor = vec4((textureColor.rgb + vec3(brightness)), textureColor.w);\n    vec4 contrastColor = vec4(((brightnessColor.rgb - vec3(0.5)) * contrast + vec3(0.5)), brightnessColor.w);\n    float luminance = dot(contrastColor.rgb, luminanceWeighting);\n    vec3 greyScaleColor = vec3(luminance);\n    gl_FragColor = vec4(mix(greyScaleColor, contrastColor.rgb, saturation), contrastColor.w);\n}\n");
                    this.mRenderFlags[1] = false;
                } else {
                    this.mRenderFlags[1] = true;
                }
                GLES20.glAttachShader((int)this.mProgram, (int)vertexShader);
                GLES20.glAttachShader((int)this.mProgram, (int)fragmentShader);
                GLES20.glLinkProgram((int)this.mProgram);
                if (this.mRenderFlags[0]) {
                    gLThreadManager2 = SurfaceTextureEGLSurface.this.mGLThreadManager;
                    synchronized (gLThreadManager2) {
                        if (this.mRenderListener != null) {
                            this.mRenderListener.onDeleteShader(vertexShader);
                        }
                    }
                } else {
                    GLES20.glDeleteShader((int)vertexShader);
                }
                if (this.mRenderFlags[1]) {
                    gLThreadManager2 = SurfaceTextureEGLSurface.this.mGLThreadManager;
                    synchronized (gLThreadManager2) {
                        if (this.mRenderListener != null) {
                            this.mRenderListener.onDeleteShader(fragmentShader);
                        }
                    }
                } else {
                    GLES20.glDeleteShader((int)fragmentShader);
                }
            }
            this.mRequestRender = false;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseGLResource() {
            PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface releaseGLResource");
            this.mWriteSurfaceTexture = null;
            if (this.mProgram != 0) {
                GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
                synchronized (gLThreadManager) {
                    if (this.mRenderListener != null) {
                        this.mRenderListener.onDeleteProgram(this.mProgram);
                    }
                }
                BaseGLRender.deleteProgram(this.mProgram);
                this.mProgram = 0;
            }
            if (this.mReadSurfaceTexture != null) {
                if (SurfaceTextureEGLSurface.this.mListener != null) {
                    SurfaceTextureEGLSurface.this.mListener.onSurfaceTextureDestroyed(this.mReadSurfaceTexture);
                }
                this.mReadSurfaceTexture.release();
                this.mReadSurfaceTexture = null;
            }
            if (this.mTextures != null) {
                BaseGLRender.deleteTextures(this.mTextures);
                this.mTextures = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawEglSurface() {
            GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
            synchronized (gLThreadManager) {
                if (this.mWriteSurfaceTexture == null) {
                    return;
                }
            }
            if (this.mProgram > 0) {
                this.mReadSurfaceTexture.updateTexImage();
                this.mReadSurfaceTexture.getTransformMatrix(this.mTextureMatrix);
                BaseGLRender.clear(0.0f, 0.0f, 0.0f, 1.0f);
                if (this.mWriteSurfaceWidth > 0 && this.mWriteSurfaceHeight > 0) {
                    BaseGLRender.viewport(this.mWriteSurfaceX, this.mWriteSurfaceY, this.mWriteSurfaceWidth, this.mWriteSurfaceHeight);
                } else {
                    int width = this.mEglCoreProxy.getSurfaceWidth(this.mEglSurface);
                    int height = this.mEglCoreProxy.getSurfaceHeight(this.mEglSurface);
                    if (width > 0 && height > 0) {
                        BaseGLRender.viewport(0, 0, width, height);
                    }
                }
                BaseGLRender.useProgram(this.mProgram);
                this.drawEglSurfaceWithShader();
                if (!this.mFirstFrameAvailable && this.mDrawFrameCount > 2L) {
                    this.mFirstFrameAvailable = true;
                    PlayerLogger.d(SurfaceTextureEGLSurface.TAG, "SurfaceTextureEGLSurface drawEglSurface width = " + this.mWriteSurfaceWidth + " height = " + this.mWriteSurfaceHeight);
                    SurfaceTextureEGLSurface.this.mListener.onFirstFrameAvailable();
                }
                ++this.mDrawFrameCount;
            }
        }

        private void drawEglRecordSurface() {
            if (this.mProgram > 0) {
                BaseGLRender.clear(0.0f, 0.0f, 0.0f, 1.0f);
                int width = this.mEglCoreProxy.getSurfaceWidth(this.mEglRecordSurface);
                int height = this.mEglCoreProxy.getSurfaceHeight(this.mEglRecordSurface);
                if (width > 1 && height > 1) {
                    BaseGLRender.viewport(0, 0, width, height);
                }
                BaseGLRender.useProgram(this.mProgram);
                this.drawEglSurfaceWithShader();
                this.mEglCoreProxy.setPresentationTime(this.mEglRecordSurface, System.nanoTime());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawEglSurfaceWithShader() {
            if (this.mProgram <= 0) {
                return;
            }
            if (!this.mRenderFlags[0]) {
                BaseGLRender.vertexAttribPointer(this.mProgram, "aPosition", 2, this.mVertexs);
                BaseGLRender.vertexAttribPointer(this.mProgram, "aTextureCoord", 2, this.mTexCoords);
                BaseGLRender.uniformMatrix4fv(this.mProgram, "uTextureMatrix", this.mTextureMatrix);
            }
            if (!this.mRenderFlags[1]) {
                BaseGLRender.bindTexture(0, BaseGLRender.TextureType.TEXTURE_EXTERNAL_OES, this.mTextures[0]);
                BaseGLRender.uniformTexture(this.mProgram, "sTexture", 0);
                BaseGLRender.uniform1f(this.mProgram, "brightness", this.mBrightnessValue);
                BaseGLRender.uniform1f(this.mProgram, "contrast", this.mContrastValue);
                BaseGLRender.uniform1f(this.mProgram, "saturation", this.mSaturationValue);
            }
            if (this.mRenderFlags[0] || this.mRenderFlags[1]) {
                GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
                synchronized (gLThreadManager) {
                    if (this.mRenderListener != null) {
                        this.mRenderListener.onDraw(this.mProgram, this.mVertexs, this.mTexCoords, this.mTextureMatrix, 33984, 36197, this.mTextures[0]);
                    }
                }
            } else {
                BaseGLRender.drawArrays(false, BaseGLRender.BlendSrcType.BLEND_SRC_ONE, 4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFirstFrameAvailable() {
            GLThreadManager gLThreadManager = SurfaceTextureEGLSurface.this.mGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mFirstFrameAvailable;
            }
        }
    }

    private class GLThreadManager {
        private GLThreadManager() {
        }

        synchronized void threadExiting(GLThread thread) {
            thread.mExited = true;
            this.notifyAll();
        }
    }
}

