/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud;

import android.graphics.SurfaceTexture;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.qihoo.livecloud.play.callback.ILiveCloudDisplay;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public interface IQHVCPlayer {
    public static final int PLAYTYPE_LIVE = 0;
    public static final int PLAYTYPE_VOD = 1;
    public static final int ERROR_PREPARE_FAILED = 1001;
    public static final int ERROR_START_PLAY_FAILED = 1002;
    public static final int ERROR_FORMATNOTSUPPORT = 1003;
    public static final int ERROR_FILE_NOT_OPEN = 1004;
    public static final int ERROR_PLAYER_PLUGIN_LOAD_FAILED = 1005;
    public static final int ERROR_EXTRA_UNKNOW = 10000;
    public static final int ERROR_EXTRA_EMPTY = 10001;
    public static final int ERROR_EXTRA_PREPARE_DISPATCH_FAILED = 10002;
    public static final int ERROR_EXTRA_PLAY_SET_SESSION_FAILED = 10003;
    public static final int ERROR_EXTRA_PLAY_OPEN_URL_FAILED = 10004;
    public static final int ERROR_EXTRA_PLAY_JPLAYER_OPEN_FAILED = 10005;
    public static final int ERROR_EXTRA_PLAY_SN_FAILED = 10006;
    public static final int ERROR_EXTRA_PLAY_SUBSCRIBE_FAILED = 10007;
    public static final int ERROR_EXTRA_PLAY_UNSUPPORT_HARDWARE_DECODE = 10008;
    public static final int ERROR_EXTRA_PLAY_CONNECT_FAILED = 10009;
    public static final int ERROR_EXTRA_RECORD_ERROR = 10010;
    public static final int ERROR_EXTRA_RECORD_FILE_ERROR = 10011;
    public static final int ERROR_EXTRA_FORMAT_NOT_SUPPORT = 10012;
    public static final int INFO_PLAYER_OPEN_SUCCESS = 2000;
    public static final int INFO_LIVE_PLAY_START = 2001;
    public static final int INFO_LIVE_PLAY_SPEED = 2002;
    public static final int INFO_LIVE_PLAY_FPS = 2003;
    public static final int INFO_SESSION_CLOSED = 2004;
    public static final int INFO_CONNECT_INBACKGOURND = 2005;
    public static final int INFO_VIDEO_CACHE = 2006;
    public static final int INFO_PLAY_H265 = 2007;
    public static final int INFO_PLAYER_CLOSE = 2008;
    public static final int INFO_SEEK_FAILED = 2009;
    public static final int INFO_DEVICE_RENDER_QUERY_SURFACE = 2010;
    public static final int INFO_DEVICE_RENDER_SURFACE_CHANGE = 2011;
    public static final int INFO_DEVICE_RENDER_FIRST_FRAME = 2012;
    public static final int INFO_DEVICE_RENDER_ERR = 2013;
    public static final int INFO_RENDER_RESET_SURFACE = 2014;
    public static final int INFO_PLAYER_PLUGIN_START_DOWNLOAD = 2015;
    public static final int INFO_PLAYER_PLUGIN_DOWNLOAD_SUCCESS = 2016;
    public static final int INFO_EXTRA_EMPTY = 20001;
    public static final int INFO_EXTRA_VIDEO_CACHE_SUCCESS = 20002;
    public static final int INFO_EXTRA_VIDEO_CACHE_FAILED = 20003;
    public static final int INFO_EXTRA_H265_START_PLAY = 20004;
    public static final int INFO_EXTRA_H265_PLAY_FAILED = 20005;
    public static final String KEY_MEDIA_INFO_VIDEO_WIDTH_INT = "video_width";
    public static final String KEY_MEDIA_INFO_VIDEO_HEIGHT_INT = "video_height";
    public static final String KEY_MEDIA_INFO_VIDEO_FPS_INT = "video_fps";
    public static final String KEY_MEDIA_INFO_VIDEO_FORMAT_STRING = "video_format";
    public static final String KEY_MEDIA_INFO_AUDIO_FORMAT_STRING = "audio_format";
    public static final String KEY_MEDIA_INFO_AUDIO_CHANNEL_INT = "audio_channel";
    public static final String KEY_MEDIA_INFO_AUDIO_SAMPLE_RATE_INT = "audio_sample_rate";
    public static final String KEY_MEDIA_INFO_BITRATE_INT = "bitrate";
    public static final String KEY_MEDIA_INFO_CDN_DOWNLOAD_SPEED_LONG = "cdn_download_speed";
    public static final String KEY_MEDIA_INFO_P2P_DOWNLOAD_SPEED_LONG = "p2p_download_speed";
    public static final String KEY_MEDIA_INFO_REAL_URL_STRING = "real_play_url";

    public void setDisplay(ILiveCloudDisplay var1);

    public void setDataSource(int var1, @NonNull String var2, @NonNull String var3) throws IOException, IllegalArgumentException, IllegalStateException;

    public void setDataSource(int var1, @NonNull String var2, @NonNull String var3, @Nullable Map<String, Object> var4) throws IOException, IllegalArgumentException, IllegalStateException;

    public void prepareAsync() throws IllegalStateException;

    public void start() throws IllegalStateException;

    public boolean isPlaying();

    public void pause() throws IllegalStateException;

    public boolean isPaused();

    public void seekTo(int var1) throws IllegalStateException;

    public int getCurrentPosition();

    public int getDuration();

    public void stop() throws IllegalStateException;

    public void release();

    public void setMute(boolean var1) throws IllegalStateException;

    public boolean isMute();

    public void setVolume(float var1) throws IllegalStateException;

    public float getVolume() throws IllegalStateException;

    public void setScreenOnWhilePlaying(boolean var1);

    public int getPlayerId();

    public Map<String, Object> getMediaInformation();

    public void setOnPreparedListener(OnPreparedListener var1);

    public void setOnSeekCompleteListener(OnSeekCompleteListener var1);

    public void setOnErrorListener(OnErrorListener var1);

    public void setOnCompletionListener(OnCompletionListener var1);

    public void setOnInfoListener(OnInfoListener var1);

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener var1);

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener var1);

    public void setOnBufferingEventListener(OnBufferingEventListener var1);

    public void setOnProgressChangeListener(onProgressChangeListener var1);

    public void setSurface(String var1, SurfaceTexture var2);

    public int setSurfaceViewport(int var1, int var2, int var3, int var4);

    public int getRenderMode();

    public static interface onProgressChangeListener {
        public void onProgressChange(int var1, int var2, int var3);
    }

    public static interface OnBufferingEventListener {
        public void onBufferingStart(int var1);

        public void onBufferingProgress(int var1, int var2);

        public void onBufferingStop(int var1);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(int var1, int var2);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(int var1, int var2, int var3);
    }

    public static interface OnInfoListener {
        public void onInfo(int var1, int var2, int var3);
    }

    public static interface OnCompletionListener {
        public void onCompletion(int var1);
    }

    public static interface OnErrorListener {
        public boolean onError(int var1, int var2, int var3);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(int var1);
    }

    public static interface OnPreparedListener {
        public void onPrepared();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaInfoKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InfoExtra {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Info {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorExtra {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Error {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayType {
    }
}

