/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud;

import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.Surface;
import com.qihoo.livecloud.play.RecordConfig;
import com.qihoo.livecloud.play.callback.ILiveCloudDisplay;
import com.qihoo.livecloud.utils.PlayerLogger;
import com.qihoo.videocloud.IQHVCPlayer;
import com.qihoo.videocloud.IQHVCPlayerAdvanced;
import com.qihoo.videocloud.view.QHVCTextureView;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;

final class MediaPlayerWrapper
implements IQHVCPlayerAdvanced {
    private static final String TAG = "MediaPlayerWrapper";
    private final ReentrantLock mMediaPlayerLock = new ReentrantLock();
    private MediaPlayer mMediaPlayer;
    private boolean mPreparing = false;
    private static final int STATE_IDLE = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_PREPARING = 2;
    private static final int STATE_PREPARED = 3;
    private static final int STATE_STARTED = 4;
    private static final int STATE_PAUSED = 5;
    private static final int STATE_STOPPED = 6;
    private static final int STATE_PLAYBACK_COMPLETED = 7;
    private static final int STATE_END = 8;
    private static final int STATE_ERROR = 9;
    private static final String[] PLAYER_STATES = new String[]{"IDLE", "INITIALIZED", "PREPARING", "PREPARED", "STARTED", "PAUSED", "STOPPED", "PLAYBACK_COMPLETED", "END", "ERROR"};
    private int mPlayerState = 0;
    private String mPlayerStateStr = PLAYER_STATES[0];
    private boolean mMute = false;
    private float mVolume = 1.0f;
    private int mPlayerId = 0;
    private int mSeekToInitValue = 0;
    private boolean mPlayedAtLeastOnce = false;
    private int mRenderMode = 0;
    private SurfaceTexture mSurfaceTextCache = null;
    private Surface mSurface = null;
    private final ReentrantLock mHandlerLock = new ReentrantLock();
    private EventHandler mHandler;
    private Timer mTimer;
    private TimerTask mTimerTask;
    private boolean mQueryPlayingPosition = false;
    private static final int CONSTANT_MSG_QUERY_PLAYING_POSITION_DELAY = 200;
    private boolean mNotifyVideoRenderingMsg = false;
    private volatile boolean mReceiveRenderMsg = false;
    private volatile boolean mVideoBuffering = true;
    private static final int MSG_SIMULATE__MEDIA_INFO_VIDEO_RENDERING_START = 1000;
    private static final int MSG_QUERY_PLAYING_POSITION = 1001;
    private static final int MSG_PROGRESS_CHANGE = 1002;
    private IQHVCPlayer.OnPreparedListener mOnPreparedListener;
    private IQHVCPlayer.OnSeekCompleteListener mOnSeekCompleteListener;
    private IQHVCPlayer.OnErrorListener mOnErrorListener;
    private IQHVCPlayer.OnCompletionListener mOnCompletionListener;
    private IQHVCPlayer.OnInfoListener mOnInfoListener;
    private IQHVCPlayer.OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private IQHVCPlayer.OnBufferingUpdateListener mOnBufferingUpdateListener;
    private IQHVCPlayer.onProgressChangeListener mOnProgressChangeListener;
    private IQHVCPlayer.OnBufferingEventListener mOnBufferingEventListener;
    private IQHVCPlayerAdvanced.OnAudioPCMListener mOnAudioPCMListener;
    private IQHVCPlayerAdvanced.OnPlayerNetStatsListener mOnPlayerNetStatsListener;

    protected MediaPlayerWrapper() {
        this.mMediaPlayerLock.lock();
        try {
            PlayerLogger.i(TAG, "MediaPlayerWrapper construction");
            this.mMediaPlayer = new MediaPlayer();
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataSource(int playType, @NonNull String sn, @NonNull String channelId, @NonNull String sign, @Nullable Map<String, Object> options) throws IOException, IllegalArgumentException, IllegalStateException {
        PlayerLogger.i(TAG, "setDataSource sn=" + sn + " playType=" + this.playTypeStr(playType));
        if (playType != 1) {
            throw new IllegalArgumentException("playType != IQHVCPlayerAdvanced.PLAYTYPE_VOD");
        }
        if (TextUtils.isEmpty((CharSequence)sn)) {
            throw new IllegalArgumentException("sn is empty!!!");
        }
        this.mMediaPlayerLock.lock();
        try {
            if (this.mMediaPlayer == null) {
                throw new IllegalStateException("mMediaPlayer == null");
            }
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
        if (options != null && !options.isEmpty()) {
            int tmp;
            PlayerLogger.i(TAG, options.toString());
            Object obj = options.get("position");
            if (obj != null && obj instanceof Integer) {
                if (playType == 1) {
                    this.mSeekToInitValue = (Integer)obj;
                } else {
                    PlayerLogger.e(TAG, "set data source. option position invalid!");
                }
            }
            if ((obj = options.get("positionAccurate")) != null && obj instanceof Boolean) {
                PlayerLogger.w(TAG, "seekTo accurate not support!");
            }
            if ((obj = options.get("scheduleUrl")) != null && obj instanceof String) {
                PlayerLogger.w(TAG, "schedule not support!");
            }
            if ((obj = options.get("renderMode")) != null && obj instanceof Integer && (tmp = ((Integer)obj).intValue()) >= 0 && tmp <= 2) {
                this.mRenderMode = tmp;
            }
            if ((obj = options.get("playMode")) != null && obj instanceof Integer) {
                PlayerLogger.w(TAG, "play mode not support!");
            }
            if ((obj = options.get("mute")) != null && obj instanceof Boolean) {
                this.mMute = (Boolean)obj;
            }
            if ((obj = options.get("streamType")) != null && obj instanceof String) {
                PlayerLogger.w(TAG, "stream type not support!");
            }
            if ((obj = options.get("previewDuration")) != null && obj instanceof Integer) {
                PlayerLogger.w(TAG, "preview duration not support!");
            }
            if ((obj = options.get("decodeMode")) != null && obj instanceof Integer) {
                PlayerLogger.w(TAG, "decode mode not support!");
            }
        }
        this.mMediaPlayerLock.lock();
        try {
            int state = this.getPlayerState();
            if (this.mMediaPlayer != null && state == 0) {
                this.mMediaPlayer.setDataSource(sn);
                this.setPlayerState(1);
            } else {
                PlayerLogger.w(TAG, "do not setDataSource. state: " + this.mPlayerStateStr);
            }
        }
        catch (IllegalStateException e) {
            PlayerLogger.w(TAG, e != null ? e.getMessage() : "");
            throw e;
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
    }

    @Override
    public void setDataSource(int playType, @NonNull String[] rids, @NonNull String[] sources, int defaultIndex, @NonNull String channelId, @NonNull String sign, @Nullable Map<String, Object> options) throws IOException, IllegalArgumentException, IllegalStateException {
        if (rids == null || sources == null) {
            throw new IllegalArgumentException("rid or sn is null");
        }
        if (rids.length != sources.length) {
            throw new IllegalArgumentException("rid.length != sn.length");
        }
        if (defaultIndex < 0 || defaultIndex >= sources.length) {
            throw new IllegalArgumentException("defaultIndex < 0 || defaultIndex >= sources.length");
        }
        this.setDataSource(playType, sources[defaultIndex], channelId, sign, options);
    }

    @Override
    public boolean snapshot(String path) {
        PlayerLogger.w(TAG, "snapshot not support.");
        return false;
    }

    @Override
    public int getDecoderMode() {
        PlayerLogger.w(TAG, "getDecoderMode");
        return 11;
    }

    @Override
    public void disableRender(boolean isRender) throws IllegalStateException {
        PlayerLogger.w(TAG, "disableRender not support. " + isRender);
        throw new IllegalStateException("disableRender not support. " + isRender);
    }

    @Override
    public void seekTo(int millis, boolean accurate) throws IllegalStateException {
        PlayerLogger.w(TAG, "seekTo(not support accurate). " + millis + " " + accurate);
        this.seekTo(millis);
    }

    @Override
    public void setPlayBackRate(float rate) throws IllegalStateException {
        PlayerLogger.w(TAG, "setPlayBackRate not support.");
        throw new IllegalStateException("setPlayBackRate not support. " + rate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stop(int reason) throws IllegalStateException {
        PlayerLogger.d(TAG, "stop. " + reason);
        int state = this.getPlayerState();
        if (this.mMediaPlayer != null && state != 0 && state != 1 && state != 2 && state != 9) {
            this.mMediaPlayerLock.lock();
            try {
                if (this.mMediaPlayer == null) return;
                this.mMediaPlayer.stop();
                this.setPlayerState(6);
                return;
            }
            catch (IllegalStateException e) {
                PlayerLogger.w(TAG, e != null ? e.getMessage() : "");
                throw e;
            }
            finally {
                this.mMediaPlayerLock.unlock();
            }
        } else {
            PlayerLogger.w(TAG, "do not stop. state: " + this.mPlayerStateStr);
        }
    }

    @Override
    public int addToGroup(int group) {
        PlayerLogger.w(TAG, "addToGroup not support.");
        return -1;
    }

    @Override
    public void setDisplay(ILiveCloudDisplay display) {
        PlayerLogger.d(TAG, "setDisplay.");
        if (display != null && display instanceof QHVCTextureView) {
            QHVCTextureView textureView = (QHVCTextureView)display;
            if (textureView.isAvailable()) {
                this.setSurface("setDisplay", textureView.getSurfaceTexture());
            } else {
                PlayerLogger.w(TAG, "textureView not isAvailable.");
            }
        } else {
            PlayerLogger.w(TAG, "display: " + (display == null ? "" : display.toString()));
        }
    }

    @Override
    public void setDataSource(int playType, @NonNull String url, @NonNull String channelId) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(playType, url, channelId, null, null);
    }

    @Override
    public void setOnPlayerNetStatsListener(IQHVCPlayerAdvanced.OnPlayerNetStatsListener listener) {
        PlayerLogger.w(TAG, "setOnPlayerNetStatsListener not support.");
        this.mOnPlayerNetStatsListener = listener;
    }

    @Override
    public void setDataSource(int playType, @NonNull String url, @NonNull String channelId, @Nullable Map<String, Object> options) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(playType, url, channelId, null, options);
    }

    @Override
    public void setOnAudioPCMListener(IQHVCPlayerAdvanced.OnAudioPCMListener listener) {
        PlayerLogger.w(TAG, "setOnAudioPCMListener not support.");
        this.mOnAudioPCMListener = listener;
    }

    @Override
    public void prepareAsync() throws IllegalStateException {
        PlayerLogger.d(TAG, "prepareAsync.");
        int state = this.getPlayerState();
        if (this.mMediaPlayer != null && state != 0 && state != 2 && state != 3 && state != 4 && state != 5 && state != 7 && state != 9) {
            this.mMediaPlayerLock.lock();
            try {
                if (this.mMediaPlayer != null) {
                    this.mMediaPlayer.prepareAsync();
                    this.setPlayerState(2);
                    this.mPreparing = true;
                }
            }
            catch (IllegalStateException e) {
                PlayerLogger.w(TAG, e != null ? e.getMessage() : "");
                throw e;
            }
            finally {
                this.mMediaPlayerLock.unlock();
            }
            this.initListener();
        } else {
            PlayerLogger.w(TAG, "do not prepareAsync. state: " + this.mPlayerStateStr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start() throws IllegalStateException {
        PlayerLogger.d(TAG, "start.");
        int state = this.getPlayerState();
        if (this.mMediaPlayer != null && state != 0 && state != 1 && state != 2 && state != 6 && state != 9) {
            this.mMediaPlayerLock.lock();
            try {
                if (this.mMediaPlayer == null) return;
                this.mMediaPlayer.start();
                this.setPlayerState(4);
                this.mPlayedAtLeastOnce = true;
                this.startTimer();
                return;
            }
            catch (IllegalStateException e) {
                PlayerLogger.w(TAG, e != null ? e.getMessage() : "");
                throw e;
            }
            finally {
                this.mMediaPlayerLock.unlock();
            }
        } else {
            PlayerLogger.w(TAG, "do not start. state: " + this.mPlayerStateStr);
        }
    }

    @Override
    public boolean isPlaying() {
        int state = this.getPlayerState();
        if (this.mMediaPlayer != null && state != 2 && state != 9) {
            this.mMediaPlayerLock.lock();
            try {
                if (this.mMediaPlayer != null) {
                    boolean bl = this.mMediaPlayer.isPlaying();
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IllegalStateException e) {
                PlayerLogger.w(TAG, e.getMessage());
            }
            finally {
                this.mMediaPlayerLock.unlock();
            }
        } else {
            PlayerLogger.w(TAG, "do not isPlaying. state: " + this.mPlayerStateStr);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void pause() throws IllegalStateException {
        PlayerLogger.d(TAG, "pause.");
        int state = this.getPlayerState();
        if (this.mMediaPlayer != null && state != 0 && state != 1 && state != 2 && state != 3 && state != 6 && state != 9) {
            this.mMediaPlayerLock.lock();
            try {
                if (this.mMediaPlayer == null) return;
                this.mMediaPlayer.pause();
                this.setPlayerState(5);
                return;
            }
            catch (IllegalStateException e) {
                PlayerLogger.w(TAG, e != null ? e.getMessage() : "");
                throw e;
            }
            finally {
                this.mMediaPlayerLock.unlock();
            }
        } else {
            PlayerLogger.w(TAG, "do not pause. state: " + this.mPlayerStateStr);
        }
    }

    @Override
    public boolean isPaused() {
        PlayerLogger.d(TAG, "isPaused.");
        return !this.isPlaying() && this.getCurrentPosition() > 1 && this.mPlayedAtLeastOnce;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void seekTo(int millis) throws IllegalStateException {
        PlayerLogger.d(TAG, "seekTo. " + millis);
        int state = this.getPlayerState();
        if (this.mMediaPlayer != null && state != 0 && state != 1 && state != 2 && state != 6 && state != 9) {
            this.mMediaPlayerLock.lock();
            try {
                if (this.mMediaPlayer == null) return;
                PlayerLogger.d(TAG, "do seekTo.");
                this.mMediaPlayer.seekTo(millis);
                if (this.getPlayerState() != 7) return;
                this.start();
                return;
            }
            catch (IllegalStateException e) {
                PlayerLogger.w(TAG, e != null ? e.getMessage() : "");
                throw e;
            }
            finally {
                this.mMediaPlayerLock.unlock();
            }
        } else {
            PlayerLogger.w(TAG, "do not seekTo. state: " + this.mPlayerStateStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentPosition() {
        int state = this.getPlayerState();
        if (this.mMediaPlayer != null && state != 2 && state != 9) {
            this.mMediaPlayerLock.lock();
            try {
                if (this.mMediaPlayer != null) {
                    int n = this.mMediaPlayer.getCurrentPosition();
                    return n;
                }
                int n = 0;
                return n;
            }
            catch (Exception e) {
                PlayerLogger.e(TAG, e.getMessage());
                int n = -1;
                return n;
            }
            finally {
                this.mMediaPlayerLock.unlock();
            }
        }
        PlayerLogger.w(TAG, "do not getCurrentPosition. state: " + this.mPlayerStateStr);
        return 0;
    }

    @Override
    public int startRecorder(String filePath, String fmt, RecordConfig config, IQHVCPlayerAdvanced.OnRecordListener listener) {
        PlayerLogger.w(TAG, "startRecorder not support.");
        return -1;
    }

    @Override
    public int getDuration() {
        int state = this.getPlayerState();
        if (this.mMediaPlayer != null && state != 0 && state != 1 && state != 2 && state != 9) {
            this.mMediaPlayerLock.lock();
            try {
                if (this.mMediaPlayer != null) {
                    int n = this.mMediaPlayer.getDuration();
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                this.mMediaPlayerLock.unlock();
            }
        }
        PlayerLogger.w(TAG, "do not getDuration. state: " + this.mPlayerStateStr);
        return 0;
    }

    @Override
    public void stop() throws IllegalStateException {
        this.stop(0);
    }

    @Override
    public int stopRecorder() {
        PlayerLogger.w(TAG, "stopRecorder not support.");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        PlayerLogger.d(TAG, "release.");
        this.mMediaPlayerLock.lock();
        try {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.release();
                this.mMediaPlayer = null;
            }
            this.setPlayerState(8);
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
        this.stopTimer();
        this.mHandlerLock.lock();
        try {
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler = null;
            }
        }
        finally {
            this.mHandlerLock.unlock();
        }
        this.mMute = false;
        this.mVolume = 1.0f;
        this.mPlayerId = 0;
        this.mSeekToInitValue = 0;
        this.mPlayedAtLeastOnce = false;
        this.mNotifyVideoRenderingMsg = false;
        this.mQueryPlayingPosition = false;
        this.mReceiveRenderMsg = false;
        this.mVideoBuffering = true;
        this.mRenderMode = 0;
        MediaPlayerWrapper mediaPlayerWrapper = this;
        synchronized (mediaPlayerWrapper) {
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
            this.mSurfaceTextCache = null;
        }
    }

    @Override
    public void setMute(boolean mute) throws IllegalStateException {
        PlayerLogger.d(TAG, "setMute. " + mute);
        int state = this.getPlayerState();
        this.mMediaPlayerLock.lock();
        try {
            if (this.mMediaPlayer != null && state != 2 && state != 9) {
                this.mMute = mute;
                if (mute) {
                    this.mMediaPlayer.setVolume(0.0f, 0.0f);
                } else {
                    this.mMediaPlayer.setVolume(this.mVolume, this.mVolume);
                }
            } else {
                PlayerLogger.w(TAG, "do not setMute. state: " + this.mPlayerStateStr);
            }
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
    }

    @Override
    public void switchResolution(int index, IQHVCPlayerAdvanced.QHVCSwitchResolutionListener listener) {
        PlayerLogger.w(TAG, "switchResolution not support.");
    }

    @Override
    public boolean isMute() {
        PlayerLogger.d(TAG, "isMute.");
        return this.mMute;
    }

    @Override
    public void setVolume(@FloatRange(from=0.0, to=1.0) float volume) throws IllegalStateException {
        PlayerLogger.d(TAG, "setVolume. " + volume);
        this.mMediaPlayerLock.lock();
        try {
            int state = this.getPlayerState();
            if (this.mMediaPlayer != null && state != 9) {
                this.mVolume = volume;
                this.mMediaPlayer.setVolume(volume, volume);
            } else {
                PlayerLogger.w(TAG, "do not setVolume. state: " + this.mPlayerStateStr);
            }
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
    }

    @Override
    public int switchResolutionStop(String reason) {
        PlayerLogger.w(TAG, "switchResolutionStop not support.");
        return -1;
    }

    @Override
    public int setResolutionAdapt(boolean isAdapt, IQHVCPlayerAdvanced.QHVCSwitchResolutionListener listener) {
        PlayerLogger.w(TAG, "setResolutionAdapt not support.");
        return -1;
    }

    @Override
    public float getVolume() throws IllegalStateException {
        PlayerLogger.d(TAG, "getVolume. ");
        this.mMediaPlayerLock.lock();
        try {
            if (this.mMediaPlayer != null) {
                float f = this.mVolume;
                return f;
            }
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
        return 0.0f;
    }

    @Override
    public void setScreenOnWhilePlaying(boolean screenOn) {
        PlayerLogger.d(TAG, "setScreenOnWhilePlaying. " + screenOn);
        this.mMediaPlayerLock.lock();
        try {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setScreenOnWhilePlaying(screenOn);
            }
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
    }

    @Override
    public int getPlayerId() {
        this.mMediaPlayerLock.lock();
        try {
            if (this.mMediaPlayer != null && this.mPlayerId == 0) {
                this.mPlayerId = this.mMediaPlayer.hashCode();
                PlayerLogger.d(TAG, "getPlayerId. " + this.mPlayerId);
            }
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
        return this.mPlayerId;
    }

    @Override
    public Map<String, Object> getMediaInformation() {
        PlayerLogger.w(TAG, "getMediaInformation not support.");
        return null;
    }

    @Override
    public void setOnPreparedListener(IQHVCPlayer.OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
    }

    @Override
    public void setOnSeekCompleteListener(IQHVCPlayer.OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
    }

    @Override
    public void setOnErrorListener(IQHVCPlayer.OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    @Override
    public void setOnCompletionListener(IQHVCPlayer.OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
    }

    @Override
    public void setOnInfoListener(IQHVCPlayer.OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    @Override
    public void setOnVideoSizeChangedListener(IQHVCPlayer.OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
    }

    @Override
    public void setOnBufferingUpdateListener(IQHVCPlayer.OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
    }

    @Override
    public void setOnBufferingEventListener(IQHVCPlayer.OnBufferingEventListener listener) {
        this.mOnBufferingEventListener = listener;
    }

    @Override
    public void setOnProgressChangeListener(IQHVCPlayer.onProgressChangeListener listener) {
        this.mOnProgressChangeListener = listener;
    }

    @Override
    public void setSurfaceRenderListener(IQHVCPlayerAdvanced.SurfaceRenderListener surfaceRenderListener) {
        PlayerLogger.w(TAG, "setSurfaceRenderListener not support.");
    }

    @Override
    public void setSurface(String from, SurfaceTexture texture) {
        PlayerLogger.d(TAG, "setSurface. " + from + " " + texture);
        this.mMediaPlayerLock.lock();
        try {
            if (this.mMediaPlayer != null) {
                if (texture != null) {
                    if (texture != this.mSurfaceTextCache) {
                        this.mSurfaceTextCache = texture;
                        if (this.mSurface != null) {
                            this.mSurface.release();
                            this.mSurface = null;
                        }
                    }
                    if (this.mSurface == null) {
                        this.mSurface = new Surface(texture);
                    }
                    this.mMediaPlayer.setSurface(this.mSurface);
                } else {
                    this.mMediaPlayer.setSurface(null);
                }
            }
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
    }

    @Override
    public int setSurfaceViewport(int x, int y, int width, int height) {
        PlayerLogger.w(TAG, "setSurfaceViewport not support. " + x + " " + y + " " + width + " " + height);
        return -1;
    }

    @Override
    public int getRenderMode() {
        return this.mRenderMode;
    }

    @Override
    public boolean isSystemMediaPlayer() {
        return true;
    }

    @Override
    public int getPropertyRotate() {
        return 0;
    }

    @Override
    public void enableP2P(boolean enable) {
        PlayerLogger.w(TAG, "enableP2P not support.");
    }

    @Override
    public void setFilterValues(float brightness, float contrast, float saturation) {
        PlayerLogger.w(TAG, "setFilterValues not support. " + brightness + " " + contrast + " " + saturation);
    }

    private void initListener() {
        this.mMediaPlayerLock.lock();
        try {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    public void onPrepared(MediaPlayer mp) {
                        PlayerLogger.d(MediaPlayerWrapper.TAG, "onPrepared");
                        MediaPlayerWrapper.this.setPlayerState(3);
                        MediaPlayerWrapper.this.mPreparing = false;
                        if (MediaPlayerWrapper.this.mSeekToInitValue > 0) {
                            MediaPlayerWrapper.this.seekTo(MediaPlayerWrapper.this.mSeekToInitValue);
                        }
                        if (MediaPlayerWrapper.this.mMute) {
                            MediaPlayerWrapper.this.setMute(MediaPlayerWrapper.this.mMute);
                        }
                        if (MediaPlayerWrapper.this.mOnPreparedListener != null) {
                            MediaPlayerWrapper.this.mOnPreparedListener.onPrepared();
                        }
                    }
                });
                this.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

                    public void onSeekComplete(MediaPlayer mp) {
                        PlayerLogger.d(MediaPlayerWrapper.TAG, "onSeekComplete");
                        if (MediaPlayerWrapper.this.mOnSeekCompleteListener != null) {
                            MediaPlayerWrapper.this.mOnSeekCompleteListener.onSeekComplete(MediaPlayerWrapper.this.getPlayerId());
                        }
                    }
                });
                this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        PlayerLogger.d(MediaPlayerWrapper.TAG, "onCompletion");
                        if (MediaPlayerWrapper.this.getPlayerState() != 9) {
                            MediaPlayerWrapper.this.setPlayerState(7);
                            if (MediaPlayerWrapper.this.mOnCompletionListener != null) {
                                MediaPlayerWrapper.this.mOnCompletionListener.onCompletion(MediaPlayerWrapper.this.getPlayerId());
                            }
                        } else {
                            PlayerLogger.w(MediaPlayerWrapper.TAG, "in error state receive complete msg, do nothing.");
                        }
                    }
                });
                this.mMediaPlayer.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                    public boolean onInfo(MediaPlayer mp, int what, int extra) {
                        PlayerLogger.d(MediaPlayerWrapper.TAG, "onInfo. what: " + what + " extra: " + extra);
                        switch (what) {
                            case 3: {
                                if (MediaPlayerWrapper.this.mVideoBuffering) {
                                    PlayerLogger.i(MediaPlayerWrapper.TAG, "receive MEDIA_INFO_VIDEO_RENDERING_START onBufferingStop");
                                    MediaPlayerWrapper.this.mVideoBuffering = false;
                                    if (MediaPlayerWrapper.this.mOnBufferingEventListener != null) {
                                        MediaPlayerWrapper.this.mOnBufferingEventListener.onBufferingStop(MediaPlayerWrapper.this.getPlayerId());
                                    }
                                }
                                if (MediaPlayerWrapper.this.mReceiveRenderMsg) break;
                                MediaPlayerWrapper.this.mReceiveRenderMsg = true;
                                if (MediaPlayerWrapper.this.mOnInfoListener == null) break;
                                PlayerLogger.i(MediaPlayerWrapper.TAG, "live first start.");
                                MediaPlayerWrapper.this.mOnInfoListener.onInfo(MediaPlayerWrapper.this.getPlayerId(), 2001, 20001);
                                PlayerLogger.i(MediaPlayerWrapper.TAG, "device render first frame.");
                                MediaPlayerWrapper.this.mOnInfoListener.onInfo(MediaPlayerWrapper.this.getPlayerId(), 2012, 20001);
                                break;
                            }
                            case 701: {
                                MediaPlayerWrapper.this.mVideoBuffering = true;
                                if (MediaPlayerWrapper.this.mOnBufferingEventListener == null) break;
                                MediaPlayerWrapper.this.mOnBufferingEventListener.onBufferingStart(MediaPlayerWrapper.this.getPlayerId());
                                break;
                            }
                            case 702: {
                                if (!MediaPlayerWrapper.this.mVideoBuffering) break;
                                MediaPlayerWrapper.this.mVideoBuffering = false;
                                if (MediaPlayerWrapper.this.mOnBufferingEventListener == null) break;
                                MediaPlayerWrapper.this.mOnBufferingEventListener.onBufferingStop(MediaPlayerWrapper.this.getPlayerId());
                                break;
                            }
                            default: {
                                if (MediaPlayerWrapper.this.mOnInfoListener == null) break;
                                MediaPlayerWrapper.this.mOnInfoListener.onInfo(MediaPlayerWrapper.this.getPlayerId(), what, extra);
                            }
                        }
                        return true;
                    }
                });
                this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                    public boolean onError(MediaPlayer mp, int what, int extra) {
                        PlayerLogger.w(MediaPlayerWrapper.TAG, "onError. what: " + what + " extra: " + extra);
                        MediaPlayerWrapper.this.setPlayerState(9);
                        if (MediaPlayerWrapper.this.mOnErrorListener != null) {
                            return MediaPlayerWrapper.this.mOnErrorListener.onError(MediaPlayerWrapper.this.getPlayerId(), what, extra);
                        }
                        return false;
                    }
                });
                this.mMediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

                    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                        PlayerLogger.d(MediaPlayerWrapper.TAG, "onVideoSizeChanged. width: " + width + " height: " + height);
                        if (MediaPlayerWrapper.this.mOnVideoSizeChangedListener != null) {
                            MediaPlayerWrapper.this.mOnVideoSizeChangedListener.onVideoSizeChanged(MediaPlayerWrapper.this.getPlayerId(), width, height);
                        }
                    }
                });
                this.mMediaPlayer.setOnBufferingUpdateListener(new MediaPlayer.OnBufferingUpdateListener(){

                    public void onBufferingUpdate(MediaPlayer mp, int percent) {
                        PlayerLogger.d(MediaPlayerWrapper.TAG, "onBufferingUpdate. percent: " + percent);
                        if (MediaPlayerWrapper.this.mOnBufferingUpdateListener != null) {
                            if (percent < 0) {
                                percent = 0;
                            } else if (percent > 100) {
                                percent = 100;
                            }
                            if (MediaPlayerWrapper.this.mPreparing && percent == 100) {
                                PlayerLogger.w(MediaPlayerWrapper.TAG, "onBufferingUpdate(100) invoked while in preparing state - ignoring");
                            } else {
                                MediaPlayerWrapper.this.mOnBufferingUpdateListener.onBufferingUpdate(MediaPlayerWrapper.this.getPlayerId(), percent);
                            }
                        }
                    }
                });
            }
        }
        finally {
            this.mMediaPlayerLock.unlock();
        }
    }

    private void startTimer() {
        if (this.mTimer != null && this.mTimerTask != null) {
            return;
        }
        this.mHandlerLock.lock();
        try {
            this.mHandler = new EventHandler(Looper.getMainLooper());
        }
        finally {
            this.mHandlerLock.unlock();
        }
        this.mTimer = new Timer();
        this.mTimerTask = new TimerTask(){

            @Override
            public void run() {
                if (MediaPlayerWrapper.this.mHandler != null && MediaPlayerWrapper.this.isPlaying()) {
                    int duration = MediaPlayerWrapper.this.getDuration();
                    int position = MediaPlayerWrapper.this.getCurrentPosition();
                    if (duration > 0 && position >= 0) {
                        MediaPlayerWrapper.this.simulateMediaPlayerMsg(duration, position);
                        if (MediaPlayerWrapper.this.mOnProgressChangeListener != null) {
                            MediaPlayerWrapper.this.mHandlerLock.lock();
                            try {
                                if (MediaPlayerWrapper.this.mHandler != null) {
                                    MediaPlayerWrapper.this.mHandler.obtainMessage(1002, duration, position).sendToTarget();
                                }
                            }
                            finally {
                                MediaPlayerWrapper.this.mHandlerLock.unlock();
                            }
                        }
                    }
                }
            }
        };
        this.mTimer.scheduleAtFixedRate(this.mTimerTask, 0L, 1000L);
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void simulateMediaPlayerMsg(int duration, int position) {
        if (Build.VERSION.SDK_INT >= 17) return;
        if (position > 0) {
            if (this.mNotifyVideoRenderingMsg) return;
            this.mNotifyVideoRenderingMsg = true;
            if (this.mOnInfoListener == null) return;
            this.mHandlerLock.lock();
            try {
                if (this.mHandler == null) return;
                PlayerLogger.i(TAG, "query video rending status start. position: " + position);
                this.mHandler.obtainMessage(1000).sendToTarget();
                return;
            }
            finally {
                this.mHandlerLock.unlock();
            }
        }
        if (this.mNotifyVideoRenderingMsg || this.mQueryPlayingPosition) return;
        this.mQueryPlayingPosition = true;
        this.mHandlerLock.lock();
        try {
            if (this.mHandler == null) return;
            PlayerLogger.i(TAG, "query playing position start.");
            this.mHandler.sendEmptyMessageDelayed(1001, 200L);
            return;
        }
        finally {
            this.mHandlerLock.unlock();
        }
    }

    private synchronized int getPlayerState() {
        return this.mPlayerState;
    }

    private synchronized void setPlayerState(int playerState) {
        this.mPlayerState = playerState;
        this.mPlayerStateStr = this.getPlayerStateStr(playerState);
        PlayerLogger.i(TAG, "setPlayerState: " + this.mPlayerStateStr);
    }

    private String getPlayerStateStr(int playerState) {
        if (playerState >= 0 && playerState < PLAYER_STATES.length) {
            return PLAYER_STATES[playerState];
        }
        return "";
    }

    private String playTypeStr(int playType) {
        String ptStr = "LIVE";
        if (playType == 1) {
            ptStr = "VOD";
        }
        return ptStr;
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    PlayerLogger.i(MediaPlayerWrapper.TAG, "receive MSG_SIMULATE__MEDIA_INFO_VIDEO_RENDERING_START.");
                    if (MediaPlayerWrapper.this.mVideoBuffering) {
                        PlayerLogger.i(MediaPlayerWrapper.TAG, "receive MSG_SIMULATE__MEDIA_INFO_VIDEO_RENDERING_START onBufferingStop");
                        MediaPlayerWrapper.this.mVideoBuffering = false;
                        if (MediaPlayerWrapper.this.mOnBufferingEventListener != null) {
                            MediaPlayerWrapper.this.mOnBufferingEventListener.onBufferingStop(MediaPlayerWrapper.this.getPlayerId());
                        }
                    }
                    if (MediaPlayerWrapper.this.mReceiveRenderMsg) break;
                    MediaPlayerWrapper.this.mReceiveRenderMsg = true;
                    if (MediaPlayerWrapper.this.mOnInfoListener == null) break;
                    PlayerLogger.i(MediaPlayerWrapper.TAG, "[simulate] live first start.");
                    MediaPlayerWrapper.this.mOnInfoListener.onInfo(MediaPlayerWrapper.this.getPlayerId(), 2001, 20001);
                    PlayerLogger.i(MediaPlayerWrapper.TAG, "[simulate] device render first frame.");
                    MediaPlayerWrapper.this.mOnInfoListener.onInfo(MediaPlayerWrapper.this.getPlayerId(), 2012, 20001);
                    break;
                }
                case 1002: {
                    PlayerLogger.d(MediaPlayerWrapper.TAG, "onProgressChange. state: " + MediaPlayerWrapper.this.mPlayerStateStr + " duration : " + msg.arg1 + " position : " + msg.arg2);
                    if (MediaPlayerWrapper.this.mOnProgressChangeListener == null) break;
                    MediaPlayerWrapper.this.mOnProgressChangeListener.onProgressChange(MediaPlayerWrapper.this.getPlayerId(), msg.arg1, msg.arg2);
                    break;
                }
                case 1001: {
                    PlayerLogger.i(MediaPlayerWrapper.TAG, "query playing position.(for notify MEDIA_INFO_VIDEO_RENDERING_START)");
                    if (MediaPlayerWrapper.this.mNotifyVideoRenderingMsg) break;
                    if (MediaPlayerWrapper.this.isPlaying()) {
                        int duration = MediaPlayerWrapper.this.getDuration();
                        int position = MediaPlayerWrapper.this.getCurrentPosition();
                        if (duration > 0 && position > 0) {
                            MediaPlayerWrapper.this.mNotifyVideoRenderingMsg = true;
                            MediaPlayerWrapper.this.mHandlerLock.lock();
                            try {
                                if (MediaPlayerWrapper.this.mHandler == null) break;
                                PlayerLogger.i(MediaPlayerWrapper.TAG, "duration: " + duration + " position: " + position);
                                MediaPlayerWrapper.this.mHandler.sendEmptyMessage(1000);
                                break;
                            }
                            finally {
                                MediaPlayerWrapper.this.mHandlerLock.unlock();
                            }
                        }
                        MediaPlayerWrapper.this.mHandlerLock.lock();
                        try {
                            if (MediaPlayerWrapper.this.mHandler == null) break;
                            MediaPlayerWrapper.this.mHandler.sendEmptyMessageDelayed(1001, 200L);
                            break;
                        }
                        finally {
                            MediaPlayerWrapper.this.mHandlerLock.unlock();
                        }
                    }
                    MediaPlayerWrapper.this.mHandlerLock.lock();
                    try {
                        if (MediaPlayerWrapper.this.mHandler == null) break;
                        MediaPlayerWrapper.this.mHandler.removeMessages(1001);
                        break;
                    }
                    finally {
                        MediaPlayerWrapper.this.mHandlerLock.unlock();
                    }
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface MediaPlayerState {
    }
}

