/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.Surface;
import com.qihoo.livecloud.config.PlayerSettings;
import com.qihoo.livecloud.play.AudioInfo;
import com.qihoo.livecloud.play.PlayerControl;
import com.qihoo.livecloud.play.RecordConfig;
import com.qihoo.livecloud.play.callback.ILiveCloudDisplay;
import com.qihoo.livecloud.play.callback.PlayerCallback;
import com.qihoo.livecloud.play.jni.JPlayer;
import com.qihoo.livecloud.recorder.hc.QHVCRecorderSDK;
import com.qihoo.livecloud.sdk.QHVCSdk;
import com.qihoo.livecloud.sdk.QHVCSdkConfig;
import com.qihoo.livecloud.settings.GPWebrtcSettings;
import com.qihoo.livecloud.tools.CloudControlManager;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.Schedule;
import com.qihoo.livecloud.tools.ScheduleCallBack;
import com.qihoo.livecloud.tools.ServerAddrs;
import com.qihoo.livecloud.tools.Stats;
import com.qihoo.livecloud.tools.Version;
import com.qihoo.livecloud.utils.P2PServerHelper;
import com.qihoo.livecloud.utils.PlayerLogger;
import com.qihoo.livecloud.view.elgcore.SurfaceTextureEGLSurface;
import com.qihoo.videocloud.IQHVCPlayer;
import com.qihoo.videocloud.IQHVCPlayerAdvanced;
import com.qihoo.videocloud.QHVCQyCodec;
import com.qihoo.videocloud.model.MediaInformation;
import com.qihoo.videocloud.resolution.QHVCPlayMonitor;
import com.qihoo.videocloud.resolution.QHVCResolutionMgr;
import com.qihoo.videocloud.view.QHVCTextureView;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;

public class QHVCPlayer
implements IQHVCPlayerAdvanced,
PlayerCallback {
    private static final String TAG = "QHVCPlayer";
    private static final String DEFAULT_CHANNEL_ID = "QHVCDefaultChannel";
    public static final float FLOAT_EPSINON = 0.05f;
    private static final int DATA_SOURCE_TYPE_NONE = 0;
    private static final int DATA_SOURCE_TYPE_AUDIO = 1;
    private static final int DATA_SOURCE_TYPE_VIDEO = 2;
    public static final int FILTER_MODE_USER = 0;
    public static final int FILTER_MODE_CLOUD = 1;
    private static final int STATE_ERROR = -1;
    private static final int STATE_UNINIT = 0;
    private static final int STATE_IDLE = 1;
    private static final int STATE_PREPARING = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_STOP = 5;
    private static final int STATE_COMPLETED = 6;
    private volatile int mCurrentState = 0;
    private Context mContext;
    private final ReentrantLock mPlayerLock = new ReentrantLock();
    private final ReentrantLock mHandlerLock = new ReentrantLock();
    private PlayerControl mPlayerControl;
    private ListenerInfo mListenerInfo;
    private int mPlayerId = 0;
    private QHVCSdkConfig mConfig;
    private int mPlayType;
    private String mPlayUrl;
    private String mSign;
    private String mSessionId;
    private String mSessionIdInitValue;
    public static final String SESSION_ID_SUFFIX_SWITCH = "__switch";
    public static final String SESSION_ID_SUFFIX_HEVC_FAILED = "__hevc_failed";
    private String mSn;
    private String mChannelId;
    private String mScheduleUrl = "http://g2.live.360.cn/";
    private int mReturnProto = 8;
    private PlayerSettings mPlayerSettings = null;
    private String mStreamType = "all";
    private int mDecodeMode = 10;
    private int mIsHevc = 0;
    private boolean mFailedHevcplayback = false;
    private int mDelaySecond = 0;
    private int mRenderMode = 0;
    private int mPlayMode = 0;
    private int previewDurationMillis = 0;
    private int previewLoopTimes = -1;
    private boolean mAddToGroup = false;
    private int mGroup = 0;
    private boolean mFormatNotSupport = false;
    private boolean mBufferingUpdate = false;
    private boolean mMute = false;
    private boolean mInBackground = false;
    public static final float PLAYBACK_RATE_DEFAULT = 1.0f;
    private float mPlayBackRate = 1.0f;
    private int mSeekTo = 0;
    private boolean mInitSeekToAccurate = false;
    private boolean mIsSeek = false;
    private ByteBuffer mAACByteBuffer = null;
    private final int AAC_BUFFER_SIZE = 40960;
    private long mStatBeginTick;
    private ILiveCloudDisplay mCurrentDisplay;
    private LinkedList<ILiveCloudDisplay> mDisplayList = null;
    private boolean firstSetDisplay = false;
    private boolean mFirstFrame = false;
    private boolean mScreenOnWhilePlaying = false;
    private PowerManager.WakeLock mWakeLock = null;
    private static final int MSG_PLAYER_NOTIFY = 100;
    private static final int MSG_PLAYER_PREPARE = 101;
    private static final int MSG_PLAYER_PROGRESS_CHANGE = 102;
    private static final int MSG_PLAYER_COMPLETE = 103;
    private static final int MSG_PLAYER_CACHE = 104;
    private static final int MSG_PLAYER_INFO = 105;
    private static final int MSG_PLAYER_ERROR = 106;
    private HandlerThread mHandlerThread;
    private EventHandler mEventHandler;
    private volatile boolean onlyAudioPlay = false;
    private volatile boolean videoReadyMsgReceive = false;
    private volatile boolean audioReadyMsgReceive = false;
    private volatile boolean isPlayComplete = false;
    private SurfaceTextureEGLSurface mSurfaceTextureEGLSurface;
    private IQHVCPlayerAdvanced.SurfaceRenderListener mSurfaceRenderListener;
    private Surface mSurfaceRead = null;
    private SurfaceTexture mSurfaceTextCache = null;
    private SurfaceTexture mSurfaceTextureCheck = null;
    private int mSurfaceX;
    private int mSurfaceY;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private boolean mUseSwapSurface = false;
    private LocalServerHelper mLocalServerHelper;
    private IQHVCPlayerAdvanced.OnRecordListener mOnRecordListener;
    private volatile boolean isResolutionAdapt = false;
    private volatile IQHVCPlayerAdvanced.QHVCSwitchResolutionListener switchResolutionListener;
    private String[] mSourceRids;
    private String[] mSource;
    private volatile int mSourceIndex;
    private volatile int mSourceIndexCache;
    private volatile boolean mSwitchResolutionDoing = false;
    private volatile int mSwitchResolutionDoingCachePosition = 0;
    QHVCPlayMonitor mPlayMonitor;
    QHVCResolutionMgr mResolutionMgr;
    private int videoWidth;
    private int videoHeight;
    private boolean mUseHdRedord = false;
    QHVCRecorderSDK mRecorderSDK;
    private boolean isRecording;
    AudioInfo mAudioInfo;
    private int mSarNum = 0;
    private int mSarDen = 0;
    private int mPropertyRotate = 0;
    private P2PServerHelper mP2PServerHelper;
    private boolean mForceP2P = false;
    private boolean mP2PEnable = false;
    private float mBrightnessValue = 0.0f;
    private float mContrastValue = 1.0f;
    private float mSaturationValue = 1.0f;
    private boolean mUseFilter = false;
    private static final String VERSION = "2.0.3.18041001";
    private Timer mTimer = null;
    private TimerTask mTimerTask = null;
    private Runnable switchResolutionRunable = new Runnable(){

        @Override
        public void run() {
            QHVCPlayer.this.switchResolutionRunWrap();
        }
    };

    public QHVCPlayer(@NonNull Context context) {
        Looper looper;
        PlayerSettings settings;
        PlayerLogger.d(TAG, "QHVCPlayer construction");
        Version.check((String)"2.0.3.0");
        this.mContext = context.getApplicationContext();
        this.setAppContext(this.mContext);
        this.mConfig = QHVCSdk.getInstance().getConfig();
        if (this.mConfig == null) {
            throw new IllegalArgumentException("global config not init!");
        }
        String schedule = this.mConfig.getScheduleUrl();
        if (!TextUtils.isEmpty((CharSequence)schedule)) {
            this.mScheduleUrl = schedule;
            PlayerLogger.i(TAG, "schedule url: " + this.mScheduleUrl);
        }
        if ((settings = PlayerSettings.fromJsonStr(CloudControlManager.getInstance().getConfigJson())) != null) {
            this.mPlayerSettings = settings;
            PlayerLogger.i(TAG, this.mPlayerSettings.toString());
        }
        if (this.mPlayerSettings != null && this.mPlayerSettings.getFilter_enable() == 1 && this.mPlayerSettings.getFilter_mode() == 1) {
            float brightness = this.mPlayerSettings.getFilter_brightness();
            float contrast = this.mPlayerSettings.getFilter_contrast();
            float saturation = this.mPlayerSettings.getFilter_saturation();
            if (brightness < -0.2f || brightness > 0.35f || contrast < 0.9f || contrast > 1.6f || saturation < 0.15f || saturation > 2.0f) {
                this.mUseFilter = false;
            } else {
                this.mUseFilter = true;
                this.mBrightnessValue = this.mPlayerSettings.getFilter_brightness();
                this.mContrastValue = this.mPlayerSettings.getFilter_contrast();
                this.mSaturationValue = this.mPlayerSettings.getFilter_saturation();
            }
        }
        if ((looper = Looper.myLooper()) == null && (looper = Looper.getMainLooper()) == null) {
            this.mHandlerThread = new HandlerThread("QHVCPlayerEventThread", -2);
            this.mHandlerThread.start();
            looper = this.mHandlerThread.getLooper();
        }
        this.mEventHandler = new EventHandler(looper);
        this.mListenerInfo = new ListenerInfo(this);
        this.mPlayMonitor = new QHVCPlayMonitor();
        this.mResolutionMgr = new QHVCResolutionMgr();
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getNativeVersion() {
        return PlayerControl.getNativeVersion();
    }

    private int getHandle() {
        return this.mPlayerId;
    }

    @Override
    public void setDataSource(int playType, @NonNull String sn, @NonNull String channelId, @NonNull String sign, @Nullable Map<String, Object> options) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(playType, null, sn, channelId, sign, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void setDataSource(int playType, @Nullable String rid, @NonNull String sn, @NonNull String channelId, @NonNull String sign, @Nullable Map<String, Object> options) throws IOException, IllegalArgumentException, IllegalStateException {
        PlayerLogger.i(TAG, "[setDataSource] sn=" + sn + " playType=" + this.playTypeStr(playType));
        if (TextUtils.isEmpty((CharSequence)sn)) {
            throw new IllegalArgumentException("sn is empty!!!");
        }
        this.mPlayType = playType;
        this.mSn = sn;
        this.mChannelId = channelId;
        if (TextUtils.isEmpty((CharSequence)this.mChannelId)) {
            throw new IllegalArgumentException("need channel id");
        }
        this.mSign = sign;
        if (!TextUtils.isEmpty((CharSequence)rid)) {
            if (this.mLocalServerHelper == null) {
                Class<LocalServerHelper> clazz = LocalServerHelper.class;
                // MONITORENTER : com.qihoo.videocloud.QHVCPlayer$LocalServerHelper.class
                if (this.mLocalServerHelper == null) {
                    this.mLocalServerHelper = new LocalServerHelper();
                }
                // MONITOREXIT : clazz
            }
            this.mLocalServerHelper.setDataSource(rid, sn);
        }
        if (options != null && !options.isEmpty()) {
            int tmp;
            PlayerLogger.i(TAG, options.toString());
            Object obj = options.get("position");
            if (obj != null && obj instanceof Integer) {
                if (playType == 1) {
                    this.mSeekTo = (Integer)obj;
                } else {
                    PlayerLogger.e(TAG, "set data source. option position invalid!");
                }
            }
            if ((obj = options.get("positionAccurate")) != null && obj instanceof Boolean) {
                this.mInitSeekToAccurate = (Boolean)obj;
            }
            if ((obj = options.get("scheduleUrl")) != null && obj instanceof String) {
                this.mScheduleUrl = (String)obj;
            }
            if ((obj = options.get("renderMode")) != null && obj instanceof Integer && (tmp = ((Integer)obj).intValue()) >= 0 && tmp <= 2) {
                this.mRenderMode = tmp;
            }
            if ((obj = options.get("playMode")) != null && obj instanceof Integer && ((tmp = ((Integer)obj).intValue()) == 0 || tmp == 1)) {
                this.mPlayMode = tmp;
            }
            if ((obj = options.get("mute")) != null && obj instanceof Boolean) {
                this.mMute = (Boolean)obj;
            }
            if ((obj = options.get("streamType")) != null && obj instanceof String) {
                this.mStreamType = (String)obj;
            }
            if ((obj = options.get("previewDuration")) != null && obj instanceof Integer) {
                if (playType == 0) {
                    this.previewDurationMillis = (Integer)obj;
                } else {
                    PlayerLogger.e(TAG, "set data source. option preview duration invalid!");
                }
            }
            if ((obj = options.get("decodeMode")) != null && obj instanceof Integer) {
                if ((Integer)obj == 10) {
                    this.setDecoderMode(10);
                } else {
                    this.setDecoderMode(11);
                }
            }
            if ((obj = options.get("force_p2p")) != null && obj instanceof Boolean) {
                this.mForceP2P = (Boolean)obj;
            }
        }
        this.setCurState(1);
    }

    @Override
    public void setDataSource(int playType, @NonNull String url, @NonNull String channelId, @Nullable Map<String, Object> options) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(playType, url, channelId, "", options);
    }

    @Override
    public void setDataSource(int playType, @NonNull String url, @NonNull String channelId) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(playType, url, channelId, null);
    }

    @Override
    public void setDataSource(int playType, @Nullable String[] rids, @NonNull String[] sources, int defaultIndex, @NonNull String channelId, @NonNull String sign, @Nullable Map<String, Object> options) throws IOException, IllegalArgumentException, IllegalStateException {
        if (playType != 1) {
            throw new IllegalArgumentException("playType != IQHVCPlayerAdvanced.PLAYTYPE_VOD");
        }
        if (rids == null || sources == null) {
            throw new IllegalArgumentException("rid or sn is null");
        }
        if (rids.length != sources.length) {
            throw new IllegalArgumentException("rid.length != sn.length");
        }
        if (defaultIndex < 0 || defaultIndex >= sources.length) {
            throw new IllegalArgumentException("defaultIndex < 0 || defaultIndex >= sources.length");
        }
        this.mSourceRids = rids;
        this.mSource = sources;
        this.mSourceIndex = defaultIndex;
        this.setDataSource(playType, rids[defaultIndex], sources[defaultIndex], channelId, sign, options);
        if (this.mPlayMonitor != null) {
            this.mPlayMonitor.stat(2, defaultIndex, 0, sources);
        }
    }

    private void setCurState(int state) {
        this.mCurrentState = state;
        String curState = "UNINIT";
        switch (this.mCurrentState) {
            case -1: {
                curState = "ERROR";
                break;
            }
            case 0: {
                curState = "UNINIT";
                break;
            }
            case 1: {
                curState = "IDLE";
                break;
            }
            case 2: {
                curState = "PREPARING";
                break;
            }
            case 3: {
                curState = "PLAYING";
                break;
            }
            case 4: {
                curState = "PAUSED";
                break;
            }
            case 5: {
                curState = "STOP";
                break;
            }
            case 6: {
                curState = "COMPLETED";
            }
        }
        PlayerLogger.i(TAG, "CurState=" + curState);
    }

    private String playTypeStr(int playType) {
        String ptStr = "LIVE";
        if (playType == 1) {
            ptStr = "VOD";
        }
        return ptStr;
    }

    @Override
    public boolean snapshot(String path) {
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                boolean bl = this.mPlayerControl.snapshot(path);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.mPlayerLock.unlock();
        }
    }

    private void setDecoderMode(int decodeMode) {
        int blackListSupport;
        int useHwDecode;
        this.mDecodeMode = 10;
        if (this.mPlayerSettings != null && (useHwDecode = this.mPlayerSettings.getUse_hw_decode()) == 1 && (blackListSupport = GPWebrtcSettings.getInstance().getEnableLiveHwDecodeH264()) == 1) {
            this.mDecodeMode = decodeMode;
        }
    }

    @Override
    public int getDecoderMode() {
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                if (this.mPlayerControl.getUseHwDecoder() == 1) {
                    int n = 11;
                    return n;
                }
                int n = 10;
                return n;
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
        return this.mDecodeMode;
    }

    private void setPlayMode(int playMode) throws IllegalStateException {
        block4: {
            PlayerLogger.i(TAG, "setPlayMode mode=" + playMode);
            this.mPlayerLock.lock();
            try {
                if (this.mPlayerId != 0 && this.mPlayerControl != null) {
                    this.mPlayerControl.setPlayMode(this.mPlayMode);
                    break block4;
                }
                throw new IllegalStateException("player not init.");
            }
            finally {
                this.mPlayerLock.unlock();
            }
        }
    }

    @Override
    public void disableRender(boolean isDisableRender) throws IllegalStateException {
        block7: {
            PlayerLogger.i(TAG, "disableRender=" + isDisableRender);
            this.mPlayerLock.lock();
            try {
                if (this.mPlayerControl != null && this.mPlayerId != 0) {
                    this.mInBackground = isDisableRender;
                    this.mPlayerControl.setInBackground(isDisableRender);
                    if (!TextUtils.isEmpty((CharSequence)this.mSessionId)) {
                        if (isDisableRender) {
                            Stats.userBackground((String)this.mSessionId);
                        } else {
                            Stats.userForeground((String)this.mSessionId);
                        }
                    }
                    break block7;
                }
                throw new IllegalStateException("player not init.");
            }
            finally {
                this.mPlayerLock.unlock();
            }
        }
    }

    private void setPreviewDurationMillis(int durationMillis) {
        this.previewDurationMillis = durationMillis;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start() throws IllegalStateException {
        PlayerLogger.i(TAG, "play start");
        this.isPlayComplete = false;
        if (this.mCurrentState == 4) {
            if (!this.isVod()) return;
            this.mPlayerLock.lock();
            try {
                if (this.mPlayerControl == null) return;
                PlayerLogger.d(TAG, "play");
                this.mPlayerControl.pause(0);
                this.setCurState(3);
                return;
            }
            finally {
                this.mPlayerLock.unlock();
            }
        }
        if (this.mCurrentState <= 1) {
            return;
        }
        this.initPlayerControl(this.mPlayType);
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl == null) return;
            if (this.mCurrentState == 5 || this.mCurrentState == 6) {
                this.setCurState(2);
            }
            if (this.mCurrentState != 2) return;
            if (this.mReturnProto == 2) {
                this.relayPlay();
                return;
            } else if (this.isVod()) {
                this.replayProxy(this.mSeekTo);
                return;
            } else {
                if (!this.isLive()) return;
                this.rtmpLive();
            }
            return;
        }
        finally {
            this.mPlayerLock.unlock();
        }
    }

    private void setPlayerId(int playerId) {
        PlayerLogger.i(TAG, "setPlayerId handle=" + playerId);
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                this.mPlayerControl.setPlayerId(playerId);
                PlayerLogger.i(TAG, "setPlayerId mMute= " + this.mMute);
                this.mPlayerControl.setMute(this.mMute);
            }
            this.setUseHw(this.mPlayerControl, this.mSessionId);
            this.mPlayerId = playerId;
            this.setUseQy265dec(this.mPlayerControl, this.mPlayerId, true);
            this.mPlayerControl.setStreamType(this.cStreamType());
        }
        finally {
            this.mPlayerLock.unlock();
        }
        if (this.firstSetDisplay) {
            if (this.mCurrentDisplay != null) {
                this.mCurrentDisplay.setHandle(playerId);
            }
            this.firstSetDisplay = false;
        }
        this.disableRender(this.mInBackground);
        if (this.mAddToGroup) {
            this.mAddToGroup = false;
            this.addToGroup(this.mGroup);
        }
        this.setPlayMode(this.mPlayMode);
    }

    private void setUseHw(PlayerControl playerControl, String sid) {
        String packageNames = "";
        try {
            PackageInfo info = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 0);
            packageNames = info.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        PlayerLogger.d(TAG, "packageName=" + packageNames);
        int priority = 0;
        if (this.mDecodeMode == 11) {
            priority = 1;
        }
        PlayerLogger.i(TAG, "QHVCPlayer, use decode: " + priority);
        if (playerControl != null) {
            if (!TextUtils.isEmpty((CharSequence)sid)) {
                Stats.notifyCommonStat((String)sid, (String)"decodemd", (int)402, (int)0, (String)("b_hwdecode=" + priority));
            }
            playerControl.setUseHwDecoderPriority(priority, packageNames);
        }
    }

    private void relayPlay() {
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                PlayerLogger.d(TAG, "mIsHevc=" + this.mIsHevc);
                int ret = this.mPlayerControl.openLivePlayer(0, 0, this.mIsHevc);
                if (ret != 0) {
                    this.sendMsg(105, 2000, 20001);
                    this.setPlayerId(ret);
                    this.mPlayerControl.setCallback(this);
                    if (this.previewDurationMillis > 0) {
                        this.mPlayerControl.setPreviewDuration(ret, this.previewDurationMillis);
                    }
                    this.mPlayerControl.startLive();
                } else {
                    this.setCurState(-1);
                    this.sendMsg(106, 1002, 10005);
                }
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
    }

    private void replayProxy(final int seekto) {
        P2PServerHelper p2PServerHelper = this.getP2PServerHelper();
        if (p2PServerHelper != null) {
            p2PServerHelper.createTask(this.mSn, this.mForceP2P, new P2PServerHelper.CreateTaskCallback(){

                @Override
                public void onCallback(int ret, String p2pUrl) {
                    QHVCPlayer.this.mPlayUrl = p2pUrl;
                    QHVCPlayer.this.replay(seekto);
                }
            });
        } else {
            this.replay(seekto);
        }
    }

    private void replay(int seekto) {
        PlayerLogger.d(TAG, "replay=" + seekto);
        this.initTimer();
        this.mPlayerLock.lock();
        try {
            int ret = 0;
            if (this.mPlayerControl != null) {
                ret = this.mPlayerControl.openHls(this.mPlayUrl, 1, seekto, true, this.mInitSeekToAccurate ? 1 : 0);
                this.setPlayerId(ret);
                if (this.mPlayerSettings != null) {
                    this.mPlayerControl.playerSetting(this.mPlayerSettings);
                }
                this.mPlayerControl.setCallback(this);
                if (ret != 0) {
                    if (this.previewDurationMillis > 0) {
                        this.mPlayerControl.setPreviewDuration(ret, this.previewDurationMillis);
                    }
                    this.mPlayerControl.startLive();
                }
                PlayerLogger.d(TAG, "open hls handle=" + ret + " seekto=" + seekto);
            }
        }
        catch (Exception e) {
            PlayerLogger.e(TAG, e.getMessage());
        }
        finally {
            this.mPlayerLock.unlock();
        }
    }

    private void initTimer() {
        if (this.mTimer == null) {
            PlayerLogger.d(TAG, "initTimer");
            this.mTimer = new Timer();
        }
        if (this.mTimerTask == null) {
            this.mTimerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (QHVCPlayer.this.mCurrentState == -1) {
                        PlayerLogger.d(QHVCPlayer.TAG, "drop run");
                        QHVCPlayer.this.unInitTimer();
                        return;
                    }
                    if ((QHVCPlayer.this.mCurrentState == 3 || QHVCPlayer.this.mCurrentState == 4) && QHVCPlayer.this.isVod() && !QHVCPlayer.this.mSwitchResolutionDoing) {
                        if (QHVCPlayer.this.mPlayerControl != null && QHVCPlayer.this.mCurrentState == 3) {
                            long all = 0L;
                            QHVCPlayer.this.mPlayerLock.lock();
                            try {
                                if (QHVCPlayer.this.mPlayerControl != null) {
                                    all = QHVCPlayer.this.mPlayerControl.getPosition();
                                }
                            }
                            finally {
                                QHVCPlayer.this.mPlayerLock.unlock();
                            }
                            if (all != 0L) {
                                int progress = (int)(all >> 32);
                                int duration = (int)all;
                                if (duration != 0) {
                                    PlayerLogger.d(QHVCPlayer.TAG, "[" + Thread.currentThread().getName() + "] onProgressChange duration : " + duration + " progress : " + progress);
                                    QHVCPlayer.this.sendMsg(102, duration, progress);
                                    if (duration == progress && !QHVCPlayer.this.isPlayComplete) {
                                        QHVCPlayer.this.isPlayComplete = true;
                                        QHVCPlayer.this.setCurState(6);
                                        PlayerLogger.d(QHVCPlayer.TAG, "onCompletion");
                                        QHVCPlayer.this.sendMsg(103);
                                    }
                                    if (QHVCPlayer.this.mPlayMonitor != null) {
                                        QHVCPlayer.this.mPlayMonitor.stat(1, duration, progress, null);
                                    }
                                }
                            }
                        }
                        if (QHVCPlayer.this.mPlayerControl != null) {
                            int duration = QHVCPlayer.this.getDuration();
                            int currentPosition = QHVCPlayer.this.getCurrentPosition();
                            long cacheDuration = -1L;
                            if (QHVCPlayer.this.mLocalServerHelper != null) {
                                cacheDuration = QHVCPlayer.this.mLocalServerHelper.getCacheDuration();
                            } else {
                                QHVCPlayer.this.mPlayerLock.lock();
                                try {
                                    if (QHVCPlayer.this.mPlayerControl != null) {
                                        cacheDuration = QHVCPlayer.this.mPlayerControl.getCacheDuration();
                                    }
                                }
                                finally {
                                    QHVCPlayer.this.mPlayerLock.unlock();
                                }
                            }
                            long cacheDruationP2p = 0L;
                            if (QHVCPlayer.this.mP2PServerHelper != null) {
                                cacheDruationP2p = QHVCPlayer.this.mP2PServerHelper.getCacheDuration(QHVCPlayer.this.mSn, QHVCPlayer.this.getCurrentPosition());
                            }
                            if (cacheDuration < cacheDruationP2p) {
                                cacheDuration = cacheDruationP2p;
                            }
                            if (duration != 0 && currentPosition != 0 && cacheDuration > 0L) {
                                PlayerLogger.d(QHVCPlayer.TAG, "duration: " + duration + " current position: " + currentPosition + " cacheDuration: " + cacheDuration);
                                int cacheProgress = (currentPosition + (int)cacheDuration) * 100 / duration;
                                if (cacheProgress > 100) {
                                    cacheProgress = 100;
                                }
                                QHVCPlayer.this.sendMsg(104, cacheProgress, 0);
                                if (QHVCPlayer.this.mPlayMonitor != null) {
                                    QHVCPlayer.this.mPlayMonitor.stat(0, (int)cacheDuration, 0, null);
                                }
                            }
                        }
                    }
                    if (QHVCPlayer.this.isPlaying() && !QHVCPlayer.this.mInBackground && !QHVCPlayer.this.isPlayComplete && !QHVCPlayer.this.mIsSeek && QHVCPlayer.this.isResolutionAdapt && QHVCPlayer.this.mSourceIndex + 1 < QHVCPlayer.this.mSource.length && QHVCPlayer.this.mResolutionMgr != null && QHVCPlayer.this.mResolutionMgr.getSwitchStatus() == 0 && QHVCPlayer.this.mPlayMonitor != null && QHVCPlayer.this.mPlayMonitor.needSwitchResolution(QHVCPlayer.this.mContext, true)) {
                        PlayerLogger.d(QHVCPlayer.TAG, "need switch resolution");
                        if (QHVCPlayer.this.mEventHandler != null) {
                            QHVCPlayer.this.postAtFrontOfQueueMsg(new Runnable(){

                                @Override
                                public void run() {
                                    QHVCPlayer.this.switchResolutionImpl(QHVCPlayer.this.mSourceIndex + 1, QHVCPlayer.this.switchResolutionListener, true);
                                }
                            });
                        }
                    }
                }
            };
            this.mTimer.scheduleAtFixedRate(this.mTimerTask, 0L, 1000L);
        }
    }

    private void unInitTimer() {
        if (this.mTimer != null) {
            PlayerLogger.d(TAG, "unInitTimer");
            this.mTimer.cancel();
            this.mTimer = null;
        }
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
    }

    private void rtmpLive() {
        PlayerLogger.d(TAG, "rtmpLive");
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                int ret = this.mPlayerControl.openVideoUrl(this.mPlayUrl);
                PlayerLogger.d(TAG, "openVideoUrl handle : " + ret);
                this.sendMsg(105, 2000, 20001);
                this.setPlayerId(ret);
                if (this.mPlayerSettings != null) {
                    this.mPlayerControl.playerSetting(this.mPlayerSettings);
                }
                this.mPlayerControl.setCallback(this);
                if (ret != 0) {
                    if (this.previewDurationMillis > 0) {
                        this.mPlayerControl.setPreviewDuration(ret, this.previewDurationMillis);
                    }
                    this.mPlayerControl.startLive();
                }
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
    }

    @SuppressLint(value={"Wakelock"})
    private void initPlayerControl(int playType) {
        PlayerLogger.d(TAG, "initPlayerControl playType=" + this.playTypeStr(playType));
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl == null) {
                this.mPlayerControl = new PlayerControl();
            }
            this.mPlayerControl.setUid(this.mConfig.getUserId());
            this.mPlayerControl.setCid(this.mChannelId);
            this.mPlayerControl.setSN(this.mSn);
            this.mPlayerControl.setSid(this.mSessionId);
            if (this.mScreenOnWhilePlaying) {
                PowerManager powerManager = null;
                powerManager = (PowerManager)this.mContext.getSystemService("power");
                this.mWakeLock = powerManager.newWakeLock(10, "Play Lock");
                this.mWakeLock.acquire();
            }
        }
        catch (Exception e) {
            PlayerLogger.e(TAG, e.getMessage());
        }
        finally {
            this.mPlayerLock.unlock();
        }
    }

    protected void finalize() {
        this.mHandlerLock.lock();
        try {
            if (this.mEventHandler != null) {
                this.mEventHandler.removeCallbacksAndMessages(null);
                Looper looper = this.mEventHandler.getLooper();
                if (looper != Looper.getMainLooper()) {
                    looper.quit();
                }
                this.mEventHandler = null;
            }
        }
        finally {
            this.mHandlerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int reason) throws IllegalStateException {
        PlayerLogger.i(TAG, "QHVCPlayer stop");
        this.mFailedHevcplayback = false;
        this.unInitTimer();
        this.setCurState(5);
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                this.mPlayerControl.close(reason);
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
        if (this.mScreenOnWhilePlaying) {
            this.mWakeLock.release();
            this.mScreenOnWhilePlaying = false;
        }
        this.onlyAudioPlay = false;
        this.audioReadyMsgReceive = false;
        this.videoReadyMsgReceive = false;
        this.firstSetDisplay = true;
        this.mFirstFrame = false;
        this.mPlayerId = 0;
        QHVCPlayer qHVCPlayer = this;
        synchronized (qHVCPlayer) {
            if (this.mSurfaceRead != null) {
                this.mSurfaceRead.release();
                this.mSurfaceRead = null;
            }
            this.mSurfaceTextCache = null;
            this.mSurfaceTextureCheck = null;
            if (this.mSurfaceTextureEGLSurface != null) {
                this.mSurfaceTextureEGLSurface.release();
                this.mSurfaceTextureEGLSurface = null;
            }
        }
        this.switchResolutionStop("stop action");
        PlayerLogger.d(TAG, "QHVCPlayer stop end");
        if (this.mP2PServerHelper != null) {
            this.mP2PServerHelper.cancelTask(this.mSn, new P2PServerHelper.CancelTaskCallback(){

                @Override
                public void onCallback(int ret) {
                }
            });
        }
    }

    @Override
    public int addToGroup(int group) {
        PlayerLogger.i(TAG, "addToGroup=" + group);
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                this.mPlayerControl.addToGroup(group);
            } else {
                this.mAddToGroup = true;
                this.mGroup = group;
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
        return 0;
    }

    @Override
    public void setDisplay(ILiveCloudDisplay display) {
        PlayerLogger.d(TAG, "setDisplay");
        if (display == null) {
            PlayerLogger.d(TAG, "display is null");
            return;
        }
        if (this.mDisplayList == null) {
            this.mDisplayList = new LinkedList();
        }
        if (this.mCurrentDisplay == null) {
            if (!this.find(display)) {
                this.mDisplayList.add(display);
            }
            this.mCurrentDisplay = display;
            if (this.mPlayerId != 0) {
                this.mCurrentDisplay.setHandle(this.mPlayerId);
            } else {
                this.firstSetDisplay = true;
            }
        } else if (this.mCurrentDisplay != null) {
            if (this.find(display)) {
                if (this.mCurrentDisplay == display) {
                    return;
                }
                this.mCurrentDisplay.stopRender();
                this.mCurrentDisplay = display;
                if (this.mFirstFrame) {
                    this.mCurrentDisplay.startRender();
                }
            } else {
                this.mCurrentDisplay.stopRender();
                this.mDisplayList.add(display);
                this.mCurrentDisplay = display;
                if (this.mPlayerId != 0) {
                    this.mCurrentDisplay.setHandle(this.mPlayerId);
                }
                if (this.mFirstFrame) {
                    this.mCurrentDisplay.startRender();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean find(ILiveCloudDisplay fdisplay) {
        boolean find = false;
        if (this.mDisplayList != null && this.mDisplayList.size() > 0) {
            LinkedList<ILiveCloudDisplay> linkedList = this.mDisplayList;
            synchronized (linkedList) {
                for (ILiveCloudDisplay dp : this.mDisplayList) {
                    if (dp != fdisplay) continue;
                    find = true;
                    break;
                }
            }
        }
        return find;
    }

    @Override
    public void setOnPlayerNetStatsListener(IQHVCPlayerAdvanced.OnPlayerNetStatsListener listener) {
        this.mListenerInfo.onPlayerNetStatsListener = listener;
    }

    @Override
    public void prepareAsync() throws IllegalStateException {
        PlayerLogger.i(TAG, "prepareAsync");
        this.mStatBeginTick = System.currentTimeMillis();
        this.mSessionIdInitValue = this.mSessionId = MD5.encryptMD5((String)(String.valueOf(System.currentTimeMillis()) + String.valueOf(new Random().nextInt())));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("module", "player");
        params.put("sdk_ver", QHVCPlayer.getVersion());
        params.put("so_ver", QHVCPlayer.getNativeVersion());
        Stats.sessionStart((String)this.mSessionId, (String)this.mConfig.getUserId(), (String)this.mChannelId, (String)this.mConfig.getNetworkType(), (String)this.mSn, params);
        if (this.isNeedSchedule()) {
            this.doPrepare(0);
        } else {
            PlayerLogger.d(TAG, "isNeedSchedule not mCallback");
            this.mPlayUrl = this.mSn;
            this.mReturnProto = 8;
            this.setCurState(2);
            this.sendMsg(101);
        }
    }

    private void doPrepare(int backup) {
        Schedule.scheduleDoscheduling((String)this.mSessionId, (String)this.mScheduleUrl, (int)this.mDelaySecond, (String)"0", null, (int)0, (int)1, null, null, (String)this.mSign, (String)"h265", (String)"sd", (String)this.mStreamType, (ScheduleCallBack)new ScheduleCallBack(){

            public void scheduleState(int event, int errCode, String sid, ServerAddrs serverAddrs) {
                PlayerLogger.i(QHVCPlayer.TAG, "enent=" + event + " sid=" + sid + " serverAddress: " + (serverAddrs != null ? serverAddrs.toString() : " null"));
                if (event == 4 && serverAddrs != null) {
                    PlayerLogger.d(QHVCPlayer.TAG, serverAddrs.toString());
                    QHVCPlayer.this.mReturnProto = serverAddrs.getProto();
                    QHVCPlayer.this.mPlayUrl = serverAddrs.getMainAddr();
                    QHVCPlayer.this.mIsHevc = serverAddrs.getIsH265();
                    QHVCPlayer.this.setCurState(2);
                    if (QHVCPlayer.this.mFailedHevcplayback) {
                        QHVCPlayer.this.start();
                    } else {
                        QHVCPlayer.this.sendMsg(101);
                    }
                } else if (event == 5) {
                    QHVCPlayer.this.setCurState(-1);
                    QHVCPlayer.this.sendMsg(106, 1001, 10002);
                }
            }
        });
    }

    private boolean isNeedSchedule() {
        boolean need = false;
        if (this.isVod()) {
            return need;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSn)) {
            need = Schedule.scheduleIsNecessary((String)this.mSn);
            PlayerLogger.d(TAG, "need schedule=" + need);
        }
        return need;
    }

    private boolean isVod() {
        return this.mPlayType == 1;
    }

    private boolean isLive() {
        return this.mPlayType == 0;
    }

    @Override
    public boolean isPlaying() {
        PlayerLogger.d(TAG, "isPlaying");
        return this.mCurrentState == 3;
    }

    @Override
    public void pause() throws IllegalStateException {
        PlayerLogger.i(TAG, "pause");
        if (this.isLive()) {
            throw new IllegalStateException("live not support 'pause()'");
        }
        if (this.mCurrentState == -1 || this.mCurrentState == 2 || this.mCurrentState == 0 || this.mCurrentState == 1 || this.mCurrentState == 5) {
            throw new IllegalStateException();
        }
        boolean isSuccess = false;
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                this.mPlayerControl.pause(-1);
                this.setCurState(4);
                isSuccess = true;
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
        if (isSuccess) {
            this.switchResolutionStop("pause action");
        }
    }

    @Override
    public boolean isPaused() {
        PlayerLogger.d(TAG, "isPaused");
        return this.mCurrentState == 4;
    }

    @Override
    public void seekTo(int millis) throws IllegalStateException {
        this.seekTo(millis, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seekTo(int millis, boolean accurate) throws IllegalStateException {
        PlayerLogger.i(TAG, "seekTo=" + millis + " accurate: " + accurate);
        if (this.isLive()) {
            throw new IllegalStateException("live not support 'seekTo(int millis)'");
        }
        if (this.mCurrentState == -1 || this.mCurrentState == 0 || this.mCurrentState == 1 || this.mCurrentState == 5) {
            throw new IllegalStateException();
        }
        boolean isSuccess = false;
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                this.mSeekTo = millis;
                this.mIsSeek = true;
                if (this.mCurrentState == 6) {
                    this.setCurState(3);
                }
                this.isPlayComplete = false;
                int seek = this.mPlayerControl.seekTo(millis, accurate);
                PlayerLogger.i(TAG, "seekReturn=" + seek);
                isSuccess = true;
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
        if (isSuccess) {
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.stat(6, 0, 0, null);
            }
            this.switchResolutionStop("seek action");
        }
    }

    @Override
    public void setPlayBackRate(float rate) throws IllegalStateException {
        PlayerLogger.i(TAG, "setPlayBackRate rate=" + rate);
        boolean isSuccess = false;
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null && this.mPlayerId != 0) {
                this.mPlayBackRate = rate;
                this.mPlayerControl.setPlayBackRate(rate);
                isSuccess = true;
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
        if (isSuccess) {
            this.switchResolutionStop("setPlayBackRate action");
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.stat(7, 0, 0, Float.valueOf(rate));
            }
        }
    }

    @Override
    public int getCurrentPosition() {
        PlayerLogger.d(TAG, "getCurrentPosition");
        if (this.isVod()) {
            long all = 0L;
            this.mPlayerLock.lock();
            try {
                if (this.mPlayerControl != null) {
                    all = this.mPlayerControl.getPosition();
                }
            }
            finally {
                this.mPlayerLock.unlock();
            }
            if (all != 0L) {
                int pro = (int)(all >> 32);
                if (!this.mSwitchResolutionDoing) {
                    return pro;
                }
                PlayerLogger.d(TAG, "get current position. switch resolution doing cache position: " + this.mSwitchResolutionDoingCachePosition);
                return this.mSwitchResolutionDoingCachePosition;
            }
        }
        return 0;
    }

    @Override
    public int getDuration() {
        PlayerLogger.d(TAG, "getDuration");
        if (this.isVod()) {
            long all = 0L;
            this.mPlayerLock.lock();
            try {
                if (this.mPlayerControl != null) {
                    all = this.mPlayerControl.getPosition();
                }
            }
            finally {
                this.mPlayerLock.unlock();
            }
            if (all != 0L) {
                int total = (int)all;
                return total;
            }
        }
        return 0;
    }

    @Override
    public void stop() throws IllegalStateException {
        this.stop(0);
    }

    @Override
    public void release() {
        PlayerLogger.i(TAG, "release");
        this.mHandlerLock.lock();
        try {
            if (this.mEventHandler != null) {
                this.mEventHandler.removeCallbacksAndMessages(null);
                Looper looper = this.mEventHandler.getLooper();
                if (looper != Looper.getMainLooper()) {
                    looper.quit();
                }
                this.mEventHandler = null;
            }
        }
        finally {
            this.mHandlerLock.unlock();
        }
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                this.mPlayerControl = null;
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSessionId)) {
            Schedule.scheduleDestroy((String)this.mSessionId);
            Stats.sessionStop((String)this.mSessionId);
        }
        this.setCurState(0);
        this.releaseDisplayList();
        this.mCurrentDisplay = null;
        this.mUseSwapSurface = false;
        this.mOnRecordListener = null;
        this.mPlayBackRate = 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDisplayList() {
        if (this.mDisplayList != null) {
            LinkedList<ILiveCloudDisplay> linkedList = this.mDisplayList;
            synchronized (linkedList) {
                if (this.mDisplayList != null) {
                    this.mDisplayList.clear();
                    this.mDisplayList = null;
                }
            }
        }
    }

    @Override
    public void setMute(boolean mute) throws IllegalStateException {
        block5: {
            PlayerLogger.i(TAG, "setMute mMute=" + this.mMute + " mute=" + mute);
            if (this.mMute == mute) {
                return;
            }
            this.mMute = mute;
            this.mPlayerLock.lock();
            try {
                if (this.mPlayerControl != null && this.mPlayerId != 0) {
                    PlayerLogger.d(TAG, "setMute handle=" + this.mPlayerId);
                    this.mPlayerControl.setMute(mute);
                    break block5;
                }
                throw new IllegalStateException("play not init.");
            }
            finally {
                this.mPlayerLock.unlock();
            }
        }
    }

    @Override
    public void setOnAudioPCMListener(IQHVCPlayerAdvanced.OnAudioPCMListener listener) {
        if (listener == null) {
            if (this.mListenerInfo.onAudioPCMListener != null) {
                this.stopRecordAAC();
                this.mListenerInfo.onAudioPCMListener = null;
            }
        } else {
            this.mListenerInfo.onAudioPCMListener = listener;
            this.startRecordAAC();
        }
    }

    private void startRecordAAC() {
        PlayerLogger.d(TAG, "startRecordAAC");
        if (this.mAACByteBuffer == null) {
            this.mAACByteBuffer = ByteBuffer.allocateDirect(40960);
        }
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null && this.mPlayerId != 0) {
                this.mPlayerControl.startRecordAAC(this.mAACByteBuffer, 40960, System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            PlayerLogger.e(TAG, e.getMessage());
        }
        finally {
            this.mPlayerLock.unlock();
        }
    }

    private void stopRecordAAC() {
        PlayerLogger.d(TAG, "stopRecordAAC");
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null && this.mPlayerId != 0) {
                this.mPlayerControl.stopRecordAAC();
            }
        }
        catch (Exception e) {
            PlayerLogger.e(TAG, e.getMessage());
        }
        finally {
            this.mPlayerLock.unlock();
        }
    }

    @Override
    public void setOnBufferingUpdateListener(IQHVCPlayer.OnBufferingUpdateListener listener) {
        this.mListenerInfo.onBufferingUpdateListener = listener;
    }

    @Override
    public void setOnBufferingEventListener(IQHVCPlayer.OnBufferingEventListener listener) {
        this.mListenerInfo.onBufferingEventListener = listener;
    }

    @Override
    public boolean isMute() {
        return this.mMute;
    }

    @Override
    public void setScreenOnWhilePlaying(boolean screenOn) {
        PlayerLogger.d(TAG, "ScreenOnWhilePlaying=" + screenOn);
        this.mScreenOnWhilePlaying = screenOn;
    }

    @Override
    public int getPlayerId() {
        return this.mPlayerId;
    }

    @Override
    public void setOnPreparedListener(IQHVCPlayer.OnPreparedListener listener) {
        this.mListenerInfo.onPreparedListener = listener;
    }

    @Override
    public void setOnSeekCompleteListener(IQHVCPlayer.OnSeekCompleteListener listener) {
        this.mListenerInfo.onSeekCompleteListener = listener;
    }

    @Override
    public void setOnErrorListener(IQHVCPlayer.OnErrorListener listener) {
        this.mListenerInfo.onErrorListener = listener;
    }

    @Override
    public void setOnCompletionListener(IQHVCPlayer.OnCompletionListener listener) {
        this.mListenerInfo.onCompletionListener = listener;
    }

    @Override
    public void setOnInfoListener(IQHVCPlayer.OnInfoListener listener) {
        this.mListenerInfo.onInfoListener = listener;
    }

    @Override
    public void setOnVideoSizeChangedListener(IQHVCPlayer.OnVideoSizeChangedListener listener) {
        this.mListenerInfo.onVideoSizeChangedListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPlayerMsg(int handle, int command, long para1, long para2, int user) {
        if (command == -999 && this.mSwitchResolutionDoing) {
            this.mSwitchResolutionDoing = false;
            if (this.switchResolutionListener != null) {
                this.switchResolutionListener.onSuccess(this.mSourceIndex, this.mSource[this.mSourceIndex]);
            }
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.resetStat();
            }
        }
        boolean isMsgSend = true;
        if (command == -999 && this.mCurrentState != 2) {
            isMsgSend = false;
        }
        if (command == -996 && this.mCurrentState == 6) {
            isMsgSend = false;
        }
        if (isMsgSend) {
            this.mHandlerLock.lock();
            try {
                if (this.mEventHandler != null) {
                    this.mEventHandler.obtainMessage(100, new PlayerMsg(handle, command, para1, para2, user)).sendToTarget();
                } else {
                    PlayerLogger.d(TAG, "event handler is null. filter msg. handle=" + handle + " command=" + command + " para1=" + para1 + " para2=" + para2 + " user=" + user);
                }
            }
            finally {
                this.mHandlerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onPlayerMsgHandle(int handle, int command, long para1, long para2, int user) {
        switch (command) {
            case -1001: {
                PlayerLogger.e("QHVCPlayer", "JPLAYER_MSG_NO_INIT_FAIL");
                if (this.mFormatNotSupport) {
                    this.mFormatNotSupport = false;
                    return;
                }
                this.setCurState(-1);
                ListenerInfo.access$600(this.mListenerInfo, 1002, 10004);
                break;
            }
            case -975: {
                this.setCurState(-1);
                PlayerLogger.e("QHVCPlayer", "JPLAYER_MSG_CONNECT_FAILED");
                if (para1 == 0L) {
                    ListenerInfo.access$600(this.mListenerInfo, 1002, 10006);
                    break;
                }
                if (para1 == 1L) {
                    ListenerInfo.access$600(this.mListenerInfo, 1002, 10009);
                    break;
                }
                ListenerInfo.access$600(this.mListenerInfo, 1002, 10000);
                break;
            }
            case -978: {
                PlayerLogger.e("QHVCPlayer", "JPLAYER_MSG_SESSION_CONNECTED");
                break;
            }
            case -1000: {
                PlayerLogger.e("QHVCPlayer", "JPLAYER_MSG_SUBSCRIBE_FAILED");
                this.setCurState(-1);
                ListenerInfo.access$600(this.mListenerInfo, 1002, 10007);
                break;
            }
            case 10: {
                PlayerLogger.i("QHVCPlayer", "JPLAYER_MSG_START_SUCCESS");
                break;
            }
            case -972: {
                PlayerLogger.i("QHVCPlayer", "JPLAYER_MSG_STATUS_SEEK. " + para1);
                if (para1 != -1L) break;
                ListenerInfo.access$500(this.mListenerInfo, 2009, 20001);
                break;
            }
            case -992: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_AUDIO_IS_READY para1: " + para1);
                if (!QHVCPlayer.isDefaultPlayBackRate(this.mPlayBackRate)) {
                    PlayerLogger.d("QHVCPlayer", "receive audio is ready, set playback rate: " + this.mPlayBackRate);
                    this.mPlayerLock.lock();
                    try {
                        if (this.mPlayerControl != null) {
                            this.mPlayerControl.setPlayBackRate(this.mPlayBackRate);
                        }
                    }
                    finally {
                        this.mPlayerLock.unlock();
                    }
                }
                this.audioReadyMsgReceive = true;
                if (0L != para1) ** GOTO lbl72
                this.onlyAudioPlay = true;
                if (this.mCurrentState != 2) break;
                this.setCurState(3);
                this.mPlayerLock.lock();
                try {
                    if (this.mPlayerControl != null) {
                        this.mPlayerControl.playSound();
                    }
                }
                finally {
                    this.mPlayerLock.unlock();
                }
                this.reportPlayStart();
                PlayerLogger.d("QHVCPlayer", "mIsHevc=" + this.mIsHevc);
                if (this.mIsHevc != 1) break;
                ListenerInfo.access$500(this.mListenerInfo, 2007, 20004);
                break;
lbl72:
                // 1 sources

                this.onlyAudioPlay = false;
                break;
            }
            case -999: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_VIDEO_IS_READY. para1: " + para1);
                if (this.onlyAudioPlay) ** GOTO lbl97
                if (this.mCurrentState != 2) break;
                this.setCurState(3);
                if (this.mCurrentDisplay != null) {
                    PlayerLogger.i("QHVCPlayer", "startRender handle : " + this.mPlayerId);
                    if (!this.mFirstFrame) {
                        this.mCurrentDisplay.startRender();
                        this.mFirstFrame = true;
                    }
                }
                this.mPlayerLock.lock();
                try {
                    if (this.mPlayerControl != null) {
                        this.mPlayerControl.playSound();
                    }
                }
                finally {
                    this.mPlayerLock.unlock();
                }
                this.reportPlayStart();
                PlayerLogger.d("QHVCPlayer", "mIsHevc=" + this.mIsHevc);
                if (this.mIsHevc != 1) break;
                ListenerInfo.access$500(this.mListenerInfo, 2007, 20004);
                break;
lbl97:
                // 1 sources

                this.onlyAudioPlay = false;
                if (!this.isPlaying() || this.mCurrentDisplay == null) break;
                PlayerLogger.d("QHVCPlayer", "startRender handle : " + this.mPlayerId);
                if (this.mFirstFrame) break;
                this.mCurrentDisplay.startRender();
                this.mFirstFrame = true;
                break;
            }
            case -995: {
                this.videoWidth = (int)para1;
                this.videoHeight = (int)para2;
                PlayerLogger.i("QHVCPlayer", "JPLAYER_MSG_VIDEO_SIZE_CHANGE videoWidth=" + this.videoWidth + " videoHeight=" + this.videoHeight);
                if (this.mSarNum > 0 && this.mSarDen > 0) {
                    this.videoWidth = this.videoWidth * this.mSarNum / this.mSarDen;
                }
                ListenerInfo.access$4700(this.mListenerInfo, this.videoWidth, this.videoHeight);
                break;
            }
            case -950: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_STARTBUFFERING");
                if (this.mCurrentState != 3) {
                    return;
                }
                ListenerInfo.access$4800(this.mListenerInfo);
                break;
            }
            case -949: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_STOPBUFFERING");
                if (this.mCurrentState != 3) {
                    return;
                }
                ListenerInfo.access$4900(this.mListenerInfo);
                break;
            }
            case -996: {
                PlayerLogger.v("QHVCPlayer", "JPLAYER_MSG_STATUS_UPDATE=" + handle + " command=" + command + " para1=" + para1 + " para2=" + para2 + " user=" + user);
                this.replayStatusUpdate(para1, para2, user);
                break;
            }
            case -979: {
                PlayerLogger.i("QHVCPlayer", "JPLAYER_MSG_SESSION_CLOSED");
                ListenerInfo.access$500(this.mListenerInfo, 2004, 20001);
                break;
            }
            case -998: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_VIDEO_RESOLUTION");
                break;
            }
            case -899: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_BUSY");
                break;
            }
            case -997: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_AUDIO_IS_SILENT");
                break;
            }
            case -974: {
                PlayerLogger.i("QHVCPlayer", "JPLAYER_MSG_CONNECT_COMPLETE");
                if (this.mCurrentState != 3 || !this.isVod()) ** GOTO lbl160
                all = 0L;
                this.mPlayerLock.lock();
                try {
                    if (this.mPlayerControl != null) {
                        all = this.mPlayerControl.getPosition();
                    }
                }
                finally {
                    this.mPlayerLock.unlock();
                }
                if (all != 0L) {
                    pro = (int)(all >> 32);
                    total = (int)all;
                    PlayerLogger.d("QHVCPlayer", "msg complete. onProgressChange total : " + total + " pro : " + pro);
                }
                PlayerLogger.d("QHVCPlayer", "msg complete. vod. handle progress 100%");
                duration = this.getDuration();
                ListenerInfo.access$200(this.mListenerInfo, duration, duration);
lbl160:
                // 2 sources

                this.setCurState(6);
                if (this.isPlayComplete) break;
                this.isPlayComplete = true;
                ListenerInfo.access$300(this.mListenerInfo);
                break;
            }
            case -973: {
                PlayerLogger.i("QHVCPlayer", "JPLAYER_MSG_CONNECT_INBACKGOURND");
                ListenerInfo.access$500(this.mListenerInfo, 2005, 20001);
                break;
            }
            case -930: {
                this.setCurState(-1);
                PlayerLogger.e("QHVCPlayer", "JPLAYER_MSG_ERROR_FORMATNOTSUPPORT");
                this.mFormatNotSupport = true;
                ListenerInfo.access$600(this.mListenerInfo, 1003, (int)para1);
                break;
            }
            case -931: {
                PlayerLogger.e("QHVCPlayer", "JPLAYER_MSG_ERROR_FILENOTOPEN handle=" + handle + " command=" + command + " para1=" + para1 + " para2=" + para2 + " user=" + user);
                ListenerInfo.access$600(this.mListenerInfo, 1004, (int)para1);
                break;
            }
            case -800: {
                PlayerLogger.e("QHVCPlayer", "JPLAYER_MSG_HW_DECODER_IS_NOT_SUPPORT");
                encoderUrl = "";
                try {
                    encoderUrl = URLEncoder.encode(this.mPlayUrl, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    encoderUrl = "";
                    PlayerLogger.e("QHVCPlayer", e.getMessage());
                }
                if (!TextUtils.isEmpty((CharSequence)encoderUrl) && !TextUtils.isEmpty((CharSequence)this.mChannelId)) {
                    s = "b_url=" + encoderUrl + "&b_ishevc=" + this.mIsHevc;
                    Stats.notifyCommonStat((String)this.mSessionId, (String)"hwdecodefail", (int)403, (int)((int)para2), (String)s);
                }
                this.postMsg(new Runnable(){

                    @Override
                    public void run() {
                        PlayerLogger.d(QHVCPlayer.TAG, "JPLAYER_MSG_HW_DECODER_IS_NOT_SUPPORT stop");
                        int seekValue = QHVCPlayer.this.getCurrentPosition();
                        Stats.sessionStop((String)QHVCPlayer.this.mSessionId);
                        QHVCPlayer.this.stop(0);
                        QHVCPlayer.this.setDecoderMode(10);
                        PlayerLogger.d(QHVCPlayer.TAG, "QHVCPlayer setDecoderMode(LIVECLOUD_SOFT_DECODE_MODE) seekValue = " + seekValue);
                        if (QHVCPlayer.this.mInBackground) {
                            QHVCPlayer.this.disableRender(true);
                            PlayerLogger.d(QHVCPlayer.TAG, "QHVCPlayer setInBackground(true)");
                        }
                        QHVCPlayer.this.mSeekTo = seekValue;
                        QHVCPlayer.this.start();
                    }
                });
                break;
            }
            case -994: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_DVRENDER handle=" + handle + " para1=" + para1 + " para2=" + para2);
                if (para1 == 1L) {
                    ListenerInfo.access$500(this.mListenerInfo, 2010, 20001);
                    break;
                }
                if (para1 == 2L) {
                    ListenerInfo.access$500(this.mListenerInfo, 2011, 20001);
                    break;
                }
                if (para1 == 3L) {
                    PlayerLogger.i("QHVCPlayer", "first frame render time=" + (System.currentTimeMillis() - this.mStatBeginTick) + ", url=" + this.mPlayUrl);
                    ListenerInfo.access$500(this.mListenerInfo, 2012, 20001);
                    break;
                }
                if (para1 != 4L) break;
                ListenerInfo.access$500(this.mListenerInfo, 2013, 20001);
                break;
            }
            case -920: {
                PlayerLogger.e("QHVCPlayer", "JPLAYER_MSG_FAILED_HEVCPLAYBACK");
                if (this.mIsHevc == 1) {
                    ListenerInfo.access$500(this.mListenerInfo, 2007, 20005);
                }
                if (this.mEventHandler == null) break;
                this.postMsg(new Runnable(){

                    @Override
                    public void run() {
                        PlayerLogger.d(QHVCPlayer.TAG, "stop play h265");
                        Stats.sessionStop((String)QHVCPlayer.this.mSessionId);
                        QHVCPlayer.this.mCurrentDisplay.stopRender();
                        QHVCPlayer.this.stop(0);
                    }
                });
                this.postDelayedMsg(new Runnable(){

                    @Override
                    public void run() {
                        QHVCPlayer.this.resumePlay();
                    }
                }, 2500L);
                break;
            }
            case -700: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_DVRENDER_RESETSURFACE handle=" + handle + " para1=" + para1 + " para2=" + para2);
                ListenerInfo.access$500(this.mListenerInfo, 2014, 20001);
                break;
            }
            case -929: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_VIDEOCACHE handle=" + handle + " para1=" + para1);
                if (para1 == 1L) {
                    ListenerInfo.access$500(this.mListenerInfo, 2006, 20002);
                    break;
                }
                PlayerLogger.e("QHVCPlayer", "JPLAYER_MSG_VIDEOCACHE FAILED");
                ListenerInfo.access$500(this.mListenerInfo, 2006, 20003);
                break;
            }
            case -500: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_RECORD_SUCCUSS handle=" + handle);
                if (this.mOnRecordListener == null) break;
                this.mOnRecordListener.onRecordSuccess();
                break;
            }
            case -991: {
                this.mSarNum = (int)para1;
                this.mSarDen = (int)para2;
                PlayerLogger.i("QHVCPlayer", "JPLAYER_MSG_VIDEO_SAR mSarNum=" + this.mSarNum + " mSarDen=" + this.mSarDen);
                break;
            }
            case -601: {
                this.mPropertyRotate = (int)para1;
                PlayerLogger.i("QHVCPlayer", "JPLAYER_MSG_FILE_PROPERTY_ROTATE mPropertyRotate=" + this.mPropertyRotate);
                break;
            }
            default: {
                PlayerLogger.d("QHVCPlayer", "JPLAYER_MSG_OTHER handle=" + handle + " command=" + command + " para1=" + para1 + " para2=" + para2 + " user=" + user);
            }
        }
    }

    private void resumePlay() {
        PlayerLogger.i(TAG, "resume play h264 mIsHevc=" + this.mIsHevc);
        this.mSessionId = this.mSessionIdInitValue + SESSION_ID_SUFFIX_HEVC_FAILED;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("module", "player");
        params.put("sdk_ver", QHVCPlayer.getVersion());
        params.put("so_ver", QHVCPlayer.getNativeVersion());
        Stats.sessionStart((String)this.mSessionId, (String)this.mConfig.getUserId(), (String)this.mChannelId, (String)this.mConfig.getNetworkType(), (String)this.mSn, params);
        this.firstSetDisplay = true;
        this.mFirstFrame = false;
        this.mFailedHevcplayback = true;
        if (this.mIsHevc == 1) {
            this.doPrepare(1);
        }
    }

    private void replayStatusUpdate(long para1, long para2, int user) {
        if (user == 1 && this.mBufferingUpdate) {
            int progress = 0;
            if (para2 > 0L && para1 > 0L) {
                progress = (int)(para1 * 100L / para2);
            }
            if (progress > 100) {
                progress = 100;
            }
            PlayerLogger.v(TAG, "buffering event. progress: " + progress);
            this.mListenerInfo.onBufferingEventProgressSafeCall(progress);
            return;
        }
        if (user == 1) {
            this.mBufferingUpdate = true;
            PlayerLogger.d(TAG, "buffering event. START");
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.stat(4, 0, 0, null);
            }
            this.mListenerInfo.onBufferingEventStartSafeCall();
        }
        if (user == 0 && this.mBufferingUpdate) {
            this.mBufferingUpdate = false;
            PlayerLogger.d(TAG, "buffering event. STOP");
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.stat(4, 1, 0, null);
            }
            this.mListenerInfo.onBufferingEventStopSafeCall();
            if (this.mIsSeek) {
                this.mIsSeek = false;
                this.mListenerInfo.onSeekCompleteSafeCall();
            }
        }
    }

    @Override
    public void onUpdateStatus(int handle, int vbps, int abps, int vfps, int afps, int fps, int bitrate, int param1, int param2, int user) {
        if (this.mCurrentState == 3) {
            PlayerLogger.d(TAG, "onLiveUpdateStatus");
            this.mListenerInfo.onPlayerNetStatsSafeCall(vbps, abps, vfps, afps, fps, bitrate, param1, param2, user);
        }
    }

    @Override
    public void onUpdateGPPlayState(int handle, long nowTime, long videoBufferTime, long audioBufferTime) {
        if (!this.isLive() || this.mPlayerSettings != null || this.mPlayerSettings.getGp_play_state_upload() == 0) {
            return;
        }
        PlayerLogger.d(TAG, "onUpdateGPPlayerState nt = " + nowTime + ", bvt = " + videoBufferTime + ", bat = " + audioBufferTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(int handle, int id, int type, int flags, int size, long data, long time) {
        if (1 == type && this.mAACByteBuffer != null) {
            this.mListenerInfo.onAudioFrameDataSafeCall(id, flags, size, this.mAACByteBuffer, time);
            if (this.mRecorderSDK != null) {
                if (this.mAudioInfo == null) {
                    this.mAudioInfo = new AudioInfo();
                }
                this.mPlayerLock.lock();
                try {
                    if (this.mPlayerControl != null) {
                        this.mPlayerControl.getAudioInfo(handle, this.mAudioInfo);
                    }
                }
                finally {
                    this.mPlayerLock.unlock();
                }
                this.mRecorderSDK.writeAudioData(this.mAACByteBuffer, size, time, this.mAudioInfo.getChannel(), this.mAudioInfo.getBitsPerSample(), this.mAudioInfo.getSampleRate());
            }
        }
    }

    @Override
    public void onUserDefineData(int handle, byte[] data, int length) {
        PlayerLogger.d(TAG, "onUserDefineData handle=" + handle + " length=" + length);
        this.mListenerInfo.onUserDefinedDataSafeCall(data);
    }

    @Override
    public void setOnProgressChangeListener(IQHVCPlayer.onProgressChangeListener listener) {
        this.mListenerInfo.onProgressChangeListener = listener;
    }

    private int getAudioInfo(AudioInfo audioInfo) {
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null && this.mPlayerId != 0) {
                int n = this.mPlayerControl.getAudioInfo(this.mPlayerId, audioInfo);
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.mPlayerLock.unlock();
        }
    }

    @Override
    public void setVolume(float volume) throws IllegalStateException {
        block4: {
            this.mPlayerLock.lock();
            try {
                if (this.mPlayerId != 0 && this.mPlayerControl != null) {
                    this.mPlayerControl.setVolume(volume);
                    break block4;
                }
                throw new IllegalStateException("");
            }
            finally {
                this.mPlayerLock.unlock();
            }
        }
    }

    @Override
    public float getVolume() throws IllegalStateException {
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerId != 0 && this.mPlayerControl != null) {
                float f = this.mPlayerControl.getVolume();
                return f;
            }
            throw new IllegalStateException("");
        }
        finally {
            this.mPlayerLock.unlock();
        }
    }

    private int cStreamType() {
        if (this.mStreamType.equals("audio")) {
            return 0;
        }
        if (this.mStreamType.equals("video")) {
            return 1;
        }
        return 2;
    }

    private void setAppContext(Context appContext) {
        PlayerControl.setAppContext(appContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUseQy265dec(PlayerControl playerControl, int playerId, boolean isUseQy265dec) {
        if (playerId != 0 && playerControl != null) {
            int useQy265decFlag = 0;
            if (isUseQy265dec) {
                if (this.mPlayerSettings != null) {
                    useQy265decFlag = this.mPlayerSettings.getUse_qy265dec();
                }
                if (useQy265decFlag != 0) {
                    int n = useQy265decFlag = QHVCQyCodec.supportQy265dec(this.mContext) ? 1 : 0;
                    if (0 == useQy265decFlag) {
                        QHVCQyCodec.downloadAndInstall(this.mContext);
                    }
                }
            }
            PlayerLogger.i(TAG, "setUseQy265dec playerId: " + playerId + " flags: " + useQy265decFlag);
            this.mPlayerLock.lock();
            try {
                if (playerId != 0 && playerControl != null) {
                    this.mPlayerControl.setUseQy265dec(playerId, useQy265decFlag);
                }
            }
            finally {
                this.mPlayerLock.unlock();
            }
        }
    }

    private int getUseQy265dec() {
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerId != 0 && this.mPlayerControl != null) {
                int n = this.mPlayerControl.getUseQy265dec(this.mPlayerId);
                return n;
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMediaInformation() {
        P2PServerHelper.TaskInfo taskInfo;
        int ret;
        HashMap<String, Object> map = new HashMap<String, Object>();
        MediaInformation mediaInformation = new MediaInformation();
        boolean isSuccess = false;
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null && this.mPlayerId != 0) {
                this.mPlayerControl.getMediaInformation(this.mPlayerId, mediaInformation);
                isSuccess = true;
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
        if (isSuccess) {
            map.put("video_width", mediaInformation.getVideoWidth());
            map.put("video_height", mediaInformation.getVideoHeight());
            map.put("video_fps", mediaInformation.getVideoFps());
            map.put("video_format", mediaInformation.getVideoDecodeName());
            map.put("audio_format", mediaInformation.getAudioDecodeName());
            map.put("audio_channel", mediaInformation.getAudioChannel());
            map.put("audio_sample_rate", mediaInformation.getAudioSampleRate());
            map.put("bitrate", mediaInformation.getBitrate());
        }
        map.put("real_play_url", this.mPlayUrl);
        if (this.mP2PServerHelper != null && this.mPlayType == 1 && (ret = this.mP2PServerHelper.getTaskInfo(this.mSn, taskInfo = new P2PServerHelper.TaskInfo())) == P2PServerHelper.ERROR_OK) {
            map.put("p2p_download_speed", taskInfo.p2pDownSpeed);
            map.put("cdn_download_speed", taskInfo.cdnDownSpeed);
        }
        return map;
    }

    @Override
    public int getRenderMode() {
        return this.mRenderMode;
    }

    @Override
    public void setSurfaceRenderListener(IQHVCPlayerAdvanced.SurfaceRenderListener surfaceRenderListener) {
        this.mSurfaceRenderListener = surfaceRenderListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setSurface(final String from, SurfaceTexture texture) {
        PlayerLogger.d(TAG, "QHVCPlayer synchronized void setSurface from = " + from + " texture = " + texture);
        if (this.mCurrentState == 5) {
            PlayerLogger.i(TAG, "QHVCPlayer setSurface return mCurrentState == STATE_STOP");
            return;
        }
        if (this.mSurfaceTextureCheck == texture && texture == null) {
            PlayerLogger.i(TAG, "mSurfaceTextureCheck == texture && texture == null. return???");
            return;
        }
        this.mSurfaceTextureCheck = texture;
        if (this.getDecoderMode() != 11 && !this.mUseSwapSurface && !this.isUseFilter() && this.mSurfaceRenderListener == null) {
            PlayerLogger.i(TAG, "QHVCPlayer not use swap surface");
            if (texture != null) {
                if (texture != this.mSurfaceTextCache) {
                    this.mSurfaceTextCache = texture;
                    if (this.mSurfaceRead != null) {
                        this.mSurfaceRead.release();
                        this.mSurfaceRead = null;
                    }
                }
                if (this.mSurfaceRead == null) {
                    this.mSurfaceRead = new Surface(texture);
                }
                JPlayer.setSurface(from, this.mPlayerId, this.mSurfaceRead);
            } else {
                JPlayer.setSurface(from, this.mPlayerId, null);
            }
            return;
        }
        this.mUseSwapSurface = true;
        if (texture != null) {
            this.mSurfaceTextCache = texture;
            if (this.mSurfaceRead != null) {
                JPlayer.setSurface(from, this.mPlayerId, this.mSurfaceRead);
            } else if (this.mSurfaceTextureEGLSurface == null) {
                this.mSurfaceTextureEGLSurface = new SurfaceTextureEGLSurface();
                this.mSurfaceTextureEGLSurface.init(new SurfaceTextureEGLSurface.SurfaceTextureListener(){

                    @Override
                    public void onSurfaceTextureCreated(SurfaceTexture surfaceTexture) {
                        QHVCPlayer.this.mSurfaceRead = new Surface(surfaceTexture);
                        JPlayer.setSurface(from, QHVCPlayer.this.mPlayerId, QHVCPlayer.this.mSurfaceRead);
                        PlayerLogger.d(QHVCPlayer.TAG, "QHVCPlayer onSurfaceTextureCreated" + surfaceTexture);
                    }

                    @Override
                    public void onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                        if (QHVCPlayer.this.mSurfaceRead != null) {
                            QHVCPlayer.this.mSurfaceRead.release();
                            QHVCPlayer.this.mSurfaceRead = null;
                            boolean isHwDecoder = false;
                            QHVCPlayer.this.mPlayerLock.lock();
                            try {
                                if (QHVCPlayer.this.mPlayerControl != null && QHVCPlayer.this.mPlayerControl.getUseHwDecoder() == 1) {
                                    isHwDecoder = true;
                                }
                            }
                            finally {
                                QHVCPlayer.this.mPlayerLock.unlock();
                            }
                            if (!isHwDecoder) {
                                JPlayer.setSurface(from, QHVCPlayer.this.mPlayerId, null);
                                PlayerLogger.d(QHVCPlayer.TAG, "QHVCPlayer onSurfaceTextureDestroyed" + surfaceTexture);
                            }
                        }
                    }

                    @Override
                    public void onFirstFrameAvailable() {
                        PlayerLogger.d(QHVCPlayer.TAG, "QHVCPlayer onFirstFrameAvailable");
                        QHVCPlayer.this.postMsg(new Runnable(){

                            @Override
                            public void run() {
                                QHVCPlayer.this.reportPlayStart();
                            }
                        });
                    }
                }, this.mSurfaceRenderListener);
            }
            if (this.mSurfaceTextureEGLSurface != null) {
                this.mSurfaceTextureEGLSurface.setSurface(texture);
                this.mSurfaceTextureEGLSurface.setSurfaceViewport(this.mSurfaceX, this.mSurfaceY, this.mSurfaceWidth, this.mSurfaceHeight);
                this.mSurfaceTextureEGLSurface.setFilterValues(this.mBrightnessValue, this.mContrastValue, this.mSaturationValue);
            }
        } else {
            boolean isHwDecoder = false;
            this.mPlayerLock.lock();
            try {
                if (this.mPlayerControl != null && this.mPlayerControl.getUseHwDecoder() == 1) {
                    isHwDecoder = true;
                }
            }
            finally {
                this.mPlayerLock.unlock();
            }
            if (!isHwDecoder) {
                JPlayer.setSurface(from, this.mPlayerId, null);
                PlayerLogger.d(TAG, "QHVCPlayer setSurface null");
            }
            if (this.mSurfaceTextureEGLSurface != null) {
                this.mSurfaceTextureEGLSurface.setSurface(null);
            }
        }
    }

    @Override
    public int setSurfaceViewport(int x, int y, int width, int height) {
        this.mSurfaceX = x;
        this.mSurfaceY = y;
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        if (this.mSurfaceTextureEGLSurface != null) {
            this.mSurfaceTextureEGLSurface.setSurfaceViewport(this.mSurfaceX, this.mSurfaceY, this.mSurfaceWidth, this.mSurfaceHeight);
        }
        return 0;
    }

    private void reportPlayStart() {
        if (this.mSurfaceTextureEGLSurface == null || this.mSurfaceTextureEGLSurface.isFirstFrameAvailable()) {
            this.mListenerInfo.onInfoSafeCall(2001, 20001);
            PlayerLogger.d(TAG, "QHVCPlayer reportPlayStart mCallback.onInfo");
            if (this.mP2PServerHelper != null) {
                this.mP2PServerHelper.setVideoDuration(this.mSn, this.getDuration());
            }
        } else {
            PlayerLogger.d(TAG, "QHVCPlayer reportPlayStart wait");
        }
    }

    public boolean isUseHdRedord(int width, int height) {
        if (this.mPlayerSettings == null) {
            return false;
        }
        int blackListSupport = GPWebrtcSettings.getInstance().getEnableLiveHwEncodeH264();
        int use_hw_record = this.mPlayerSettings.getUse_hw_record();
        boolean sizeFit = false;
        if (width >= 360 && height >= 640 || height >= 360 && width >= 640) {
            sizeFit = true;
        }
        PlayerLogger.i(TAG, "use_hw_record=" + use_hw_record + " --blackListSupport: " + blackListSupport + "-- Build.VERSION.SDK_INT: " + Build.VERSION.SDK_INT + "--sizeFit:" + sizeFit + "--width:" + width + "--heigth:" + height);
        return use_hw_record != 0 && blackListSupport == 1 && Build.VERSION.SDK_INT >= 19 && sizeFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int startRecorder(String filePath, String fmt, RecordConfig config, IQHVCPlayerAdvanced.OnRecordListener listener) {
        PlayerLogger.i("QHVCPlayer", "startRecorder filePath=" + filePath + " fmt: " + fmt + " config: " + (config != null ? config.toString() : ""));
        this.mOnRecordListener = null;
        if ("mp4".equals(fmt)) {
            this.mUseHdRedord = this.isUseHdRedord(this.videoWidth, this.videoHeight);
            PlayerLogger.i("QHVCPlayer", "startRecorder\uff08\uff09---isUseHdRedord \uff1a" + this.mUseHdRedord + "--getVideoWidth():" + this.videoWidth + "--getVideoHeight:" + this.videoHeight);
            PlayerLogger.i("QHVCPlayer", "ILiveCloudPlayer.RECORDER_FORMAT_MP4.equals(fmt):mUseHdRedord" + this.mUseHdRedord);
        }
        if (!this.mUseSwapSurface && this.mUseHdRedord) {
            this.setSurface("recored", null);
            var5_5 = this;
            synchronized (var5_5) {
                this.mUseSwapSurface = true;
                this.mSurfaceTextureCheck = null;
                this.mSurfaceTextCache = null;
                if (this.mSurfaceRead != null) {
                    this.mSurfaceRead.release();
                    this.mSurfaceRead = null;
                }
            }
        }
        if (this.mPlayerControl != null && this.mPlayerId != 0 && !TextUtils.isEmpty((CharSequence)filePath) && (TextUtils.equals((CharSequence)fmt, (CharSequence)"mov") || TextUtils.equals((CharSequence)fmt, (CharSequence)"gif") || TextUtils.equals((CharSequence)fmt, (CharSequence)"mp4"))) {
            this.mOnRecordListener = listener;
            ret = -1;
            if (!this.mUseHdRedord) {
                this.mPlayerLock.lock();
                try {
                    if (this.mPlayerControl == null || (ret = this.mPlayerControl.initRecorder(filePath, fmt, config)) != 0) ** GOTO lbl39
                    ret = this.mPlayerControl.startRecorder();
                }
                finally {
                    this.mPlayerLock.unlock();
                }
            } else {
                this.mRecorderSDK = QHVCRecorderSDK.getInstance();
                this.mRecorderSDK.setSurfaceTextureListener(new QHVCRecorderSDK.SurfaceTextureListener(){

                    @Override
                    public void onSurfaceTextureCreated(SurfaceTexture surfaceTexture) {
                        PlayerLogger.d(QHVCPlayer.TAG, "QHVCRecorderSDK onSurfaceTextureCreated");
                        while (QHVCPlayer.this.mSurfaceTextureEGLSurface == null) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        QHVCPlayer.this.mSurfaceTextureEGLSurface.setRecordSurface(surfaceTexture);
                    }

                    @Override
                    public void onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                        PlayerLogger.d(QHVCPlayer.TAG, "QHVCRecorderSDK onSurfaceTextureDestroyed ");
                    }

                    @Override
                    public void onFrameAvailable() {
                        PlayerLogger.d(QHVCPlayer.TAG, "QHVCRecorderSDK onFrameAvailable ");
                    }
                });
                saveFile = new File(filePath);
                this.mRecorderSDK.startRecord(this.mContext, saveFile.getParent() + "/", saveFile.getName(), this.videoWidth, this.videoHeight, (Integer)this.getMediaInformation().get("bitrate") * 1000 * 8, 30, 2);
                this.startRecordAAC();
                ret = 0;
            }
lbl39:
            // 3 sources

            if (ret == 0) {
                this.isRecording = true;
            }
            return ret;
        }
        return -1;
    }

    @Override
    public int stopRecorder() {
        PlayerLogger.i(TAG, "stopRecorder");
        if (!this.mUseHdRedord) {
            this.mPlayerLock.lock();
            try {
                if (this.mPlayerControl != null && this.mPlayerId != 0) {
                    this.isRecording = false;
                    int n = this.mPlayerControl.stopRecorder();
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                this.mPlayerLock.unlock();
            }
        }
        if (this.mRecorderSDK != null) {
            this.mRecorderSDK.stopRecording();
            this.mRecorderSDK = null;
            this.stopRecordAAC();
        }
        if (this.mSurfaceTextureEGLSurface != null) {
            this.mSurfaceTextureEGLSurface.setRecordSurface(null);
        }
        this.isRecording = false;
        return 0;
    }

    private void sendMsg(int what) {
        this.sendMsg(what, 0, 0, null);
    }

    private void sendMsg(int what, Object obj) {
        this.sendMsg(what, 0, 0, obj);
    }

    private void sendMsg(int what, int arg1, int arg2) {
        this.sendMsg(what, arg1, arg2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMsg(int what, int arg1, int arg2, Object obj) {
        this.mHandlerLock.lock();
        try {
            if (this.mEventHandler != null) {
                this.mEventHandler.obtainMessage(what, arg1, arg2, obj).sendToTarget();
            }
        }
        finally {
            this.mHandlerLock.unlock();
        }
    }

    private void postMsg(Runnable r) {
        this.postDelayedMsg(r, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postDelayedMsg(Runnable r, long delayMillis) {
        this.mHandlerLock.lock();
        try {
            if (this.mEventHandler != null) {
                this.mEventHandler.postDelayed(r, delayMillis);
            }
        }
        finally {
            this.mHandlerLock.unlock();
        }
    }

    private void postAtFrontOfQueueMsg(Runnable r) {
        this.mHandlerLock.lock();
        try {
            if (this.mEventHandler != null) {
                this.mEventHandler.postAtFrontOfQueue(r);
            }
        }
        finally {
            this.mHandlerLock.unlock();
        }
    }

    private void removeHandlerCallback(Runnable r) {
        this.mHandlerLock.lock();
        try {
            if (this.mEventHandler != null) {
                this.mEventHandler.removeCallbacks(r);
            }
        }
        finally {
            this.mHandlerLock.unlock();
        }
    }

    public void setPlayerControlConfig(PlayerControl playerControl, int playerId, String sid) {
        PlayerLogger.d(TAG, "set player control config.");
        if (playerControl != null && playerId != 0) {
            this.setUseHw(playerControl, sid);
            this.setUseQy265dec(playerControl, playerId, true);
            playerControl.setStreamType(this.cStreamType());
            playerControl.setPlayMode(this.mPlayMode);
        }
    }

    @Override
    public void switchResolution(int index, IQHVCPlayerAdvanced.QHVCSwitchResolutionListener listener) {
        PlayerLogger.i(TAG, "switch resolution.");
        this.isResolutionAdapt = false;
        if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
            this.switchResolutionStop("handle switch. stop last switch!");
        }
        if (this.mSourceIndex == index) {
            if (listener != null) {
                String url = "";
                if (this.mSource != null && index < this.mSource.length) {
                    url = this.mSource[index];
                }
                listener.onSuccess(index, url);
            }
        } else {
            this.switchResolutionImpl(index, listener, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchResolutionImpl(int index, IQHVCPlayerAdvanced.QHVCSwitchResolutionListener l, boolean isAdapt) {
        PlayerLogger.d(TAG, "switch resolution impl. index: " + index + " isAdapt: " + isAdapt);
        if (!this.isPlaying()) {
            PlayerLogger.d(TAG, "failed. player not in playing...");
            if (l != null) {
                l.onError(-1, "player not in playing...");
            }
            return;
        }
        if (this.mPlayMonitor != null && !this.mPlayMonitor.needSwitchResolution(this.mContext, isAdapt)) {
            if (l != null) {
                l.onError(-1, "");
            }
            return;
        }
        if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
            PlayerLogger.d(TAG, "failed. switch resolution doing...");
            if (l != null) {
                l.onError(-1, "switch resolution doing...");
            }
            return;
        }
        if (l != null) {
            l.onPrepare();
        }
        int curPos = this.getCurrentPosition();
        long cacheDuration = 0L;
        long[] timestamp = new long[1];
        int ret = -1;
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null) {
                cacheDuration = this.mPlayerControl.getCacheDuration();
            }
            ret = this.mPlayerControl.stopCache(timestamp, 1);
        }
        finally {
            this.mPlayerLock.unlock();
        }
        PlayerLogger.d(TAG, "stop cache. ret: " + ret + " timestamp: " + timestamp[0]);
        if (isAdapt) {
            if (0 == ret) {
                if (timestamp[0] >= 0L) {
                    long switchDelay = timestamp[0] - (long)curPos;
                    if (switchDelay < 0L) {
                        switchDelay = 0L;
                    }
                    this.switchResolutionBeginProxy(index, l, (int)timestamp[0], switchDelay);
                } else {
                    if (this.mResolutionMgr != null) {
                        this.mResolutionMgr.setForceSwitch(true);
                    }
                    this.switchResolutionBeginProxy(index, l, this.getCurrentPosition(), 0L);
                }
            } else {
                if (l != null) {
                    l.onError(-2, "stop cache failed! " + ret);
                }
                if (this.mPlayMonitor != null) {
                    this.mPlayMonitor.resetStat();
                }
            }
        } else {
            int delayMillis = (int)(5000.0f * this.mPlayBackRate);
            if (cacheDuration > (long)delayMillis) {
                this.switchResolutionBeginProxy(index, l, curPos + delayMillis, 5000L);
            } else {
                if (this.mResolutionMgr != null) {
                    this.mResolutionMgr.setForceSwitch(true);
                }
                this.switchResolutionBeginProxy(index, l, curPos, 0L);
            }
        }
    }

    private void switchResolutionBeginProxy(final int index, final IQHVCPlayerAdvanced.QHVCSwitchResolutionListener l, final int switchPos, final long switchDelay) {
        if (index > this.mSource.length - 1) {
            PlayerLogger.d(TAG, "switchResolutionBeginProxy index error!!!");
            return;
        }
        P2PServerHelper p2PServerHelper = this.getP2PServerHelper();
        if (p2PServerHelper != null) {
            p2PServerHelper.createTask(this.mSource[index], this.mForceP2P, new P2PServerHelper.CreateTaskCallback(){

                @Override
                public void onCallback(int ret, String p2pUrl) {
                    QHVCPlayer.this.switchResolutionBegin(index, l, switchPos, switchDelay, p2pUrl);
                }
            });
        } else {
            this.switchResolutionBegin(index, l, switchPos, switchDelay, this.mSource[index]);
        }
    }

    private void switchResolutionBegin(int index, IQHVCPlayerAdvanced.QHVCSwitchResolutionListener l, int switchPos, long switchDelay, String p2pUrl) {
        PlayerLogger.d(TAG, "switch begin. index: " + index + " curPos: " + this.getCurrentPosition() + " switchPos: " + switchPos + " switchDelay: " + switchDelay);
        this.mSourceIndexCache = index;
        this.switchResolutionListener = l;
        this.mResolutionMgr.switchResolution(this.mContext, this, this.mConfig, this.mChannelId, this.mSessionIdInitValue, this.mPlayerSettings, index, p2pUrl, switchPos, new QHVCResolutionMgr.OnSwitchListener(){

            @Override
            public void openLiveTimeout(int playerId, PlayerControl control, String url) {
                if (QHVCPlayer.this.mResolutionMgr != null) {
                    QHVCPlayer.this.mResolutionMgr.updateStatus(5);
                }
                if (QHVCPlayer.this.mEventHandler != null && QHVCPlayer.this.mPlayerControl != null) {
                    if (QHVCPlayer.this.isPaused()) {
                        QHVCPlayer.this.switchResolutionStop("is paused");
                    } else if (QHVCPlayer.this.isPlaying()) {
                        QHVCPlayer.this.postDelayedMsg(QHVCPlayer.this.switchResolutionRunable, 0L);
                    } else {
                        QHVCPlayer.this.switchResolutionRunError(-1, "");
                    }
                } else {
                    QHVCPlayer.this.switchResolutionRunError(-1, "");
                }
            }

            @Override
            public void onPlayerOpened(int playerId, PlayerControl control, int secondPlayerPos, String url) {
                if (QHVCPlayer.this.mResolutionMgr != null) {
                    QHVCPlayer.this.mResolutionMgr.updateStatus(5);
                }
                if (QHVCPlayer.this.mEventHandler != null && QHVCPlayer.this.mPlayerControl != null) {
                    if (QHVCPlayer.this.isPaused()) {
                        QHVCPlayer.this.switchResolutionStop("is paused");
                    } else if (QHVCPlayer.this.isPlaying()) {
                        long curPos = QHVCPlayer.this.getCurrentPosition();
                        long delayMillis = (long)secondPlayerPos - curPos;
                        if (!QHVCPlayer.isDefaultPlayBackRate(QHVCPlayer.this.mPlayBackRate)) {
                            PlayerLogger.d(QHVCPlayer.TAG, "playback rate: " + QHVCPlayer.this.mPlayBackRate + " old delay: " + delayMillis);
                            delayMillis = (int)((float)delayMillis / QHVCPlayer.this.mPlayBackRate);
                        }
                        PlayerLogger.d(QHVCPlayer.TAG, "second player pos: " + secondPlayerPos + " current pos: " + curPos + "real switch delay: " + delayMillis);
                        if (delayMillis > 0L) {
                            QHVCPlayer.this.postDelayedMsg(QHVCPlayer.this.switchResolutionRunable, delayMillis);
                        } else {
                            QHVCPlayer.this.postDelayedMsg(QHVCPlayer.this.switchResolutionRunable, 0L);
                        }
                    } else {
                        QHVCPlayer.this.switchResolutionRunError(-1, "");
                    }
                } else {
                    QHVCPlayer.this.switchResolutionRunError(-1, "");
                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {
                QHVCPlayer.this.switchResolutionRunError(errorCode, errorMsg);
            }
        }, this.isResolutionAdapt, switchDelay, this.mPlayBackRate);
    }

    private void switchResolutionRunSuccess(int switchRunRet, String url) {
        PlayerLogger.d(TAG, "switch resolution suc. idx:" + this.mSourceIndex + " url: " + this.mSource[this.mSourceIndex]);
        if (url == null || !url.equals(this.mSource[this.mSourceIndex])) {
            PlayerLogger.d(TAG, "switch resolution success. url not match!!!");
        }
        if (this.mResolutionMgr != null) {
            this.mResolutionMgr.updateStatus(7);
        }
        if (this.mResolutionMgr != null) {
            this.mResolutionMgr.resetValue();
        }
        if (0 == switchRunRet) {
            this.mSwitchResolutionDoing = false;
            if (QHVCPlayer.isDefaultPlayBackRate(this.mPlayBackRate)) {
                this.mPlayerLock.lock();
                try {
                    if (this.mPlayerControl != null) {
                        this.mPlayerControl.setPlayBackRate(this.mPlayBackRate);
                    }
                }
                finally {
                    this.mPlayerLock.unlock();
                }
            }
            if (this.switchResolutionListener != null) {
                this.switchResolutionListener.onStart();
                this.switchResolutionListener.onSuccess(this.mSourceIndex, this.mSource[this.mSourceIndex]);
            }
        } else if ((2 == switchRunRet || 1 == switchRunRet) && this.switchResolutionListener != null) {
            this.switchResolutionListener.onStart();
        }
        if (this.mPlayMonitor != null) {
            this.mPlayMonitor.stat(3, 0, 0, null);
        }
    }

    private void switchResolutionRunError(int errorCode, String errorMsg) {
        PlayerLogger.d(TAG, "switch resolution failed. " + errorCode + " " + errorMsg);
        if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.stat(3, -1, 0, null);
            }
            this.switchResolutionStop("errorCode: " + errorCode + " " + errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int switchResolutionRun(int secondPlayerId, PlayerControl secondPlayerCtrl, int secondPlayerPosition, String newUrl, int prepareStatus, String sessionId) {
        int ret = -1;
        Logger.i((String)TAG, (String)"switch resolution run");
        this.mPlayerLock.lock();
        try {
            if (this.mPlayerControl != null && secondPlayerId != 0 && secondPlayerCtrl != null && newUrl != null) {
                P2PServerHelper p2PServerHelper;
                if (!this.isPlaying()) {
                    int n = -1;
                    return n;
                }
                int curPos = this.getCurrentPosition();
                Logger.e((String)TAG, (String)("real switch. position: " + curPos + " second player position: " + secondPlayerPosition + " diff: " + (secondPlayerPosition - curPos)));
                if (this.mResolutionMgr != null && !this.mResolutionMgr.isForceSwitch() && this.isResolutionAdapt && (float)Math.abs(secondPlayerPosition - curPos) > 2000.0f * this.mPlayBackRate) {
                    int n = -1;
                    return n;
                }
                Logger.i((String)TAG, (String)"switch resolution run. begin");
                boolean isMute = this.mMute;
                this.mPlayerControl.setMute(true);
                this.mPlayerControl.pause(-1);
                ILiveCloudDisplay display = this.mCurrentDisplay;
                if (display instanceof QHVCTextureView) {
                    PlayerLogger.d(TAG, "QHVCTextureView pause surface");
                    ((QHVCTextureView)display).pauseSurface();
                }
                if (!TextUtils.isEmpty((CharSequence)this.mSessionId)) {
                    Stats.userStop((String)this.mSessionId);
                }
                final PlayerControl cacheFirstPlayerCtrl = this.mPlayerControl;
                this.mSwitchResolutionDoingCachePosition = curPos;
                this.mSwitchResolutionDoing = true;
                this.mPlayerControl = secondPlayerCtrl;
                this.mPlayerControl.setCallback(null);
                this.mPlayerId = secondPlayerId;
                this.mPlayerControl.setCallback(this);
                this.mSessionId = sessionId;
                display.setHandle(secondPlayerId);
                this.setPlayMode(this.mPlayMode);
                this.mPlayUrl = newUrl;
                this.mPlayerControl.setMute(isMute);
                this.mMute = isMute;
                PlayerLogger.e(TAG, "switch resolution. prepare status: " + prepareStatus);
                if (prepareStatus == 0) {
                    this.mPlayerControl.startLive();
                    ret = 2;
                } else if (prepareStatus == 1) {
                    this.mCurrentState = 4;
                    this.start();
                    ret = 1;
                } else if (prepareStatus == 2) {
                    this.mCurrentState = 4;
                    this.start();
                    ret = 0;
                } else {
                    PlayerLogger.e(TAG, "switch resolution. not support prepare status!");
                }
                if (display instanceof QHVCTextureView) {
                    PlayerLogger.d(TAG, "QHVCTextureView resume surface");
                    ((QHVCTextureView)display).resumeSurface();
                }
                if (this.mInBackground) {
                    this.mPlayerControl.setInBackground(this.mInBackground);
                }
                if (this.mSourceIndex >= 0 && this.mSourceIndex < this.mSourceRids.length && (p2PServerHelper = this.getP2PServerHelper()) != null) {
                    p2PServerHelper.cancelTask(this.mSource[this.mSourceIndex], new P2PServerHelper.CancelTaskCallback(){

                        @Override
                        public void onCallback(int ret) {
                        }
                    });
                }
                this.mSourceIndex = this.mSourceIndexCache;
                if (this.mSourceIndex >= 0 && this.mSourceIndex < this.mSourceRids.length) {
                    this.mSn = this.mSource[this.mSourceIndex];
                }
                if (this.mLocalServerHelper != null && this.mSourceRids != null && this.mSourceIndex >= 0 && this.mSourceIndex < this.mSourceRids.length) {
                    this.mLocalServerHelper.setDataSource(this.mSourceRids[this.mSourceIndex], this.mSource[this.mSourceIndex]);
                }
                PlayerLogger.d(TAG, "second player playing...");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        QHVCPlayer.this.mPlayerLock.lock();
                        try {
                            if (cacheFirstPlayerCtrl != null) {
                                PlayerLogger.d(QHVCPlayer.TAG, "release switch. first player close: " + cacheFirstPlayerCtrl);
                                cacheFirstPlayerCtrl.close(0);
                            }
                        }
                        finally {
                            QHVCPlayer.this.mPlayerLock.unlock();
                        }
                    }
                }).start();
                Logger.i((String)TAG, (String)"switch resolution run. end");
                int n = ret;
                return n;
            }
        }
        finally {
            this.mPlayerLock.unlock();
        }
        return -1;
    }

    private void switchResolutionRunWrap() {
        PlayerLogger.d(TAG, "multi resolution adapt check.");
        if (this.mPlayerControl != null && this.mResolutionMgr != null && this.mResolutionMgr.getSwitchStatus() == 5) {
            PlayerLogger.d(TAG, "remove switch runable. ");
            this.removeHandlerCallback(this.switchResolutionRunable);
            this.mResolutionMgr.updateStatus(6);
            QHVCResolutionMgr.SecondPlayerInfo o = this.mResolutionMgr.getSecondPlayer();
            if (o.playerId != 0 && o.control != null && o.url != null && !this.mIsSeek) {
                long tick = System.currentTimeMillis();
                int ret = this.switchResolutionRun(o.playerId, o.control, o.position, o.url, o.prepareStatus, o.sessionId);
                if (0 == ret || 2 == ret || 1 == ret) {
                    this.switchResolutionRunSuccess(ret, o.url);
                } else {
                    this.switchResolutionRunError(-1, "real switch error");
                }
                Logger.w((String)TAG, (String)("switch resolution use: " + (System.currentTimeMillis() - tick)));
            } else {
                Logger.e((String)TAG, (String)("is seeking: " + this.mIsSeek + " is play complete: " + this.isPlayComplete));
                this.switchResolutionRunError(-1, "switch error. second info invalid.");
            }
        } else {
            Logger.e((String)TAG, (String)"switch resolution run wrap. do nothing. not waiting switch status.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int switchResolutionStop(String reason) {
        PlayerLogger.d(TAG, "stop switch rsolution. reson: " + reason);
        if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
            if (this.mEventHandler != null) {
                PlayerLogger.d(TAG, "remove switch runable. ");
                this.removeHandlerCallback(this.switchResolutionRunable);
                if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
                    this.mResolutionMgr.updateStatus(8);
                    this.postAtFrontOfQueueMsg(new Runnable(){

                        @Override
                        public void run() {
                            QHVCPlayer.this.mResolutionMgr.resetValueWithClosePlayer();
                        }
                    });
                }
            }
            if (this.mPlayMonitor != null) {
                this.mPlayMonitor.resetStat();
            }
            if (this.switchResolutionListener != null) {
                this.switchResolutionListener.onError(-2, "stop reason: " + reason);
            }
            this.mPlayerLock.lock();
            try {
                if (this.mPlayerControl == null) return 0;
                int ret = this.mPlayerControl.resumeCache();
                PlayerLogger.d(TAG, "id: " + this.mPlayerId + " resumme cache ret: " + ret);
                return 0;
            }
            finally {
                this.mPlayerLock.unlock();
            }
        } else {
            PlayerLogger.d(TAG, "stop switch rsolution. not run");
        }
        return 0;
    }

    @Override
    public int setResolutionAdapt(boolean isAdapt, IQHVCPlayerAdvanced.QHVCSwitchResolutionListener listener) {
        PlayerLogger.i(TAG, "resolution adapt. isAdapt: " + isAdapt);
        if (this.mResolutionMgr != null && !this.mResolutionMgr.isUnStart()) {
            this.switchResolutionStop("resolution adapt. stop last switch!");
        }
        this.isResolutionAdapt = isAdapt;
        this.switchResolutionListener = listener;
        if (isAdapt && this.mResolutionMgr != null) {
            this.mResolutionMgr.setForceSwitch(true);
        } else {
            this.mResolutionMgr.setForceSwitch(false);
        }
        if (this.mPlayMonitor != null) {
            this.mPlayMonitor.stat(5, 0, 0, null);
        }
        return 0;
    }

    @Override
    public boolean isSystemMediaPlayer() {
        return false;
    }

    public static boolean isDefaultPlayBackRate(float playbackRate) {
        return playbackRate > 0.95f && playbackRate < 1.05f;
    }

    @Override
    public int getPropertyRotate() {
        return this.mPropertyRotate;
    }

    @Override
    public void setFilterValues(float brightness, float contrast, float saturation) {
        if (this.mPlayerSettings == null) {
            return;
        }
        if (this.mPlayerSettings.getFilter_enable() == 0) {
            return;
        }
        if (this.mPlayerSettings.getFilter_mode() != 0) {
            return;
        }
        if (brightness < -0.2f || brightness > 0.35f || contrast < 0.9f || contrast > 1.6f || saturation < 0.15f || saturation > 2.0f) {
            return;
        }
        this.mUseFilter = true;
        this.mBrightnessValue = brightness;
        this.mContrastValue = contrast;
        this.mSaturationValue = saturation;
        if (this.mSurfaceTextureEGLSurface != null) {
            this.mSurfaceTextureEGLSurface.setFilterValues(this.mBrightnessValue, this.mContrastValue, this.mSaturationValue);
        }
    }

    private boolean isUseFilter() {
        return this.mUseFilter;
    }

    @Override
    public void enableP2P(boolean enable) {
        this.mP2PEnable = enable;
    }

    public static void clearP2PCache() {
        P2PServerHelper.clearCache();
    }

    public static void setP2PCacheSize(int cacheSize) {
        P2PServerHelper.setCacheSize(cacheSize);
    }

    public static void enableP2PUpload(boolean enableUpload) {
        P2PServerHelper.enableUpload(enableUpload);
    }

    private P2PServerHelper getP2PServerHelper() {
        P2PServerHelper p2PServerHelper;
        if (this.mP2PServerHelper == null && this.mP2PEnable && (p2PServerHelper = new P2PServerHelper()) != null && p2PServerHelper.isValid()) {
            this.mP2PServerHelper = p2PServerHelper;
        }
        if (this.mP2PServerHelper != null) {
            this.mP2PServerHelper.setLogLevel(this.getP2PLogLevel());
            int ret = this.mP2PServerHelper.initialize(this.mContext, P2PServerHelper.getP2PCacheDir(), this.mChannelId, "", null);
            if (ret != P2PServerHelper.ERROR_OK) {
                this.mP2PServerHelper = null;
            }
        }
        return this.mP2PServerHelper;
    }

    private int getP2PLogLevel() {
        if (Logger.LOG_ENABLE) {
            return P2PServerHelper.LOG_LEVEL_TRACE;
        }
        return P2PServerHelper.LOG_LEVEL_NONE;
    }

    public void test_hard_decoder_error() {
        PlayerLogger.d(TAG, "QHVCPlayer test_hard_decoder_error");
        this.onPlayerMsgHandle(this.getHandle(), -800, 0L, 0L, 0);
    }

    public boolean getRecordingState() {
        return this.isRecording;
    }

    static interface QHVCSwitchResolutionRunRet {
        public static final int FAILED = -1;
        public static final int VIDEO_IS_READY = 0;
        public static final int OPEN_LIVE_TIMEOUT = 1;
        public static final int NOT_OPEN = 2;
    }

    private class LocalServerHelper {
        private Method mGetFileAvailedSizeMethod;
        private String mRid;
        private String mUrl;

        public LocalServerHelper() {
            try {
                Class<?> localServerClazz = Class.forName("net.qihoo.videocloud.LocalServer");
                this.mGetFileAvailedSizeMethod = localServerClazz.getMethod("getFileAvailedSize", String.class, String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void setDataSource(String rid, String url) {
            this.mRid = rid;
            this.mUrl = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getCacheDuration() {
            long duration = -1L;
            if (this.mGetFileAvailedSizeMethod != null && !TextUtils.isEmpty((CharSequence)this.mRid) && !TextUtils.isEmpty((CharSequence)this.mUrl)) {
                try {
                    duration = ((Integer)this.mGetFileAvailedSizeMethod.invoke(null, this.mRid, this.mUrl, QHVCPlayer.this.getCurrentPosition(), QHVCPlayer.this.getDuration())).intValue();
                    PlayerLogger.v(QHVCPlayer.TAG, "cache duration localserver: " + duration);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            QHVCPlayer.this.mPlayerLock.lock();
            try {
                if (duration <= 0L && QHVCPlayer.this.mPlayerControl != null) {
                    duration = QHVCPlayer.this.mPlayerControl.getCacheDuration();
                    PlayerLogger.v(QHVCPlayer.TAG, "cache duration: " + duration);
                }
            }
            finally {
                QHVCPlayer.this.mPlayerLock.unlock();
            }
            return duration;
        }
    }

    static class PlayerMsg {
        int handle;
        int command;
        long para1;
        long para2;
        int user;

        public PlayerMsg(int handle, int command, long para1, long para2, int user) {
            this.handle = handle;
            this.command = command;
            this.para1 = para1;
            this.para2 = para2;
            this.user = user;
        }
    }

    static class ListenerInfo {
        QHVCPlayer qhvcPlayer;
        private IQHVCPlayer.OnPreparedListener onPreparedListener;
        private IQHVCPlayer.OnSeekCompleteListener onSeekCompleteListener;
        private IQHVCPlayer.OnErrorListener onErrorListener;
        private IQHVCPlayer.OnCompletionListener onCompletionListener;
        private IQHVCPlayer.OnInfoListener onInfoListener;
        private IQHVCPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener;
        private IQHVCPlayer.OnBufferingUpdateListener onBufferingUpdateListener;
        private IQHVCPlayer.OnBufferingEventListener onBufferingEventListener;
        private IQHVCPlayer.onProgressChangeListener onProgressChangeListener;
        private AudioInfo audioInfo;
        private IQHVCPlayerAdvanced.OnAudioPCMListener onAudioPCMListener;
        private IQHVCPlayerAdvanced.OnUserDefinedDataListener onUserDefinedDataListener;
        private IQHVCPlayerAdvanced.OnPlayerNetStatsListener onPlayerNetStatsListener;

        public ListenerInfo(QHVCPlayer player) {
            this.qhvcPlayer = player;
        }

        private int getHandle() {
            if (this.qhvcPlayer != null) {
                return this.qhvcPlayer.getHandle();
            }
            return 0;
        }

        private void onPreparedSafeCall() {
            if (this.onPreparedListener != null) {
                this.onPreparedListener.onPrepared();
            }
        }

        private void onSeekCompleteSafeCall() {
            int handle;
            if (this.onSeekCompleteListener != null && (handle = this.getHandle()) != 0) {
                this.onSeekCompleteListener.onSeekComplete(handle);
            }
        }

        private boolean onErrorSafeCall(int what, int extra) {
            if (this.onErrorListener != null) {
                return this.onErrorListener.onError(this.getHandle(), what, extra);
            }
            return false;
        }

        private void onCompletionSafeCall() {
            int handle;
            if (this.onCompletionListener != null && (handle = this.getHandle()) != 0) {
                this.onCompletionListener.onCompletion(handle);
            }
        }

        private void onInfoSafeCall(int what, int extra) {
            int handle;
            if (this.onInfoListener != null && (handle = this.getHandle()) != 0) {
                this.onInfoListener.onInfo(handle, what, extra);
            }
        }

        private void onVideoSizeChangedSafeCall(int width, int height) {
            int handle;
            if (this.onVideoSizeChangedListener != null && (handle = this.getHandle()) != 0) {
                this.onVideoSizeChangedListener.onVideoSizeChanged(handle, width, height);
            }
        }

        private void onBufferingUpdateSafeCall(int percent) {
            int handle;
            if (this.onBufferingUpdateListener != null && (handle = this.getHandle()) != 0) {
                this.onBufferingUpdateListener.onBufferingUpdate(handle, percent);
            }
        }

        private void onBufferingEventProgressSafeCall(int progress) {
            int handle;
            if (this.onBufferingEventListener != null && (handle = this.getHandle()) != 0) {
                this.onBufferingEventListener.onBufferingProgress(handle, progress);
            }
        }

        private void onBufferingEventStartSafeCall() {
            int handle;
            if (this.onBufferingEventListener != null && (handle = this.getHandle()) != 0) {
                this.onBufferingEventListener.onBufferingStart(handle);
            }
        }

        private void onBufferingEventStopSafeCall() {
            int handle;
            if (this.onBufferingEventListener != null && (handle = this.getHandle()) != 0) {
                this.onBufferingEventListener.onBufferingStop(handle);
            }
        }

        private void setOnProgressChangeSafeCall(int total, int progress) {
            int handle;
            if (this.onProgressChangeListener != null && (handle = this.getHandle()) != 0) {
                this.onProgressChangeListener.onProgressChange(handle, total, progress);
            }
        }

        private void onAudioFrameDataSafeCall(int id, int flags, int size, ByteBuffer buffer, long time) {
            int handle;
            if (this.onAudioPCMListener != null && (handle = this.getHandle()) != 0) {
                int ret;
                if (this.audioInfo == null && ((ret = this.qhvcPlayer.getAudioInfo(this.audioInfo)) != 0 || this.audioInfo == null)) {
                    this.audioInfo = null;
                    PlayerLogger.d(QHVCPlayer.TAG, "get audio info failed.");
                }
                if (this.audioInfo != null) {
                    buffer.position(0);
                    buffer.limit(size);
                    this.onAudioPCMListener.onAudioPCM(handle, id, buffer, time, this.audioInfo.getChannel(), this.audioInfo.getSampleRate(), this.audioInfo.getBitsPerSample());
                }
            }
        }

        private void onUserDefinedDataSafeCall(byte[] data) {
            int handle;
            if (this.onUserDefinedDataListener != null && (handle = this.getHandle()) != 0) {
                this.onUserDefinedDataListener.onUserDefinedData(handle, data);
            }
        }

        private void onPlayerNetStatsSafeCall(long dvbps, long dabps, long dvfps, long dafps, long fps, long bitrate, long param1, long param2, long param3) {
            int handle;
            if (this.onPlayerNetStatsListener != null && (handle = this.getHandle()) != 0) {
                this.onPlayerNetStatsListener.onPlayerNetStats(handle, dvbps, dabps, dvfps, dafps, fps, bitrate, param1, param2, param3);
            }
        }

        static /* synthetic */ void access$4700(ListenerInfo x0, int x1, int x2) {
            x0.onVideoSizeChangedSafeCall(x1, x2);
        }
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 101: {
                    QHVCPlayer.this.mListenerInfo.onPreparedSafeCall();
                    break;
                }
                case 102: {
                    QHVCPlayer.this.mListenerInfo.setOnProgressChangeSafeCall(msg.arg1, msg.arg2);
                    break;
                }
                case 100: {
                    if (msg.obj == null || !(msg.obj instanceof PlayerMsg)) break;
                    PlayerMsg o = (PlayerMsg)msg.obj;
                    QHVCPlayer.this.onPlayerMsgHandle(o.handle, o.command, o.para1, o.para2, o.user);
                    break;
                }
                case 103: {
                    QHVCPlayer.this.mListenerInfo.onCompletionSafeCall();
                    break;
                }
                case 104: {
                    QHVCPlayer.this.mListenerInfo.onBufferingUpdateSafeCall(msg.arg1);
                    break;
                }
                case 105: {
                    QHVCPlayer.this.mListenerInfo.onInfoSafeCall(msg.arg1, msg.arg2);
                    break;
                }
                case 106: {
                    QHVCPlayer.this.mListenerInfo.onErrorSafeCall(msg.arg1, msg.arg2);
                    break;
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface PlayerState {
    }
}

