/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.qihoo.livecloud.config.PlayerSettings;
import com.qihoo.livecloud.plugin.ILiveCloudPlugin;
import com.qihoo.livecloud.plugin.ILiveCloudPluginEx;
import com.qihoo.livecloud.tools.CloudControlManager;
import com.qihoo.livecloud.tools.LocalSoLoadManager;
import com.qihoo.livecloud.tools.Stats;
import com.qihoo.livecloud.utils.PlayerLogger;
import com.qihoo.videocloud.QHVCPlayer;
import java.util.HashMap;
import java.util.Map;

public class QHVCPlayerPlugin
extends ILiveCloudPluginEx {
    private static QHVCPlayerPlugin sInstance = null;
    public static final String TYPE_SYSTEM = "player_system";
    public static final String TYPE_NORMAL = "player";
    public static final String TYPE_RECORD = "player_record";
    public static final String TYPE_DECODER = "player_decoder";
    public static final String TYPE_DECODER_RECORD = "player_decoder_record";
    private Map<String, ILiveCloudPluginEx> mPlayerPluginTypes;
    private String mPlayerPluginType = "player";
    private String mLoadedPlayerPluginType = null;
    private String mCloudPlayerPluginType = null;

    protected QHVCPlayerPlugin() {
        super(TYPE_NORMAL, QHVCPlayer.getVersion(), "2.0.2.0", 4459601L);
        String nowVersion = QHVCPlayer.getVersion();
        String minVersion = "2.0.2.0";
        this.mPlayerPluginTypes = new HashMap<String, ILiveCloudPluginEx>();
        this.mPlayerPluginTypes.put(TYPE_NORMAL, new ILiveCloudPluginEx(TYPE_NORMAL, nowVersion, minVersion, 4459601L));
        this.mPlayerPluginTypes.put(TYPE_RECORD, new ILiveCloudPluginEx(TYPE_RECORD, nowVersion, minVersion, 5172835L));
        this.mPlayerPluginTypes.put(TYPE_DECODER, new ILiveCloudPluginEx(TYPE_DECODER, nowVersion, minVersion, 7832969L));
        this.mPlayerPluginTypes.put(TYPE_DECODER_RECORD, new ILiveCloudPluginEx(TYPE_DECODER_RECORD, nowVersion, minVersion, 8496721L));
        this.mCloudPlayerPluginType = this.getCloudControlType();
        PlayerLogger.i("LiveCloudPlayer", "setCloudPlayerPluginType=" + this.mCloudPlayerPluginType);
        if (!TextUtils.isEmpty((CharSequence)this.mCloudPlayerPluginType)) {
            this.setPlayerPluginTypeInternal(this.mCloudPlayerPluginType);
        }
        CloudControlManager.getInstance().addCallback(new CloudControlManager.updateConfigCallback(){

            public void updateConfigFinish() {
                ILiveCloudPlugin liveCloudPlugin;
                CloudControlManager.getInstance().removeCallback((CloudControlManager.updateConfigCallback)this);
                String cloudPlayerPluginType = QHVCPlayerPlugin.this.getCloudControlType();
                if (!TextUtils.isEmpty((CharSequence)cloudPlayerPluginType) && cloudPlayerPluginType.compareTo(QHVCPlayerPlugin.TYPE_SYSTEM) != 0 && cloudPlayerPluginType.compareTo(QHVCPlayerPlugin.this.mPlayerPluginType) != 0 && (liveCloudPlugin = (ILiveCloudPlugin)QHVCPlayerPlugin.this.mPlayerPluginTypes.get(cloudPlayerPluginType)) != null && !liveCloudPlugin.isPluginInstalled()) {
                    PlayerLogger.i("LiveCloudPlayer", "cloud control checkInstallPlugin plugin=" + liveCloudPlugin.getTag());
                    liveCloudPlugin.checkInstallPlugin(Stats.getContext(), QHVCPlayerPlugin.this.getPluginDownloadListener(), null);
                }
            }
        });
    }

    public static synchronized QHVCPlayerPlugin getInstance() {
        if (sInstance == null) {
            sInstance = new QHVCPlayerPlugin();
        }
        return sInstance;
    }

    public String getPlayerPluginType() {
        if (this.mPlayerPluginType.compareTo(TYPE_SYSTEM) == 0) {
            return this.mPlayerPluginType;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mLoadedPlayerPluginType)) {
            return this.mLoadedPlayerPluginType;
        }
        return this.mPlayerPluginType;
    }

    public void setPlayerPluginType(String playerPluginType) {
        if (TextUtils.isEmpty((CharSequence)playerPluginType)) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCloudPlayerPluginType)) {
            return;
        }
        this.setPlayerPluginTypeInternal(playerPluginType);
    }

    private void setPlayerPluginTypeInternal(String playerPluginType) {
        if (TextUtils.isEmpty((CharSequence)playerPluginType)) {
            return;
        }
        PlayerLogger.i("LiveCloudPlayer", "setPlayerPluginType=" + playerPluginType);
        if (playerPluginType.compareTo(TYPE_SYSTEM) == 0 || this.mPlayerPluginTypes.containsKey(playerPluginType)) {
            this.mPlayerPluginType = playerPluginType;
        }
    }

    private ILiveCloudPluginEx getPlayerPlugin() {
        if (this.mPlayerPluginType.compareTo(TYPE_SYSTEM) == 0) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mLoadedPlayerPluginType) && this.mPlayerPluginTypes.containsKey(this.mLoadedPlayerPluginType)) {
            return this.mPlayerPluginTypes.get(this.mLoadedPlayerPluginType);
        }
        if (this.mPlayerPluginTypes.containsKey(this.mPlayerPluginType)) {
            return this.mPlayerPluginTypes.get(this.mPlayerPluginType);
        }
        return null;
    }

    public String getTag() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin != null) {
            return liveCloudPlugin.getTag();
        }
        return TYPE_SYSTEM;
    }

    public void setDefaultPluginInstalled(boolean defaultPluginInstalled) {
        if (!defaultPluginInstalled) {
            LocalSoLoadManager.getInstance().cancelLoadSo(new String[]{"transcore", "viewer", "dvrender", "jplayer"});
        }
        for (ILiveCloudPlugin iLiveCloudPlugin : this.mPlayerPluginTypes.values()) {
            iLiveCloudPlugin.setDefaultPluginInstalled(defaultPluginInstalled);
        }
    }

    public boolean isDefaultPluginInstalled() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin != null) {
            return liveCloudPlugin.isDefaultPluginInstalled();
        }
        return true;
    }

    public boolean isPluginInstalled() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin == null || liveCloudPlugin.isPluginInstalled()) {
            return true;
        }
        for (ILiveCloudPlugin iLiveCloudPlugin : this.mPlayerPluginTypes.values()) {
            if (!iLiveCloudPlugin.isPluginInstalled()) continue;
            return true;
        }
        return false;
    }

    public boolean isPluginInstalled(String playerPluginType) {
        ILiveCloudPlugin liveCloudPlugin = (ILiveCloudPlugin)this.mPlayerPluginTypes.get(playerPluginType);
        if (liveCloudPlugin != null) {
            return liveCloudPlugin.isPluginInstalled();
        }
        return true;
    }

    public boolean isPluginValid() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin == null || liveCloudPlugin.isPluginValid()) {
            return true;
        }
        for (ILiveCloudPlugin iLiveCloudPlugin : this.mPlayerPluginTypes.values()) {
            if (!iLiveCloudPlugin.isPluginValid()) continue;
            return true;
        }
        return false;
    }

    public int loadPlugin() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin == null) {
            return 0;
        }
        int ret = liveCloudPlugin.loadPlugin();
        if (ret == 0) {
            this.mLoadedPlayerPluginType = liveCloudPlugin.getTag();
            return ret;
        }
        liveCloudPlugin = (ILiveCloudPlugin)this.mPlayerPluginTypes.get(this.mPlayerPluginType);
        if (liveCloudPlugin != null) {
            PlayerLogger.i("LiveCloudPlayer", "auto checkInstallPlugin plugin=" + liveCloudPlugin.getTag());
            liveCloudPlugin.checkInstallPlugin(Stats.getContext(), this.getPluginDownloadListener(), null);
        }
        for (ILiveCloudPlugin iLiveCloudPlugin : this.mPlayerPluginTypes.values()) {
            if (!iLiveCloudPlugin.isPluginInstalled() || iLiveCloudPlugin.loadPlugin() != 0) continue;
            this.mLoadedPlayerPluginType = iLiveCloudPlugin.getTag();
            ret = 0;
            break;
        }
        return ret;
    }

    public boolean isPluginLoaded() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin == null || liveCloudPlugin.isPluginLoaded()) {
            return true;
        }
        for (ILiveCloudPlugin iLiveCloudPlugin : this.mPlayerPluginTypes.values()) {
            if (!iLiveCloudPlugin.isPluginLoaded()) continue;
            return true;
        }
        return false;
    }

    public String getPluginVersion() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin == null) {
            return Build.VERSION.RELEASE;
        }
        return liveCloudPlugin.getPluginVersion();
    }

    public void checkUninstallPlugin() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin != null) {
            this.getPlayerPlugin().checkUninstallPlugin();
        }
    }

    public void checkUninstallPlugin(String playerPluginType) {
        ILiveCloudPlugin liveCloudPlugin = (ILiveCloudPlugin)this.mPlayerPluginTypes.get(playerPluginType);
        if (liveCloudPlugin != null) {
            liveCloudPlugin.checkUninstallPlugin();
        }
    }

    public int checkInstallOrUpdatePlugin(Context context, ILiveCloudPlugin.PluginCallback callback) {
        return this.checkInstallPlugin(context, callback);
    }

    public int checkInstallOrUpdatePlugin(Context context, ILiveCloudPlugin.PluginDownloadListener listener, ILiveCloudPlugin.PluginCallback callback) {
        return this.checkInstallPlugin(context, listener, callback);
    }

    public int checkInstallPlugin(Context context, ILiveCloudPlugin.PluginCallback callback) {
        return this.checkInstallPlugin(context, null, callback);
    }

    public int checkInstallPlugin(Context context, ILiveCloudPlugin.PluginDownloadListener listener, ILiveCloudPlugin.PluginCallback callback) {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin != null) {
            return this.getPlayerPlugin().checkInstallPlugin(context, listener, callback);
        }
        if (callback != null) {
            callback.onComplete(context, false, 0);
        }
        return 0;
    }

    public int checkUpdatePlugin(Context context, ILiveCloudPlugin.PluginDownloadListener listener) {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin != null) {
            return liveCloudPlugin.checkUpdatePlugin(context, listener);
        }
        return 0;
    }

    public void cancelInstallOrUpdatePlugin() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin != null) {
            this.getPlayerPlugin().cancelInstallOrUpdatePlugin();
        }
    }

    public void backgroundInstallOrUpdatePlugin() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin != null) {
            this.getPlayerPlugin().backgroundInstallOrUpdatePlugin();
        }
    }

    public int removePlugin() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin != null) {
            return this.getPlayerPlugin().removePlugin();
        }
        return 10;
    }

    public int removePlugin(String playerPluginType) {
        ILiveCloudPlugin liveCloudPlugin = (ILiveCloudPlugin)this.mPlayerPluginTypes.get(playerPluginType);
        if (liveCloudPlugin != null) {
            return liveCloudPlugin.removePlugin();
        }
        return 10;
    }

    public long getPluginSize() {
        ILiveCloudPluginEx liveCloudPlugin = this.getPlayerPlugin();
        if (liveCloudPlugin != null) {
            return this.getPlayerPlugin().getPluginSize();
        }
        return 0L;
    }

    private String getCloudControlType() {
        String cloudPlayerPluginType = null;
        PlayerSettings playerSettings = PlayerSettings.fromJsonStr(CloudControlManager.getInstance().getConfigJson());
        if (playerSettings != null) {
            switch (playerSettings.getPlugin_type()) {
                case 0: {
                    cloudPlayerPluginType = null;
                    break;
                }
                case 1: {
                    cloudPlayerPluginType = TYPE_SYSTEM;
                    break;
                }
                case 2: {
                    cloudPlayerPluginType = TYPE_NORMAL;
                    break;
                }
                case 3: {
                    cloudPlayerPluginType = TYPE_RECORD;
                    break;
                }
                case 4: {
                    cloudPlayerPluginType = TYPE_DECODER;
                    break;
                }
                case 5: {
                    cloudPlayerPluginType = TYPE_DECODER_RECORD;
                }
            }
        }
        return cloudPlayerPluginType;
    }
}

