/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud;

import android.content.Context;
import android.util.Log;
import com.qihoo.livecloud.plugin.ILiveCloudPlugin;

public class QHVCQyCodec {
    private static final String TAG = "QY_CODEC";
    private static final String PLUGIN = "qycodec";
    private static final String VERSION = "1.0.0.18031201";
    private static boolean sDebug = false;
    private static volatile boolean sTaskDoing = false;
    private static boolean sIsQyCodecValid = false;
    private static final String QY_CODEC = "qycodec";

    public static void downloadAndInstall(Context context) {
        MyLog.i(TAG, "download and install");
        if (!sTaskDoing) {
            sTaskDoing = true;
            QHVCQyCodec.initProxy(context, new Callback(){

                @Override
                public void onSuccess() {
                    MyLog.i(QHVCQyCodec.TAG, "on success");
                    sTaskDoing = false;
                }

                @Override
                public void onFailed(int errCode) {
                    MyLog.i(QHVCQyCodec.TAG, "not init, because ret=" + errCode);
                    sTaskDoing = false;
                }
            });
        } else {
            MyLog.i(TAG, "download and install. task doing...");
        }
    }

    public static void setDebug(boolean debug) {
        sDebug = debug;
    }

    private static void initProxy(Context context, final Callback callback) {
        final QHVCQyCodecPlugin liveCloudPlugin = QHVCQyCodecPlugin.getInstance();
        if (liveCloudPlugin.isDefaultPluginInstalled()) {
            MyLog.d(TAG, "default %s plugin installed", "qycodec");
            callback.onSuccess();
        } else if (liveCloudPlugin.isPluginInstalled()) {
            int result = liveCloudPlugin.loadPlugin();
            if (result == 0) {
                MyLog.d(TAG, "%s plugin valid, version=%s", "qycodec", liveCloudPlugin.getPluginVersion());
                callback.onSuccess();
            } else {
                MyLog.d(TAG, "%s plugin load failed, result=%d", "qycodec", result);
                callback.onFailed(result);
            }
        } else {
            liveCloudPlugin.checkInstallPlugin(context, new ILiveCloudPlugin.PluginCallback(){

                public void onStart(Context context) {
                    MyLog.d(QHVCQyCodec.TAG, "%s plugin onStart", "qycodec");
                }

                public void onProgress(Context context, int progress) {
                    MyLog.d(QHVCQyCodec.TAG, "%s plugin onProgress, progress=%d", "qycodec", progress);
                }

                public void onComplete(Context context, boolean background, int result) {
                    MyLog.d(QHVCQyCodec.TAG, "%s plugin onComplete, background=%b, result=%d", "qycodec", background, result);
                    if (result == 0) {
                        int loadResult = liveCloudPlugin.loadPlugin();
                        if (loadResult == 0) {
                            MyLog.d(QHVCQyCodec.TAG, "%s plugin onComplete load success", "qycodec");
                            callback.onSuccess();
                        } else {
                            MyLog.e(QHVCQyCodec.TAG, "%s plugin onComplete load failed, result=%d", "qycodec", loadResult);
                            callback.onFailed(loadResult);
                        }
                    } else {
                        MyLog.e(QHVCQyCodec.TAG, "%s plugin onComplete failed, result=%d", "qycodec", result);
                        callback.onFailed(result);
                    }
                }

                public void onCancel(Context context) {
                    MyLog.d(QHVCQyCodec.TAG, "%s plugin onCancel", "qycodec");
                    callback.onFailed(1);
                }
            });
        }
    }

    public static boolean supportQy265dec(Context context) {
        if (!sIsQyCodecValid) {
            boolean isValid = false;
            try {
                MyLog.i(TAG, "load library: qycodec");
                System.loadLibrary("qycodec");
                QHVCQyCodecPlugin.getInstance().setDefaultPluginInstalled(true);
                isValid = true;
            }
            catch (Throwable ignore) {
                isValid = false;
            }
            if (!isValid) {
                QHVCQyCodecPlugin liveCloudPlugin = QHVCQyCodecPlugin.getInstance();
                liveCloudPlugin.setDefaultPluginInstalled(false);
                isValid = liveCloudPlugin.isPluginValid();
            }
            sIsQyCodecValid = isValid;
            return isValid;
        }
        return true;
    }

    private static class MyLog {
        private MyLog() {
        }

        public static void d(String tag, String msg) {
            if (sDebug) {
                Log.d((String)tag, (String)msg);
            }
        }

        public static void d(String tag, String format, Object ... args) {
            if (sDebug) {
                Log.d((String)tag, (String)String.format(format, args));
            }
        }

        public static void i(String tag, String msg) {
            if (sDebug) {
                Log.i((String)tag, (String)msg);
            }
        }

        public static void i(String tag, String format, Object ... args) {
            if (sDebug) {
                Log.i((String)tag, (String)String.format(format, args));
            }
        }

        public static void e(String tag, String msg) {
            if (sDebug) {
                Log.e((String)tag, (String)msg);
            }
        }

        public static void e(String tag, String format, Object ... args) {
            if (sDebug) {
                Log.e((String)tag, (String)String.format(format, args));
            }
        }
    }

    private static class QHVCQyCodecPlugin
    extends ILiveCloudPlugin {
        private static QHVCQyCodecPlugin sInstance = null;

        QHVCQyCodecPlugin() {
            super("qycodec", QHVCQyCodec.VERSION, QHVCQyCodec.VERSION, 448023L);
        }

        public static synchronized QHVCQyCodecPlugin getInstance() {
            if (sInstance == null) {
                sInstance = new QHVCQyCodecPlugin();
            }
            return sInstance;
        }
    }

    private static interface Callback {
        public void onSuccess();

        public void onFailed(int var1);
    }
}

