/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud.resolution;

import android.content.Context;
import android.text.TextUtils;
import com.qihoo.livecloud.tools.NetUtil;
import com.qihoo.livecloud.utils.PlayerLogger;
import java.util.Arrays;

public class QHVCPlayMonitor {
    private static final String TAG = "QHVCPlayMonitor";
    public static final int STAT_CACHE_SIZE = 0;
    public static final int STAT_PLAY_POSITION = 1;
    public static final int STAT_DATA_SOURCE = 2;
    public static final int STAT_PLAYER_SWITCH_RESULT = 3;
    public static final int STAT_PLAYER_BUFFERING = 4;
    public static final int STAT_SET_RESOLUTION_ADAPT = 5;
    public static final int STAT_SEEK = 6;
    public static final int STAT_PLAYABCK_RATE = 7;
    String[] src;
    int srcIdx;
    private static final long DURATION_TO_END = 10000L;
    private static final long VIDEO_DURATION = 0L;
    private static final int CACHE_CHECK_THRESHOLD = 10000;
    private static final int CACHE_NOT_FULL_COUNT_MAX = 3;
    private final int maxCacheSize = 30000;
    private final int maxCheckCacheSize = 10000;
    private int lastCacheSize;
    private int currentCacheSize;
    private int cacheNotFullCount = 0;
    private int duration;
    private int playPos;
    private int bufferingCount = 0;
    private boolean isFirstBuffering = true;
    private long firstBufferingStartTick = 0L;
    private long firstBufferingUseTime = 0L;
    private volatile boolean isSeek = false;
    private long mLastSwitchTick = 0L;
    private float mPlayBackRate = 1.0f;

    public void stat(int what, int arg1, int arg2, Object obj) {
        PlayerLogger.v(TAG, "stat. what: " + what + " arg1: " + arg1 + " arg2: " + arg2 + " obj: " + (obj == null ? "" : obj));
        switch (what) {
            case 0: {
                this.lastCacheSize = this.currentCacheSize;
                this.currentCacheSize = arg1;
                if (this.currentCacheSize < 10000) {
                    if (this.currentCacheSize < this.lastCacheSize || this.currentCacheSize - this.lastCacheSize < this.getCheckCacheThresholdValue()) {
                        ++this.cacheNotFullCount;
                    }
                    PlayerLogger.d(TAG, "max_cache: 30000 last_cache:" + this.lastCacheSize + " current_cache: " + this.currentCacheSize + " count: " + this.cacheNotFullCount);
                    break;
                }
                this.cacheNotFullCount = 0;
                break;
            }
            case 1: {
                this.duration = arg1;
                this.playPos = arg2;
                break;
            }
            case 4: {
                if (arg1 == 0) {
                    if (this.isFirstBuffering) {
                        this.firstBufferingStartTick = System.currentTimeMillis();
                        PlayerLogger.d(TAG, "first buffering tick: " + this.firstBufferingStartTick);
                    }
                    if (this.isSeek) {
                        this.isSeek = false;
                        PlayerLogger.d(TAG, "seek effect. filter this buffering.");
                        return;
                    }
                    ++this.bufferingCount;
                    if (this.bufferingCount <= 1) break;
                    if (this.bufferingCount == 2) {
                        if (this.firstBufferingUseTime > 100L) {
                            this.cacheNotFullCount = 3;
                        }
                        PlayerLogger.d(TAG, "set cache count max. because first buffering use time: " + this.firstBufferingUseTime);
                        break;
                    }
                    this.cacheNotFullCount = 3;
                    PlayerLogger.d(TAG, "set cache count max. because buffering count: " + this.bufferingCount);
                    break;
                }
                if (arg1 != 1 || !this.isFirstBuffering) break;
                long tick = System.currentTimeMillis();
                this.firstBufferingUseTime = tick - this.firstBufferingStartTick;
                this.isFirstBuffering = false;
                PlayerLogger.d(TAG, "first buffering use: " + this.firstBufferingUseTime);
                break;
            }
            case 2: {
                if (obj == null || !(obj instanceof String[])) break;
                this.src = (String[])obj;
                this.srcIdx = arg1;
                break;
            }
            case 3: {
                this.resetStat();
                this.mLastSwitchTick = System.currentTimeMillis();
                break;
            }
            case 5: {
                this.mLastSwitchTick = 0L;
                break;
            }
            case 6: {
                this.cacheNotFullCount = 0;
                this.isSeek = true;
                break;
            }
            case 7: {
                if (obj instanceof Float) {
                    this.mPlayBackRate = ((Float)obj).floatValue();
                    break;
                }
                PlayerLogger.e(TAG, "STAT_SWITCH_MULTIPLE_FACTOR param error. " + obj);
                break;
            }
        }
    }

    public boolean needSwitchResolution(Context context, boolean isAdapt) {
        PlayerLogger.v(TAG, "check need switch resolution!");
        if (!isAdapt) {
            return context != null && NetUtil.isConnected((Context)context);
        }
        if (this.isSourceValid()) {
            if (this.isPlayPosValid()) {
                if (context != null && NetUtil.isConnected((Context)context)) {
                    if (this.isCacheDecrease()) {
                        long tick = System.currentTimeMillis() - this.mLastSwitchTick;
                        if (tick > 3000L) {
                            return true;
                        }
                        PlayerLogger.d(TAG, "between last switch: " + tick);
                    }
                } else {
                    PlayerLogger.d(TAG, "network not connected!");
                }
            } else {
                PlayerLogger.d(TAG, "duration: " + this.duration + " position: " + this.playPos);
            }
        } else {
            PlayerLogger.d(TAG, "source invalid. index: " + this.srcIdx + " sources: " + Arrays.toString(this.src));
        }
        return false;
    }

    public void resetStat() {
        PlayerLogger.d(TAG, "reset stat.");
        this.lastCacheSize = 0;
        this.currentCacheSize = 0;
        this.cacheNotFullCount = 0;
        this.duration = 0;
        this.playPos = 0;
    }

    private boolean isSourceValid() {
        int idx = this.srcIdx + 1;
        return this.src != null && idx >= 0 && idx < this.src.length && !TextUtils.isEmpty((CharSequence)this.src[idx]);
    }

    private boolean isPlayPosValid() {
        return this.playPos != 0 && this.duration != 0 && (long)this.duration > 0L && (long)this.playPos + 10000L < (long)this.duration;
    }

    private boolean isCacheDecrease() {
        return this.cacheNotFullCount >= 3 && this.currentCacheSize < 10000;
    }

    private int getCheckCacheThresholdValue() {
        int value;
        float rate = this.mPlayBackRate;
        if (rate < 1.0f) {
            rate = 1.0f;
        }
        if ((value = (int)(rate * 10000.0f)) > 25000) {
            value = 25000;
        }
        return value;
    }
}

