/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.videocloud.resolution;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import com.qihoo.livecloud.config.PlayerSettings;
import com.qihoo.livecloud.play.PlayerControl;
import com.qihoo.livecloud.play.callback.PlayerCallback;
import com.qihoo.livecloud.sdk.QHVCSdkConfig;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.Stats;
import com.qihoo.livecloud.utils.PlayerLogger;
import com.qihoo.videocloud.QHVCPlayer;
import java.util.HashMap;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class QHVCResolutionMgr {
    private static final String TAG = "QHVCResolutionMgr";
    public static final int HANCLE_SWITCH_DELAY = 5000;
    public static final int REAL_SWITCH_TIME_DIFF = 2000;
    private static final String[] STATUS_STR = new String[]{"switch-invalid", "switch-prepare", "switch-playerCreated", "switch-playerOpening", "switch-playerOpened", "switch-waitingSwitch", "switch-switching", "switch-switchSuccess", "switch-switchFailed", "switch-release"};
    private volatile int mStatus = 0;
    private Context mContext;
    private String mUrl;
    private int mSeekTo;
    private float mPlayBackRate = 1.0f;
    private OnSwitchListener mListener;
    private int mSecondPausePosition;
    private QHVCSdkConfig mSdkConfig;
    private PlayerControl mSecondPlayerCtrl;
    private int mSecondPlayerId;
    private volatile boolean mIsReceiveVideoIsReady = false;
    private int mSwitchCount = 0;
    private volatile int mPrepareStatus;
    private String mNewSessionId;
    private boolean mBufferingUpdate = false;
    private long mBufferingStartTick = 0L;
    private volatile boolean mIsResolutionAdapt = false;
    private boolean mIsForce = false;
    private PlayerCallback secondPlayerCallback = new PlayerCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlayerMsg(int handle, int command, long para1, long para2, int user) {
            PlayerLogger.v(QHVCResolutionMgr.TAG, "[handle]: " + handle + " command=" + command + " para1=" + para1 + " para2=" + para2 + " user=" + user);
            switch (command) {
                case -1001: 
                case -1000: 
                case -989: 
                case -987: 
                case -975: 
                case -931: 
                case -930: 
                case -800: {
                    PlayerLogger.d(QHVCResolutionMgr.TAG, "[handle]: " + handle + " command: " + command + " para1: " + para1 + " para2: " + para2 + " user: " + user);
                    if (QHVCResolutionMgr.this.mListener != null) {
                        QHVCResolutionMgr.this.mListener.onError(-2, "handle: " + handle + " command: " + command + " para1: " + para1 + " para2: " + para2 + " user: " + user);
                    }
                    if (QHVCResolutionMgr.this.mContext == null) break;
                    new Handler(QHVCResolutionMgr.this.mContext.getMainLooper()).postAtFrontOfQueue(new Runnable(){

                        @Override
                        public void run() {
                            PlayerLogger.d(QHVCResolutionMgr.TAG, "run. second player. reset value with close player.");
                            QHVCResolutionMgr.this.resetValueWithClosePlayer();
                        }
                    });
                    break;
                }
                case -999: {
                    PlayerLogger.v(QHVCResolutionMgr.TAG, "[handle]: " + handle + " JPLAYER_MSG_VIDEO_IS_READY. para1: " + para1);
                    if (QHVCResolutionMgr.this.mIsReceiveVideoIsReady) break;
                    QHVCResolutionMgr.this.mIsReceiveVideoIsReady = true;
                    if (0 == QHVCResolutionMgr.this.mRunFlag) {
                        QHVCResolutionMgr.this.lock.lock();
                        try {
                            if (0 == QHVCResolutionMgr.this.mRunFlag) {
                                QHVCResolutionMgr.this.mRunFlag = 2;
                            }
                        }
                        finally {
                            QHVCResolutionMgr.this.lock.unlock();
                        }
                    }
                    if (2 == QHVCResolutionMgr.this.mRunFlag) {
                        QHVCResolutionMgr.this.unInitTimer();
                        PlayerLogger.v(QHVCResolutionMgr.TAG, "JPLAYER_MSG_VIDEO_IS_READY run");
                        QHVCResolutionMgr.this.mSecondPausePosition = (int)para1;
                        QHVCResolutionMgr.this.mSecondPlayerCtrl.setMute(true);
                        QHVCResolutionMgr.this.mSecondPlayerCtrl.pause(-1);
                        QHVCResolutionMgr.this.updateStatus(4);
                        if (QHVCResolutionMgr.this.mListener == null) break;
                        QHVCResolutionMgr.this.mPrepareStatus = 2;
                        PlayerLogger.e(QHVCResolutionMgr.TAG, "video is ready. playerId: " + QHVCResolutionMgr.this.mSecondPlayerId + " prepare status: " + QHVCResolutionMgr.this.mPrepareStatus + " url: " + QHVCResolutionMgr.this.mUrl);
                        QHVCResolutionMgr.this.mListener.onPlayerOpened(QHVCResolutionMgr.this.mSecondPlayerId, QHVCResolutionMgr.this.mSecondPlayerCtrl, QHVCResolutionMgr.this.mSecondPausePosition, QHVCResolutionMgr.this.mUrl);
                        break;
                    }
                    PlayerLogger.v(QHVCResolutionMgr.TAG, "JPLAYER_MSG_VIDEO_IS_READY not run");
                    break;
                }
                case -992: {
                    PlayerLogger.v(QHVCResolutionMgr.TAG, "[handle]: " + handle + " JPLAYER_MSG_AUDIO_IS_READY.");
                    if (QHVCResolutionMgr.this.mSecondPlayerCtrl != null) {
                        QHVCResolutionMgr.this.mSecondPlayerCtrl.setMute(true);
                    }
                    if (QHVCPlayer.isDefaultPlayBackRate(QHVCResolutionMgr.this.mPlayBackRate)) break;
                    PlayerLogger.d(QHVCResolutionMgr.TAG, "second player. receive audio is ready, set playback rate: " + QHVCResolutionMgr.this.mPlayBackRate);
                    QHVCResolutionMgr.this.mSecondPlayerCtrl.setPlayBackRate(QHVCResolutionMgr.this.mPlayBackRate);
                    break;
                }
                case -996: {
                    this.replayStatusUpdate(handle, command, para1, para2, user);
                    break;
                }
                case -998: 
                case -997: 
                case -994: 
                case -988: 
                case -979: 
                case -978: 
                case -977: 
                case -974: 
                case -973: 
                case -950: 
                case -949: 
                case -929: 
                case -920: 
                case -899: 
                case -700: 
                case 10: {
                    break;
                }
            }
        }

        @Override
        public void onUpdateStatus(int handle, int vbps, int abps, int vfps, int afps, int sdvbps, int sdabps, int sdvfps, int sdafps, int user) {
        }

        @Override
        public void onUpdateGPPlayState(int handle, long nowTime, long videoBufferTime, long audioBufferTime) {
        }

        @Override
        public void onMessage(int handle, int id, int type, int flags, int size, long data, long time) {
        }

        @Override
        public void onUserDefineData(int handle, byte[] data, int length) {
        }

        private void replayStatusUpdate(int handle, int command, long para1, long para2, int user) {
            if (user == 1 && QHVCResolutionMgr.this.mBufferingUpdate) {
                int progress = 0;
                if (para2 > 0L && para1 > 0L) {
                    progress = (int)(para1 * 100L / para2);
                }
                if (progress > 100) {
                    progress = 100;
                }
                PlayerLogger.v(QHVCResolutionMgr.TAG, "[handle]: " + handle + " progress: " + progress);
                return;
            }
            if (user == 1) {
                QHVCResolutionMgr.this.mBufferingUpdate = true;
                PlayerLogger.d(QHVCResolutionMgr.TAG, "[handle]: " + handle + " onBufferingUpdate Buffer.START");
                QHVCResolutionMgr.this.mBufferingStartTick = System.currentTimeMillis();
            }
            if (user == 0 && QHVCResolutionMgr.this.mBufferingUpdate) {
                QHVCResolutionMgr.this.mBufferingUpdate = false;
                long useTick = System.currentTimeMillis() - QHVCResolutionMgr.this.mBufferingStartTick;
                PlayerLogger.d(QHVCResolutionMgr.TAG, "[handle]: " + handle + " onBufferingUpdate Buffer.STOP use tick: " + useTick);
            }
        }
    };
    private Timer mTimer = null;
    private TimerTask mTimerTask = null;
    private Lock lock = new ReentrantLock();
    private static final int RUN_FLAG_INVALID = 0;
    private static final int RUN_FLAG_TIMER_RUN = 1;
    private static final int RUN_FLAG_OTHER = 2;
    private volatile int mRunFlag = 0;

    public synchronized void setForceSwitch(boolean force) {
        this.mIsForce = force;
        PlayerLogger.d(TAG, "set switch force: " + force);
    }

    public synchronized boolean isForceSwitch() {
        PlayerLogger.d(TAG, "get switch force: " + this.mIsForce);
        return this.mIsForce;
    }

    public void switchResolution(Context context, QHVCPlayer player, QHVCSdkConfig sdkConfig, String cId, String sessionIdInitValue, PlayerSettings playerSettings, int urlIndex, String url, int seekTo, OnSwitchListener listener, boolean isAdapt, long switchDelay, float playbackRate) {
        if (Logger.LOG_ENABLE) {
            Logger.i((String)TAG, (String)("switch resolution. switch position: " + seekTo + " newUrl: " + url + " " + Thread.currentThread().getName()));
        }
        this.updateStatus(1);
        if (context == null || sdkConfig == null || TextUtils.isEmpty((CharSequence)cId) || TextUtils.isEmpty((CharSequence)url)) {
            PlayerLogger.e(TAG, "switch resolution input param invalid!");
            this.resetValueWithClosePlayer();
            if (listener != null) {
                listener.onError(-2, "input param invalid");
            }
            return;
        }
        this.mContext = context;
        this.mUrl = url;
        this.mSeekTo = seekTo;
        this.mPlayBackRate = playbackRate;
        this.mListener = listener;
        this.mIsResolutionAdapt = isAdapt;
        this.mSdkConfig = sdkConfig;
        this.mSecondPlayerCtrl = new PlayerControl();
        PlayerLogger.d(TAG, "switch resolution. create player: " + this.mSecondPlayerCtrl);
        this.mSecondPlayerCtrl.setUid(sdkConfig.getUserId());
        this.mSecondPlayerCtrl.setCid(cId);
        this.mSecondPlayerCtrl.setSN(url);
        this.mNewSessionId = this.getResolutionNewSessionId(sessionIdInitValue);
        this.mSecondPlayerCtrl.setSid(this.mNewSessionId);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("module", "player");
            params.put("sdk_ver", QHVCPlayer.getVersion());
            params.put("so_ver", QHVCPlayer.getNativeVersion());
            Stats.sessionStart((String)this.mNewSessionId, (String)sdkConfig.getUserId(), (String)cId, (String)sdkConfig.getNetworkType(), (String)url, params);
            int playerId = this.mSecondPlayerCtrl.openHls(url, 1, this.mSeekTo, true, 1);
            if (playerId != 0) {
                PlayerLogger.d(TAG, "open hls handle=" + playerId + " seekto=" + this.mSeekTo);
                this.updateStatus(2);
                player.setPlayerControlConfig(this.mSecondPlayerCtrl, playerId, this.mNewSessionId);
                this.mSecondPlayerId = playerId;
                this.mSecondPlayerCtrl.playerSetting(playerSettings);
                this.mSecondPlayerCtrl.setCallback(this.secondPlayerCallback);
                PlayerLogger.d(TAG, "second player startLive.");
                if (this.mIsForce) {
                    this.mRunFlag = 1;
                    this.updateStatus(3);
                    if (this.mListener != null) {
                        this.mPrepareStatus = 0;
                        PlayerLogger.e(TAG, "force switch. playerId: " + playerId + " prepare status: " + this.mPrepareStatus + " url: " + url);
                        this.mListener.openLiveTimeout(this.mSecondPlayerId, this.mSecondPlayerCtrl, this.mUrl);
                    }
                } else {
                    this.mSecondPlayerCtrl.startLive();
                    this.updateStatus(3);
                    this.initTimer(switchDelay);
                }
            } else {
                PlayerLogger.e(TAG, "openHls failed.");
                if (listener != null) {
                    listener.onError(-2, "openHls failed.");
                }
                this.resetValueWithClosePlayer();
            }
        }
        catch (Exception e) {
            PlayerLogger.e(TAG, "exception: " + e.getMessage());
            if (listener != null) {
                listener.onError(-2, e == null ? "" : e.getMessage());
            }
            this.resetValueWithClosePlayer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetValueWithClosePlayer() {
        if (this.mStatus == 0 || this.mStatus == 9) {
            return;
        }
        PlayerLogger.d(TAG, "reset value with close player.");
        this.updateStatus(9);
        if (this.mSecondPlayerCtrl != null) {
            PlayerControl playerControl = this.mSecondPlayerCtrl;
            synchronized (playerControl) {
                if (this.mSecondPlayerCtrl != null) {
                    PlayerLogger.d(TAG, "release resource. player close: " + this.mSecondPlayerCtrl);
                    this.mSecondPlayerCtrl.close(0);
                    this.mSecondPlayerCtrl = null;
                }
            }
        }
        this.resetValue();
    }

    public void resetValue() {
        PlayerLogger.d(TAG, "reset flag.");
        this.unInitTimer();
        this.mListener = null;
        this.mSecondPlayerCtrl = null;
        this.mSecondPlayerId = 0;
        this.mIsReceiveVideoIsReady = false;
        this.mContext = null;
        this.mSecondPausePosition = 0;
        this.updateStatus(0);
        this.mRunFlag = 0;
        this.mIsForce = false;
    }

    public synchronized void updateStatus(int status) {
        this.mStatus = status;
        PlayerLogger.d(TAG, this.mStatus >= 0 && this.mStatus < STATUS_STR.length ? STATUS_STR[status] : status + "");
    }

    public synchronized int getSwitchStatus() {
        return this.mStatus;
    }

    public synchronized boolean isUnStart() {
        return this.mStatus == 0;
    }

    public SecondPlayerInfo getSecondPlayer() {
        return new SecondPlayerInfo(this.mSecondPlayerId, this.mSecondPlayerCtrl, this.mSecondPausePosition, this.mUrl, this.mPrepareStatus, this.mNewSessionId);
    }

    private String getResolutionNewSessionId(String sessionIdInitValue) {
        String newSid = "";
        if (!TextUtils.isEmpty((CharSequence)sessionIdInitValue)) {
            ++this.mSwitchCount;
            newSid = sessionIdInitValue + "__switch" + "_" + this.mSwitchCount;
        } else {
            newSid = MD5.encryptMD5((String)(String.valueOf(System.currentTimeMillis()) + String.valueOf(new Random().nextInt())));
        }
        Logger.d((String)TAG, (String)("new sid: " + newSid));
        return newSid;
    }

    private void initTimer(long delay) {
        this.mRunFlag = 0;
        if (this.mTimer == null) {
            PlayerLogger.d(TAG, "initTimer. for open player.");
            this.mTimer = new Timer();
        }
        if (this.mTimerTask == null) {
            this.mTimerTask = new TimerTask(){

                @Override
                public void run() {
                    QHVCResolutionMgr.this.openPlayerTimeout();
                }
            };
            long switchDelay = 4000L;
            if (delay > 6000L) {
                switchDelay = delay - 1000L;
            }
            Logger.i((String)TAG, (String)("switch param delay: " + delay + " real delay: " + switchDelay));
            this.mTimer.schedule(this.mTimerTask, switchDelay);
        }
    }

    private void unInitTimer() {
        try {
            if (this.mTimerTask != null) {
                this.mTimerTask.cancel();
                this.mTimerTask = null;
            }
            if (this.mTimer != null) {
                PlayerLogger.d(TAG, "unInitTimer. for open player");
                this.mTimer.cancel();
                this.mTimer = null;
            }
        }
        catch (Exception e) {
            PlayerLogger.d(TAG, "unInitTimer." + e.getMessage());
        }
    }

    private void openPlayerTimeout() {
        PlayerLogger.d(TAG, "timer run. open player timeout! ");
        if (0 == this.mRunFlag) {
            this.lock.lock();
            try {
                if (0 == this.mRunFlag) {
                    this.mRunFlag = 1;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (1 == this.mRunFlag) {
            PlayerLogger.d(TAG, "run");
            if (this.mIsResolutionAdapt) {
                if (this.mListener != null) {
                    this.mListener.onError(-2, "playerId: " + this.mSecondPlayerId + " open timeout!");
                }
                this.resetValueWithClosePlayer();
            } else if (this.mListener != null) {
                this.mPrepareStatus = 1;
                PlayerLogger.e(TAG, "open live timeout. playerId: " + this.mSecondPlayerId + " prepare status: " + this.mPrepareStatus + " url: " + this.mUrl);
                this.mListener.openLiveTimeout(this.mSecondPlayerId, this.mSecondPlayerCtrl, this.mUrl);
            }
        } else {
            PlayerLogger.d(TAG, "not run");
        }
    }

    public static class SecondPlayerInfo {
        public int playerId;
        public PlayerControl control;
        public int position;
        public String url;
        public int prepareStatus;
        public String sessionId;

        public SecondPlayerInfo(int playerId, PlayerControl control, int position, String url, int prepareStatus, String sessionId) {
            this.playerId = playerId;
            this.control = control;
            this.position = position;
            this.url = url;
            this.prepareStatus = prepareStatus;
            this.sessionId = sessionId;
        }
    }

    public static interface OnSwitchListener {
        public void openLiveTimeout(int var1, PlayerControl var2, String var3);

        public void onPlayerOpened(int var1, PlayerControl var2, int var3, String var4);

        public void onError(int var1, String var2);
    }

    public static interface SwitchStatus {
        public static final int INVALID = 0;
        public static final int PREPARE = 1;
        public static final int PLAYER_CREATED = 2;
        public static final int PLAYER_OPENING = 3;
        public static final int PLAYER_OPENED = 4;
        public static final int WAITING_SWITCH = 5;
        public static final int SWITCHING = 6;
        public static final int SWITCH_SUCCESS = 7;
        public static final int SWITCH_FAILED = 8;
        public static final int RELEASE = 9;
    }

    public static interface PrepareStatus {
        public static final int NOT_OPEN = 0;
        public static final int OPEN_LIVE_TIMEOUT = 1;
        public static final int VIDEO_IS_READY = 2;
    }
}

