/*
 * Decompiled with CFR 0.152.
 */
package com.gpsoft.tools;

import com.qihoo.livecloud.settings.GPWebrtcSettings;

public class GPFPSLimiter {
    private int type;
    private boolean drop;
    private int delay;
    private int rdIndex;
    private int rdCount;
    private int fps;
    private int nowFpsCount;
    private int rfIndex;
    private int rfCount;
    private long timeHolder;
    private long delayTimeHolder;
    private long fpsTimeHolder;
    private static final int SAMPLE_RANGE = 30;
    private static final int TARGET_FPS = 15;
    private static final int FPS_RANGE = 3;
    private static final int TARGET_DELAY = Math.round(66.0f);
    private static final int DELAY_RANGE = Math.round(83.0f) - TARGET_DELAY;
    private static final boolean AUTO_CHANGE = true;
    public static final int NO_DROP = 0;
    public static final int FRAME_DROP = 1;
    public static final int DELAY_DROP = 2;

    public GPFPSLimiter() {
        this(GPWebrtcSettings.getInstance().getFpsLimiterType());
    }

    public GPFPSLimiter(int type) {
        this.setType(type);
    }

    private void clearData() {
        this.drop = false;
        this.rdIndex = 0;
        this.rdCount = 0;
        this.rfIndex = 0;
        this.rfCount = 0;
        this.timeHolder = -1L;
        this.delayTimeHolder = -1L;
        this.fpsTimeHolder = -1L;
    }

    public boolean limate() {
        boolean limate;
        switch (this.type) {
            default: {
                limate = this.ndl();
                break;
            }
            case 1: {
                limate = this.fdl();
                break;
            }
            case 2: {
                limate = this.ddl();
            }
        }
        if (!limate) {
            this.countFps();
        }
        this.countDelay();
        return limate;
    }

    private boolean ndl() {
        return false;
    }

    private boolean fdl() {
        boolean bl = this.drop = !this.drop;
        return !this.drop;
    }

    private boolean ddl() {
        long delay;
        long now = System.currentTimeMillis();
        if (this.timeHolder != -1L && (delay = now - this.timeHolder) < (long)TARGET_DELAY && (long)this.delay + delay < (long)(TARGET_DELAY + DELAY_RANGE)) {
            return true;
        }
        this.timeHolder = now;
        return false;
    }

    private void countFps() {
        long time;
        ++this.nowFpsCount;
        long now = System.currentTimeMillis();
        if (this.fpsTimeHolder == -1L) {
            this.fpsTimeHolder = now;
        }
        if ((time = now - this.fpsTimeHolder) >= 1000L) {
            this.saveFps(this.nowFpsCount);
            this.fpsTimeHolder = -1L;
            this.nowFpsCount = 0;
        }
    }

    private void saveFps(int fps) {
        ++this.rfIndex;
        this.rfCount += fps;
        this.fps = this.rfCount / this.rfIndex;
        if (this.rfIndex >= 30) {
            this.autoChange();
            this.rfIndex = 0;
            this.rfCount = 0;
        }
        System.out.println("GPFPSLimiter, now fps = " + fps + "!");
    }

    private void countDelay() {
        if (this.delayTimeHolder == -1L) {
            this.delayTimeHolder = System.currentTimeMillis();
            return;
        }
        long now = System.currentTimeMillis();
        int delay = (int)(now - this.delayTimeHolder);
        this.saveDelay(delay);
        this.delayTimeHolder = now;
    }

    private void saveDelay(int delay) {
        ++this.rdIndex;
        this.rdCount += delay;
        this.delay = this.rdCount / this.rdIndex;
        if (this.rdIndex >= 30) {
            this.rdIndex = 0;
            this.rdCount = 0;
        }
    }

    private void autoChange() {
        if (this.type == 0) {
            if (this.fps >= 27) {
                this.setType(1);
            } else if (this.fps >= 18) {
                this.setType(2);
            }
        } else if (this.type == 1) {
            if (this.fps <= 12) {
                this.setType(2);
            }
        } else if (this.type == 2 && this.fps <= 12) {
            this.setType(0);
        }
    }

    public void setType(int type) {
        this.type = type;
        this.clearData();
        System.out.println("GPFPSLimiter, change to " + type + " type!");
    }
}

