/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.network;

import com.qihoo.livecloud.network.HttpCallBack;
import com.qihoo.livecloud.network.LiveCloudHttp;
import com.qihoo.livecloud.network.LiveCloudHttpParam;
import com.qihoo.livecloud.tools.Logger;

public class LCHttpGet
implements HttpCallBack {
    static final String TAG = "LCHttpGet";
    private HttpCallBack mCallBack;
    private LiveCloudHttpParam mParam;
    private String mUrl;
    private int maxRetryTimes = 3;
    private int mCurrRetryTimes = 0;

    public LCHttpGet(String url, LiveCloudHttpParam param, HttpCallBack callBack) {
        this.mCallBack = callBack;
        this.mParam = param;
        this.mUrl = url;
        this.init();
    }

    private void init() {
        int retryTimes;
        if (this.mParam != null && (retryTimes = this.mParam.getRetryTimes()) > 0) {
            this.maxRetryTimes = retryTimes;
        }
        this.mCurrRetryTimes = 0;
    }

    public void get() {
        ++this.mCurrRetryTimes;
        new LiveCloudHttp(this.mUrl, this.mParam, this).get();
    }

    @Override
    public void onSuccess(String result) {
        if (this.mCallBack != null) {
            this.mCallBack.onSuccess(result);
        }
    }

    @Override
    public void onFailed(int errCode, String errMessage) {
        Logger.i(TAG, "onFailed  mCurrRetryTimes = " + this.mCurrRetryTimes);
        if (this.mCurrRetryTimes <= this.maxRetryTimes) {
            this.get();
        } else if (this.mCallBack != null) {
            this.mCallBack.onFailed(errCode, errMessage);
        }
    }

    @Override
    public void onProgressAdd(int add) {
        if (this.mCallBack != null) {
            this.mCallBack.onProgressAdd(add);
        }
    }
}

