/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.network;

import com.qihoo.livecloud.network.HttpByteCallBack;
import com.qihoo.livecloud.network.LiveCloudHttp;
import com.qihoo.livecloud.network.LiveCloudHttpParam;
import com.qihoo.livecloud.tools.Logger;

public class LCHttpGetByte
implements HttpByteCallBack {
    static final String TAG = "LCHttpGet";
    private HttpByteCallBack mCallBack;
    private LiveCloudHttpParam mParam;
    private String mUrl;
    private int maxRetryTimes = 3;
    private int mCurrRetryTimes = 0;

    public LCHttpGetByte(String url, LiveCloudHttpParam param, HttpByteCallBack callBack) {
        this.mCallBack = callBack;
        this.mParam = param;
        this.mUrl = url;
        this.init();
    }

    private void init() {
        int retryTimes;
        if (this.mParam != null && (retryTimes = this.mParam.getRetryTimes()) > 0) {
            this.maxRetryTimes = retryTimes;
        }
        this.mCurrRetryTimes = 0;
    }

    public void getByte() {
        ++this.mCurrRetryTimes;
        new LiveCloudHttp(this.mUrl, this.mParam, null, this).getByte();
    }

    @Override
    public void onSuccess(byte[] data) {
        if (this.mCallBack != null) {
            this.mCallBack.onSuccess(data);
        }
    }

    @Override
    public void onFailed(int errCode, byte[] data) {
        Logger.i(TAG, "onFailed  mCurrRetryTimes = " + this.mCurrRetryTimes);
        if (this.mCurrRetryTimes <= this.maxRetryTimes) {
            this.getByte();
        } else if (this.mCallBack != null) {
            this.mCallBack.onFailed(errCode, data);
        }
    }
}

