/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.network;

import com.qihoo.livecloud.network.HttpByteCallBack;
import com.qihoo.livecloud.network.HttpCallBack;
import com.qihoo.livecloud.network.LiveCloudHttpParam;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class LiveCloudHttp
extends Thread {
    private static final int DEFAULT_TIMEOUT = 15000;
    private static final int DEFAULT_RETRY = 1;
    private static final int REQUEST_GET = 1;
    private static final int REQUEST_POST = 2;
    private static final int REQUEST_GET_BYTE = 3;
    private static final String CLIENT_LOG_FOR_360YUNPAN = "client_log=";
    private String mUrl;
    private LiveCloudHttpParam mParam;
    private HttpCallBack mCallBack;
    private HttpByteCallBack mByteCallBack;
    private HttpURLConnection mConnection = null;
    private DataOutputStream mDos = null;
    private InputStream mResponseIn = null;
    private BufferedReader bReader = null;
    private ByteArrayOutputStream bos = null;
    private int mTimeout;
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private int currRequestType = 2;
    private InputStream mInputStream;
    private int uploadTotalLength;

    public LiveCloudHttp(String url) {
        this(url, null, null);
    }

    public LiveCloudHttp(String url, LiveCloudHttpParam param) {
        this(url, param, null);
    }

    public LiveCloudHttp(String url, LiveCloudHttpParam param, HttpCallBack callBack) {
        this.mUrl = url;
        this.mParam = param;
        this.mCallBack = callBack;
        if (this.mParam != null) {
            this.mTimeout = this.mParam.getTimeout();
        } else {
            this.mParam = new LiveCloudHttpParam();
            this.mTimeout = 15000;
        }
    }

    public LiveCloudHttp(String url, LiveCloudHttpParam param, HttpCallBack callBack, HttpByteCallBack bytecallBack) {
        this.mUrl = url;
        this.mParam = param;
        this.mCallBack = callBack;
        this.mByteCallBack = bytecallBack;
        if (this.mParam != null) {
            this.mTimeout = this.mParam.getTimeout();
        } else {
            this.mParam = new LiveCloudHttpParam();
            this.mTimeout = 15000;
        }
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public void setLiveCloudHttpParam(LiveCloudHttpParam param) {
        this.mParam = param;
    }

    public void setCallBack(HttpCallBack callBack) {
        this.mCallBack = callBack;
    }

    public void setCallBack(HttpByteCallBack callBack) {
        this.mByteCallBack = callBack;
    }

    public void post() {
        this.currRequestType = 2;
        this.start();
    }

    public void get() {
        this.currRequestType = 1;
        this.start();
    }

    public void getByte() {
        this.currRequestType = 3;
        this.start();
    }

    public void upload(byte[] data) {
        ByteArrayInputStream bio = new ByteArrayInputStream(data);
        this.uploadTotalLength = data.length;
        this.upload(bio);
    }

    public void upload(InputStream data) {
        this.mInputStream = data;
        this.start();
    }

    @Override
    public synchronized void start() {
        try {
            super.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.mConnection != null && this.isAlive();
    }

    public void cancelHttpRequest() {
        if (this.mConnection != null && this.isAlive()) {
            if (this.mConnection != null) {
                try {
                    this.canceled.set(true);
                    this.mConnection.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.closeIO();
        }
    }

    public boolean isCanceled() {
        return this.canceled.get();
    }

    private String addParameterForUrl(String originalUrl) {
        String newUrl = originalUrl;
        HashMap<String, ?> parameters = this.mParam.getParameter();
        StringBuffer sbParam = new StringBuffer();
        if (parameters != null && parameters.size() > 0) {
            Set<String> keys = parameters.keySet();
            if (keys != null) {
                Object value = null;
                for (String key : keys) {
                    value = parameters.get(key);
                    sbParam.append(key + "=" + value + "&");
                }
                sbParam.delete(sbParam.length() - 1, sbParam.length());
            }
            String parm = sbParam.toString();
            try {
                parm = URLEncoder.encode(sbParam.toString(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            newUrl = originalUrl.indexOf("&") > 0 ? newUrl + "&client_log=" + parm : newUrl + "?client_log=" + parm;
        }
        return newUrl;
    }

    private String createUrlForGet(String originalUrl) {
        String newUrl = originalUrl;
        HashMap<String, ?> parameters = this.mParam.getParameter();
        StringBuffer sbParam = new StringBuffer();
        if (parameters != null && parameters.size() > 0) {
            Set<String> keys = parameters.keySet();
            if (keys != null) {
                Object value = null;
                for (String key : keys) {
                    value = parameters.get(key);
                    sbParam.append(key + "=" + value + "&");
                }
                sbParam.delete(sbParam.length() - 1, sbParam.length());
            }
            String parm = sbParam.toString();
            newUrl = originalUrl.indexOf("&") > 0 ? newUrl + "&" + parm : newUrl + "?" + parm;
        }
        return newUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPostRequest() {
        if (this.mCallBack == null) {
            throw new NullPointerException("HttpCallBack is null!");
        }
        try {
            int responseCode;
            URL url = new URL(this.addParameterForUrl(this.mUrl));
            this.mConnection = (HttpURLConnection)url.openConnection();
            this.mConnection.setDoInput(true);
            this.mConnection.setDoOutput(true);
            this.mConnection.setUseCaches(false);
            this.mConnection.setRequestMethod("POST");
            this.mConnection.setReadTimeout(this.mTimeout);
            this.mConnection.setConnectTimeout(this.mTimeout);
            this.mConnection.setRequestProperty("Connection", "Keep-Alive");
            this.mConnection.setRequestProperty("Charset", "UTF-8");
            this.mConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=1a2b3c");
            if (this.mParam.getRequestProperty() != null) {
                HashMap<String, String> requestProperty = this.mParam.getRequestProperty();
                Set<String> setKey = requestProperty.keySet();
                String value = null;
                for (String strKey : setKey) {
                    value = requestProperty.get(strKey);
                    this.mConnection.setRequestProperty(strKey, value);
                }
            }
            boolean chunkMode = false;
            if (this.mParam != null) {
                chunkMode = this.mParam.isUseChunkMode();
            }
            if (chunkMode) {
                this.mConnection.setChunkedStreamingMode(-1);
            } else {
                if (this.mInputStream != null) {
                    this.mConnection.setFixedLengthStreamingMode(this.uploadTotalLength);
                }
                this.mConnection.connect();
            }
            if (this.mInputStream != null) {
                this.mDos = new DataOutputStream(this.mConnection.getOutputStream());
                byte[] buffer = new byte[10240];
                int length = -1;
                boolean allLen = false;
                while ((length = this.mInputStream.read(buffer)) != -1) {
                    this.mDos.write(buffer, 0, length);
                    this.mCallBack.onProgressAdd(length);
                }
                this.mDos.flush();
            }
            this.mResponseIn = (responseCode = this.mConnection.getResponseCode()) == 200 ? this.mConnection.getInputStream() : this.mConnection.getErrorStream();
            StringBuffer strBuf = new StringBuffer();
            this.bReader = new BufferedReader(new InputStreamReader(this.mResponseIn));
            String line = null;
            while ((line = this.bReader.readLine()) != null) {
                strBuf.append(line).append("\n");
            }
            String responseMsg = strBuf.toString();
            if (responseCode == 200) {
                this.onSuccess(responseMsg);
            } else {
                this.onFailed(responseCode, responseMsg);
            }
        }
        catch (MalformedURLException e) {
            this.onFailed(-602, e.getMessage());
        }
        catch (ProtocolException e) {
            this.onFailed(-603, e.getMessage());
        }
        catch (IOException e) {
            this.onFailed(-604, e.getMessage());
        }
        catch (Exception e) {
            this.onFailed(-605, e.getMessage());
        }
        finally {
            this.closeIO();
            if (this.mConnection != null) {
                this.mConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendGetRequest() {
        if (this.mCallBack == null) {
            throw new NullPointerException("HttpCallBack is null!");
        }
        try {
            URL url = new URL(this.createUrlForGet(this.mUrl));
            this.mConnection = (HttpURLConnection)url.openConnection();
            this.mConnection.setUseCaches(false);
            this.mConnection.setReadTimeout(this.mTimeout);
            this.mConnection.setConnectTimeout(this.mTimeout);
            this.mConnection.connect();
            int responseCode = this.mConnection.getResponseCode();
            this.mResponseIn = responseCode == 200 ? this.mConnection.getInputStream() : this.mConnection.getErrorStream();
            StringBuffer strBuf = new StringBuffer();
            this.bReader = new BufferedReader(new InputStreamReader(this.mResponseIn));
            String line = null;
            while ((line = this.bReader.readLine()) != null) {
                strBuf.append(line).append("\n");
            }
            String responseMsg = strBuf.toString();
            if (responseCode == 200) {
                this.onSuccess(responseMsg);
            } else {
                this.onFailed(responseCode, responseMsg);
            }
        }
        catch (MalformedURLException e) {
            this.onFailed(-602, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.onFailed(-605, e.getMessage());
        }
        finally {
            try {
                this.closeIO();
                if (this.mConnection != null) {
                    this.mConnection.disconnect();
                }
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendGetByteRequest() {
        if (this.mByteCallBack == null) {
            throw new NullPointerException("HttpCallBack is null!");
        }
        try {
            int ch;
            URL url = new URL(this.createUrlForGet(this.mUrl));
            this.mConnection = (HttpURLConnection)url.openConnection();
            this.mConnection.setUseCaches(false);
            this.mConnection.setReadTimeout(this.mTimeout);
            this.mConnection.setConnectTimeout(this.mTimeout);
            this.mConnection.connect();
            int responseCode = this.mConnection.getResponseCode();
            this.mResponseIn = responseCode == 200 ? this.mConnection.getInputStream() : this.mConnection.getErrorStream();
            this.bos = new ByteArrayOutputStream();
            while ((ch = this.mResponseIn.read()) != -1) {
                this.bos.write(ch);
            }
            this.bos.flush();
            if (responseCode == 200) {
                this.onSuccessByte(this.bos.toByteArray());
            } else {
                this.onFailedByte(responseCode, this.bos.toByteArray());
            }
        }
        catch (MalformedURLException e) {
            this.onFailed(-602, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.onFailed(-605, e.getMessage());
        }
        finally {
            this.closeIO();
            if (this.mConnection != null) {
                this.mConnection.disconnect();
            }
        }
    }

    private void onSuccessByte(byte[] data) {
        if (!this.canceled.get() && this.mByteCallBack != null) {
            this.mByteCallBack.onSuccess(data);
        }
    }

    private void onFailedByte(int errCode, byte[] data) {
        if (!this.canceled.get() && this.mByteCallBack != null) {
            this.mByteCallBack.onFailed(errCode, data);
        }
    }

    private void onSuccess(String responseMsg) {
        if (!this.canceled.get() && this.mCallBack != null) {
            this.mCallBack.onSuccess(responseMsg);
        }
    }

    public void onFailed(int errCode, String errMessage) {
        if (!this.canceled.get() && this.mCallBack != null) {
            this.mCallBack.onFailed(errCode, errMessage);
        }
    }

    private void closeIO() {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
            this.mInputStream = null;
            if (this.mResponseIn != null) {
                this.mResponseIn.close();
            }
            this.mResponseIn = null;
            if (this.bReader != null) {
                this.bReader.close();
            }
            this.bReader = null;
            if (this.mDos != null) {
                this.mDos.close();
            }
            this.mDos = null;
            if (this.bos != null) {
                this.bos.close();
            }
            this.bos = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (this.currRequestType == 2) {
            this.sendPostRequest();
        } else if (this.currRequestType == 1) {
            this.sendGetRequest();
        } else if (this.currRequestType == 3) {
            this.sendGetByteRequest();
        }
    }

    public static boolean isHttpStatus4XX(int statusCode) {
        return statusCode >= 400 && statusCode <= 499;
    }
}

