/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.NetUtil;
import java.util.HashSet;
import java.util.Set;

public class NetworkStateMonitor {
    private static final String TAG = "LiveCloud_NetworkStateMonitor";
    private static NetworkStateMonitor instance;
    private final Set<NetworkChangeListener> mNetworkChangeListenerSet = new HashSet<NetworkChangeListener>();
    private BroadcastReceiver mNetReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                Logger.d(NetworkStateMonitor.TAG, "LiveCloud_NetworkStateMonitor, onNetworkChange");
                try {
                    ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                    NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                    Set set = NetworkStateMonitor.this.mNetworkChangeListenerSet;
                    synchronized (set) {
                        for (NetworkChangeListener listener : NetworkStateMonitor.this.mNetworkChangeListenerSet) {
                            try {
                                listener.onNetworkChange(networkInfo, NetUtil.getNetWorkTypeToString(context));
                            }
                            catch (Throwable e) {
                                Logger.e("Logger", e.getMessage());
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Logger.e("Logger", e.getMessage());
                }
            }
        }
    };

    private NetworkStateMonitor() {
    }

    public static synchronized NetworkStateMonitor getInstance() {
        if (instance == null) {
            instance = new NetworkStateMonitor();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNetworkChangeListener(Context context, NetworkChangeListener listener) {
        Logger.d(TAG, "LiveCloud_NetworkStateMonitor, registerNetworkChangeListener");
        if (context == null || listener == null) {
            return;
        }
        Set<NetworkChangeListener> set = this.mNetworkChangeListenerSet;
        synchronized (set) {
            boolean isEmpty = this.mNetworkChangeListenerSet.isEmpty();
            this.mNetworkChangeListenerSet.add(listener);
            if (isEmpty) {
                this.registerNetReceiver(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterNetworkChangeListener(Context context, NetworkChangeListener listener) {
        Logger.d(TAG, "LiveCloud_NetworkStateMonitor, unRegisterNetworkChangeListener");
        if (context == null || listener == null) {
            return;
        }
        Set<NetworkChangeListener> set = this.mNetworkChangeListenerSet;
        synchronized (set) {
            this.mNetworkChangeListenerSet.remove(listener);
            if (this.mNetworkChangeListenerSet.isEmpty()) {
                this.unRegisterNetReceiver(context);
            }
        }
    }

    private void registerNetReceiver(Context context) {
        Logger.d(TAG, "LiveCloud_NetworkStateMonitor, registerNetReceiver");
        if (context != null) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            try {
                context.getApplicationContext().registerReceiver(this.mNetReceiver, filter);
            }
            catch (Throwable e) {
                Logger.e(TAG, "LiveCloud_NetworkStateMonitor, registerNetReceiver failed! " + e.getMessage());
            }
        } else {
            Logger.e(TAG, "LiveCloud_NetworkStateMonitor, registerNetReceiver failed, context is null!");
        }
    }

    private void unRegisterNetReceiver(Context context) {
        Logger.d(TAG, "LiveCloud_NetworkStateMonitor, unRegisterNetReceiver");
        if (this.mNetReceiver != null && context != null) {
            try {
                context.getApplicationContext().unregisterReceiver(this.mNetReceiver);
            }
            catch (Exception e) {
                Logger.e(TAG, "LiveCloud_NetworkStateMonitor," + e.getMessage());
            }
        }
        instance = null;
    }

    public static interface NetworkChangeListener {
        public void onNetworkChange(NetworkInfo var1, String var2);
    }
}

