/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin;

import android.content.Context;
import android.text.TextUtils;
import com.qihoo.livecloud.plugin.LiveCloudPlugin;
import com.qihoo.livecloud.plugin.LiveCloudPluginCallback;
import com.qihoo.livecloud.plugin.LiveCloudPluginConstant;
import com.qihoo.livecloud.plugin.base.utils.ThreadUtils;
import com.qihoo.livecloud.plugin.core.PluginConfig;
import com.qihoo.livecloud.tools.Logger;
import java.io.File;

public abstract class ILiveCloudPlugin
implements LiveCloudPluginConstant {
    private String mPlugin;
    private String mNowVersion;
    private String mMinVersion;
    private long mFileSize;
    private PluginDownloadListener mPluginDownloadListener;

    protected ILiveCloudPlugin(String plugin, String nowVersion, String minVersion, long fileSize) {
        if (TextUtils.isEmpty((CharSequence)plugin) || TextUtils.isEmpty((CharSequence)nowVersion) || TextUtils.isEmpty((CharSequence)minVersion)) {
            throw new IllegalArgumentException("param can't null");
        }
        this.mPlugin = plugin;
        this.mNowVersion = nowVersion;
        this.mMinVersion = minVersion;
        this.mFileSize = fileSize;
        if (this.mNowVersion.startsWith("0.0.0")) {
            this.mMinVersion = this.mNowVersion;
        }
        LiveCloudPlugin.getInstance().checkUninstallPlugin(this.mPlugin, this.mMinVersion);
    }

    public String getTag() {
        return this.mPlugin;
    }

    public void setDefaultPluginInstalled(boolean defaultPluginInstalled) {
        LiveCloudPlugin.getInstance().setDefaultPluginInstalled(this.mPlugin, defaultPluginInstalled);
    }

    public boolean isDefaultPluginInstalled() {
        return LiveCloudPlugin.getInstance().isDefaultPluginInstalled(this.mPlugin);
    }

    public boolean isPluginInstalled() {
        return LiveCloudPlugin.getInstance().isPluginInstalled(this.mPlugin, null);
    }

    public boolean isPluginValid() {
        return LiveCloudPlugin.getInstance().isPluginValid(this.mPlugin);
    }

    public int loadPlugin() {
        if (!LiveCloudPlugin.getInstance().isPluginLoaded(this.mPlugin)) {
            this.checkUpdatePlugin(PluginConfig.getAppContext(), this.getPluginDownloadListener());
        }
        return LiveCloudPlugin.getInstance().loadPlugin(this.mPlugin);
    }

    public boolean isPluginLoaded() {
        return LiveCloudPlugin.getInstance().isPluginLoaded(this.mPlugin);
    }

    public String getPluginVersion() {
        return LiveCloudPlugin.getInstance().getPluginVersion(this.mPlugin);
    }

    public void checkUninstallPlugin() {
        LiveCloudPlugin.getInstance().checkUninstallPlugin(this.mPlugin, this.mNowVersion);
    }

    public int checkInstallOrUpdatePlugin(Context context, PluginCallback callback) {
        return this.checkInstallPlugin(context, null, callback);
    }

    public int checkInstallOrUpdatePlugin(Context context, PluginDownloadListener listener, PluginCallback callback) {
        return this.checkInstallPlugin(context, listener, callback);
    }

    public int checkInstallPlugin(Context context, PluginCallback callback) {
        return this.checkInstallPlugin(context, null, callback);
    }

    public int checkInstallPlugin(Context context, PluginDownloadListener listener, PluginCallback callback) {
        return this.checkInstallPlugin(context, 0, listener, callback);
    }

    private int checkInstallPlugin(Context context, final int type, PluginDownloadListener listener, final PluginCallback callback) {
        return LiveCloudPlugin.getInstance().checkInstallPlugin(context, this.mPlugin, this.mNowVersion, type, listener, new LiveCloudPluginCallback(){

            @Override
            public void onStart(Context context, String plugin) {
                Logger.i("LiveCloudPlugin", "(%s) (%s) checkInstallPlugin onStart, type=%d", ThreadUtils.getCurThreadName(), ILiveCloudPlugin.this.getTag(), type);
                if (callback != null && type == 0) {
                    callback.onStart(context);
                }
            }

            @Override
            public void onProgress(Context context, String plugin, int progress) {
                Logger.d("LiveCloudPlugin", "(%s) (%s) checkInstallPlugin onProgress, type=%d progress=%d", ThreadUtils.getCurThreadName(), ILiveCloudPlugin.this.getTag(), type, progress);
                if (callback != null && type == 0) {
                    callback.onProgress(context, progress);
                }
            }

            @Override
            public void onComplete(Context context, String plugin, boolean background, int result) {
                Logger.i("LiveCloudPlugin", "(%s) (%s) checkInstallPlugin onComplete, type=%d result=%d", ThreadUtils.getCurThreadName(), ILiveCloudPlugin.this.getTag(), type, result);
                if (callback != null && type == 0) {
                    callback.onComplete(context, background, result);
                }
            }

            @Override
            public void onCancel(Context context, String plugin) {
                Logger.i("LiveCloudPlugin", "(%s) (%s) checkInstallPlugin onCancel, type=%d", ThreadUtils.getCurThreadName(), ILiveCloudPlugin.this.getTag(), type);
                if (callback != null && type == 0) {
                    callback.onCancel(context);
                }
            }
        });
    }

    public int checkUpdatePlugin(Context context, PluginDownloadListener listener) {
        return LiveCloudPlugin.getInstance().checkUpdatePlugin(context, this.mPlugin, this.mNowVersion, listener);
    }

    public void cancelInstallOrUpdatePlugin() {
        LiveCloudPlugin.getInstance().cancelInstallOrUpdatePlugin(this.mPlugin);
    }

    public void backgroundInstallOrUpdatePlugin() {
        LiveCloudPlugin.getInstance().backgroundInstallOrUpdatePlugin(this.mPlugin);
    }

    public int removePlugin() {
        return LiveCloudPlugin.getInstance().removePlugin(this.mPlugin);
    }

    public void setPluginDownloadListener(PluginDownloadListener listener) {
        this.mPluginDownloadListener = listener;
    }

    protected PluginDownloadListener getPluginDownloadListener() {
        return this.mPluginDownloadListener;
    }

    public long getPluginSize() {
        return this.mFileSize;
    }

    public static interface PluginDownloadCallback {
        public boolean isCancelled();

        public void onProgress(int var1);

        public void onCancel(boolean var1);

        public void onSuccess();

        public void onFailed();
    }

    public static interface PluginDownloadListener {
        public void onDownload(File var1, String var2, long var3, PluginDownloadCallback var5);
    }

    public static interface PluginCallback {
        public void onStart(Context var1);

        public void onProgress(Context var1, int var2);

        public void onComplete(Context var1, boolean var2, int var3);

        public void onCancel(Context var1);
    }
}

