/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.qihoo.livecloud.plugin.ILiveCloudPlugin;
import com.qihoo.livecloud.plugin.LiveCloudPluginCallback;
import com.qihoo.livecloud.plugin.base.utils.ThreadUtils;
import com.qihoo.livecloud.plugin.core.PluginConfig;
import com.qihoo.livecloud.plugin.core.PluginRunningListener;
import com.qihoo.livecloud.plugin.core.PluginUpdateHelper;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.NetUtil;
import com.qihoo.livecloud.tools.Stats;
import com.qihoo.livecloud.tools.UrlSafeEncode;
import com.qihoo.livecloud.tools.Version;
import com.qihoo.livecloud.utils.DiskUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class LiveCloudPlugin {
    private static LiveCloudPlugin sLiveCloudPlugin = null;
    private Map<String, PluginTask> mPluginTasks = new HashMap<String, PluginTask>();

    private LiveCloudPlugin() {
    }

    public static synchronized LiveCloudPlugin getInstance() {
        if (sLiveCloudPlugin == null) {
            sLiveCloudPlugin = new LiveCloudPlugin();
        }
        return sLiveCloudPlugin;
    }

    public void setDefaultPluginInstalled(String plugin, boolean defaultPluginInstalled) {
        Logger.i("LiveCloudPlugin", "(%s) (%s) setDefaultPluginInstalled, install=%b", ThreadUtils.getCurThreadName(), plugin, defaultPluginInstalled);
        PluginUpdateHelper.setDefaultPluginInstalled(plugin, defaultPluginInstalled);
    }

    public boolean isDefaultPluginInstalled(String plugin) {
        return PluginUpdateHelper.isDefaultPluginInstalled(plugin);
    }

    public boolean isPluginInstalled(String plugin, String version) {
        return PluginUpdateHelper.isPluginInstalled(plugin, version);
    }

    public boolean isPluginValid(String plugin) {
        return this.isDefaultPluginInstalled(plugin) || this.isPluginInstalled(plugin, null) && this.isPluginLoaded(plugin);
    }

    public int loadPlugin(String plugin) {
        if (PluginUpdateHelper.isPluginLoaded(plugin)) {
            return 0;
        }
        return PluginUpdateHelper.loadPlugin(plugin);
    }

    public boolean isPluginLoaded(String plugin) {
        return PluginUpdateHelper.isPluginLoaded(plugin);
    }

    public String getPluginVersion(String plugin) {
        return PluginUpdateHelper.getPluginVersion(plugin);
    }

    public void checkUninstallPlugin(String plugin, String version) {
        String oldVersion = PluginUpdateHelper.getPluginVersion(plugin);
        Logger.i("LiveCloudPlugin", "(%s) (%s) checkUninstallPlugin, newVersion=%s, oldVersion=%s", ThreadUtils.getCurThreadName(), plugin, version, oldVersion != null ? oldVersion : "");
        if (TextUtils.isEmpty((CharSequence)oldVersion)) {
            return;
        }
        if (Version.compare(oldVersion, version) < 0) {
            this.removePlugin(plugin);
        }
    }

    public int checkInstallPlugin(Context context, String plugin, String version, ILiveCloudPlugin.PluginDownloadListener listener, LiveCloudPluginCallback callback) {
        return this.checkInstallPlugin(context, plugin, version, 0, listener, callback);
    }

    public int checkInstallPlugin(Context context, String plugin, String version, int type, ILiveCloudPlugin.PluginDownloadListener listener, LiveCloudPluginCallback callback) {
        if (context == null) {
            context = PluginConfig.getAppContext();
        }
        Logger.i("LiveCloudPlugin", "(%s) (%s) checkInstallPlugin, version=%s, type=%d", ThreadUtils.getCurThreadName(), plugin, version, type);
        PluginTask pluginTask = this.mPluginTasks.get(plugin);
        if (pluginTask != null && pluginTask.running.get()) {
            if (pluginTask.task != null) {
                pluginTask.task.addCallback(callback);
            }
            return 12;
        }
        if (pluginTask == null) {
            pluginTask = new PluginTask();
            this.mPluginTasks.put(plugin, pluginTask);
        }
        pluginTask.plugin = plugin;
        pluginTask.running.set(true);
        pluginTask.task = new Task(context, plugin, version, type, listener, callback);
        pluginTask.task.execute(new String[]{plugin, version});
        return 0;
    }

    public int checkUpdatePlugin(Context context, String plugin, String newVersion, ILiveCloudPlugin.PluginDownloadListener listener) {
        int ret;
        if (context == null) {
            context = PluginConfig.getAppContext();
        }
        if (this.isDefaultPluginInstalled(plugin)) {
            Logger.i("LiveCloudPlugin", "(%s) (%s) checkUpdatePlugin default plugin install", ThreadUtils.getCurThreadName(), plugin);
            return 0;
        }
        String oldVersion = this.getPluginVersion(plugin);
        Logger.i("LiveCloudPlugin", "(%s) (%s) checkUpdatePlugin oldVersion=%s, newVersion=%s", ThreadUtils.getCurThreadName(), plugin, oldVersion, newVersion);
        if (TextUtils.isEmpty((CharSequence)newVersion) || TextUtils.isEmpty((CharSequence)oldVersion) || Version.compare(newVersion, oldVersion) < 0) {
            return 0;
        }
        if (!this.isPluginInstalled(plugin, null)) {
            Logger.i("LiveCloudPlugin", "(%s) (%s) checkUpdatePlugin old plugin not install", ThreadUtils.getCurThreadName(), plugin);
            return 0;
        }
        if (this.isPluginInstalled(plugin, newVersion)) {
            Logger.i("LiveCloudPlugin", "(%s) (%s) checkUpdatePlugin update new plugin", ThreadUtils.getCurThreadName(), plugin);
            ret = !this.isPluginLoaded(plugin) ? PluginUpdateHelper.updatePlugin(plugin, newVersion) : 17;
            Logger.i("LiveCloudPlugin", "(%s) (%s) checkUpdatePlugin update new plugin, ret=%d", ThreadUtils.getCurThreadName(), plugin, ret);
        } else {
            Logger.i("LiveCloudPlugin", "(%s) (%s) checkUpdatePlugin download new plugin", ThreadUtils.getCurThreadName(), plugin);
            ret = this.checkInstallPlugin(context, plugin, newVersion, 1, listener, new LiveCloudPluginCallback(){

                @Override
                public void onStart(Context context, String plugin) {
                    Logger.i("LiveCloudPlugin", "(%s) (%s) checkInstallPlugin onStart, type=%d", ThreadUtils.getCurThreadName(), plugin, 1);
                }

                @Override
                public void onProgress(Context context, String plugin, int progress) {
                    Logger.d("LiveCloudPlugin", "(%s) (%s) checkInstallPlugin onProgress, type=%d progress=%d", ThreadUtils.getCurThreadName(), plugin, 1, progress);
                }

                @Override
                public void onComplete(Context context, String plugin, boolean background, int result) {
                    Logger.i("LiveCloudPlugin", "(%s) (%s) checkInstallPlugin onComplete, type=%d result=%d", ThreadUtils.getCurThreadName(), plugin, 1, result);
                }

                @Override
                public void onCancel(Context context, String plugin) {
                    Logger.i("LiveCloudPlugin", "(%s) (%s) checkInstallPlugin onCancel, type=%d", ThreadUtils.getCurThreadName(), plugin, 1);
                }
            });
            Logger.i("LiveCloudPlugin", "(%s) (%s) checkUpdatePlugin download new plugin, ret=%d", ThreadUtils.getCurThreadName(), plugin, ret);
        }
        return ret;
    }

    public void cancelInstallOrUpdatePlugin(String plugin) {
        Logger.i("LiveCloudPlugin", "(%s) (%s) cancelInstallOrUpdatePlugin", ThreadUtils.getCurThreadName(), plugin);
        PluginTask pluginTask = this.mPluginTasks.get(plugin);
        if (pluginTask == null || pluginTask.task == null || !pluginTask.running.get()) {
            return;
        }
        pluginTask.task.cancel(true);
    }

    public void backgroundInstallOrUpdatePlugin(String plugin) {
        Logger.i("LiveCloudPlugin", "(%s) (%s) backgroundInstallOrUpdatePlugin", ThreadUtils.getCurThreadName(), plugin);
        PluginTask pluginTask = this.mPluginTasks.get(plugin);
        if (pluginTask == null || pluginTask.task == null || !pluginTask.running.get()) {
            return;
        }
        pluginTask.task.background(true);
    }

    public int removePlugin(String plugin) {
        int ret = PluginUpdateHelper.removePlugin(plugin, null);
        Logger.i("LiveCloudPlugin", "(%s) (%s) removePlugin, version=%s, result=%d", ThreadUtils.getCurThreadName(), plugin, PluginUpdateHelper.getPluginVersion(plugin), ret);
        return ret;
    }

    private static class NetReport {
        private String sid = MD5.encryptMD5(String.valueOf(System.currentTimeMillis()) + String.valueOf(new Random().nextInt()));
        private long time;
        private boolean start;
        private long space = DiskUtils.getFreeSpaces(PluginConfig.getAppContext().getFilesDir().getAbsolutePath());
        private String plugin;
        private String plugin_ver;
        private String plugin_dt;

        public void start(String plugin, String version, int type) {
            try {
                String net = NetUtil.getNetworkTypeName(PluginConfig.getAppContext());
                this.time = System.currentTimeMillis();
                this.plugin = plugin;
                this.plugin_ver = version;
                this.plugin_dt = type == 0 ? "install" : "update";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("module", "tools");
                params.put("sdk_ver", Stats.getVersion());
                params.put("plugin", this.plugin);
                params.put("plugin_ver", this.plugin_ver);
                params.put("plugin_dt", this.plugin_dt);
                params.put("plugin_space", String.valueOf(this.space));
                this.start = Stats.sessionStart(this.sid, null, null, net, null, params);
            }
            catch (Throwable ignore) {
                this.start = false;
            }
        }

        public void stop(int result, boolean background) {
            if (!this.start) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("module", "tools");
                params.put("sdk_ver", Stats.getVersion());
                params.put("plugin", this.plugin);
                params.put("plugin_ver", this.plugin_ver);
                params.put("plugin_dt", this.plugin_dt);
                params.put("plugin_space", String.valueOf(this.space));
                params.put("plugin_time", String.valueOf(System.currentTimeMillis() - this.time));
                params.put("plugin_bg", String.valueOf(background));
                Stats.notifyWithoutJni("debug", "plugin", "404", result, params);
                return;
            }
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("plugin_time", String.valueOf(System.currentTimeMillis() - this.time));
                params.put("plugin_bg", String.valueOf(background));
                StringBuilder kvList = new StringBuilder();
                for (Map.Entry entry : params.entrySet()) {
                    kvList.append("&").append((String)entry.getKey()).append("=").append(UrlSafeEncode.encode((String)entry.getValue()));
                }
                Stats.notifyCommonStat(this.sid, "plugin", 404, result, kvList.toString());
                Stats.sessionStop(this.sid);
                Stats.sessionDestroy(this.sid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class Task
    extends AsyncTask<String, Integer, Integer> {
        private Context context;
        private String plugin;
        private String version;
        private AtomicBoolean background;
        private int type;
        private ILiveCloudPlugin.PluginDownloadListener listener;
        private Set<LiveCloudPluginCallback> callbacks;
        private NetReport netReport;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task(Context context, String plugin, String version, int type, ILiveCloudPlugin.PluginDownloadListener listener, LiveCloudPluginCallback callback) {
            this.context = context;
            this.plugin = plugin;
            this.version = version;
            this.background = new AtomicBoolean(false);
            this.type = type;
            this.listener = listener;
            this.callbacks = new HashSet<LiveCloudPluginCallback>();
            if (callback != null) {
                Set<LiveCloudPluginCallback> set = this.callbacks;
                synchronized (set) {
                    this.callbacks.add(callback);
                }
            }
            this.netReport = new NetReport();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallback(LiveCloudPluginCallback callback) {
            if (callback != null) {
                Set<LiveCloudPluginCallback> set = this.callbacks;
                synchronized (set) {
                    this.callbacks.add(callback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCallback(LiveCloudPluginCallback callback) {
            if (callback != null) {
                Set<LiveCloudPluginCallback> set = this.callbacks;
                synchronized (set) {
                    this.callbacks.remove(callback);
                }
            }
        }

        protected Integer doInBackground(String ... params) {
            int errCode = 0;
            int retryCount = 0;
            while (retryCount++ < PluginConfig.RETRY_COUNT_MAX && (errCode = PluginUpdateHelper.checkInstallOrUpdatePlugin(this.plugin, this.version, this.type, retryCount, this.listener, new PluginRunningListener(){

                @Override
                public boolean isCancelled() {
                    return Task.this.isCancelled();
                }

                @Override
                public void onProgress(int progress) {
                    Task.this.publishProgress(new Integer[]{progress});
                }
            })) != 0 && errCode != 1) {
            }
            if (errCode != 0 && LiveCloudPlugin.this.isPluginInstalled(this.plugin, this.type == 0 ? null : this.version)) {
                errCode = 0;
            }
            if (errCode != 0 && errCode != 1) {
                PluginUpdateHelper.clearPluginConfig(this.plugin, this.type == 0 ? null : this.version);
            }
            return errCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onPreExecute() {
            super.onPreExecute();
            this.netReport.start(this.plugin, this.version, this.type);
            Set<LiveCloudPluginCallback> set = this.callbacks;
            synchronized (set) {
                for (LiveCloudPluginCallback callback : this.callbacks) {
                    if (callback == null) continue;
                    callback.onStart(this.context, this.plugin);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onProgressUpdate(Integer ... values) {
            super.onProgressUpdate((Object[])values);
            Set<LiveCloudPluginCallback> set = this.callbacks;
            synchronized (set) {
                for (LiveCloudPluginCallback callback : this.callbacks) {
                    if (callback == null) continue;
                    callback.onProgress(this.context, this.plugin, values[0]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onCancelled() {
            super.onCancelled();
            this.netReport.stop(1, this.background.get());
            Set<LiveCloudPluginCallback> set = this.callbacks;
            synchronized (set) {
                for (LiveCloudPluginCallback callback : this.callbacks) {
                    if (callback == null) continue;
                    callback.onCancel(this.context, this.plugin);
                }
            }
            this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onPostExecute(Integer result) {
            super.onPostExecute((Object)result);
            this.netReport.stop(result, this.background.get());
            HashSet<LiveCloudPluginCallback> callbackTemp = new HashSet<LiveCloudPluginCallback>();
            Set<LiveCloudPluginCallback> set = this.callbacks;
            synchronized (set) {
                callbackTemp.addAll(this.callbacks);
            }
            for (LiveCloudPluginCallback callback : callbackTemp) {
                if (callback == null) continue;
                callback.onComplete(this.context, this.plugin, this.background.get(), result);
            }
            this.clear();
        }

        public void background(boolean background) {
            this.background.set(background);
        }

        private void clear() {
            PluginTask pluginTask = (PluginTask)LiveCloudPlugin.this.mPluginTasks.get(this.plugin);
            if (pluginTask != null) {
                pluginTask.running.set(false);
                pluginTask.task = null;
            }
        }
    }

    private class PluginTask {
        public String plugin;
        public AtomicBoolean running = new AtomicBoolean(false);
        public Task task;

        private PluginTask() {
        }
    }
}

