/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.base.network;

import android.text.TextUtils;
import android.webkit.URLUtil;
import com.qihoo.livecloud.plugin.base.network.HttpClientNative;
import com.qihoo.livecloud.plugin.base.network.HttpRequest;
import com.qihoo.livecloud.plugin.base.network.HttpResponse;
import com.qihoo.livecloud.plugin.base.network.HttpTask;
import com.qihoo.livecloud.plugin.base.network.HttpUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Request;
import okhttp3.Response;

public class HttpClient {
    private static HttpClient sInstance = new HttpClient();

    public static HttpClient getInstance() {
        return sInstance;
    }

    public static HttpTask addRequest(HttpRequest request) {
        return HttpClientNative.addRequest(HttpClient.addDefaultInfo(request));
    }

    public static HttpResponse addRequestSync(HttpRequest request) {
        return HttpClientNative.addRequestSync(HttpClient.addDefaultInfo(request));
    }

    public static Response addRequestSync(Request request) throws IOException {
        return HttpClientNative.getInstance().getClient().newCall(request).execute();
    }

    private static HttpRequest addDefaultInfo(HttpRequest request) {
        if (request == null || !URLUtil.isValidUrl((String)request.getUrl())) {
            return null;
        }
        HttpClient.addDefaultExtends(request);
        HttpClient.addDefaultHeader(request);
        return request;
    }

    private static void addDefaultExtends(HttpRequest request) {
        String extra;
        String url = request.getUrl();
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (!url.contains("?")) {
            url = url + "?";
        }
        if (!url.endsWith("&") && !url.endsWith("?")) {
            url = url + "&";
        }
        if ((extra = HttpUtils.getExtra(url)).indexOf("?") == 0) {
            extra = extra.substring(1);
        }
        request.setUrl(url + extra);
    }

    private static void addDefaultHeader(HttpRequest request) {
        HashMap<String, String> defHeader = null;
        try {
            defHeader = HttpUtils.getDefaultHttpHeader(new URL(request.getUrl()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (defHeader == null || defHeader.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : defHeader.entrySet()) {
            String key = entry.getKey();
            if (TextUtils.isEmpty((CharSequence)key)) continue;
            request.addHeader(key, entry.getValue());
        }
    }
}

