/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.base.network;

import android.text.TextUtils;
import com.qihoo.livecloud.plugin.base.network.HttpRequest;
import com.qihoo.livecloud.plugin.base.network.HttpResponse;
import com.qihoo.livecloud.plugin.base.network.HttpTask;
import com.qihoo.livecloud.plugin.core.PluginConfig;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class HttpClientNative {
    public static final int TIME_OUT = 15000;
    private static String sUserAgent;
    private static HttpClientNative sInstance;
    private OkHttpClient mClient = HttpClientNative.newClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClientNative getInstance() {
        if (sInstance != null) return sInstance;
        Class<HttpClientNative> clazz = HttpClientNative.class;
        synchronized (HttpClientNative.class) {
            if (sInstance != null) return sInstance;
            sInstance = new HttpClientNative();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static HttpTask addRequest(HttpRequest request) {
        if (request == null) {
            return null;
        }
        try {
            Call call = HttpClientNative.getInstance().getClient().newCall(HttpClientNative.getRequest(request));
            HttpTask task = new HttpTask();
            task.setRequest(request);
            task.enqueue(call);
            return task;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HttpResponse addRequestSync(HttpRequest request) {
        if (request == null) {
            return null;
        }
        try {
            Call call = HttpClientNative.getInstance().getClient().newCall(HttpClientNative.getRequest(request));
            return new HttpResponse(call.execute());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public OkHttpClient getClient() {
        return this.mClient;
    }

    private static OkHttpClient newClient() {
        try {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.connectTimeout(15000L, TimeUnit.MILLISECONDS);
            builder.readTimeout(15000L, TimeUnit.MILLISECONDS);
            builder.writeTimeout(15000L, TimeUnit.MILLISECONDS);
            builder.retryOnConnectionFailure(false);
            builder.sslSocketFactory(HttpClientNative.getAllTrustSSLSocketFractory());
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
            return builder.build();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Request getRequest(HttpRequest request) {
        if (request == null) {
            return null;
        }
        try {
            Request.Builder builder = new Request.Builder();
            builder.url(request.getUrl());
            builder.tag(request.getTag());
            builder.headers(request.getRequestHeaders());
            switch (request.mMethod) {
                case 0: {
                    builder.get();
                    break;
                }
                case 1: {
                    if (request.isFilePost() || request.isStreamPost()) {
                        builder.post(request.getRequestBodyFile());
                        break;
                    }
                    builder.post(request.getRequestBody());
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported http method.");
                }
            }
            return builder.build();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SSLSocketFactory getAllTrustSSLSocketFractory() {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate loadCertificate(int id) {
        InputStream in = null;
        try {
            X509Certificate cert;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            in = PluginConfig.getAppContext().getResources().openRawResource(id);
            X509Certificate x509Certificate = cert = (X509Certificate)cf.generateCertificate(in);
            return x509Certificate;
        }
        catch (Exception e) {
            e.printStackTrace();
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class HuajiaoHostVerifier
    implements HostnameVerifier {
        private static final int ALT_DNS_NAME = 2;
        private static final int ALT_IPA_NAME = 7;
        private static final String HOST_NAME = "huajiao.com";

        @Override
        public boolean verify(String host, SSLSession session) {
            try {
                Certificate[] certificates = session.getPeerCertificates();
                return this.verifyHostname(host, (X509Certificate)certificates[0]);
            }
            catch (SSLException e) {
                return false;
            }
        }

        private boolean verifyHostname(String hostname, X509Certificate certificate) {
            hostname = hostname.toLowerCase(Locale.US);
            List<String> altNames = this.getSubjectAltNames(certificate, 2);
            int size = altNames.size();
            for (int i = 0; i < size; ++i) {
                String atlName = altNames.get(i);
                if (TextUtils.isEmpty((CharSequence)atlName) || !hostname.endsWith(HOST_NAME) || !atlName.endsWith(HOST_NAME)) continue;
                return true;
            }
            return false;
        }

        private List<String> getSubjectAltNames(X509Certificate certificate, int type) {
            ArrayList<String> result = new ArrayList<String>();
            try {
                Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
                if (subjectAltNames == null) {
                    return Collections.emptyList();
                }
                for (List<?> subjectAltName : subjectAltNames) {
                    String altName;
                    Integer altNameType;
                    List<?> entry = subjectAltName;
                    if (entry == null || entry.size() < 2 || (altNameType = (Integer)entry.get(0)) == null || altNameType != type || (altName = (String)entry.get(1)) == null) continue;
                    result.add(altName);
                }
                return result;
            }
            catch (CertificateParsingException e) {
                return Collections.emptyList();
            }
        }
    }
}

