/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.base.network;

import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.qihoo.livecloud.plugin.base.network.HttpError;
import com.qihoo.livecloud.plugin.base.network.HttpListener;
import com.qihoo.livecloud.plugin.base.network.request.ProgressRequestBody;
import com.qihoo.livecloud.plugin.base.network.request.UploadStreamDescriber;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class HttpRequest<T> {
    public static final String TAG = HttpRequest.class.getSimpleName();
    private String mUrl;
    public final int mMethod;
    public final HttpListener<T> mListener;
    protected Object mTag;
    protected HashMap<String, String> mPostParams;
    protected HashMap<String, String> mHeaders;
    protected HashMap<String, Object> mSecurityPostParams;
    protected ArrayList<RequestBody> mBodyParams;
    protected HashMap<String, String> m_get_params;
    protected LinkedList<String> m_files;
    protected HashMap<String, String> filesMap;
    protected Map<String, UploadStreamDescriber> streamMap;
    private ProgressRequestBody.ProgressRequestListener progressRequestListener;

    public HttpRequest(String url, HttpListener listener) {
        this(-1, url, listener);
    }

    public HttpRequest(int method, String url, HttpListener listener) {
        this.mMethod = method;
        this.mUrl = url;
        this.mListener = listener;
    }

    public void setProgressRequestBody(ProgressRequestBody.ProgressRequestListener progressRequestListener) {
        this.progressRequestListener = progressRequestListener;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getUrl() {
        String url = this.mUrl;
        if (0 == this.mMethod) {
            url = url + this.GetParameterForGet();
        }
        return url;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    public Object getTag() {
        return this.mTag;
    }

    public void onFailure(HttpError e) {
        if (this.mListener != null) {
            this.mListener.onFailure(e);
        }
    }

    public void onResponse(Response response) {
    }

    public RequestBody getRequestBody() {
        FormBody.Builder builder = new FormBody.Builder();
        HashMap<String, String> mParams = this.getPostParameter();
        if (mParams != null && mParams.size() > 0) {
            for (Map.Entry<String, String> entry : mParams.entrySet()) {
                String key = entry.getKey();
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                String value = entry.getValue();
                if (value == null) {
                    value = "";
                }
                builder.add(key, value);
            }
        }
        if (this.mBodyParams == null || this.mBodyParams.size() == 0) {
            return builder.build();
        }
        MultipartBody.Builder multiPartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addPart((RequestBody)builder.build());
        for (RequestBody body : this.mBodyParams) {
            multiPartBuilder.addPart(body);
        }
        return multiPartBuilder.build();
    }

    public boolean isFilePost() {
        boolean b_ret = false;
        if (this.m_files != null && this.m_files.size() > 0) {
            b_ret = true;
        }
        if (this.filesMap != null && this.filesMap.size() > 0) {
            b_ret = true;
        }
        return b_ret;
    }

    public boolean isStreamPost() {
        boolean b_ret = false;
        if (this.streamMap != null && this.streamMap.size() > 0) {
            b_ret = true;
        }
        return b_ret;
    }

    public RequestBody getRequestBodyFile() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        HashMap<String, String> mParams = this.getPostParameter();
        if (mParams != null && mParams.size() > 0) {
            for (Map.Entry<String, String> entry : mParams.entrySet()) {
                String key = entry.getKey();
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                String value = entry.getValue();
                if (value == null) {
                    value = "";
                }
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + key + "\""}), RequestBody.create(null, (String)value));
            }
        }
        if (this.m_files != null && this.m_files.size() > 0) {
            for (int i = 0; i < this.m_files.size(); ++i) {
                ProgressRequestBody progressRequestBody = new ProgressRequestBody(MediaType.parse((String)this.guessMimeType(this.m_files.get(i))), new File(this.m_files.get(i)), this.progressRequestListener);
                builder.addFormDataPart("file", this.m_files.get(i), (RequestBody)progressRequestBody);
            }
        }
        if (this.filesMap != null && this.filesMap.size() > 0) {
            for (Map.Entry<String, Object> entry : this.filesMap.entrySet()) {
                File file = new File((String)entry.getValue());
                ProgressRequestBody fileBody = new ProgressRequestBody(MediaType.parse((String)this.getMimeType(file.getName())), file, this.progressRequestListener);
                builder.addFormDataPart(entry.getKey(), (String)entry.getValue(), (RequestBody)fileBody);
            }
        }
        if (this.streamMap != null && this.streamMap.size() > 0) {
            for (Map.Entry<String, Object> entry : this.streamMap.entrySet()) {
                UploadStreamDescriber describer = (UploadStreamDescriber)entry.getValue();
                if (describer == null) continue;
                String extention = MimeTypeMap.getSingleton().getExtensionFromMimeType(describer.mimeType);
                if ("jpeg".equals(extention)) {
                    extention = "jpg";
                } else if (TextUtils.isEmpty((CharSequence)extention) && describer.mimeType != null) {
                    if (describer.mimeType.contains("jpg")) {
                        extention = "jpg";
                    } else if (describer.mimeType.contains("png")) {
                        extention = "png";
                    }
                }
                ProgressRequestBody inputstreamBody = new ProgressRequestBody(MediaType.parse((String)describer.mimeType), describer.inputStream, describer.length, this.progressRequestListener);
                builder.addFormDataPart(entry.getKey(), entry.getKey() + "." + extention, (RequestBody)inputstreamBody);
            }
        }
        return builder.build();
    }

    private String guessMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = null;
        try {
            contentTypeFor = fileNameMap.getContentTypeFor(URLEncoder.encode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    private String getMimeType(String filename) {
        String result = filename.endsWith("jpeg") || filename.endsWith("jpg") ? "image/jpeg" : (filename.endsWith("gif") ? "image/gif" : (filename.endsWith("png") ? "image/png" : (filename.endsWith("bmp") ? "image/bmp" : "application/octet-stream")));
        return result;
    }

    public Headers getRequestHeaders() {
        Headers.Builder builder = new Headers.Builder();
        HashMap<String, String> mHeaders = this.getHeaders();
        if (mHeaders != null && mHeaders.size() > 0) {
            for (Map.Entry<String, String> entry : mHeaders.entrySet()) {
                String key = entry.getKey();
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                String value = entry.getValue();
                if (value == null) {
                    value = "";
                }
                try {
                    builder.add(key, value);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return builder.build();
    }

    public void setGetParameter(HashMap<String, String> params) {
        if (params != null) {
            this.m_get_params = params;
        }
    }

    public void addGetParameter(String key, String value) {
        if (this.m_get_params == null) {
            this.m_get_params = new HashMap();
        }
        if (value != null) {
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_get_params.put(key, value);
    }

    public String GetParameterForGet() {
        if (this.m_get_params == null || this.m_get_params.size() == 0) {
            return "";
        }
        String str_paras = "";
        for (Map.Entry<String, String> entry : this.m_get_params.entrySet()) {
            String key = entry.getKey();
            if (TextUtils.isEmpty((CharSequence)key)) continue;
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            str_paras = str_paras + "&";
            str_paras = str_paras + key;
            str_paras = str_paras + "=";
            str_paras = str_paras + value;
        }
        return str_paras;
    }

    public void setPostParameters(HashMap<String, String> params) {
        this.mPostParams = params;
    }

    public void addPostParameter(String key, String value) {
        if (this.mPostParams == null) {
            this.mPostParams = new HashMap();
        }
        this.mPostParams.put(key, value);
    }

    public HashMap<String, String> getPostParameter() {
        return this.mPostParams;
    }

    public void addFiles(String str_file_path) {
        if (this.m_files == null) {
            this.m_files = new LinkedList();
        }
        this.m_files.add(str_file_path);
    }

    public void setFiles(HashMap<String, String> filesMap) {
        if (filesMap != null) {
            this.filesMap = filesMap;
        }
    }

    public void addStreams(String key, UploadStreamDescriber inputStream) {
        if (this.streamMap == null) {
            this.streamMap = new HashMap<String, UploadStreamDescriber>();
        }
        if (inputStream != null && !TextUtils.isEmpty((CharSequence)key)) {
            this.streamMap.put(key, inputStream);
        }
    }

    public void setStreams(HashMap<String, UploadStreamDescriber> streamMap) {
        if (streamMap != null) {
            this.streamMap = streamMap;
        }
    }

    public void setHeaders(HashMap<String, String> params) {
        this.mHeaders = params;
    }

    public void addHeader(String key, String value) {
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap();
        }
        this.mHeaders.put(key, value);
    }

    public HashMap<String, String> getHeaders() {
        return this.mHeaders;
    }

    public void setBodyParameter(ArrayList<RequestBody> params) {
        this.mBodyParams = params;
    }

    public void addBodyParameter(RequestBody body) {
        if (this.mBodyParams == null) {
            this.mBodyParams = new ArrayList();
        }
        this.mBodyParams.add(body);
    }

    public ArrayList<RequestBody> getmBodyParams() {
        return this.mBodyParams;
    }

    public void addSecurityPostParameter(String key, Object value) {
        if (this.mSecurityPostParams == null) {
            this.mSecurityPostParams = new HashMap();
        }
        this.mSecurityPostParams.put(key, value);
    }

    public class HttpMethod {
        public static final int DEPRECATED_GET_OR_POST = -1;
        public static final int GET = 0;
        public static final int POST = 1;
        public static final int PUT = 2;
        public static final int DELETE = 3;
        public static final int HEAD = 4;
        public static final int OPTIONS = 5;
        public static final int TRACE = 6;
        public static final int PATCH = 7;
    }
}

