/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.base.network;

import com.qihoo.livecloud.tools.Logger;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;

public class HttpResponse {
    private final Response mResponse;

    HttpResponse(Response response) {
        this.mResponse = response;
    }

    public String getString() {
        if (this.mResponse == null) {
            return null;
        }
        try {
            return this.mResponse.body().string();
        }
        catch (IOException e) {
            Logger.d("Logger", "Logger" + e.getMessage());
            return null;
        }
    }

    public InputStream getByteStream() {
        return this.mResponse == null ? null : this.mResponse.body().byteStream();
    }

    public long getContentLength() {
        return this.mResponse == null ? 0L : this.mResponse.body().contentLength();
    }

    public int getHttpStatusCode() {
        if (this.mResponse != null) {
            return this.mResponse.code();
        }
        return -1;
    }

    public boolean isSuccessful() {
        if (this.mResponse != null) {
            return this.mResponse.isSuccessful();
        }
        return false;
    }
}

