/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.base.network;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.qihoo.livecloud.plugin.core.PluginConfig;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.NetUtil;
import com.qihoo.livecloud.tools.Stats;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class HttpUtils {
    private static final String TAG = HttpUtils.class.getSimpleName();
    private static String signature;

    public static String getExtra(String url) {
        StringBuilder params = new StringBuilder();
        String platform = "android";
        String network = HttpUtils.getNetWorkTypeToString(PluginConfig.getAppContext());
        String version = Stats.getVersion();
        String netSpeed = "1024";
        String rand = UUID.randomUUID().toString();
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String packageName = "";
        try {
            packageName = PluginConfig.getAppContext().getPackageName();
        }
        catch (Throwable e) {
            Logger.e(TAG, "getSign:signature:" + e.getMessage());
        }
        params.append("&platform=").append(platform);
        params.append("&network=").append(network);
        params.append("&version=").append(version);
        params.append("&sdk_rand=").append(rand);
        params.append("&netspeed=").append(netSpeed);
        params.append("&sdk_time=").append(time);
        params.append("&sdk_packagename=").append(packageName);
        HashMap<String, String> seParams = new HashMap<String, String>();
        seParams.put("platform", platform);
        seParams.put("sdk_rand", rand);
        seParams.put("sdk_time", time);
        seParams.put("sdk_packagename", packageName);
        try {
            params.append("&device=").append(URLEncoder.encode(Build.DEVICE, "utf-8"));
            params.append("&devicebrand=").append(URLEncoder.encode(Build.BRAND, "utf-8"));
            params.append("&devicemanufacturer=").append(URLEncoder.encode(Build.MANUFACTURER, "utf-8"));
            params.append("&model=").append(URLEncoder.encode(Build.MODEL, "utf-8"));
            params.append("&androidversion=").append(URLEncoder.encode(Build.VERSION.RELEASE, "utf-8"));
            params.append("&androidversioncode=").append(URLEncoder.encode(Integer.valueOf(Build.VERSION.SDK_INT).toString(), "utf-8"));
        }
        catch (Throwable e) {
            Logger.e("Logger", "Logger," + e.getMessage());
        }
        return params.toString();
    }

    private static String getSign(Context context, String packageName) {
        Logger.d(TAG, "getSign:signature:" + signature);
        if (!TextUtils.isEmpty((CharSequence)signature)) {
            return signature;
        }
        Signature[] signs = HttpUtils.getRawSignature(context, packageName);
        if (signs == null || signs.length == 0) {
            signature = null;
        } else {
            Signature sign = signs[0];
            signature = MD5.encryptMD5(sign.toByteArray());
        }
        Logger.d(TAG, "getSign:signature:" + signature);
        return signature;
    }

    private static Signature[] getRawSignature(Context context, String packageName) {
        PackageInfo info;
        if (packageName == null || packageName.length() == 0) {
            return null;
        }
        PackageManager pkgMgr = context.getPackageManager();
        try {
            info = pkgMgr.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        if (info == null) {
            return null;
        }
        return info.signatures;
    }

    public static String getNetWorkTypeToString(Context context) {
        return NetUtil.getNetWorkTypeToString(context);
    }

    public static String getUserAgent(Context context) {
        String id;
        String model;
        String webUserAgent = null;
        if (context != null) {
            try {
                Class<?> sysResCls = Class.forName("com.android.internal.R$string");
                Field webUserAgentField = sysResCls.getDeclaredField("web_user_agent");
                Integer resId = (Integer)webUserAgentField.get(null);
                webUserAgent = context.getString(resId.intValue());
            }
            catch (Throwable sysResCls) {
                // empty catch block
            }
        }
        if (TextUtils.isEmpty(webUserAgent)) {
            webUserAgent = "Mozilla/5.0 (Linux; U; Android %s) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 %sSafari/533.1";
        }
        Locale locale = Locale.getDefault();
        StringBuffer buffer = new StringBuffer();
        String version = Build.VERSION.RELEASE;
        if (version.length() > 0) {
            buffer.append(version);
        } else {
            buffer.append("1.0");
        }
        buffer.append("; ");
        String language = locale.getLanguage();
        if (language != null) {
            buffer.append(language.toLowerCase());
            String country = locale.getCountry();
            if (country != null) {
                buffer.append("-");
                buffer.append(country.toLowerCase());
            }
        } else {
            buffer.append("en");
        }
        if ("REL".equals(Build.VERSION.CODENAME) && (model = Build.MODEL).length() > 0) {
            buffer.append("; ");
            buffer.append(model);
        }
        if ((id = Build.ID).length() > 0) {
            buffer.append(" Build/");
            buffer.append(id);
        }
        return String.format(webUserAgent, buffer, "Mobile ");
    }

    public static String formatUrlByMethod(String url, Map<String, String> params) {
        if (params != null && params.size() > 0) {
            Uri.Builder builder = Uri.parse((String)url).buildUpon();
            for (String key : params.keySet()) {
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                String value = params.get(key);
                if (TextUtils.isEmpty((CharSequence)value)) {
                    value = "";
                }
                builder.appendQueryParameter(key, value);
            }
            return builder.toString();
        }
        return url;
    }

    public static HashMap<String, String> getDefaultHttpHeader(URL url) {
        HashMap<String, String> headerList = new HashMap<String, String>();
        return headerList;
    }

    private static String getUrl(URL url) {
        return url.getPath() + "?" + url.getQuery();
    }

    private static String getUrlHost(String url) {
        try {
            return new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return "";
        }
    }
}

